# CloudWatch alarm that triggers the autoscaling up policy
resource "aws_cloudwatch_metric_alarm" "alerta_service_cpu_high" {
  alarm_name          = "alerta_cpu_utilization_high"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "2"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/ECS"
  period              = "60"
  statistic           = "Average"
  threshold           = "85"

  dimensions = {
    ClusterName = aws_ecs_cluster.alerta_cluster.name
    ServiceName = aws_ecs_service.alerta_service.name
  }

  alarm_actions = [aws_appautoscaling_policy.alerta_up.arn]
}

# CloudWatch alarm that triggers the autoscaling down policy
resource "aws_cloudwatch_metric_alarm" "alerta_service_cpu_low" {
  alarm_name          = "alerta_codepipeline_cpu_utilization_low"
  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = "2"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/ECS"
  period              = "60"
  statistic           = "Average"
  threshold           = "10"

  dimensions = {
    ClusterName = aws_ecs_cluster.alerta_cluster.name
    ServiceName = aws_ecs_service.alerta_service.name
  }

  alarm_actions = [aws_appautoscaling_policy.alerta_down.arn]
}


# Set up CloudWatch group and log stream and retain logs for 30 days
resource "aws_cloudwatch_log_group" "alerta_log_group" {
  name              = "/ecs/alerta"
  retention_in_days = 30

  tags = {
    Name = "alerta-log-group"
  }
}

resource "aws_cloudwatch_log_stream" "alerta_log_stream" {
  name           = "alerta-log-stream"
  log_group_name = aws_cloudwatch_log_group.alerta_log_group.name
}
