data "template_file" "alerta_task_defn_file" {
  template = file("./templates/alerta_task_defn.json.tpl")

  vars = {
    aws_region                   = var.region
    env                          = local.environment_map[var.env]
    alerta_rds_connection_string = "arn:aws:ssm:${var.region}:${data.aws_caller_identity.current.account_id}:parameter/${local.environment}/alerta_rds/connection_string/master"
    alerta_secret_key_arn        = aws_secretsmanager_secret.alerta_secret_key_token.arn
  }
}

resource "aws_ecs_cluster" "alerta_cluster" {
  name = module.shared_vars.ecs_cluster_name
}

resource "aws_ecs_task_definition" "alerta_defn" {
  family                   = "alerta-task"
  execution_role_arn       = aws_iam_role.ecs_task_execution_role.arn
  network_mode             = "awsvpc"
  requires_compatibilities = ["FARGATE"]
  cpu                      = 4096
  memory                   = 8192
  container_definitions    = data.template_file.alerta_task_defn_file.rendered
}

resource "aws_ecs_service" "alerta_service" {
  name                               = module.shared_vars.ecs_cluster_name
  cluster                            = aws_ecs_cluster.alerta_cluster.id
  task_definition                    = aws_ecs_task_definition.alerta_defn.arn
  desired_count                      = 3
  deployment_minimum_healthy_percent = 50
  deployment_maximum_percent         = 200
  launch_type                        = "FARGATE"
  platform_version                   = "1.4.0"

  deployment_controller {
    type = "CODE_DEPLOY"
  }

  network_configuration {
    security_groups  = [module.variables.sg_twitch_subnet_id]
    subnets          = module.variables.private_subnet_ids
    assign_public_ip = false
  }

  load_balancer {
    target_group_arn = aws_lb_target_group.alerta_tg_green.id
    container_name   = "alerta"
    container_port   = 8080
  }

  depends_on = [aws_lb_listener.alerta_front_end, aws_iam_role_policy_attachment.ecs_task_execution_role]
}
