resource "aws_lb" "alerta_nlb" {
  name               = "alerta-nlb"
  internal           = true
  load_balancer_type = "network"
  subnets            = module.variables.private_subnet_ids
}

resource "aws_lb_target_group" "alerta_nlb_tg" {
  name        = "alerta-nlb-tg"
  port        = 443
  protocol    = "TLS"
  vpc_id      = module.variables.vpc_id
  target_type = "ip"

  health_check {
    healthy_threshold   = "3"
    interval            = "30"
    protocol            = "TCP"
    timeout             = "10"
    unhealthy_threshold = "3"
  }
}

resource "aws_lb_listener" "alerta_nlb_listener" {
  load_balancer_arn = "${aws_lb.alerta_nlb.arn}"
  port              = "443"
  protocol          = "TLS"
  ssl_policy        = "ELBSecurityPolicy-2015-05"
  certificate_arn   = "arn:aws:acm:us-west-2:152548578290:certificate/3329fbd1-fb06-427a-a64d-57673ec581d0"

  default_action {
    type             = "forward"
    target_group_arn = "${aws_lb_target_group.alerta_nlb_tg.arn}"
  }
}


resource "aws_lb" "alerta_lb" {
  name            = "alerta-lb"
  internal        = true
  subnets         = module.variables.private_subnet_ids
  security_groups = [module.variables.sg_twitch_subnet_id]
  idle_timeout    = 600
}

resource "aws_lb_target_group" "alerta_tg_blue" {
  name        = module.shared_vars.lb_tg_blue
  port        = 8080
  protocol    = "HTTP"
  vpc_id      = module.variables.vpc_id
  target_type = "ip"

  health_check {
    healthy_threshold   = "3"
    interval            = "30"
    protocol            = "HTTP"
    matcher             = "200"
    timeout             = "3"
    path                = "/"
    unhealthy_threshold = "2"
  }
}

resource "aws_lb_target_group" "alerta_tg_green" {
  name        = module.shared_vars.lb_tg_green
  port        = 8080
  protocol    = "HTTP"
  vpc_id      = module.variables.vpc_id
  target_type = "ip"

  health_check {
    healthy_threshold   = "3"
    interval            = "30"
    protocol            = "HTTP"
    matcher             = "200"
    timeout             = "3"
    path                = "/"
    unhealthy_threshold = "2"
  }
}

# Redirect all traffic from the ALB to the target group
resource "aws_lb_listener" "alerta_front_end" {
  load_balancer_arn = aws_lb.alerta_lb.id
  port              = 443
  protocol          = "HTTPS"
  ssl_policy        = "ELBSecurityPolicy-2015-05"
  certificate_arn   = "${data.aws_acm_certificate.env.arn}"

  default_action {
    target_group_arn = aws_lb_target_group.alerta_tg_green.id
    type             = "forward"
  }
}

# Creates a DNS record for the service.
resource "aws_route53_record" "codedeploy_route53" {
  zone_id = "Z2JOZ1ZHX5BQPQ"
  name    = "video-alerta.${var.region}.${local.environment}.alerta.live-video.a2z.com"
  type    = "A"

  alias {
    name                   = "${aws_lb.alerta_lb.dns_name}"
    zone_id                = "${aws_lb.alerta_lb.zone_id}"
    evaluate_target_health = true
  }
}
