terraform {
  backend "s3" {
    encrypt = true
  }
}

module "variables" {
  source = "./vendor/modules/twitch-video-ops-defaults/current"
  region = var.region
}

module "shared_vars" {
  source = "../shared_vars"
}

module "alerta_vpc_service_endpoint" {
  source             = "git@git.xarth.tv:video-coreservices/tf-mod-vpce-service.git?ref=v1.1.0"
  alb_arn            = aws_lb.alerta_lb.arn
  nlb_arn            = aws_lb.alerta_nlb.arn
  nlb_tg_arn         = aws_lb_target_group.alerta_nlb_tg.arn
  region             = var.region
  service_id         = "video-alerta-${local.environment_map[var.env]}"
  allowed_principals = ["arn:aws:iam::360826418937:root"]
}

data "aws_caller_identity" "current" {}
