[
  {
    "name": "alerta",
    "image": "docker-registry.internal.justin.tv/video-monitoring/alerta:106dc034e0634ba41ff064fcd5a4f52a0d6cd932",
    "cpu": 4096,
    "memory": 8192,
    "networkMode": "awsvpc",
    "logConfiguration": {
        "logDriver": "awslogs",
        "options": {
          "awslogs-group": "/ecs/alerta",
          "awslogs-region": "${aws_region}",
          "awslogs-stream-prefix": "ecs"
        }
    },
    "secrets": [
      {
      "name": "SECRET_KEY",
      "valueFrom": "${alerta_secret_key_arn}"
      },
      {
        "name": "DATABASE_URL",
        "valueFrom": "${alerta_rds_connection_string}"
      }
    ],
    "environment": [
      {
        "name": "ADMIN_USERS",
        "value": "johpick@twitch.tv,ktimofee@twitch.tv,yangan@twitch.tv,dhollim@twitch.tv,tetmat@twitch.tv,video-coreservices@twitch.tv"
      },
      {
        "name": "DASHBOARD_URL",
        "value": "video-alerta.${aws_region}.${env}.alerta.live-video.a2z.com"
      },
      {
        "name": "DATABASE_NAME",
        "value": "alerta"
      },
      {
        "name": "CORS_ORIGINS",
        "value": "http://localhost,http://localhost:8080,video-alerta.${aws_region}.${env}.alerta.live-video.a2z.com"
      },
      {
        "name": "DEBUG",
        "value": "true"
      },
      {
        "name": "PLUGINS",
        "value": "blackout,enhance,reject"
      },
      {
        "name": "RUNBOOK_URL",
        "value": "https://wiki.twitch.com/display/VID/Nagios+Alerts"
      }
    ],
    "portMappings": [
      {
        "containerPort": 8080,
        "hostPort": 8080
      }
    ]
  }
]
