# Shared Vars module

This module contains no resources but is the resting place for variables that are commonly shared through the other modules that make up the Alerta infrastructure. Variables are viewable/editable in the `variables.tf` of this module.

Please be careful in modifying shared variables as their reach, as the title implies, is shared among multiple modules! Adding variables is a simpler endeavor though. Simply add the variable to `variables.tf` and other modules that import these variables may use their values referenced as `module.shared_vars.<your_new_var>` (this is barring you change the alias of the `shared_vars` module declared in the main.tf of each module that includes it, of course!)

## Getting Started

1. Clone the repository

2. Download the following (assuming MacOS)

  * [tfenv](https://github.com/tfutils/tfenv#automatic) --> `brew install tfenv`
  * [terrafile](https://github.com/coretech/terrafile#how-to-install) --> `brew tap coretech/terrafile && brew install terrafile`

3. Copy the credentials for your AWS account in your shell (i.e: isengard temporary creds, other mechanisms)

4. See if your terraform environment can set up. In the same folder as this README, run `./deploy.sh -e [staging|prod] -r <aws_region> (plan|apply)`
