#!/bin/bash

set -eo pipefail

ENV="staging"
REGION="us-west-2"

while getopts ":e:r:" opt; do
  case ${opt} in
    e )
      ENV=$OPTARG
      ;;
    r )
      REGION=$OPTARG
      ;;
    \? )
      echo "Usage: $0 [ -e prod|staging ][ -r <aws_region> ] [init|plan|apply]" 1>&2
      exit 1
      ;;
  esac
done

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && exit 1 )
    command -v terrafile &> /dev/null || ( echo "terrafile required but missing" && exit 1 )
}

tf_init() {
    shift

    terrafile -f "../../conf/${ENV}/${REGION}/shared_vars/Terrafile"
    # tf 0.12 resolves symlink path and writes it to this file instead
    rm -f .terraform/modules/modules.json

    terraform init "$@" -reconfigure -backend-config="../../conf/${ENV}/${REGION}/shared_vars/backend.tfvars"
}


requirements


CMD=${@:$OPTIND:1}

shift $((OPTIND-1))

case "$CMD" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@" \
            -var-file="../../conf/${ENV}/${REGION}/shared_vars/variables.tfvars"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
