variable "env" {
  description = "Service environment - (prod|staging)"
  default     = "staging"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

locals {
  environment_map = {
    prod    = "production"
    stage   = "staging"
    staging = "staging"
    dev     = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "docker-alerta"
    Environment = var.env
    Source      = "video-monitoring/docker-alerta"
  }
}
