resource "aws_api_gateway_deployment" "alerta_webhook_deployment" {
  depends_on = ["aws_api_gateway_integration.alerta_webhook_lambda_integration"]
  rest_api_id = aws_api_gateway_rest_api.alerta_webhook_api.id
  stage_name  = var.env
}

resource "aws_api_gateway_rest_api" "alerta_webhook_api" {
  name = "alerta-webhook-api"

  endpoint_configuration {
    types = ["REGIONAL"]
  }

  policy = <<POLICY
{
 "Version": "2012-10-17",
 "Statement": [
     {
         "Effect": "Allow",
         "Principal": "*",
         "Action": "execute-api:Invoke",
         "Resource": "*",
         "Condition": {
             "IpAddress": {
                 "aws:SourceIp": [
                   "34.210.57.30",
                   "34.210.242.134",
                   "52.34.208.156",
                   "34.202.21.89",
                   "34.239.229.93",
                   "34.231.45.166",
                   "34.248.147.39",
                   "54.77.228.115",
                   "54.154.145.191",
                   "34.222.110.137",
                   "52.27.80.200",
                   "54.213.252.21",
                   "54.215.194.220",
                   "54.193.20.212",
                   "13.52.245.128"
                 ]
             }
         }
     }
   ]
}
POLICY
}

resource "aws_api_gateway_resource" "alerta_webhook_resource" {
  rest_api_id = aws_api_gateway_rest_api.alerta_webhook_api.id
  parent_id   = aws_api_gateway_rest_api.alerta_webhook_api.root_resource_id
  path_part   = "webhooks"
}

resource "aws_api_gateway_method" "alerta_webhook_pd_method" {
  rest_api_id   = aws_api_gateway_rest_api.alerta_webhook_api.id
  resource_id   = aws_api_gateway_resource.alerta_webhook_resource.id
  http_method   = "POST"
  authorization = "NONE"
}

resource "aws_api_gateway_integration" "alerta_webhook_lambda_integration" {
  rest_api_id             = aws_api_gateway_rest_api.alerta_webhook_api.id
  resource_id             = aws_api_gateway_resource.alerta_webhook_resource.id
  http_method             = aws_api_gateway_method.alerta_webhook_pd_method.http_method
  integration_http_method = "POST"
  type                    = "AWS"
  uri                     = aws_lambda_function.alerta_pd_webhook_lambda.invoke_arn
}

resource "aws_api_gateway_method_response" "alerta_webhook_method_response" {
  rest_api_id = aws_api_gateway_rest_api.alerta_webhook_api.id
  resource_id = aws_api_gateway_resource.alerta_webhook_resource.id
  http_method = aws_api_gateway_method.alerta_webhook_pd_method.http_method
  status_code = "200"

  response_models = {"application/json" = "Empty"}
}

resource "aws_api_gateway_integration_response" "alerta_webhook_integration_response" {
  rest_api_id = aws_api_gateway_rest_api.alerta_webhook_api.id
  resource_id = aws_api_gateway_resource.alerta_webhook_resource.id
  http_method = aws_api_gateway_method.alerta_webhook_pd_method.http_method
  status_code = aws_api_gateway_method_response.alerta_webhook_method_response.status_code
}
