
resource "aws_lambda_function" "alerta_scheduled_tasks_lambda" {
  filename      = "${path.module}/lambda/dist/alerta_scheduled_tasks.zip"
  function_name = "alerta_scheduled_tasks"
  handler       = "alerta_scheduled_tasks.lambda_handler"
  runtime       = "python3.7"
  role          = aws_iam_role.alerta_scheduled_tasks_role.arn
  source_code_hash = filebase64sha256("${path.module}/lambda/dist/alerta_scheduled_tasks.zip")
  timeout = 60

  vpc_config {
    subnet_ids = module.variables.private_subnet_ids
    security_group_ids = [module.variables.sg_twitch_subnet_id]
  }
}

resource "aws_cloudwatch_event_rule" "every_10_minutes" {
  name                = "every-10-minutes"
  description         = "Fires every 10 minutes"
  schedule_expression = "rate(10 minutes)"
}

resource "aws_cloudwatch_event_rule" "every_minute" {
  name                = "every-minute"
  description         = "Fires every minute"
  schedule_expression = "rate(1 minute)"
}

resource "aws_cloudwatch_event_target" "run_scheduled_tasks_every_10_minutes" {
  rule      = "${aws_cloudwatch_event_rule.every_10_minutes.name}"
  target_id = "alerta_scheduled_tasks_lambda"
  arn       = "${aws_lambda_function.alerta_scheduled_tasks_lambda.arn}"
  input     = "{\"action\": \"housekeeping\"}"
}

resource "aws_cloudwatch_event_target" "run_status_every_minute" {
  rule      = "${aws_cloudwatch_event_rule.every_minute.name}"
  target_id = "alerta_scheduled_tasks_lambda"
  arn       = "${aws_lambda_function.alerta_scheduled_tasks_lambda.arn}"
  input     = "{\"action\": \"status\"}"
}

resource "aws_lambda_permission" "allow_cloudwatch_to_call_alerta_scheduled_tasks_lambda" {
  statement_id  = "AllowExecutionFromCloudWatch"
  action        = "lambda:InvokeFunction"
  function_name = "${aws_lambda_function.alerta_scheduled_tasks_lambda.function_name}"
  principal     = "events.amazonaws.com"
  source_arn    = "${aws_cloudwatch_event_rule.every_10_minutes.arn}"
}

resource "aws_lambda_permission" "allow_cloudwatch_to_call_alerta_scheduled_tasks_lambda_status" {
  statement_id  = "AllowExecutionFromCloudWatchEveryMinute"
  action        = "lambda:InvokeFunction"
  function_name = "${aws_lambda_function.alerta_scheduled_tasks_lambda.function_name}"
  principal     = "events.amazonaws.com"
  source_arn    = "${aws_cloudwatch_event_rule.every_minute.arn}"
}

resource "aws_iam_role" "alerta_scheduled_tasks_role" {
  name               = "video-alerta-scheduled_tasks-${var.env}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
  {
    "Effect": "Allow",
    "Principal": {
      "Service": "lambda.amazonaws.com"
    },
    "Action": "sts:AssumeRole"
  }
 ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "alerta_scheduled_tasks_policy_attachment" {
  role       = aws_iam_role.alerta_scheduled_tasks_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole" # managed role
}
