resource "aws_lambda_function" "alerta_pd_webhook_lambda" {
  filename      = "${path.module}/lambda/dist/pagerduty_webhook.zip"
  function_name = "alerta-pagerduty-webhook"
  role          = aws_iam_role.pd_webhook_role.arn
  handler       = "pagerduty_webhook.lambda_handler"

  source_code_hash = filebase64sha256("${path.module}/lambda/dist/pagerduty_webhook.zip")

  runtime = "python3.7"

  timeout = 60

  environment {
    variables = {
      ALERTA_WEBHOOK_URL = ""
    }
  }

  vpc_config {
    subnet_ids = module.variables.private_subnet_ids
    security_group_ids = ["sg-5733632e"]
  }
}

resource "aws_lambda_permission" "allow_api_gateway_execution" {
  statement_id  = "AllowExecutionFromAPIGateway"
  action        = "lambda:InvokeFunction"
  function_name = aws_lambda_function.alerta_pd_webhook_lambda.function_name
  principal     = "apigateway.amazonaws.com"

  # More: http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html
  source_arn = "arn:aws:execute-api:${var.region}:${data.aws_caller_identity.caller.account_id}:${aws_api_gateway_rest_api.alerta_webhook_api.id}/*/${aws_api_gateway_method.alerta_webhook_pd_method.http_method}${aws_api_gateway_resource.alerta_webhook_resource.path}"
}

resource "aws_iam_role" "pd_webhook_role" {
  name               = "video-alerta-pd-webhook-${var.env}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
  {
    "Effect": "Allow",
    "Principal": {
      "Service": "lambda.amazonaws.com"
    },
    "Action": "sts:AssumeRole"
  }
 ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "alerta_pd_webhook_policy_attachment" {
  role       = aws_iam_role.pd_webhook_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole" # managed role
}
