#!/usr/bin/env bash

set -eo pipefail

usage() {
    echo "Usage: $0 -e <staging|prod> <command> [args]"
    exit 1
}

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && usage )
    command -v terrafile &> /dev/null|| ( echo "terrafile required but missing: " && usage )
}

tf_init() {
    shift

    terrafile -f "conf/${env}/Terrafile"
    ln -sfn "${env}" vendor/modules/twitch-video-ops-defaults/current

    # tf 0.12 resolves symlink path path and writes it to this file instead
    rm -f .terraform/modules/modules.json

    terraform init "$@" -reconfigure -backend-config="conf/${env}/backend.tfvars"
}

package_lambdas() {
    build_dir="/tmp/package_lambdas-$$"
    for req in "$(cd $(dirname $0) && pwd)"/lambda/*/requirements.txt; do
        lambda_src_dir=$(dirname $req)
        lambda_name=$(basename $lambda_src_dir)
        mkdir -p $build_dir/$lambda_name
        cp -r $lambda_src_dir/* $build_dir/$lambda_name
        pip install --target $build_dir/$lambda_name -r $req
        ( cd $build_dir/$lambda_name && zip -r $lambda_src_dir/../dist/$lambda_name.zip . )
    done
    rm -rf $build_dir
}

if [[ "$1" == "-e" && "$2" =~ ^staging$|^prod$ ]]; then
    env="$2"
    shift 2

    requirements

    case "$1" in
        init)
            tf_init "$@"
            ;;
        plan|apply)
            tf_init "$@"
            package_lambdas
            exec terraform "$@" \
                -var-file="conf/${env}/variables.tfvars"
            ;;
        destroy)
            exec terraform "$@" \
                -var-file="conf/${env}/variables.tfvars"
            ;;
        *)
            exec terraform "$@"
            ;;
    esac
else
    usage
fi
