import boto3
import requests

# region and env can be parameterized for multi-region deployment
ALERTA_WEBHOOK_URL = "https://video-alerta.us-west-2.staging.alerta.live-video.a2z.com/api/webhooks/pagerduty"

def lambda_handler(event, context):
    try:
        i_key = event['messages'][0]['data']['incident']['incident_key']
        print("processing incident key {}".format(i_key))
        resp = requests.post(ALERTA_WEBHOOK_URL, json=event)
        print(resp.content)
    except Exception as e:
        print("failed to process incident {}: {}".format(i_key, e))
