import logging
import boto3
from botocore.exceptions import ClientError, ParamValidationError
import sys
import json
import os

logger = logging.getLogger()
logging.basicConfig(stream=sys.stdout, level=logging.INFO)

sqs = boto3.client('sqs')
sns = boto3.client('sns')


def forward_message_to_sns(message):
    try:
        raw_message = json.loads(message['body'])
        unloaded_alarm = json.loads(raw_message['Message'])
        sns.publish(
            TargetArn=os.environ['sns_topic'],
            Message=json.dumps({'default': json.dumps(unloaded_alarm, separators=(',', ':'))}),
            MessageStructure='json'
        )
        return True
    except ClientError as e:
        logger.error("Failed to forward message to sns: %s", e)
        return False



def lambda_handler(event, context):
    messages_processed = 0
    # Go through all messages at best effort
    for message in event['Records']:
        forward_success = forward_message_to_sns(message)
        # "Alerts are cheap" - Alerta. we can dumbly forward the message
        # at best effort and delete them from the queue to keep the queue small
        # and let alerts be sent again
        if forward_success:
            messages_processed += 1


    logger.info("Successfully processed %s of %s messages", messages_processed, len(event['Records']))
