[
  {
    "name": "alerta-netdata",
    "image": "${app_image}",
    "cpu": ${fargate_cpu},
    "memory": ${fargate_memory},
    "networkMode": "awsvpc",
    "logConfiguration": {
        "logDriver": "awslogs",
        "options": {
          "awslogs-group": "/ecs/alerta-netdata",
          "awslogs-region": "${aws_region}",
          "awslogs-stream-prefix": "ecs"
        }
    },
    "environment": [
      {
        "name": "SECRET_KEY",
        "value": "9(jB%tXvAI6jvXTgwbIw9s=%5Rp3px+%"
      },
      {
        "name": "DASHBOARD_URL",
        "value": "https://video-alerta-netdata-internal.${env}.vidops.twitch.a2z.com"
      },
      {
        "name": "PAGERDUTY_SERVICE_KEY",
        "value": "fc1668d2113141c59a08ef34b24119ee"
      },
      {
        "name": "DATABASE_URL",
        "value": "postgresql://${db_username}:${db_password}@${alerta_db_addr}/${database_name}?connect_timeout=10&application_name=alerta"

      },
      {
        "name": "DATABASE_NAME",
        "value": "alertadb"
      },
      {
        "name": "CORS_ORIGINS",
        "value": "http://localhost,http://localhost:8080,https://video-alerta-netdata-internal.${env}.vidops.twitch.a2z.com"
      },
      {
        "name": "DEBUG",
        "value": "true"
      },
      {
        "name": "PLUGINS",
        "value": "blackout,enhance,pagerduty,reject,slack"
      },
      {
        "name": "RUNBOOK_URL",
        "value": "https://wiki.twitch.com/display/VID/Nagios+Alerts"
      },
      {
        "name": "SLACK_WEBHOOK_URL",
        "value": ""
      },
      {
        "name": "SLACK_ATTACHMENTS",
        "value": "true"
      },
      {
        "name": "SLACK_CHANNEL",
        "value": "CK06TCB61"
      },
      {
        "name": "ALERTA_USERNAME",
        "value": "Mercy"
      },
      {
        "name": "ICON_EMOJI",
        "value": ":mercy:"
      }
    ],
    "portMappings": [
      {
        "containerPort": ${app_port},
        "hostPort": ${app_port}
      }
    ]
  }
]
