# Optional inputs
variable "env" {
  description = "Service environment - (prod|stage)"
  default     = "stage"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

variable "instance_type_server" {
  description = "EC2 instance type for servers"
  default     = "m4.xlarge"
}

variable "account_topics" {
  description = "The list of SNS topics from other accounts the central queue allows messages to publish to"
  default     = ""
}

# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    staging = "staging"
    dev   = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "alerta"
    Environment = var.env
    Source      = "video-monitoring/tf-io-alerta"
  }
}

# Alerta API/UI
variable "ecs_task_execution_role_name" {
  description = "ECS task execution role name"
  default     = "alertaEcsTaskExecutionRole"
}

variable "ecs_auto_scale_role_name" {
  description = "ECS auto scale role Name"
  default     = "alertaEcsAutoScaleRole"
}

variable "cloudwatch_app_image" {
  description = "Docker image to run in the ECS cluster"
  default     = "docker-registry.internal.justin.tv/video-monitoring/alerta:a786d5485bfb75aebeae62edd5ebb9840bf91a95"
}

variable "netdata_app_image" {
  description = "Docker image to run in the ECS cluster"
  default     = "docker-registry.internal.justin.tv/video-monitoring/alerta:106dc034e0634ba41ff064fcd5a4f52a0d6cd932"
}

variable "app_port" {
  description = "Port exposed by the docker image to redirect traffic to"
  default     = 8080
}

variable "app_count" {
  description = "Number of docker containers to run"
  default     = 3
}

variable "health_check_path" {
  default = "/"
}

variable "fargate_cpu" {
  description = "Fargate instance CPU units to provision (1 vCPU = 1024 CPU units)"
  default     = "4096"
}

variable "fargate_memory" {
  description = "Fargate instance memory to provision (in MiB)"
  default     = "8192"
}
# Alerta API/UI
