# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`chrony`](#chrony): Installs and configures chrony

#### Private Classes

* `chrony::config`: Configures chrony
* `chrony::install`: Installs chrony
* `chrony::params`: chrony class parameters
* `chrony::service`: Manages the chrony service

### Functions

#### Public Functions


#### Private Functions

* `chrony::server_array_to_hash`: Function to normalise servers/pools/peers

### Data types

* [`Chrony::Servers`](#chronyservers): Type for the `servers`, `pools` and `peers` parameters.

## Classes

### `chrony`

Installs and configures chrony

* **See also**
  * https://chrony.tuxfamily.org

#### Examples

##### Install chrony with default options

```puppet
include chrony
```

##### Use specific servers (These will be configured with the `iburst` option.)

```puppet
class { 'chrony':
  servers => [ 'ntp1.corp.com', 'ntp2.corp.com', ],
}
```

##### Two specific servers without `iburst`

```puppet
class { 'chrony':
  servers => {
    'ntp1.corp.com' => [],
    'ntp2.corp.com' => [],
  },
}
```

##### Ensure a secret password is used for chronyc

```puppet
class { 'chrony':
  servers         => [ 'ntp1.corp.com', 'ntp2.corp.com', ],
  chrony_password => 'secret_password',
}
```

##### Use NTP authentication

```puppet
class { 'chrony':
  keys            => [
    '25 SHA1 HEX:1dc764e0791b11fa67efc7ecbc4b0d73f68a070c',
  ],
  servers         => {
    'ntp1.corp.com' => ['key 25', 'iburst'],
    'ntp2.corp.com' => ['key 25', 'iburst'],
  },
}
```

##### Have chronyd autogenerate a command key at startup

```puppet
class { 'chrony':
  chrony_password    => 'unset',
  config_keys_manage => false,
}
```

##### Allow some hosts

```puppet
class { 'chrony':
  queryhosts => ['192.168/16'],
}
```

##### Configure the leap second mode

```puppet
class { 'chrony':
  leapsecmode => 'slew',
  smoothtime  => '400 0.001 leaponly',
  maxslewrate => 1000.0
}
```

##### Configure [makestep](https://chrony.tuxfamily.org/doc/3.4/chrony.conf.html#makestep)

```puppet
# Step the system clock if the adjustment is larger than 1000 seconds, but only in the first ten clock updates.
class { 'chrony':
  makestep_seconds => 1000,
  makestep_updates => 10,
}
```

#### Parameters

The following parameters are available in the `chrony` class.

##### `bindcmdaddress`

Data type: `Array[String]`

Array of addresses of interfaces on which chronyd will listen for monitoring command packets.

Default value: `['127.0.0.1', '::1']`

##### `cmdacl`

Data type: `Array[String]`

An array of ACLs for monitoring access. This expects a list of directives, for
example: `['cmdallow 1.2.3.4', 'cmddeny 1.2.3']`. The order will be respected at
the time of generating the configuration. The argument of the allow or deny
commands can be an address, a partial address or a subnet (see manpage for more
details).

Default value: `$chrony::params::cmdacl`

##### `cmdport`

Data type: `Optional[Stdlib::Port]`

The cmdport directive allows the port that is used for run-time monitoring (via the chronyc program)
to be altered from its default (323).

Default value: ``undef``

##### `commandkey`

Data type: `Any`

This sets the key ID used by chronyc to authenticate to chronyd.

Default value: `0`

##### `chrony_password`

Data type: `String[1]`

This sets the chrony password to be used in the key file.
By default a short fixed string is used. If set explicitly to
'unset' then no password will be added to the keys file by puppet.

Default value: `'xyzzy'`

##### `config`

Data type: `Stdlib::Unixpath`

This sets the file to write chrony configuration into.

Default value: `$chrony::params::config`

##### `config_template`

Data type: `String[1]`

This determines which template puppet should use for the chrony configuration.

Default value: `'chrony/chrony.conf.epp'`

##### `config_keys`

Data type: `Stdlib::Unixpath`

This sets the file to write chrony keys into.

Default value: `$chrony::params::config_keys`

##### `config_keys_manage`

Data type: `Boolean`

Determines whether puppet will manage the content of the keys file after it has been created for the first time.

Default value: ``true``

##### `config_keys_template`

Data type: `String[1]`

This determines which template puppet should use for the chrony key file.

Default value: `'chrony/chrony.keys.epp'`

##### `config_keys_owner`

Data type: `Variant[Integer[0],String[1]]`

Specify unix owner of chrony keys file, defaults to 0.

Default value: `$chrony::params::config_keys_owner`

##### `config_keys_group`

Data type: `Variant[Integer[0],String[1]]`

Specify unix group of chrony keys files, defaults to 0 on ArchLinux and chrony on Redhat.

Default value: `$chrony::params::config_keys_group`

##### `config_keys_mode`

Data type: `Stdlib::Filemode`

Specify unix mode of chrony keys files, defaults to 0644 on ArchLinux and 0640 on Redhat.

Default value: `$chrony::params::config_keys_mode`

##### `keys`

Data type: `Array[String[1]]`

An array of key lines.  These are printed as-is into the chrony key file.

Default value: `[]`

##### `driftfile`

Data type: `Stdlib::Unixpath`

A file for chrony to record clock drift in.

Default value: `'/var/lib/chrony/drift'`

##### `local_stratum`

Data type: `Integer[1,15]`

Override the stratum of the server which will be reported to clients
when the local reference is active.

Default value: `10`

##### `stratumweight`

Data type: `Optional[Numeric]`

Sets how much distance should be added per stratum to the synchronisation distance when chronyd
selects the synchronisation source from available sources.
When not set, chronyd's default will be used, which since version 2.0 of chrony, is 0.001 seconds.

Default value: ``undef``

##### `log_options`

Data type: `Optional[String[1]]`

Specify which information is to be logged.

Default value: ``undef``

##### `package_ensure`

Data type: `String[1]`

This can be set to 'present' or 'latest' or a specific version to choose the
chrony package to be installed.

Default value: `'present'`

##### `package_name`

Data type: `String[1]`

This determines the name of the package to install.

Default value: `$chrony::params::package_name`

##### `package_source`

Data type: `Optional[String]`

Source for the package when not wanting to install from a package repository.  This is required if
[`package_provider`](#package_provider) is set to `rpm` or `dpkg`.

Default value: ``undef``

##### `package_provider`

Data type: `Optional[String]`

Override the default package provider with a specific backend to use when installing the chrony package.
Also see [`package_source`](#package_source).

Default value: ``undef``

##### `peers`

Data type: `Chrony::Servers`

This selects the servers to use for NTP peers (symmetric association).
It can be an array of peers or a hash of peers with their respective options.

Default value: `[]`

##### `servers`

Data type: `Chrony::Servers`

This selects the servers to use for NTP servers.  It can be an array of servers
or a hash of servers to their respective options. If an array is used, `iburst` will be configured for each server.
If you don't want to use `iburst`, use a hash instead.

Default value: `{
    '0.pool.ntp.org' => ['iburst'],
    '1.pool.ntp.org' => ['iburst'],
    '2.pool.ntp.org' => ['iburst'],
    '3.pool.ntp.org' => ['iburst'],
  }`

##### `pools`

Data type: `Chrony::Servers`

This is used to specify one or more *pools* of NTP servers to use instead of individual NTP servers.
Similar to [`server`](#server), it can be an array of pools, (using iburst), or a hash of pools to their respective options.
See [pool](https://chrony.tuxfamily.org/doc/3.4/chrony.conf.html#pool)

Default value: `{}`

##### `refclocks`

Data type: `Any`

This should be a Hash of hardware reference clock drivers to use.  They hash
can either list a single list of options for the driver, or any array of
multiple options if the same driver is used for multiple hardware clocks.

Example:
```puppet
refclocks => { 'PPS' => [ '/dev/pps0 lock NMEA refid GPS',
                         '/dev/pps1:clear refid GPS2' ],
               'SHM' => '0 offset 0.5 delay 0.2 refid NMEA noselect' }
```

Default value: `[]`

##### `makestep_seconds`

Data type: `Numeric`

Configures the [`makestep`](https://chrony.tuxfamily.org/doc/3.4/chrony.conf.html#makestep) `threshold`.
Normally chronyd will cause the system to gradually correct any time offset, by slowing down or speeding up the clock as required.
If the adjustment is larger than `makestep_seconds`, chronyd will step the clock.
Also see [`makestep_updates`](#makestep_updates).

Default value: `10`

##### `makestep_updates`

Data type: `Integer`

Configures the [`makestep`](https://chrony.tuxfamily.org/doc/3.4/chrony.conf.html#makestep) `limit`.
Chronyd will step the time only if there have been no more than `makestep_updates` clock updates.
Set to a negative value to disable the limit (useful for virtual machines and laptops that may get suspended for a prolonged time).
Also see [`makestep_seconds`](#makestep_seconds).

Default value: `3`

##### `queryhosts`

Data type: `Array[String]`

This adds the networks, hosts that are allowed to query the daemon.

Default value: `[]`

##### `port`

Data type: `Optional[Stdlib::Port]`

Port the service should listen on. Module default is `undef` which means that port
isn't added to chrony.conf, and chrony listens to the default ntp port 123 if
`queryhosts` is used.

Default value: ``undef``

##### `service_enable`

Data type: `Boolean`

This determines if the service should be enabled at boot.

Default value: ``true``

##### `service_ensure`

Data type: `Stdlib::Ensure::Service`

This determines if the service should be running or not.

Default value: `'running'`

##### `service_manage`

Data type: `Boolean`

This selects if puppet should manage the service in the first place.

Default value: ``true``

##### `service_name`

Data type: `String[1]`

This selects the name of the chrony service for puppet to manage.

Default value: `$chrony::params::service_name`

##### `smoothtime`

Data type: `Optional[String]`

Specify the smoothing of the time parameter as a string, for example `smoothtime 50000 0.01`.

Default value: ``undef``

##### `mailonchange`

Data type: `Optional[String[1]]`

Specify the mail you wanna alert when chronyd executes a sync grater than the `threshold`.

Default value: ``undef``

##### `threshold`

Data type: `Float`

Specify the time limit for triggering events.

Default value: `0.5`

##### `lock_all`

Data type: `Boolean`

Force chrony to only use RAM & prevent swapping.

Default value: ``false``

##### `leapsecmode`

Data type: `Optional[Enum['system', 'step', 'slew', 'ignore']]`

Configures how to insert the leap second mode.

Default value: ``undef``

##### `leapsectz`

Data type: `Optional[String]`

Specifies a timezone that chronyd can use to determine the offset between UTC and TAI.

Default value: ``undef``

##### `maxslewrate`

Data type: `Optional[Float]`

Maximum rate for chronyd to slew the time. Only float type values possible, for example: `maxslewrate 1000.0`.

Default value: ``undef``

##### `clientlog`

Data type: `Boolean`

Determines whether to log client accesses.

Default value: `$chrony::params::clientlog`

##### `clientloglimit`

Data type: `Optional[Integer]`

When set, specifies the maximum amount of memory in bytes that chronyd is allowed to allocate for logging of client accesses.
If not set, chrony's, default will be used. In modern versions this is 524288 bytes.  Older versions defaulted to have no limit.
See [clientloglimit](https://chrony.tuxfamily.org/doc/3.4/chrony.conf.html#clientloglimit)

Default value: ``undef``

##### `rtcsync`

Data type: `Boolean`

Sync system clock to RTC periodically

Default value: ``true``

##### `rtconutc`

Data type: `Boolean`

Keep RTC in UTC instead of local time.
If not set, chrony's, default will be used. On Arch Linux the default is true instead.
See [rtconutc](https://chrony.tuxfamily.org/doc/3.4/chrony.conf.html#rtconutc)

Default value: `$chrony::params::rtconutc`

##### `hwtimestamps`

Data type: `Variant[Hash,Array[String]]`

This selects interfaces to enable hardware timestamps on. It can be an array of
interfaces or a hash of interfaces to their respective options.

Default value: `[]`

##### `dumpdir`

Data type: `Optional[Stdlib::Unixpath]`

Directory to store measurement history in on exit.

Default value: `$chrony::params::dumpdir`

## Functions

## Data types

### `Chrony::Servers`

This type is for the `servers`, `pools` and `peers` parameters.

#### Examples

##### A hash of servers

```puppet
{
  'ntp1.example.com => [
    'minpoll 3',
    'maxpoll 6',
  ],
  'ntp2.example.com => [
    'iburst',
    'minpoll 4',
    'maxpoll 8',
  ],
}
```

##### An array of servers

```puppet
[
  'ntp1.example.com',
  'ntp2.example.com',
]
```

Alias of `Variant[Hash[Stdlib::Host, Optional[Array[String]]], Array[Stdlib::Host]]`

