# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

_Public Classes_

* [`java`](#java): This module manages the Java runtime package

_Private Classes_

* `java::config`: 
* `java::params`: This class builds a hash of JDK/JRE packages and (for Debian)
alternatives.  For wheezy/precise, we provide Oracle JDK/JRE
options, even though those are not in the package repositories.

**Defined types**

* [`java::adopt`](#javaadopt): Install one or more versions of AdoptOpenJDK Java.
* [`java::download`](#javadownload): Installs Java from a url location.
* [`java::sap`](#javasap): Install one or more versions of SAPJVM or Sapmachine

## Classes

### java

This module manages the Java runtime package

#### Parameters

The following parameters are available in the `java` class.

##### `distribution`

Data type: `String`

The java distribution to install. Can be one of "jdk" or "jre",
or other platform-specific options where there are multiple
implementations available (eg: OpenJDK vs Oracle JDK).

Default value: 'jdk'

##### `version`

Data type: `Pattern[/present|installed|latest|^[.+_0-9a-zA-Z:~-]+$/]`

The version of java to install. By default, this module simply ensures
that java is present, and does not require a specific version.

Default value: 'present'

##### `package`

Data type: `Optional[String]`

The name of the java package. This is configurable in case a non-standard
java package is desired.

Default value: `undef`

##### `package_options`

Data type: `Optional[Array]`

Array of strings to pass installation options to the 'package' Puppet resource.
Options available depend on the 'package' provider for the target OS.

Default value: `undef`

##### `java_alternative`

Data type: `Optional[String]`

The name of the java alternative to use on Debian systems.
"update-java-alternatives -l" will show which choices are available.
If you specify a particular package, you will almost always also
want to specify which java_alternative to choose. If you set
this, you also need to set the path below.

Default value: `undef`

##### `java_alternative_path`

Data type: `Optional[String]`

The path to the "java" command on Debian systems. Since the
alternatives system makes it difficult to verify which
alternative is actually enabled, this is required to ensure the
correct JVM is enabled.

Default value: `undef`

##### `java_home`

Data type: `Optional[String]`

The path to where the JRE is installed. This will be set as an
environment variable.

Default value: `undef`

## Defined types

### java::adopt

Defined Type java::adopt

#### Parameters

The following parameters are available in the `java::adopt` defined type.

##### `ensure`

Data type: `Any`

Install or remove the package.

Default value: 'present'

##### `version`

Data type: `Any`

Version of Java to install, e.g. '8' or '9'. Default values for major and minor versions will be used.

Default value: '8'

##### `version_major`

Data type: `Any`

Major version which should be installed, e.g. '8u101' or '9.0.4'. Must be used together with version_minor.

Default value: `undef`

##### `version_minor`

Data type: `Any`

Minor version which should be installed, e.g. 'b12' (for version = '8') or '11' (for version != '8'). Must be used together with version_major.

Default value: `undef`

##### `java`

Data type: `Any`

Type of Java Standard Edition to install, jdk or jre.

Default value: 'jdk'

##### `proxy_server`

Data type: `Any`

Specify a proxy server, with port number if needed. ie: https://example.com:8080. (passed to archive)

Default value: `undef`

##### `proxy_type`

Data type: `Any`

Proxy server type (none|http|https|ftp). (passed to archive)

Default value: `undef`

##### `basedir`

Data type: `Any`

Directory under which the installation will occur. If not set, defaults to
/usr/lib/jvm for Debian and /usr/java for RedHat.

Default value: `undef`

##### `manage_basedir`

Data type: `Any`

Whether to manage the basedir directory.  Defaults to false.
Note: /usr/lib/jvm is managed for Debian by default, separate from this parameter.

Default value: `true`

##### `package_type`

Data type: `Any`

Type of installation package for specified version of java_se. java_se 6 comes
in a few installation package flavors and we need to account for them.
Optional forced package types: rpm, rpmbin, tar.gz

Default value: `undef`

##### `manage_symlink`

Data type: `Any`

Whether to manage a symlink that points to the installation directory.  Defaults to false.

Default value: `false`

##### `symlink_name`

Data type: `Any`

The name for the optional symlink in the installation directory.

Default value: `undef`

### java::download

Defined Type java::download

#### Parameters

The following parameters are available in the `java::download` defined type.

##### `ensure`

Data type: `Any`

Install or remove the package.

Default value: 'present'

##### `version`

Data type: `Any`

Version of Java to install, e.g. '7' or '8'. Default values for major and minor versions will be used.

Default value: '8'

##### `version_major`

Data type: `Any`

Major version which should be installed, e.g. '8u101'. Must be used together with version_minor.

Default value: `undef`

##### `version_minor`

Data type: `Any`

Minor version which should be installed, e.g. 'b12'. Must be used together with version_major.

Default value: `undef`

##### `java_se`

Data type: `Any`

Type of Java Standard Edition to install, jdk or jre.

Default value: 'jdk'

##### `proxy_server`

Data type: `Any`

Specify a proxy server, with port number if needed. ie: https://example.com:8080. (passed to archive)

Default value: `undef`

##### `proxy_type`

Data type: `Any`

Proxy server type (none|http|https|ftp). (passed to archive)

Default value: `undef`

##### `url`

Data type: `Any`

Full URL

Default value: `undef`

##### `jce`

Data type: `Any`

Install Oracles Java Cryptographic Extensions into the JRE or JDK

Default value: `false`

##### `jce_url`

Data type: `Any`

Full URL to the jce zip file

Default value: `undef`

##### `basedir`

Data type: `Any`

Directory under which the installation will occur. If not set, defaults to
/usr/lib/jvm for Debian and /usr/java for RedHat.

Default value: `undef`

##### `manage_basedir`

Data type: `Any`

Whether to manage the basedir directory.  Defaults to false.
Note: /usr/lib/jvm is managed for Debian by default, separate from this parameter.

Default value: `false`

##### `package_type`

Data type: `Any`

Type of installation package for specified version of java_se. java_se 6 comes
in a few installation package flavors and we need to account for them.
Optional forced package types: rpm, rpmbin, tar.gz

Default value: `undef`

##### `manage_symlink`

Data type: `Any`

Whether to manage a symlink that points to the installation directory.  Defaults to false.

Default value: `false`

##### `symlink_name`

Data type: `Any`

The name for the optional symlink in the installation directory.

Default value: `undef`

### java::sap

Defined Type java::sap

#### Parameters

The following parameters are available in the `java::sap` defined type.

##### `ensure`

Data type: `Any`

Install or remove the package.

Default value: 'present'

##### `version`

Data type: `Any`

Version of Java to install, e.g. '8' or '9'. Default values for full versions will be used.

Default value: '8'

##### `version_full`

Data type: `Any`

Major version which should be installed, e.g. '8.1.063' or '11.0.7'. If used, "version" parameter is ignored.

Default value: `undef`

##### `java`

Data type: `Any`

Type of Java Edition to install, jdk or jre.

Default value: 'jdk'

##### `proxy_server`

Data type: `Any`

Specify a proxy server, with port number if needed. ie: https://example.com:8080. (passed to archive)

Default value: `undef`

##### `proxy_type`

Data type: `Any`

Proxy server type (none|http|https|ftp). (passed to archive)

Default value: `undef`

##### `basedir`

Data type: `Any`

Directory under which the installation will occur. If not set, defaults to
/usr/lib/jvm for Debian and /usr/java for RedHat.

Default value: `undef`

##### `manage_basedir`

Data type: `Any`

Whether to manage the basedir directory.  Defaults to false.
Note: /usr/lib/jvm is managed for Debian by default, separate from this parameter.

Default value: `true`

##### `manage_symlink`

Data type: `Any`

Whether to manage a symlink that points to the installation directory.  Defaults to false.

Default value: `false`

##### `symlink_name`

Data type: `Any`

The name for the optional symlink in the installation directory.

Default value: `undef`

