# == Class: nsd::service
#
# This class manages the nsd service. It inherits its options from the main nsd
# class and uses them to configure the service.
#
# === Authors
#
# Mario Finelli <mario@finel.li>
#
# === Copyright
#
# Copyright 2015 Mario Finelli
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
class nsd::service inherits nsd {
  if ! ($nsd::service_ensure in [ 'running', 'stopped' ]) {
    fail('service_ensure parameter must be running or stopped')
  }

  if $nsd::service_manage == true {
    service { 'nsd':
      ensure     => $nsd::service_ensure,
      enable     => $nsd::service_enable,
      name       => $nsd::service_name,
      hasstatus  => true,
      hasrestart => true,
    }
  }
}
