# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

_Public Classes_

* [`ntp`](#ntp): ntp  Main class, includes all other classes.

_Private Classes_

* `ntp::config`: This class handles the configuration file.
* `ntp::install`: This class handles ntp packages.
* `ntp::service`: This class handles the ntp service.

**Data types**

* [`Ntp::Key_id`](#ntpkey_id): See http://doc.ntp.org/4.2.6/authopt.html#controlkey for documentation Alternatively: type Ntp::Key_id = Variant[Integer, Pattern['']]
* [`Ntp::Poll_interval`](#ntppoll_interval): See http://doc.ntp.org/4.2.6/clockopt.html#server for documentation Alternatively: type Ntp::Poll_interval = Variant[Integer, Pattern['']]

## Classes

### ntp

ntp

Main class, includes all other classes.

#### Parameters

The following parameters are available in the `ntp` class.

##### `authprov`

Data type: `Optional[String]`

Enables compatibility with W32Time in some versions of NTPd (such as Novell DSfW). Default value: undef.

##### `broadcastclient`

Data type: `Boolean`

Enables reception of broadcast server messages to any local interface. Default value: false.

##### `burst`

Data type: `Boolean`

When the server is reachable, send a burst of eight packets instead of the usual one. Default value: false.

##### `config`

Data type: `Stdlib::Absolutepath`

Specifies a file for NTP's configuration info. Default value: '/etc/ntp.conf' (or '/etc/inet/ntp.conf' on Solaris).

##### `config_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies a directory for the NTP configuration files. Default value: undef.

##### `config_epp`

Data type: `Optional[String]`

Specifies an absolute or relative file path to an EPP template for the config file.
Example value: 'ntp/ntp.conf.epp'. A validation error is thrown if both this **and** the `config_template` parameter are specified.

##### `config_file_mode`

Data type: `String`

Specifies a file mode for the ntp configuration file. Default value: '0664'.

##### `config_template`

Data type: `Optional[String]`

Specifies an absolute or relative file path to an ERB template for the config file.
Example value: 'ntp/ntp.conf.erb'. A validation error is thrown if both this **and** the `config_epp` parameter are specified.

##### `daemon_extra_opts`

Data type: `Optional[String]`

Specifies any arguments to pass to ntp daemon. Default value: '-g'.
Example value: '-g -i /var/lib/ntp' to enable jaildir options.
Note that user is a specific parameter handled separately.

##### `disable_auth`

Data type: `Boolean`

Disables cryptographic authentication for broadcast client, multicast client, and symmetric passive associations.

##### `disable_dhclient`

Data type: `Boolean`

Disables `ntp-servers` in `dhclient.conf` to prevent Dhclient from managing the NTP configuration.

##### `disable_kernel`

Data type: `Boolean`

Disables kernel time discipline.

##### `disable_monitor`

Data type: `Boolean`

Disables the monitoring facility in NTP. Default value: true.

##### `driftfile`

Data type: `Stdlib::Absolutepath`

Specifies an NTP driftfile. Default value: '/var/lib/ntp/drift' (except on AIX and Solaris).

##### `enable_mode7`

Data type: `Boolean`

Enables processing of NTP mode 7 implementation-specific requests which are used by the deprecated ntpdc program. Default value: false.

##### `fudge`

Data type: `Optional[Array[String]]`

Provides additional information for individual clock drivers. Default value: [ ]

##### `iburst_enable`

Data type: `Boolean`

Specifies whether to enable the iburst option for every NTP peer. Default value: false (true on AIX and Debian).

##### `interfaces`

Data type: `Array[String]`

Specifies one or more network interfaces for NTP to listen on. Default value: [ ].

##### `interfaces_ignore`

Data type: `Array[String]`

Specifies one or more ignore pattern for the NTP listener configuration (for example: all, wildcard, ipv6). Default value: [ ].

##### `keys`

Data type: `Array[String]`

Distributes keys to keys file. Default value: [ ].

##### `keys_controlkey`

Data type: `Optional[Ntp::Key_id]`

Specifies the key identifier to use with the ntpq utility. Value in the range of 1 to 65,534 inclusive. Default value: ' '.

##### `keys_enable`

Data type: `Boolean`

Whether to enable key-based authentication. Default value: false.

##### `keys_file`

Data type: `Stdlib::Absolutepath`

Specifies the complete path and location of the MD5 key file containing the keys and key identifiers used by ntpd, ntpq and ntpdc
when operating with symmetric key cryptography. Default value: `/etc/ntp.keys` (on RedHat and Amazon, `/etc/ntp/keys`).

##### `keys_requestkey`

Data type: `Optional[Ntp::Key_id]`

Specifies the key identifier to use with the ntpdc utility program. Value in the range of 1 to 65,534. Default value: ' '.

##### `keys_trusted`

Data type: `Optional[Array[Ntp::Key_id]]`

Provides one or more keys to be trusted by NTP. Default value: [ ].

##### `leapfile`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies a leap second file for NTP to use. Default value: ' '.

##### `logfile`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies a log file for NTP to use instead of syslog. Default value: ' '.

##### `logconfig`

Data type: `Optional[String]`

Specifies the logconfig for NTP to use. Default value: ' '.

##### `minpoll`

Data type: `Optional[Ntp::Poll_interval]`

Sets Puppet to non-standard minimal poll interval of upstream servers.
Values: 3 to 16. Default: undef.

##### `maxpoll`

Data type: `Optional[Ntp::Poll_interval]`

Sets use non-standard maximal poll interval of upstream servers.
Values: 3 to 16. Default option: undef, except on FreeBSD (on FreeBSD, defaults to 9).

##### `ntpsigndsocket`

Data type: `Optional[Stdlib::Absolutepath]`

Sets NTP to sign packets using the socket in the ntpsigndsocket path. Requires NTP to be configured to sign sockets.
Value: Path to the socket directory; for example, for Samba: `usr/local/samba/var/lib/ntp_signd/`. Default value: undef.

##### `package_ensure`

Data type: `String`

Whether to install the NTP package, and what version to install. Values: 'present', 'latest', or a specific version number.
Default value: 'present'.

##### `package_manage`

Data type: `Boolean`

Whether to manage the NTP package. Default value: true.

##### `package_name`

Data type: `Array[String]`

Specifies the NTP package to manage. Default value: ['ntp'] (except on AIX and Solaris).

##### `panic`

Data type: `Optional[Integer[0]]`

Whether NTP should "panic" in the event of a very large clock skew. Applies only if `tinker` option set to true or if your environment
is in a virtual machine. Default value: 0 if environment is virtual, undef in all other cases.

##### `peers`

Data type: `Array[String]`

List of NTP servers with which to synchronise the local clock.

##### `tos_orphan`

Data type: `Optional[Integer[1]]`

Enables Orphan mode for peer group
Value: Should be set to 2 more than the worst-case externally-reachable source's stratum.

##### `pool`

Data type: `Optional[Array[String]]`

List of NTP server pools with which to synchronise the local clock.

##### `preferred_servers`

Data type: `Array[String]`

Specifies one or more preferred peers. Puppet appends 'prefer' to each matching item in the `servers` array.
Default value: [ ].

##### `noselect_servers`

Data type: `Array[String]`

Specifies one or more peers to not sync with. Puppet appends 'noselect' to each matching item in the `servers` array.
Default value: [ ].

##### `restrict`

Data type: `Array[String]`

Specifies one or more `restrict` options for the NTP configuration.
Puppet prefixes each item with 'restrict', so you need to list only the content of the restriction.
Default value for most operating systems:
  '[default kod nomodify notrap nopeer noquery', '-6 default kod nomodify notrap nopeer noquery', '127.0.0.1', '-6 ::1']'.
Default value for AIX systems:
  '['default nomodify notrap nopeer noquery', '127.0.0.1',]'.

##### `servers`

Data type: `Array[String]`

Specifies one or more servers to be used as NTP peers. Default value: varies by operating system.

##### `service_enable`

Data type: `Boolean`

Whether to enable the NTP service at boot. Default value: true.

##### `service_ensure`

Data type: `Enum['running', 'stopped']`

Whether the NTP service should be running. Default value: 'running'.

##### `service_manage`

Data type: `Boolean`

Whether to manage the NTP service.  Default value: true.

##### `service_name`

Data type: `String`

The NTP service to manage. Default value: varies by operating system.

##### `service_provider`

Data type: `Optional[String]`

Which service provider to use for NTP. Default value: 'undef'.

##### `service_hasstatus`

Data type: `Boolean`

Whether service has a functional status command. Default value: true.

##### `service_hasrestart`

Data type: `Boolean`

Whether service has a restart command. Default value: true.

##### `slewalways`

Data type: `Optional[Enum['yes','no']]`

xntpd setting to disable stepping behavior and always slew the clock to handle adjustments.
Only relevant for AIX. Default value: 'undef'. Allowed values: 'yes', 'no'

##### `statistics`

Data type: `Optional[Array]`

List of statistics to have NTP generate and keep. Default value: [ ].

##### `statsdir`

Data type: `Optional[Stdlib::Absolutepath]`

Location of the NTP statistics directory on the managed system. Default value: '/var/log/ntpstats'.

##### `step_tickers_file`

Data type: `Optional[Stdlib::Absolutepath]`

Location of the step tickers file on the managed system. Default value: varies by operating system.

##### `step_tickers_epp`

Data type: `Optional[String]`

Location of the step tickers EPP template file. Default value: varies by operating system.
Validation error is thrown if both this and the `step_tickers_template` parameters are specified.

##### `step_tickers_template`

Data type: `Optional[String]`

Location of the step tickers ERB template file. Default value: varies by operating system.
Validation error is thrown if both this and the `step_tickers_epp` parameter are specified.

##### `stepout`

Data type: `Optional[Integer[0, 65535]]`

Value for stepout if `tinker` value is true. Valid options: unsigned shortint digit. Default value: undef.

##### `tos`

Data type: `Boolean`

Whether to enable tos options. Default value: false.

##### `tos_minclock`

Data type: `Optional[Integer[1]]`

Specifies the minclock tos option. Default value: 3.

##### `tos_maxclock`

Data type: `Optional[Integer[1]]`

Specifies the maxclock tos option. Default value: 6.

##### `tos_minsane`

Data type: `Optional[Integer[1]]`

Specifies the minsane tos option. Default value: 1.

##### `tos_floor`

Data type: `Optional[Integer[1]]`

Specifies the floor tos option. Default value: 1.

##### `tos_ceiling`

Data type: `Optional[Integer[1]]`

Specifies the ceiling tos option. Default value: 15.

##### `tos_cohort`

Data type: `Variant[Boolean, Integer[0,1]]`

Specifies the cohort tos option. Valid options: 0 or 1. Default value: 0.

##### `tinker`

Data type: `Optional[Boolean]`

Whether to enable tinker options. Default value: false.

##### `udlc`

Data type: `Boolean`

Specifies whether to configure NTP to use the undisciplined local clock as a time source. Default value: false.

##### `udlc_stratum`

Data type: `Optional[Integer[1,15]]`

Specifies the stratum the server should operate at when using the undisciplined local clock as the time source.
This value should be set to no less than 10 if ntpd might be accessible outside your immediate, controlled network.
Default value: 10.am udlc

##### `user`

Data type: `Optional[String]`

Specifies user to run ntpd daemon. Default value: ntp.
Usually set by default on Centos7 (/etc/systemd/system/multi-user.target.wants/ntpd.service) and ubuntu 18.04 (/usr/lib/ntp/ntp-systemd-wrapper)
This is currently restricted to Redhat based systems of version 7 and above and Ubuntu 18.04.

## Data types

### Ntp::Key_id

See http://doc.ntp.org/4.2.6/authopt.html#controlkey for documentation
Alternatively: type Ntp::Key_id = Variant[Integer, Pattern['']]

Alias of `Integer[1, 65534]`

### Ntp::Poll_interval

See http://doc.ntp.org/4.2.6/clockopt.html#server for documentation
Alternatively: type Ntp::Poll_interval = Variant[Integer, Pattern['']]

Alias of `Integer[4, 17]`

