# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

* [`php`](#php): Base class with global configuration parameters that pulls in all enabled components.  === Parameters  [*ensure*]   Specify which version of 
* [`php::apache_config`](#phpapache_config): Install and configure php apache settings  === Parameters  [*inifile*]   The path to the ini php-apache ini file  [*settings*]   Hash with ne
* [`php::cli`](#phpcli): Install and configure php CLI  === Parameters  [*inifile*]   The path to the ini php5-cli ini file  [*settings*]   Hash with nested hash of k
* [`php::composer`](#phpcomposer): Install composer package manager  === Parameters  [*source*]   Holds URL to the Composer source file  [*path*]   Holds path to the Composer e
* [`php::composer::auto_update`](#phpcomposerauto_update): Install composer package manager  === Parameters  [*max_age*]   Defines number of days after which Composer should be updated  [*source*]   H
* [`php::dev`](#phpdev): Install the development package with headers for PHP  === Parameters  [*ensure*]   The PHP ensure of PHP dev to install  [*package*]   The pa
* [`php::embedded`](#phpembedded): Install and configure php embedded SAPI  === Parameters  [*inifile*]   The path to the ini php5-embeded ini file  [*settings*]   Hash with ne
* [`php::fpm`](#phpfpm): Install and configure mod_php for fpm  === Parameters  [*user*]   The user that php-fpm should run as  [*group*]   The group that php-fpm sho
* [`php::fpm::config`](#phpfpmconfig): Configure php-fpm service  === Parameters  [*config_file*]   The path to the fpm config file  [*user*]   The user that runs php-fpm  [*group*
* [`php::fpm::service`](#phpfpmservice): Manage fpm service  === Parameters  [*service_name*]   name of the php-fpm service  [*ensure*]   'ensure' value for the service  [*enable*]  
* [`php::global`](#phpglobal): 
* [`php::globals`](#phpglobals): 
* [`php::packages`](#phppackages): Install common PHP packages  === Parameters  [*ensure*]   Specify which version of PHP packages to install  [*names*]   List of the names of 
* [`php::params`](#phpparams): PHP params class
* [`php::pear`](#phppear): Install PEAR package manager  === Parameters  [*ensure*]   The package ensure of PHP pear to install and run pear auto_discover  [*package*] 
* [`php::phpunit`](#phpphpunit): Install phpunit, PHP testing framework  === Parameters  [*source*]   Holds URL to the phpunit source file  [*path*]   Holds path to the phpun
* [`php::phpunit::auto_update`](#phpphpunitauto_update): Install phpunit package manager  === Parameters  [*max_age*]   Defines number of days after which phpunit should be updated  [*source*]   Hol
* [`php::repo`](#phprepo): Configure package repository
* [`php::repo::debian`](#phprepodebian): Configure debian apt repo  === Parameters  [*location*]   Location of the apt repository  [*release*]   Release of the apt repository  [*repo
* [`php::repo::redhat`](#phpreporedhat): 
* [`php::repo::suse`](#phpreposuse): Configure suse repo  === Parameters  [*reponame*]   Name of the Zypper repository  [*baseurl*]   Base URL of the Zypper repository
* [`php::repo::ubuntu`](#phprepoubuntu): Configure ubuntu ppa  === Parameters  [*version*]   PHP version to manage (e.g. 5.6)

**Defined types**

* [`php::apache_vhost`](#phpapache_vhost): Configures an apache vhost for php  === Parameters  [*vhost*]   The vhost address  [*docroot*]   The vhost docroot  [*port*]   The vhost port
* [`php::config`](#phpconfig): Configure php.ini settings for a PHP SAPI  === Parameters  [*file*]   The path to ini file  [*config*]   Nested hash of key => value to apply
* [`php::config::setting`](#phpconfigsetting): Configure php.ini settings  === Parameters  [*key*]   The key of the value, like `ini_setting`  [*file*]   The path to ini file  [*value*]   
* [`php::extension`](#phpextension): Install a PHP extension package  === Parameters  [*ensure*]   The ensure of the package to install   Could be "latest", "installed" or a pinn
* [`php::extension::config`](#phpextensionconfig): Configure a PHP extension package  === Parameters  [*ensure*]   The ensure of the package to install   Could be "latest", "installed" or a pi
* [`php::extension::install`](#phpextensioninstall): Install a PHP extension package  === Parameters  [*ensure*]   The ensure of the package to install   Could be "latest", "installed" or a pinn
* [`php::fpm::pool`](#phpfpmpool): Configure fpm pools  === Parameters  See the official php-fpm documentation for parameters that are not documented here: http://php.net/manua

**Functions**

* [`ensure_prefix`](#ensure_prefix): This function ensures a prefix for all elements in an array or the keys in a hash.  *Examples:*    ensure_prefix({'a' => 1, 'b' => 2, 'p.c' =
* [`to_hash_settings`](#to_hash_settings): This function converts a +{key => value}+ hash into a nested hash and can add an id to the outer key. The optional id string as second parame

## Classes

### php

Base class with global configuration parameters that pulls in all
enabled components.

=== Parameters

[*ensure*]
  Specify which version of PHP packages to install, defaults to 'present'.
  Please note that 'absent' to remove packages is not supported!

[*manage_repos*]
  Include repository (dotdeb, ppa, etc.) to install recent PHP from

[*fpm*]
  Install and configure php-fpm

[*fpm_service_enable*]
  Enable/disable FPM service

[*fpm_service_ensure*]
  Ensure FPM service is either 'running' or 'stopped'

[*fpm_service_name*]
  This is the name of the php-fpm service. It defaults to reasonable OS
  defaults but can be different in case of using php7.0/other OS/custom fpm service

[*fpm_service_provider*]
  This is the name of the service provider, in case there is a non
  OS default service provider used to start FPM.
  Defaults to 'undef', pick system defaults.

[*fpm_pools*]
  Hash of php::fpm::pool resources that will be created. Defaults
  to a single php::fpm::pool named www with default parameters.

[*fpm_global_pool_settings*]
  Hash of defaults params php::fpm::pool resources that will be created.
  Defaults to empty hash.

[*fpm_inifile*]
  Path to php.ini for fpm

[*fpm_package*]
  Name of fpm package to install

[*fpm_user*]
  The user that php-fpm should run as

[*fpm_group*]
  The group that php-fpm should run as

[*dev*]
  Install php header files, needed to install pecl modules

[*composer*]
  Install and auto-update composer

[*pear*]
  Install PEAR

[*phpunit*]
  Install phpunit

[*apache_config*]
  Manage apache's mod_php configuration

[*proxy_type*]
   proxy server type (none|http|https|ftp)

[*proxy_server*]
  specify a proxy server, with port number if needed. ie: https://example.com:8080.

[*extensions*]
  Install PHP extensions, this is overwritten by hiera hash `php::extensions`

[*package_prefix*]
  This is the prefix for constructing names of php packages. This defaults
  to a sensible default depending on your operating system, like 'php-' or
  'php5-'.

[*config_root_ini*]
  This is the path to the config .ini files of the extensions. This defaults
  to a sensible default depending on your operating system, like
  '/etc/php5/mods-available' or '/etc/php5/conf.d'.

[*config_root_inifile*]
  The path to the global php.ini file. This defaults to a sensible default
  depending on your operating system.

[*ext_tool_enable*]
  Absolute path to php tool for enabling extensions in debian/ubuntu systems.
  This defaults to '/usr/sbin/php5enmod'.

[*ext_tool_query*]
  Absolute path to php tool for querying information about extensions in
  debian/ubuntu systems. This defaults to '/usr/sbin/php5query'.

[*ext_tool_enabled*]
  Enable or disable the use of php tools on debian based systems
  debian/ubuntu systems. This defaults to 'true'.

[*log_owner*]
  The php-fpm log owner

[*log_group*]
  The group owning php-fpm logs

[*embedded*]
  Enable embedded SAPI

[*pear_ensure*]
  The package ensure of PHP pear to install and run pear auto_discover

[*settings*]

#### Parameters

The following parameters are available in the `php` class.

##### `ensure`

Data type: `String`



Default value: $php::params::ensure

##### `manage_repos`

Data type: `Boolean`



Default value: $php::params::manage_repos

##### `fpm`

Data type: `Boolean`



Default value: `true`

##### `fpm_service_enable`

Data type: `Any`



Default value: $php::params::fpm_service_enable

##### `fpm_service_ensure`

Data type: `Any`



Default value: $php::params::fpm_service_ensure

##### `fpm_service_name`

Data type: `Any`



Default value: $php::params::fpm_service_name

##### `fpm_service_provider`

Data type: `Any`



Default value: `undef`

##### `fpm_pools`

Data type: `Hash`



Default value: { 'www' => {} }

##### `fpm_global_pool_settings`

Data type: `Hash`



Default value: {}

##### `fpm_inifile`

Data type: `Any`



Default value: $php::params::fpm_inifile

##### `fpm_package`

Data type: `Any`



Default value: `undef`

##### `fpm_user`

Data type: `Any`



Default value: $php::params::fpm_user

##### `fpm_group`

Data type: `Any`



Default value: $php::params::fpm_group

##### `embedded`

Data type: `Boolean`



Default value: `false`

##### `dev`

Data type: `Boolean`



Default value: `true`

##### `composer`

Data type: `Boolean`



Default value: `true`

##### `pear`

Data type: `Boolean`



Default value: `true`

##### `pear_ensure`

Data type: `String`



Default value: $php::params::pear_ensure

##### `phpunit`

Data type: `Boolean`



Default value: `false`

##### `apache_config`

Data type: `Boolean`



Default value: `false`

##### `proxy_type`

Data type: `Any`



Default value: `undef`

##### `proxy_server`

Data type: `Any`



Default value: `undef`

##### `extensions`

Data type: `Hash`



Default value: {}

##### `settings`

Data type: `Hash`



Default value: {}

##### `package_prefix`

Data type: `Any`



Default value: $php::params::package_prefix

##### `config_root_ini`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::config_root_ini

##### `config_root_inifile`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::config_root_inifile

##### `ext_tool_enable`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: $php::params::ext_tool_enable

##### `ext_tool_query`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: $php::params::ext_tool_query

##### `ext_tool_enabled`

Data type: `Boolean`



Default value: $php::params::ext_tool_enabled

##### `log_owner`

Data type: `String`



Default value: $php::params::fpm_user

##### `log_group`

Data type: `String`



Default value: $php::params::fpm_group

### php::apache_config

Install and configure php apache settings

=== Parameters

[*inifile*]
  The path to the ini php-apache ini file

[*settings*]
  Hash with nested hash of key => value to set in inifile

#### Parameters

The following parameters are available in the `php::apache_config` class.

##### `inifile`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::apache_inifile

##### `settings`

Data type: `Hash`



Default value: {}

### php::cli

Install and configure php CLI

=== Parameters

[*inifile*]
  The path to the ini php5-cli ini file

[*settings*]
  Hash with nested hash of key => value to set in inifile

#### Parameters

The following parameters are available in the `php::cli` class.

##### `inifile`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::cli_inifile

##### `settings`

Data type: `Hash`



Default value: {}

### php::composer

Install composer package manager

=== Parameters

[*source*]
  Holds URL to the Composer source file

[*path*]
  Holds path to the Composer executable

[*channel*]
  Holds the Update channel (stable|preview|snapshot|1|2)

[*proxy_type*]
   proxy server type (none|http|https|ftp)

[*proxy_server*]
  specify a proxy server, with port number if needed. ie: https://example.com:8080.

[*auto_update*]
  Defines if composer should be auto updated

[*max_age*]
  Defines the time in days after which an auto-update gets executed

[*root_group*]
  UNIX group of the root user

#### Parameters

The following parameters are available in the `php::composer` class.

##### `source`

Data type: `String`



Default value: $php::params::composer_source

##### `path`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::composer_path

##### `proxy_type`

Data type: `Any`



Default value: `undef`

##### `proxy_server`

Data type: `Any`



Default value: `undef`

##### `auto_update`

Data type: `Boolean`



Default value: `true`

##### `max_age`

Data type: `Integer`



Default value: $php::params::composer_max_age

##### `root_group`

Data type: `Variant[Integer, String]`



Default value: $php::params::root_group

### php::composer::auto_update

Install composer package manager

=== Parameters

[*max_age*]
  Defines number of days after which Composer should be updated

[*source*]
  Holds URL to the Composer source file

[*path*]
  Holds path to the Composer executable

[*proxy_type*]
   proxy server type (none|http|https|ftp)

[*proxy_server*]
  specify a proxy server, with port number if needed. ie: https://example.com:8080.


=== Examples

 include php::composer::auto_update
 class { "php::composer::auto_update":
   "max_age" => 90
 }

#### Parameters

The following parameters are available in the `php::composer::auto_update` class.

##### `max_age`

Data type: `Any`



##### `source`

Data type: `Any`



##### `path`

Data type: `Any`



##### `proxy_type`

Data type: `Any`



Default value: `undef`

##### `proxy_server`

Data type: `Any`



Default value: `undef`

### php::dev

Install the development package with headers for PHP

=== Parameters

[*ensure*]
  The PHP ensure of PHP dev to install

[*package*]
  The package name for the PHP development files

#### Parameters

The following parameters are available in the `php::dev` class.

##### `ensure`

Data type: `String`



Default value: $php::ensure

##### `package`

Data type: `String`



Default value: "${php::package_prefix}${php::params::dev_package_suffix}"

##### `manage_repos`

Data type: `Boolean`



Default value: $php::manage_repos

### php::embedded

Install and configure php embedded SAPI

=== Parameters

[*inifile*]
  The path to the ini php5-embeded ini file

[*settings*]
  Hash with nested hash of key => value to set in inifile

[*package*]
  Specify which package to install

[*ensure*]
  Specify which version of the package to install

#### Parameters

The following parameters are available in the `php::embedded` class.

##### `ensure`

Data type: `String`



Default value: $php::ensure

##### `package`

Data type: `String`



Default value: "${php::package_prefix}${php::params::embedded_package_suffix}"

##### `inifile`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::embedded_inifile

##### `settings`

Data type: `Hash`



Default value: {}

### php::fpm

Install and configure mod_php for fpm

=== Parameters

[*user*]
  The user that php-fpm should run as

[*group*]
  The group that php-fpm should run as

[*service_enable*]
  Enable/disable FPM service

[*service_ensure*]
  Ensure FPM service is either 'running' or 'stopped'

[*service_name*]
  This is the name of the php-fpm service. It defaults to reasonable OS
  defaults but can be different in case of using php7.0/other OS/custom fpm service

[*service_provider*]
  This is the name of the service provider, in case there is a non
  OS default service provider used to start FPM.
  Defaults to 'undef', pick system defaults.

[*pools*]
  Hash of php::fpm::pool resources that will be created. Defaults
  to a single php::fpm::pool named www with default parameters.

[*log_owner*]
  The php-fpm log owner

[*log_group*]
  The group owning php-fpm logs

[*package*]
  Specify which package to install

[*ensure*]
  Specify which version of the package to install

[*inifile*]
  Path to php.ini for fpm

[*settings*]
  fpm settings hash

[*global_pool_settings*]
  Hash of defaults params php::fpm::pool resources that will be created.
  Defaults is empty hash.

#### Parameters

The following parameters are available in the `php::fpm` class.

##### `ensure`

Data type: `String`



Default value: $php::ensure

##### `user`

Data type: `Any`



Default value: $php::fpm_user

##### `group`

Data type: `Any`



Default value: $php::fpm_group

##### `service_ensure`

Data type: `Any`



Default value: $php::fpm_service_ensure

##### `service_enable`

Data type: `Any`



Default value: $php::fpm_service_enable

##### `service_name`

Data type: `Any`



Default value: $php::fpm_service_name

##### `service_provider`

Data type: `Any`



Default value: $php::fpm_service_provider

##### `package`

Data type: `String`



Default value: $php::real_fpm_package

##### `inifile`

Data type: `Stdlib::Absolutepath`



Default value: $php::fpm_inifile

##### `settings`

Data type: `Hash`



Default value: $php::real_settings

##### `global_pool_settings`

Data type: `Any`



Default value: $php::real_fpm_global_pool_settings

##### `pools`

Data type: `Hash`



Default value: $php::real_fpm_pools

##### `log_owner`

Data type: `Any`



Default value: $php::log_owner

##### `log_group`

Data type: `Any`



Default value: $php::log_group

### php::fpm::config

Configure php-fpm service

=== Parameters

[*config_file*]
  The path to the fpm config file

[*user*]
  The user that runs php-fpm

[*group*]
  The group that runs php-fpm

[*inifile*]
  The path to ini file

[*settings*]
  Nested hash of key => value to apply to php.ini

[*pool_base_dir*]
  The folder that contains the php-fpm pool configs

[*pool_purge*]
  Whether to purge pool config files not created
  by this module

[*error_log*]
  Path to error log file. If it's set to "syslog", log is
  sent to syslogd instead of being written in a local file.

[*log_level*]
  The php-fpm log level

[*emergency_restart_threshold*]
  The php-fpm emergency_restart_threshold

[*emergency_restart_interval*]
  The php-fpm emergency_restart_interval

[*process_control_timeout*]
  The php-fpm process_control_timeout

[*process_max*]
  The maximum number of processes FPM will fork.

[*rlimit_files*]
  Set open file descriptor rlimit for the master process.

[*systemd_interval*]
  The interval between health report notification to systemd

[*log_owner*]
  The php-fpm log owner

[*log_group*]
  The group owning php-fpm logs

[*log_dir_mode*]
  The octal mode of the directory

[*syslog_facility*]
  Used to specify what type of program is logging the message

[*syslog_ident*]
  Prepended to every message

[*root_group*]
  UNIX group of the root user

[*pid_file*]
  Path to fpm pid file

#### Parameters

The following parameters are available in the `php::fpm::config` class.

##### `config_file`

Data type: `Any`



Default value: $php::params::fpm_config_file

##### `user`

Data type: `String`



Default value: $php::params::fpm_user

##### `group`

Data type: `String`



Default value: $php::params::fpm_group

##### `inifile`

Data type: `String`



Default value: $php::params::fpm_inifile

##### `pid_file`

Data type: `Any`



Default value: $php::params::fpm_pid_file

##### `settings`

Data type: `Hash`



Default value: {}

##### `pool_base_dir`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::fpm_pool_dir

##### `pool_purge`

Data type: `Any`



Default value: `false`

##### `error_log`

Data type: `String`



Default value: $php::params::fpm_error_log

##### `log_level`

Data type: `String`



Default value: 'notice'

##### `emergency_restart_threshold`

Data type: `Integer`



Default value: 0

##### `emergency_restart_interval`

Data type: `Variant[Integer, Pattern[/^\d+[smhd]?$/]]`



Default value: 0

##### `process_control_timeout`

Data type: `Variant[Integer, Pattern[/^\d+[smhd]?$/]]`



Default value: 0

##### `process_max`

Data type: `Integer`



Default value: 0

##### `rlimit_files`

Data type: `Any`



Default value: `undef`

##### `systemd_interval`

Data type: `Optional[Variant[Integer,Pattern[/^\d+[smhd]?$/]]]`



Default value: `undef`

##### `log_owner`

Data type: `String`



Default value: $php::params::fpm_user

##### `log_group`

Data type: `String`



Default value: $php::params::fpm_group

##### `log_dir_mode`

Data type: `Pattern[/^\d+$/]`



Default value: '0770'

##### `root_group`

Data type: `Any`



Default value: $php::params::root_group

##### `syslog_facility`

Data type: `String`



Default value: 'daemon'

##### `syslog_ident`

Data type: `String`



Default value: 'php-fpm'

### php::fpm::service

Manage fpm service

=== Parameters

[*service_name*]
  name of the php-fpm service

[*ensure*]
  'ensure' value for the service

[*enable*]
  Defines if the service is enabled

[*provider*]
  Defines if the service provider to use

#### Parameters

The following parameters are available in the `php::fpm::service` class.

##### `service_name`

Data type: `Any`



Default value: $php::fpm::service_name

##### `ensure`

Data type: `Any`



Default value: $php::fpm::service_ensure

##### `enable`

Data type: `Any`



Default value: $php::fpm::service_enable

##### `provider`

Data type: `Any`



Default value: $php::fpm::service_provider

### php::global

The php::global class.

#### Parameters

The following parameters are available in the `php::global` class.

##### `inifile`

Data type: `Stdlib::Absolutepath`



Default value: $php::config_root_inifile

##### `settings`

Data type: `Hash`



Default value: {}

### php::globals

The php::globals class.

#### Parameters

The following parameters are available in the `php::globals` class.

##### `php_version`

Data type: `Optional[Pattern[/^(rh-)?(php)?[57](\.)?[0-9]/]]`



Default value: `undef`

##### `config_root`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: `undef`

##### `fpm_pid_file`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: `undef`

##### `rhscl_mode`

Data type: `Any`



Default value: `undef`

### php::packages

Install common PHP packages

=== Parameters

[*ensure*]
  Specify which version of PHP packages to install

[*names*]
  List of the names of the package to install

[*names_to_prefix*]
  List of packages names that should be prefixed with the common
  package prefix `$php::package_prefix`

#### Parameters

The following parameters are available in the `php::packages` class.

##### `ensure`

Data type: `String`



Default value: $php::ensure

##### `manage_repos`

Data type: `Boolean`



Default value: $php::manage_repos

##### `names_to_prefix`

Data type: `Array`



Default value: prefix($php::params::common_package_suffixes, $php::package_prefix)

##### `names`

Data type: `Array`



Default value: $php::params::common_package_names

### php::params

PHP params class

### php::pear

Install PEAR package manager

=== Parameters

[*ensure*]
  The package ensure of PHP pear to install and run pear auto_discover

[*package*]
  The package name for PHP pear

#### Parameters

The following parameters are available in the `php::pear` class.

##### `ensure`

Data type: `String`



Default value: $php::pear_ensure

##### `package`

Data type: `Optional[String]`



Default value: `undef`

##### `manage_repos`

Data type: `Boolean`



Default value: $php::manage_repos

### php::phpunit

Install phpunit, PHP testing framework

=== Parameters

[*source*]
  Holds URL to the phpunit source file

[*path*]
  Holds path to the phpunit executable

[*auto_update*]
  Defines if phpunit should be auto updated

[*max_age*]
  Defines the time in days after which an auto-update gets executed

#### Parameters

The following parameters are available in the `php::phpunit` class.

##### `source`

Data type: `String`



Default value: $php::params::phpunit_source

##### `path`

Data type: `Stdlib::Absolutepath`



Default value: $php::params::phpunit_path

##### `root_group`

Data type: `String[1]`



Default value: $php::params::root_group

##### `auto_update`

Data type: `Boolean`



Default value: `true`

##### `max_age`

Data type: `Integer`



Default value: $php::params::phpunit_max_age

### php::phpunit::auto_update

Install phpunit package manager

=== Parameters

[*max_age*]
  Defines number of days after which phpunit should be updated

[*source*]
  Holds URL to the phpunit source file

[*path*]
  Holds path to the phpunit executable

#### Parameters

The following parameters are available in the `php::phpunit::auto_update` class.

##### `max_age`

Data type: `Any`



##### `source`

Data type: `Any`



##### `path`

Data type: `Any`



### php::repo

Configure package repository

### php::repo::debian

Configure debian apt repo

=== Parameters

[*location*]
  Location of the apt repository

[*release*]
  Release of the apt repository

[*repos*]
  Apt repository names

[*include_src*]
  Add source source repository

[*key*]
  Public key in apt::key format

[*dotdeb*]
  Enable special dotdeb handling

[*sury*]
  Enable special sury handling

#### Parameters

The following parameters are available in the `php::repo::debian` class.

##### `location`

Data type: `Any`



Default value: 'https://packages.dotdeb.org'

##### `release`

Data type: `Any`



Default value: 'wheezy-php56'

##### `repos`

Data type: `Any`



Default value: 'all'

##### `include_src`

Data type: `Any`



Default value: `false`

##### `key`

Data type: `Any`



Default value: {
    'id'     => '6572BBEF1B5FF28B28B706837E3F070089DF5277',
    'source' => 'http://www.dotdeb.org/dotdeb.gpg',
  }

##### `dotdeb`

Data type: `Any`



Default value: `true`

##### `sury`

Data type: `Any`



Default value: `true`

### php::repo::redhat

The php::repo::redhat class.

#### Parameters

The following parameters are available in the `php::repo::redhat` class.

##### `yum_repo`

Data type: `Any`



Default value: 'remi_php56'

### php::repo::suse

Configure suse repo

=== Parameters

[*reponame*]
  Name of the Zypper repository

[*baseurl*]
  Base URL of the Zypper repository

#### Parameters

The following parameters are available in the `php::repo::suse` class.

##### `reponame`

Data type: `Any`



Default value: 'mayflower-php56'

##### `baseurl`

Data type: `Any`



Default value: 'http://download.opensuse.org/repositories/home:/mayflower:/php5.6_based/SLE_11_SP3/'

### php::repo::ubuntu

Configure ubuntu ppa

=== Parameters

[*version*]
  PHP version to manage (e.g. 5.6)

#### Parameters

The following parameters are available in the `php::repo::ubuntu` class.

##### `version`

Data type: `Any`



Default value: `undef`

## Defined types

### php::apache_vhost

Configures an apache vhost for php

=== Parameters

[*vhost*]
  The vhost address

[*docroot*]
  The vhost docroot

[*port*]
  The vhost port

[*default_vhost*]
  defines if vhost is the default vhost

[*fastcgi_socket*]
  address of the fastcgi socket

#### Parameters

The following parameters are available in the `php::apache_vhost` defined type.

##### `vhost`

Data type: `Any`



Default value: 'example.com'

##### `docroot`

Data type: `Any`



Default value: '/var/www'

##### `port`

Data type: `Any`



Default value: 80

##### `default_vhost`

Data type: `Any`



Default value: `true`

##### `fastcgi_socket`

Data type: `Any`



Default value: 'fcgi://127.0.0.1:9000/$1'

### php::config

Configure php.ini settings for a PHP SAPI

=== Parameters

[*file*]
  The path to ini file

[*config*]
  Nested hash of key => value to apply to php.ini

=== Examples

  php::config { '$unique-name':
    file  => '$full_path_to_ini_file'
    config => {
      {'Date/date.timezone' => 'Europe/Berlin'}
    }
  }

#### Parameters

The following parameters are available in the `php::config` defined type.

##### `file`

Data type: `Stdlib::Absolutepath`



##### `config`

Data type: `Hash`



### php::config::setting

Configure php.ini settings

=== Parameters

[*key*]
  The key of the value, like `ini_setting`

[*file*]
  The path to ini file

[*value*]
  The value to set

=== Examples

  php::config::setting { 'Date/date.timezone':
    file  => '$full_path_to_ini_file'
    value => 'Europe/Berlin'
  }

#### Parameters

The following parameters are available in the `php::config::setting` defined type.

##### `key`

Data type: `Any`



##### `value`

Data type: `Any`



##### `file`

Data type: `Stdlib::Absolutepath`



### php::extension

Install a PHP extension package

=== Parameters

[*ensure*]
  The ensure of the package to install
  Could be "latest", "installed" or a pinned version

[*package_prefix*]
  Prefix to prepend to the package name for the package provider

[*provider*]
  The provider used to install the package
  Could be "pecl", "apt", "dpkg" or any other OS package provider
  If set to "none", no package will be installed

[*source*]
  The source to install the extension from. Possible values
  depend on the *provider* used

[*so_name*]
  The DSO name of the package (e.g. opcache for zendopcache)

[*ini_prefix*]
  An optional filename prefix for the settings file of the extension

[*php_api_version*]
  This parameter is used to build the full path to the extension
  directory for zend_extension in PHP < 5.5 (e.g. 20100525)

[*header_packages*]
  System packages dependencies to install for extensions (e.g. for
  memcached libmemcached-dev on Debian)

[*compiler_packages*]
  System packages dependencies to install for compiling extensions
  (e.g. build-essential on Debian)

[*zend*]
 Boolean parameter, whether to load extension as zend_extension.
 Defaults to false.

[*settings*]
  Hash of parameters for the specific extension, which will be written to the extensions config file by
  php::extension::config or a hash of mutliple settings files, each with parameters
  (multifile_settings must be true)
  (f.ex. {p => '..'} or {'bz2' => {..}, {'math' => {...}})

[*multifile_settings*]
  Set this to true if you specify multiple setting files in *settings*. This must be used when the PHP package
  distribution bundles extensions in a single package (like 'common' bundles extensions 'bz2', ...) and each of
  the extension comes with a separate settings file.

[*settings_prefix*]
  Boolean/String parameter, whether to prefix all setting keys with
  the extension name or specified name. Defaults to false.

[*sapi*]
  String parameter, whether to specify ALL sapi or a specific sapi.
  Defaults to ALL.

[*responsefile*]
  File containing answers for interactive extension setup. Supported
  *providers*: pear, pecl.

[*install_options*]
  Array of String or Hash options to pass to the provider.

#### Parameters

The following parameters are available in the `php::extension` defined type.

##### `ensure`

Data type: `String`



Default value: 'installed'

##### `provider`

Data type: `Optional[Php::Provider]`



Default value: `undef`

##### `source`

Data type: `Optional[String]`



Default value: `undef`

##### `so_name`

Data type: `Optional[String]`



Default value: `undef`

##### `ini_prefix`

Data type: `Optional[String]`



Default value: `undef`

##### `php_api_version`

Data type: `Optional[String]`



Default value: `undef`

##### `package_prefix`

Data type: `String`



Default value: $php::package_prefix

##### `zend`

Data type: `Boolean`



Default value: `false`

##### `settings`

Data type: `Variant[Hash, Hash[String, Hash]]`



Default value: {}

##### `multifile_settings`

Data type: `Boolean`



Default value: `false`

##### `sapi`

Data type: `Php::Sapi`



Default value: 'ALL'

##### `settings_prefix`

Data type: `Variant[Boolean, String]`



Default value: `false`

##### `responsefile`

Data type: `Optional[Stdlib::AbsolutePath]`



Default value: `undef`

##### `header_packages`

Data type: `Variant[String, Array[String]]`



Default value: []

##### `compiler_packages`

Data type: `Variant[String, Array[String]]`



Default value: $php::params::compiler_packages

##### `install_options`

Data type: `Php::InstallOptions`



Default value: `undef`

### php::extension::config

Configure a PHP extension package

=== Parameters

[*ensure*]
  The ensure of the package to install
  Could be "latest", "installed" or a pinned version

[*provider*]
  The provider used to install the package
  Could be "pecl", "apt", "dpkg" or any other OS package provider
  If set to "none", no package will be installed

[*so_name*]
  The DSO name of the package (e.g. opcache for zendopcache)

[*ini_prefix*]
  An optional filename prefix for the settings file of the extension

[*php_api_version*]
  This parameter is used to build the full path to the extension
  directory for zend_extension in PHP < 5.5 (e.g. 20100525)

[*header_packages*]
  System packages dependencies to install for extensions (e.g. for
  memcached libmemcached-dev on Debian)

[*compiler_packages*]
  System packages dependencies to install for compiling extensions
  (e.g. build-essential on Debian)

[*zend*]
 Boolean parameter, whether to load extension as zend_extension.
 Defaults to false.

[*settings*]
  Nested hash of global config parameters for php.ini

[*settings_prefix*]
  Boolean/String parameter, whether to prefix all setting keys with
  the extension name or specified name. Defaults to false.

[*sapi*]
  String parameter, whether to specify ALL sapi or a specific sapi.
  Defaults to ALL.

#### Parameters

The following parameters are available in the `php::extension::config` defined type.

##### `ensure`

Data type: `String`



Default value: 'installed'

##### `provider`

Data type: `Optional[Php::Provider]`



Default value: `undef`

##### `so_name`

Data type: `Optional[String]`



Default value: downcase($name)

##### `ini_prefix`

Data type: `Optional[String]`



Default value: `undef`

##### `php_api_version`

Data type: `Optional[String]`



Default value: `undef`

##### `zend`

Data type: `Boolean`



Default value: `false`

##### `settings`

Data type: `Hash`



Default value: {}

##### `settings_prefix`

Data type: `Variant[Boolean, String]`



Default value: `false`

##### `sapi`

Data type: `Php::Sapi`



Default value: 'ALL'

### php::extension::install

Install a PHP extension package

=== Parameters

[*ensure*]
  The ensure of the package to install
  Could be "latest", "installed" or a pinned version

[*package_prefix*]
  Prefix to prepend to the package name for the package provider

[*provider*]
  The provider used to install the package
  Could be "pecl", "apt", "dpkg" or any other OS package provider
  If set to "none", no package will be installed

[*source*]
  The source to install the extension from. Possible values
  depend on the *provider* used

[*header_packages*]
  System packages dependencies to install for extensions (e.g. for
  memcached libmemcached-dev on Debian)

[*compiler_packages*]
  System packages dependencies to install for compiling extensions
  (e.g. build-essential on Debian)

[*responsefile*]
  File containing answers for interactive extension setup. Supported
  *providers*: pear, pecl.

[*install_options*]
  Array of String or Hash options to pass to the provider.

#### Parameters

The following parameters are available in the `php::extension::install` defined type.

##### `ensure`

Data type: `String`



Default value: 'installed'

##### `provider`

Data type: `Optional[Php::Provider]`



Default value: `undef`

##### `source`

Data type: `Optional[String]`



Default value: `undef`

##### `package_prefix`

Data type: `String`



Default value: $php::package_prefix

##### `responsefile`

Data type: `Optional[Stdlib::AbsolutePath]`



Default value: `undef`

##### `header_packages`

Data type: `Variant[String, Array[String]]`



Default value: []

##### `compiler_packages`

Data type: `Variant[String, Array[String]]`



Default value: $php::params::compiler_packages

##### `install_options`

Data type: `Php::InstallOptions`



Default value: `undef`

### php::fpm::pool

Configure fpm pools

=== Parameters

See the official php-fpm documentation for parameters that are not
documented here: http://php.net/manual/en/install.fpm.configuration.php.

[*ensure*]
  Remove pool if set to `'absent'`, add otherwise

[*listen*]
  On what socket to listen for FastCGI connections, i.e.
  `'127.0.0.1:9000'' or `'/var/run/php5-fpm.sock'`

[*listen_backlog*]

[*listen_allowed_clients*]

[*listen_owner*]
  Set owner of the Unix socket

[*listen_group*]
  Set the group of the Unix socket

[*listen_mode*]

[*user*]
  The user that php-fpm should run as

[*group*]
  The group that php-fpm should run as

[*apparmor_hat*]
  The Apparmor hat to use

[*pm*]

[*pm_max_children*]

[*pm_start_servers*]

[*pm_min_spare_servers*]

[*pm_max_spare_servers*]

[*pm_max_requests*]

[*pm_process_idle_timeout*]

[*pm_status_path*]

[*ping_path*]

[*ping_response*]

[*access_log*]
  The path to the file to write access log requests to

[*access_log_format*]
  The format to save the access log entries as

[*request_terminate_timeout*]

[*request_slowlog_timeout*]

[*security_limit_extensions*]

[*slowlog*]

[*template*]
  The template to use for the pool

[*rlimit_files*]

[*rlimit_core*]

[*chroot*]

[*chdir*]

[*catch_workers_output*]

[*include*]
  Other configuration files to include on this pool

[*env*]
  List of environment variables that are passed to the php-fpm from the
  outside and will be available to php scripts in this pool

[*env_value*]
  Hash of environment variables and values as strings to use in php
  scripts in this pool

[*options*]
  An optional hash for any other data.

[*php_value*]
  Hash of php_value directives

[*php_flag*]
  Hash of php_flag directives

[*php_admin_value*]
  Hash of php_admin_value directives

[*php_admin_flag*]
  Hash of php_admin_flag directives

[*php_directives*]
  List of custom directives that are appended to the pool config

[*root_group*]
  UNIX group of the root user

[*base_dir*]
  The folder that contains the php-fpm pool configs. This defaults to a
  sensible default depending on your operating system, like
  '/etc/php5/fpm/pool.d' or '/etc/php-fpm.d'

#### Parameters

The following parameters are available in the `php::fpm::pool` defined type.

##### `ensure`

Data type: `Any`



Default value: 'present'

##### `listen`

Data type: `Any`



Default value: '127.0.0.1:9000'

##### `listen_backlog`

Data type: `Any`



Default value: '-1'

##### `listen_allowed_clients`

Data type: `Any`



Default value: `undef`

##### `listen_owner`

Data type: `Any`



Default value: `undef`

##### `listen_group`

Data type: `Any`



Default value: `undef`

##### `listen_mode`

Data type: `Any`



Default value: `undef`

##### `user`

Data type: `Any`



Default value: $php::fpm::config::user

##### `group`

Data type: `Any`



Default value: $php::fpm::config::group

##### `pm`

Data type: `Any`



Default value: 'dynamic'

##### `pm_max_children`

Data type: `Any`



Default value: '50'

##### `pm_start_servers`

Data type: `Any`



Default value: '5'

##### `pm_min_spare_servers`

Data type: `Any`



Default value: '5'

##### `pm_max_spare_servers`

Data type: `Any`



Default value: '35'

##### `pm_max_requests`

Data type: `Any`



Default value: '0'

##### `pm_process_idle_timeout`

Data type: `Any`



Default value: '10s'

##### `pm_status_path`

Data type: `Any`



Default value: `undef`

##### `ping_path`

Data type: `Any`



Default value: `undef`

##### `ping_response`

Data type: `Any`



Default value: 'pong'

##### `access_log`

Data type: `Any`



Default value: `undef`

##### `access_log_format`

Data type: `Any`



Default value: '"%R - %u %t \"%m %r\" %s"'

##### `request_terminate_timeout`

Data type: `Any`



Default value: '0'

##### `request_slowlog_timeout`

Data type: `Any`



Default value: '0'

##### `security_limit_extensions`

Data type: `Any`



Default value: `undef`

##### `slowlog`

Data type: `Any`



Default value: "/var/log/php-fpm/${name}-slow.log"

##### `template`

Data type: `Any`



Default value: 'php/fpm/pool.conf.erb'

##### `rlimit_files`

Data type: `Any`



Default value: `undef`

##### `rlimit_core`

Data type: `Any`



Default value: `undef`

##### `chroot`

Data type: `Any`



Default value: `undef`

##### `chdir`

Data type: `Any`



Default value: `undef`

##### `catch_workers_output`

Data type: `Any`



Default value: 'no'

##### `include`

Data type: `Any`



Default value: `undef`

##### `env`

Data type: `Any`



Default value: []

##### `env_value`

Data type: `Any`



Default value: {}

##### `options`

Data type: `Any`



Default value: {}

##### `php_value`

Data type: `Any`



Default value: {}

##### `php_flag`

Data type: `Any`



Default value: {}

##### `php_admin_value`

Data type: `Any`



Default value: {}

##### `php_admin_flag`

Data type: `Any`



Default value: {}

##### `php_directives`

Data type: `Any`



Default value: []

##### `root_group`

Data type: `Any`



Default value: $php::params::root_group

##### `base_dir`

Data type: `Optional[Stdlib::Absolutepath]`



Default value: `undef`

## Functions

### ensure_prefix

Type: Ruby 3.x API

This function ensures a prefix for all elements in an array or the keys in a hash.

*Examples:*

  ensure_prefix({'a' => 1, 'b' => 2, 'p.c' => 3}, 'p.')

Will return:
  {
    'p.a' => 1,
    'p.b' => 2,
    'p.c' => 3,
  }

  ensure_prefix(['a', 'p.b', 'c'], 'p.')

Will return:
  ['p.a', 'p.b', 'p.c']

#### `ensure_prefix()`

This function ensures a prefix for all elements in an array or the keys in a hash.

*Examples:*

  ensure_prefix({'a' => 1, 'b' => 2, 'p.c' => 3}, 'p.')

Will return:
  {
    'p.a' => 1,
    'p.b' => 2,
    'p.c' => 3,
  }

  ensure_prefix(['a', 'p.b', 'c'], 'p.')

Will return:
  ['p.a', 'p.b', 'p.c']

Returns: `Any`

### to_hash_settings

Type: Ruby 3.x API

This function converts a +{key => value}+ hash into a nested hash and can add an id to the outer key.
The optional id string as second parameter is prepended to the resource name.

*Examples:*

  to_hash_settings({'a' => 1, 'b' => 2})

Would return:
  {
    'a' => {'key' => 'a', 'value' => 1},
    'b' => {'key' => 'b', 'value' => 2}
  }

and:

  to_hash_settings({'a' => 1, 'b' => 2}, 'foo')

Would return:
  {
    'foo: a' => {'key' => 'a', 'value' => 1},
    'foo: b' => {'key' => 'b', 'value' => 2}
  }

#### `to_hash_settings()`

This function converts a +{key => value}+ hash into a nested hash and can add an id to the outer key.
The optional id string as second parameter is prepended to the resource name.

*Examples:*

  to_hash_settings({'a' => 1, 'b' => 2})

Would return:
  {
    'a' => {'key' => 'a', 'value' => 1},
    'b' => {'key' => 'b', 'value' => 2}
  }

and:

  to_hash_settings({'a' => 1, 'b' => 2}, 'foo')

Would return:
  {
    'foo: a' => {'key' => 'a', 'value' => 1},
    'foo: b' => {'key' => 'b', 'value' => 2}
  }

Returns: `Any`

