# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

_Public Classes_

* [`postgresql::client`](#postgresqlclient): Installs PostgreSQL client software. Set the following parameters if you have a custom version you would like to install.
* [`postgresql::globals`](#postgresqlglobals): Class for setting cross-class global overrides.
* [`postgresql::lib::devel`](#postgresqllibdevel): This class installs postgresql development libraries.
* [`postgresql::lib::docs`](#postgresqllibdocs): Installs PostgreSQL bindings for Postgres-Docs. Set the following parameters if you have a custom version you would like to install.
* [`postgresql::lib::java`](#postgresqllibjava): This class installs the postgresql jdbc connector.
* [`postgresql::lib::perl`](#postgresqllibperl): This class installs the perl libs for postgresql.
* [`postgresql::lib::python`](#postgresqllibpython): This class installs the python libs for postgresql.
* [`postgresql::server`](#postgresqlserver): This installs a PostgreSQL server
* [`postgresql::server::contrib`](#postgresqlservercontrib): Install the contrib postgresql packaging.
* [`postgresql::server::plperl`](#postgresqlserverplperl): This class installs the PL/Perl procedural language for postgresql.
* [`postgresql::server::plpython`](#postgresqlserverplpython): This class installs the PL/Python procedural language for postgresql.
* [`postgresql::server::postgis`](#postgresqlserverpostgis): Install the postgis postgresql packaging.

_Private Classes_

* `postgresql::params`: 
* `postgresql::repo`: 
* `postgresql::repo::apt_postgresql_org`: 
* `postgresql::repo::yum_postgresql_org`: 
* `postgresql::server::config`: 
* `postgresql::server::initdb`: 
* `postgresql::server::install`: 
* `postgresql::server::passwd`: 
* `postgresql::server::reload`: 
* `postgresql::server::service`: 

**Defined types**

* [`postgresql::server::config_entry`](#postgresqlserverconfig_entry): Manage a postgresql.conf entry.
* [`postgresql::server::database`](#postgresqlserverdatabase): Define for creating a database.
* [`postgresql::server::database_grant`](#postgresqlserverdatabase_grant): Manage a database grant.
* [`postgresql::server::db`](#postgresqlserverdb): Define for conveniently creating a role, database and assigning the correctpermissions.
* [`postgresql::server::extension`](#postgresqlserverextension): Activate an extension on a postgresql database.
* [`postgresql::server::grant`](#postgresqlservergrant): Define for granting permissions to roles.
* [`postgresql::server::grant_role`](#postgresqlservergrant_role): Define for granting membership to a role.
* [`postgresql::server::pg_hba_rule`](#postgresqlserverpg_hba_rule): This resource manages an individual rule that applies to the file defined in target.
* [`postgresql::server::pg_ident_rule`](#postgresqlserverpg_ident_rule): This resource manages an individual rule that applies to the file defined in target.
* [`postgresql::server::reassign_owned_by`](#postgresqlserverreassign_owned_by): Define for reassigning the ownership of objects within a database.
* [`postgresql::server::recovery`](#postgresqlserverrecovery): This resource manages the parameters that applies to the recovery.conf template.
* [`postgresql::server::role`](#postgresqlserverrole): Define for creating a database role.
* [`postgresql::server::schema`](#postgresqlserverschema): Create a new schema.
* [`postgresql::server::table_grant`](#postgresqlservertable_grant): This resource wraps the grant resource to manage table grants specifically.
* [`postgresql::server::tablespace`](#postgresqlservertablespace): This module creates tablespace.
* [`postgresql::validate_db_connection`](#postgresqlvalidate_db_connection): This type validates that a successful postgres connection.

**Resource types**

* [`postgresql_conf`](#postgresql_conf): This type allows puppet to manage postgresql.conf parameters.
* [`postgresql_conn_validator`](#postgresql_conn_validator): Verify if a connection can be successfully established
* [`postgresql_psql`](#postgresql_psql): An arbitrary tag for your own reference; the name of the message.
* [`postgresql_replication_slot`](#postgresql_replication_slot): Manages Postgresql replication slots.

**Functions**

_Public Functions_

* [`postgresql::default`](#postgresqldefault): This function pull default values from the `params` class  or `globals` class if the value is not present in `params`.
* [`postgresql::postgresql_escape`](#postgresqlpostgresql_escape): This function escapes a string using [Dollar Quoting](https://www.postgresql.org/docs/12/sql-syntax-lexical.html#SQL-SYNTAX-DOLLAR-QUOTING) using a randomly generated tag if required.
* [`postgresql::postgresql_password`](#postgresqlpostgresql_password): This function returns the postgresql password hash from the clear text username / password
* [`postgresql_escape`](#postgresql_escape): DEPRECATED.  Use the namespaced function [`postgresql::postgresql_escape`](#postgresqlpostgresql_escape) instead.
* [`postgresql_password`](#postgresql_password): DEPRECATED.  Use the namespaced function [`postgresql::postgresql_password`](#postgresqlpostgresql_password) instead.

_Private Functions_

* `postgresql::postgresql_acls_to_resources_hash`: This internal function translates the ipv(4|6)acls format into a resource suitable for create_resources.

**Tasks**

* [`sql`](#sql): Allows you to execute arbitary SQL

## Classes

### postgresql::client

Installs PostgreSQL client software. Set the following parameters if you have a custom version you would like to install.

* **Note** Make sure to add any necessary yum or apt repositories if specifying a custom version.

#### Parameters

The following parameters are available in the `postgresql::client` class.

##### `file_ensure`

Data type: `Enum['file', 'absent']`

Ensure the connection validation script is present

Default value: 'file'

##### `validcon_script_path`

Data type: `Stdlib::Absolutepath`

Optional. Absolute path for the postgresql connection validation script.

Default value: $postgresql::params::validcon_script_path

##### `package_name`

Data type: `String[1]`

Sets the name of the PostgreSQL client package.

Default value: $postgresql::params::client_package_name

##### `package_ensure`

Data type: `String[1]`

Ensure the client package is installed

Default value: 'present'

### postgresql::globals

Class for setting cross-class global overrides.

* **Note** Most server-specific defaults should be overridden in the postgresql::server class.
This class should be used only if you are using a non-standard OS, or if you are changing elements that can only be changed here, such as version or manage_package_repo.

#### Parameters

The following parameters are available in the `postgresql::globals` class.

##### `client_package_name`

Data type: `Any`

Overrides the default PostgreSQL client package name.

Default value: `undef`

##### `server_package_name`

Data type: `Any`

Overrides the default PostgreSQL server package name.

Default value: `undef`

##### `contrib_package_name`

Data type: `Any`

Overrides the default PostgreSQL contrib package name.

Default value: `undef`

##### `devel_package_name`

Data type: `Any`

Overrides the default PostgreSQL devel package name.

Default value: `undef`

##### `java_package_name`

Data type: `Any`

Overrides the default PostgreSQL java package name.

Default value: `undef`

##### `docs_package_name`

Data type: `Any`

Overrides the default PostgreSQL docs package name.

Default value: `undef`

##### `perl_package_name`

Data type: `Any`

Overrides the default PostgreSQL Perl package name.

Default value: `undef`

##### `plperl_package_name`

Data type: `Any`

Overrides the default PostgreSQL PL/Perl package name.

Default value: `undef`

##### `plpython_package_name`

Data type: `Any`

Overrides the default PostgreSQL PL/Python package name.

Default value: `undef`

##### `python_package_name`

Data type: `Any`

Overrides the default PostgreSQL Python package name.

Default value: `undef`

##### `postgis_package_name`

Data type: `Any`

Overrides the default PostgreSQL PostGIS package name.

Default value: `undef`

##### `service_name`

Data type: `Any`

Overrides the default PostgreSQL service name.

Default value: `undef`

##### `service_provider`

Data type: `Any`

Overrides the default PostgreSQL service provider.

Default value: `undef`

##### `service_status`

Data type: `Any`

Overrides the default status check command for your PostgreSQL service.

Default value: `undef`

##### `default_database`

Data type: `Any`

Specifies the name of the default database to connect with.

Default value: `undef`

##### `validcon_script_path`

Data type: `Any`

Scipt path for the connection validation check.

Default value: `undef`

##### `initdb_path`

Data type: `Any`

Path to the initdb command.

Default value: `undef`

##### `createdb_path`

Data type: `Any`

Deprecated. Path to the createdb command.

Default value: `undef`

##### `psql_path`

Data type: `Any`

Sets the path to the psql command.

Default value: `undef`

##### `pg_hba_conf_path`

Data type: `Any`

Specifies the path to your pg_hba.conf file.

Default value: `undef`

##### `pg_ident_conf_path`

Data type: `Any`

Specifies the path to your pg_ident.conf file.

Default value: `undef`

##### `postgresql_conf_path`

Data type: `Any`

Sets the path to your postgresql.conf file.

Default value: `undef`

##### `recovery_conf_path`

Data type: `Any`

Path to your recovery.conf file.

Default value: `undef`

##### `default_connect_settings`

Data type: `Any`

Default connection settings.

Default value: {}

##### `pg_hba_conf_defaults`

Data type: `Any`

Disables the defaults supplied with the module for pg_hba.conf if set to false.

Default value: `undef`

##### `datadir`

Data type: `Any`

Overrides the default PostgreSQL data directory for the target platform.
Changing the datadir after installation causes the server to come to a full stop before making the change.
For Red Hat systems, the data directory must be labeled appropriately for SELinux.
On Ubuntu, you must explicitly set needs_initdb = true to allow Puppet to initialize the database in the new datadir (needs_initdb defaults to true on other systems).
Warning! If datadir is changed from the default, Puppet does not manage purging of the original data directory, which causes it to fail if the data directory is changed back to the original

Default value: `undef`

##### `confdir`

Data type: `Any`

Overrides the default PostgreSQL configuration directory for the target platform.

Default value: `undef`

##### `bindir`

Data type: `Any`

Overrides the default PostgreSQL binaries directory for the target platform.

Default value: `undef`

##### `xlogdir`

Data type: `Any`

Overrides the default PostgreSQL xlog directory.

Default value: `undef`

##### `logdir`

Data type: `Any`

Overrides the default PostgreSQL log directory.

Default value: `undef`

##### `log_line_prefix`

Data type: `Any`

Overrides the default PostgreSQL log prefix.

Default value: `undef`

##### `user`

Data type: `Any`

Overrides the default PostgreSQL super user and owner of PostgreSQL related files in the file system.

Default value: `undef`

##### `group`

Data type: `Any`

Overrides the default postgres user group to be used for related files in the file system.

Default value: `undef`

##### `version`

Data type: `Any`

The version of PostgreSQL to install and manage.

Default value: `undef`

##### `postgis_version`

Data type: `Any`

Defines the version of PostGIS to install, if you install PostGIS.

Default value: `undef`

##### `repo_proxy`

Data type: `Any`

Sets the proxy option for the official PostgreSQL yum-repositories only.

Default value: `undef`

##### `repo_baseurl`

Data type: `Any`

Sets the baseurl for the PostgreSQL repository. Useful if you host your own mirror of the repository.

Default value: `undef`

##### `needs_initdb`

Data type: `Any`

Explicitly calls the initdb operation after the server package is installed and before the PostgreSQL service is started.

Default value: `undef`

##### `encoding`

Data type: `Any`

Sets the default encoding for all databases created with this module.
On certain operating systems, this is also used during the template1 initialization, so it becomes a default outside of the module as well.

Default value: `undef`

##### `locale`

Data type: `Any`

Sets the default database locale for all databases created with this module.
On certain operating systems, this is also used during the template1 initialization, so it becomes a default outside of the module as well.
On Debian, you'll need to ensure that the 'locales-all' package is installed for full functionality of PostgreSQL.

Default value: `undef`

##### `data_checksums`

Data type: `Any`

Use checksums on data pages to help detect corruption by the I/O system that would otherwise be silent.
Warning: This option is used during initialization by initdb, and cannot be changed later.

Default value: `undef`

##### `timezone`

Data type: `Any`

Sets the default timezone of the postgresql server. The postgresql built-in default is taking the systems timezone information.

Default value: `undef`

##### `manage_pg_hba_conf`

Data type: `Any`

Allow Puppet to manage the pg_hba.conf file.

Default value: `undef`

##### `manage_pg_ident_conf`

Data type: `Any`

Allow Puppet to manage the pg_ident.conf file.

Default value: `undef`

##### `manage_recovery_conf`

Data type: `Any`

Allow Puppet to manage the recovery.conf file.

Default value: `undef`

##### `manage_datadir`

Data type: `Any`

Set to false if you have file{ $datadir: } already defined

Default value: `undef`

##### `manage_logdir`

Data type: `Any`

Set to false if you have file{ $logdir: } already defined

Default value: `undef`

##### `manage_xlogdir`

Data type: `Any`

Set to false if you have file{ $xlogdir: } already defined

Default value: `undef`

##### `manage_package_repo`

Data type: `Any`

Sets up official PostgreSQL repositories on your host if set to true.

Default value: `undef`

##### `module_workdir`

Data type: `Any`

Specifies working directory under which the psql command should be executed. May need to specify if '/tmp' is on volume mounted with noexec option.

Default value: `undef`

##### `manage_selinux`

Data type: `Any`



Default value: `undef`

### postgresql::lib::devel

This class installs postgresql development libraries.

#### Parameters

The following parameters are available in the `postgresql::lib::devel` class.

##### `package_name`

Data type: `String`

Override devel package name

Default value: $postgresql::params::devel_package_name

##### `package_ensure`

Data type: `String[1]`

Ensure the development libraries are installed

Default value: 'present'

##### `link_pg_config`

Data type: `Boolean`

If the bin directory used by the PostgreSQL page is not /usr/bin or /usr/local/bin, symlinks pg_config from the package's bin dir into usr/bin (not applicable to Debian systems). Set to false to disable this behavior.

Default value: $postgresql::params::link_pg_config

### postgresql::lib::docs

Installs PostgreSQL bindings for Postgres-Docs. Set the following parameters if you have a custom version you would like to install.

* **Note** Make sure to add any necessary yum or apt repositories if specifying a custom version.

#### Parameters

The following parameters are available in the `postgresql::lib::docs` class.

##### `package_name`

Data type: `String`

Specifies the name of the PostgreSQL docs package.

Default value: $postgresql::params::docs_package_name

##### `package_ensure`

Data type: `String[1]`

Whether the PostgreSQL docs package resource should be present.

Default value: 'present'

### postgresql::lib::java

This class installs the postgresql jdbc connector.

* **Note** Make sure to add any necessary yum or apt repositories if specifying a custom version.

#### Parameters

The following parameters are available in the `postgresql::lib::java` class.

##### `package_name`

Data type: `String`

Specifies the name of the PostgreSQL java package.

Default value: $postgresql::params::java_package_name

##### `package_ensure`

Data type: `String[1]`

Specifies whether the package is present.

Default value: 'present'

### postgresql::lib::perl

This class installs the perl libs for postgresql.

#### Parameters

The following parameters are available in the `postgresql::lib::perl` class.

##### `package_name`

Data type: `String`

Specifies the name of the PostgreSQL perl package to install.

Default value: $postgresql::params::perl_package_name

##### `package_ensure`

Data type: `String[1]`

Ensure the perl libs for postgresql are installed.

Default value: 'present'

### postgresql::lib::python

This class installs the python libs for postgresql.

#### Parameters

The following parameters are available in the `postgresql::lib::python` class.

##### `package_name`

Data type: `String[1]`

The name of the PostgreSQL Python package.

Default value: $postgresql::params::python_package_name

##### `package_ensure`

Data type: `String[1]`

Ensure the python libs for postgresql are installed.

Default value: 'present'

### postgresql::server

This installs a PostgreSQL server

#### Parameters

The following parameters are available in the `postgresql::server` class.

##### `postgres_password`

Data type: `Any`

Sets the password for the postgres user to your specified value. By default, this setting uses the superuser account in the Postgres database, with a user called postgres and no password.

Default value: `undef`

##### `package_name`

Data type: `Any`

Specifies the name of the package to use for installing the server software.

Default value: $postgresql::params::server_package_name

##### `package_ensure`

Data type: `Any`

Passes a value through to the package resource when creating the server instance.

Default value: $postgresql::params::package_ensure

##### `plperl_package_name`

Data type: `Any`

Sets the default package name for the PL/Perl extension.

Default value: $postgresql::params::plperl_package_name

##### `plpython_package_name`

Data type: `Any`

Sets the default package name for the PL/Python extension.

Default value: $postgresql::params::plpython_package_name

##### `service_ensure`

Data type: `Any`

Ensure service is installed

Default value: $postgresql::params::service_ensure

##### `service_enable`

Data type: `Any`

Enable the PostgreSQL service

Default value: $postgresql::params::service_enable

##### `service_manage`

Data type: `Any`

Defines whether or not Puppet should manage the service.

Default value: $postgresql::params::service_manage

##### `service_name`

Data type: `Any`

Overrides the default PostgreSQL service name.

Default value: $postgresql::params::service_name

##### `service_restart_on_change`

Data type: `Any`

Overrides the default behavior to restart your PostgreSQL service when a config entry has been changed that requires a service restart to become active.

Default value: $postgresql::params::service_restart_on_change

##### `service_provider`

Data type: `Any`

Overrides the default PostgreSQL service provider.

Default value: $postgresql::params::service_provider

##### `service_reload`

Data type: `Any`

Overrides the default reload command for your PostgreSQL service.

Default value: $postgresql::params::service_reload

##### `service_status`

Data type: `Any`

Overrides the default status check command for your PostgreSQL service.

Default value: $postgresql::params::service_status

##### `default_database`

Data type: `Any`

Specifies the name of the default database to connect with. On most systems this is 'postgres'.

Default value: $postgresql::params::default_database

##### `default_connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server. Becomes the default for other defined types, such as postgresql::server::role.

Default value: $postgresql::globals::default_connect_settings

##### `listen_addresses`

Data type: `Any`

Address list on which the PostgreSQL service will listen

Default value: $postgresql::params::listen_addresses

##### `port`

Data type: `Any`

Specifies the port for the PostgreSQL server to listen on. Note: The same port number is used for all IP addresses the server listens on. Also, for Red Hat systems and early Debian systems, changing the port causes the server to come to a full stop before being able to make the change.
Default value: 5432. Meaning the Postgres server listens on TCP port 5432.

Default value: $postgresql::params::port

##### `ip_mask_deny_postgres_user`

Data type: `Any`

Specifies the IP mask from which remote connections should be denied for the postgres superuser.
Default value: '0.0.0.0/0', which denies any remote connection.

Default value: $postgresql::params::ip_mask_deny_postgres_user

##### `ip_mask_allow_all_users`

Data type: `Any`

Overrides PostgreSQL defaults for remote connections. By default, PostgreSQL does not allow database user accounts to connect via TCP from remote machines. If you'd like to allow this, you can override this setting.
Set to '0.0.0.0/0' to allow database users to connect from any remote machine, or '192.168.0.0/1' to allow connections from any machine on your local '192.168' subnet.
Default value: '127.0.0.1/32'.

Default value: $postgresql::params::ip_mask_allow_all_users

##### `ipv4acls`

Data type: `Array[String[1]]`

Lists strings for access control for connection method, users, databases, IPv4 addresses;

Default value: $postgresql::params::ipv4acls

##### `ipv6acls`

Data type: `Array[String[1]]`

Lists strings for access control for connection method, users, databases, IPv6 addresses.

Default value: $postgresql::params::ipv6acls

##### `initdb_path`

Data type: `Any`

Specifies the path to the initdb command.

Default value: $postgresql::params::initdb_path

##### `createdb_path`

Data type: `Any`

Deprecated. Specifies the path to the createdb command.

Default value: $postgresql::params::createdb_path

##### `psql_path`

Data type: `Any`

Specifies the path to the psql command.

Default value: $postgresql::params::psql_path

##### `pg_hba_conf_path`

Data type: `Any`

Specifies the path to your pg_hba.conf file.

Default value: $postgresql::params::pg_hba_conf_path

##### `pg_ident_conf_path`

Data type: `Any`

Specifies the path to your pg_ident.conf file.

Default value: $postgresql::params::pg_ident_conf_path

##### `postgresql_conf_path`

Data type: `Any`

Specifies the path to your postgresql.conf file.

Default value: $postgresql::params::postgresql_conf_path

##### `recovery_conf_path`

Data type: `Any`

Specifies the path to your recovery.conf file.

Default value: $postgresql::params::recovery_conf_path

##### `datadir`

Data type: `Any`

PostgreSQL data directory

Default value: $postgresql::params::datadir

##### `xlogdir`

Data type: `Any`

PostgreSQL xlog directory

Default value: $postgresql::params::xlogdir

##### `logdir`

Data type: `Any`

PostgreSQL log directory

Default value: $postgresql::params::logdir

##### `log_line_prefix`

Data type: `Any`

PostgreSQL log line prefix

Default value: $postgresql::params::log_line_prefix

##### `pg_hba_conf_defaults`

Data type: `Any`

If false, disables the defaults supplied with the module for pg_hba.conf. This is useful if you disagree with the defaults and wish to override them yourself. Be sure that your changes of course align with the rest of the module, as some access is required to perform basic psql operations for example.

Default value: $postgresql::params::pg_hba_conf_defaults

##### `user`

Data type: `Any`

Overrides the default PostgreSQL super user and owner of PostgreSQL related files in the file system.

Default value: $postgresql::params::user

##### `group`

Data type: `Any`

Overrides the default postgres user group to be used for related files in the file system.

Default value: $postgresql::params::group

##### `needs_initdb`

Data type: `Any`

Explicitly calls the initdb operation after server package is installed, and before the PostgreSQL service is started.

Default value: $postgresql::params::needs_initdb

##### `encoding`

Data type: `Any`

Sets the default encoding for all databases created with this module. On certain operating systems this is also used during the template1 initialization, so it becomes a default outside of the module as well.

Default value: $postgresql::params::encoding

##### `locale`

Data type: `Any`

Sets the default database locale for all databases created with this module. On certain operating systems this is used during the template1 initialization as well, so it becomes a default outside of the module.

Default value: $postgresql::params::locale

##### `data_checksums`

Data type: `Any`

Boolean. Use checksums on data pages to help detect corruption by the I/O system that would otherwise be silent.
Warning: This option is used during initialization by initdb, and cannot be changed later. If set, checksums are calculated for all objects, in all databases.

Default value: $postgresql::params::data_checksums

##### `timezone`

Data type: `Any`

Set timezone for the PostgreSQL instance

Default value: $postgresql::params::timezone

##### `manage_pg_hba_conf`

Data type: `Any`

Boolean. Whether to manage the pg_hba.conf.

Default value: $postgresql::params::manage_pg_hba_conf

##### `manage_pg_ident_conf`

Data type: `Any`

Boolean. Overwrites the pg_ident.conf file.

Default value: $postgresql::params::manage_pg_ident_conf

##### `manage_recovery_conf`

Data type: `Any`

Boolean. Specifies whether or not manage the recovery.conf.

Default value: $postgresql::params::manage_recovery_conf

##### `module_workdir`

Data type: `Any`

Working directory for the PostgreSQL module

Default value: $postgresql::params::module_workdir

##### `manage_datadir`

Data type: `Any`

Set to false if you have file{ $datadir: } already defined

Default value: $postgresql::params::manage_datadir

##### `manage_logdir`

Data type: `Any`

Set to false if you have file{ $logdir: } already defined

Default value: $postgresql::params::manage_logdir

##### `manage_xlogdir`

Data type: `Any`

Set to false if you have file{ $xlogdir: } already defined

Default value: $postgresql::params::manage_xlogdir

##### `roles`

Data type: `Hash[String, Hash]`

Specifies a hash from which to generate postgresql::server::role resources.

Default value: {}

##### `config_entries`

Data type: `Hash[String, Any]`

Specifies a hash from which to generate postgresql::server::config_entry resources.

Default value: {}

##### `pg_hba_rules`

Data type: `Hash[String, Hash]`

Specifies a hash from which to generate postgresql::server::pg_hba_rule resources.

Default value: {}

##### `version`

Data type: `Any`

Deprecated. Use postgresql::globals instead. Sets PostgreSQL version

Default value: `undef`

##### `extra_systemd_config`

Data type: `Any`

Adds extra config to systemd config file, can for instance be used to add extra openfiles. This can be a multi line string

Default value: $postgresql::params::extra_systemd_config

##### `manage_selinux`

Data type: `Boolean`



Default value: $postgresql::params::manage_selinux

##### `password_encryption`

Data type: `Any`



Default value: $postgresql::params::password_encryption

### postgresql::server::contrib

Install the contrib postgresql packaging.

#### Parameters

The following parameters are available in the `postgresql::server::contrib` class.

##### `package_name`

Data type: `String`

The name of the PostgreSQL contrib package.

Default value: $postgresql::params::contrib_package_name

##### `package_ensure`

Data type: `String[1]`

Ensure the contrib package is installed.

Default value: 'present'

### postgresql::server::plperl

This class installs the PL/Perl procedural language for postgresql.

#### Parameters

The following parameters are available in the `postgresql::server::plperl` class.

##### `package_ensure`

Data type: `Any`

The ensure parameter passed on to PostgreSQL PL/Perl package resource.

Default value: 'present'

##### `package_name`

Data type: `Any`

The name of the PostgreSQL PL/Perl package.

Default value: $postgresql::server::plperl_package_name

### postgresql::server::plpython

This class installs the PL/Python procedural language for postgresql.

#### Parameters

The following parameters are available in the `postgresql::server::plpython` class.

##### `package_ensure`

Data type: `Any`

Specifies whether the package is present.

Default value: 'present'

##### `package_name`

Data type: `Any`

Specifies the name of the postgresql PL/Python package.

Default value: $postgresql::server::plpython_package_name

### postgresql::server::postgis

Install the postgis postgresql packaging.

#### Parameters

The following parameters are available in the `postgresql::server::postgis` class.

##### `package_name`

Data type: `String`

Sets the package name.

Default value: $postgresql::params::postgis_package_name

##### `package_ensure`

Data type: `String[1]`

Specifies if the package is present or not.

Default value: 'present'

## Defined types

### postgresql::server::config_entry

Manage a postgresql.conf entry.

#### Parameters

The following parameters are available in the `postgresql::server::config_entry` defined type.

##### `ensure`

Data type: `Any`

Removes an entry if set to 'absent'.

Default value: 'present'

##### `value`

Data type: `Any`

Defines the value for the setting.

Default value: `undef`

##### `path`

Data type: `Any`

Path for postgresql.conf

Default value: `false`

### postgresql::server::database

Define for creating a database.

#### Parameters

The following parameters are available in the `postgresql::server::database` defined type.

##### `comment`

Data type: `Any`

Sets a comment on the database.

Default value: `undef`

##### `dbname`

Data type: `Any`

Sets the name of the database.

Default value: $title

##### `owner`

Data type: `Any`

Sets name of the database owner.

Default value: `undef`

##### `tablespace`

Data type: `Any`

Sets tablespace for where to create this database.

Default value: `undef`

##### `template`

Data type: `Any`

Specifies the name of the template database from which to build this database. Default value: 'template0'.

Default value: 'template0'

##### `encoding`

Data type: `Any`

Overrides the character set during creation of the database.

Default value: $postgresql::server::encoding

##### `locale`

Data type: `Any`

Overrides the locale during creation of the database.

Default value: $postgresql::server::locale

##### `istemplate`

Data type: `Any`

Defines the database as a template if set to true.

Default value: `false`

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

### postgresql::server::database_grant

Manage a database grant.

#### Parameters

The following parameters are available in the `postgresql::server::database_grant` defined type.

##### `privilege`

Data type: `Any`

Specifies comma-separated list of privileges to grant. Valid options: 'ALL', 'CREATE', 'CONNECT', 'TEMPORARY', 'TEMP'.

##### `db`

Data type: `Any`

Specifies the database to which you are granting access.

##### `role`

Data type: `Any`

Specifies the role or user whom you are granting access to.

##### `ensure`

Data type: `Any`

Specifies whether to grant or revoke the privilege. Revoke or 'absent' works only in PostgreSQL version 9.1.24 or later.

Default value: `undef`

##### `psql_db`

Data type: `Any`

Defines the database to execute the grant against. This should not ordinarily be changed from the default

Default value: `undef`

##### `psql_user`

Data type: `Any`

Specifies the OS user for running psql. Default value: The default user for the module, usually 'postgres'.

Default value: `undef`

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: `undef`

### postgresql::server::db

Define for conveniently creating a role, database and assigning the correctpermissions.

#### Parameters

The following parameters are available in the `postgresql::server::db` defined type.

##### `user`

Data type: `Any`

User to create and assign access to the database upon creation. Mandatory.

##### `password`

Data type: `Any`

Required Sets the password for the created user.

##### `comment`

Data type: `Any`

Defines a comment to be stored about the database using the PostgreSQL COMMENT command.

Default value: `undef`

##### `dbname`

Data type: `Any`

Sets the name of the database to be created.

Default value: $title

##### `encoding`

Data type: `Any`

Overrides the character set during creation of the database.

Default value: $postgresql::server::encoding

##### `locale`

Data type: `Any`

Overrides the locale during creation of the database.

Default value: $postgresql::server::locale

##### `grant`

Data type: `Any`

Specifies the permissions to grant during creation. Default value: 'ALL'.

Default value: 'ALL'

##### `tablespace`

Data type: `Any`

Defines the name of the tablespace to allocate the created database to.

Default value: `undef`

##### `template`

Data type: `Any`

Specifies the name of the template database from which to build this database. Defaults value: template0.

Default value: 'template0'

##### `istemplate`

Data type: `Any`

Specifies that the database is a template, if set to true.

Default value: `false`

##### `owner`

Data type: `Any`

Sets a user as the owner of the database.

Default value: `undef`

### postgresql::server::extension

Activate an extension on a postgresql database.

#### Parameters

The following parameters are available in the `postgresql::server::extension` defined type.

##### `database`

Data type: `Any`

Specifies the database on which to activate the extension.

##### `extension`

Data type: `Any`

Specifies the extension to activate. If left blank, uses the name of the resource.

Default value: $name

##### `schema`

Data type: `Optional[String[1]]`

Specifies the schema on which to activate the extension.

Default value: `undef`

##### `version`

Data type: `Optional[String[1]]`

Specifies the version of the extension which the database uses. When an extension package is updated, this does not automatically change the effective version in each database.
This needs be updated using the PostgreSQL-specific SQL ALTER EXTENSION...
version may be set to latest, in which case the SQL ALTER EXTENSION "extension" UPDATE is applied to this database (only).
version may be set to a specific version, in which case the extension is updated using ALTER EXTENSION "extension" UPDATE TO 'version'
eg. If extension is set to postgis and version is set to 2.3.3, this will apply the SQL ALTER EXTENSION "postgis" UPDATE TO '2.3.3' to this database only.
version may be omitted, in which case no ALTER EXTENSION... SQL is applied, and the version will be left unchanged.

Default value: `undef`

##### `ensure`

Data type: `String[1]`

Specifies whether to activate or deactivate the extension. Valid options: 'present' or 'absent'.

Default value: 'present'

##### `package_name`

Data type: `Any`

Specifies a package to install prior to activating the extension.

Default value: `undef`

##### `package_ensure`

Data type: `Any`

Overrides default package deletion behavior. By default, the package specified with package_name is installed when the extension is activated and removed when the extension is deactivated. To override this behavior, set the ensure value for the package.

Default value: `undef`

##### `port`

Data type: `Optional[Integer]`

Port to use when connecting.

Default value: `undef`

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: postgresql::default('default_connect_settings')

##### `database_resource_name`

Data type: `Any`

Specifies the resource name of the DB being managed. Defaults to the parameter $database, if left blank.

Default value: $database

### postgresql::server::grant

Define for granting permissions to roles.

#### Parameters

The following parameters are available in the `postgresql::server::grant` defined type.

##### `role`

Data type: `String`

Specifies the role or user whom you are granting access to.

##### `db`

Data type: `String`

Specifies the database to which you are granting access.

##### `privilege`

Data type: `String`

Specifies the privilege to grant. Valid options: 'ALL', 'ALL PRIVILEGES' or 'object_type' dependent string.

Default value: ''

##### `object_type`

Data type: `Pattern[#/(?i:^COLUMN$)/,
    /(?i:^ALL SEQUENCES IN SCHEMA$)/,
    /(?i:^ALL TABLES IN SCHEMA$)/,
    /(?i:^DATABASE$)/,
    #/(?i:^FOREIGN DATA WRAPPER$)/,
    #/(?i:^FOREIGN SERVER$)/,
    /(?i:^FUNCTION$)/,
    /(?i:^LANGUAGE$)/,
    #/(?i:^PROCEDURAL LANGUAGE$)/,
    /(?i:^TABLE$)/,
    #/(?i:^TABLESPACE$)/,
    /(?i:^SCHEMA$)/,
    /(?i:^SEQUENCE$)/
    #/(?i:^VIEW$)/
  ]`

Specifies the type of object to which you are granting privileges. Valid options: 'DATABASE', 'SCHEMA', 'SEQUENCE', 'ALL SEQUENCES IN SCHEMA', 'TABLE' or 'ALL TABLES IN SCHEMA'.

Default value: 'database'

##### `object_name`

Data type: `Optional[Variant[
            Array[String,2,2],
            String[1]]
  ]`

Specifies name of object_type to which to grant access, can be either a string or a two element array. String: 'object_name' Array: ['schema_name', 'object_name']

Default value: `undef`

##### `psql_db`

Data type: `String`

Specifies the database to execute the grant against. This should not ordinarily be changed from the default

Default value: $postgresql::server::default_database

##### `psql_user`

Data type: `String`

Sets the OS user to run psql.

Default value: $postgresql::server::user

##### `port`

Data type: `Integer`

Port to use when connecting.

Default value: $postgresql::server::port

##### `onlyif_exists`

Data type: `Boolean`

Create grant only if doesn't exist

Default value: `false`

##### `connect_settings`

Data type: `Hash`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

##### `ensure`

Data type: `Enum['present',
        'absent'
  ]`

Specifies whether to grant or revoke the privilege. Default is to grant the privilege. Valid values: 'present', 'absent'.

Default value: 'present'

##### `group`

Data type: `String`

Sets the OS group to run psql

Default value: $postgresql::server::group

##### `psql_path`

Data type: `String`

Sets the path to psql command

Default value: $postgresql::server::psql_path

##### `object_arguments`

Data type: `Array[String[1],0]`



Default value: []

### postgresql::server::grant_role

Define for granting membership to a role.

#### Parameters

The following parameters are available in the `postgresql::server::grant_role` defined type.

##### `group`

Data type: `String[1]`

Specifies the group role to which you are assigning a role.

##### `role`

Data type: `String[1]`

Specifies the role you want to assign to a group. If left blank, uses the name of the resource.

Default value: $name

##### `ensure`

Data type: `Enum['present', 'absent']`

Specifies whether to grant or revoke the membership. Valid options: 'present' or 'absent'.

Default value: 'present'

##### `psql_db`

Data type: `Any`

Specifies the database to execute the grant against. This should not ordinarily be changed from the default

Default value: $postgresql::server::default_database

##### `psql_user`

Data type: `Any`

Sets the OS user to run psql.

Default value: $postgresql::server::user

##### `port`

Data type: `Any`

Port to use when connecting.

Default value: $postgresql::server::port

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

### postgresql::server::pg_hba_rule

This resource manages an individual rule that applies to the file defined in target.

#### Parameters

The following parameters are available in the `postgresql::server::pg_hba_rule` defined type.

##### `type`

Data type: `Enum['local', 'host', 'hostssl', 'hostnossl']`

Sets the type of rule.
Enum['local','host','hostssl','hostnossl'].

##### `database`

Data type: `String`

Sets a comma-separated list of databases that this rule matches.

##### `user`

Data type: `String`

Sets a comma-separated list of users that this rule matches.

##### `auth_method`

Data type: `String`

Provides the method that is used for authentication for the connection that this rule matches. Described further in the PostgreSQL pg_hba.conf documentation.

##### `address`

Data type: `Optional[String]`

Sets a CIDR based address for this rule matching when the type is not 'local'.

Default value: `undef`

##### `description`

Data type: `String`

Defines a longer description for this rule, if required. This description is placed in the comments above the rule in pg_hba.conf. Default value: 'none'.

Default value: 'none'

##### `auth_option`

Data type: `Optional[String]`

For certain auth_method settings there are extra options that can be passed. Consult the PostgreSQL pg_hba.conf documentation for further details.

Default value: `undef`

##### `order`

Data type: `Variant[String, Integer]`

Sets an order for placing the rule in pg_hba.conf. This can be either a string or an integer. If it is an integer, it will be converted to a string by zero-padding it to three digits. E.g. 42 will be zero-padded to the string '042'. The pg_hba_rule fragments are sorted using the alpha sorting order. Default value: 150.

Default value: 150

##### `target`

Data type: `Stdlib::Absolutepath`

Provides the target for the rule, and is generally an internal only property. Use with caution.

Default value: $postgresql::server::pg_hba_conf_path

##### `postgresql_version`

Data type: `String`

Manages pg_hba.conf without managing the entire PostgreSQL instance.

Default value: $postgresql::server::_version

### postgresql::server::pg_ident_rule

This resource manages an individual rule that applies to the file defined in target.

#### Parameters

The following parameters are available in the `postgresql::server::pg_ident_rule` defined type.

##### `map_name`

Data type: `Any`

Sets the name of the user map that is used to refer to this mapping in pg_hba.conf.

##### `system_username`

Data type: `Any`

Specifies the operating system user name (the user name used to connect to the database).

##### `database_username`

Data type: `Any`

Specifies the user name of the database user. The system_username is mapped to this user name.

##### `description`

Data type: `Any`

Sets a longer description for this rule if required. This description is placed in the comments above the rule in pg_ident.conf. Default value: 'none'.

Default value: 'none'

##### `order`

Data type: `Any`

Defines an order for placing the mapping in pg_ident.conf. Default value: 150.

Default value: '150'

##### `target`

Data type: `Any`

Provides the target for the rule and is generally an internal only property. Use with caution.

Default value: $postgresql::server::pg_ident_conf_path

### postgresql::server::reassign_owned_by

Define for reassigning the ownership of objects within a database.

* **Note** This enables us to force the a particular ownership for objects within a database

#### Parameters

The following parameters are available in the `postgresql::server::reassign_owned_by` defined type.

##### `old_role`

Data type: `String`

Specifies the role or user who is the current owner of the objects in the specified db

##### `new_role`

Data type: `String`

Specifies the role or user who will be the new owner of these objects

##### `db`

Data type: `String`

Specifies the database to which the 'REASSIGN OWNED' will be applied

##### `psql_user`

Data type: `String`

Specifies the OS user for running psql.

Default value: $postgresql::server::user

##### `port`

Data type: `Integer`

Port to use when connecting.

Default value: $postgresql::server::port

##### `connect_settings`

Data type: `Hash`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

### postgresql::server::recovery

This resource manages the parameters that applies to the recovery.conf template.

* **Note** Allows you to create the content for recovery.conf. For more details see the usage example and the PostgreSQL documentation.
Every parameter value is a string set in the template except recovery_target_inclusive, pause_at_recovery_target, standby_mode and recovery_min_apply_delay.
A detailed description of all listed parameters can be found in the PostgreSQL documentation.
Only the specified parameters are recognized in the template. The recovery.conf is only created if at least one parameter is set and manage_recovery_conf is set to true.

#### Parameters

The following parameters are available in the `postgresql::server::recovery` defined type.

##### `restore_command`

Data type: `Any`

The shell command to execute to retrieve an archived segment of the WAL file series.

Default value: `undef`

##### `archive_cleanup_command`

Data type: `Any`

This optional parameter specifies a shell command that will be executed at every restartpoint.

Default value: `undef`

##### `recovery_end_command`

Data type: `Any`

This parameter specifies a shell command that will be executed once only at the end of recovery.

Default value: `undef`

##### `recovery_target_name`

Data type: `Any`

This parameter specifies the named restore point (created with pg_create_restore_point()) to which recovery will proceed.

Default value: `undef`

##### `recovery_target_time`

Data type: `Any`

This parameter specifies the time stamp up to which recovery will proceed.

Default value: `undef`

##### `recovery_target_xid`

Data type: `Any`

This parameter specifies the transaction ID up to which recovery will proceed.

Default value: `undef`

##### `recovery_target_inclusive`

Data type: `Any`

Specifies whether to stop just after the specified recovery target (true), or just before the recovery target (false).

Default value: `undef`

##### `recovery_target`

Data type: `Any`

This parameter specifies that recovery should end as soon as a consistent state is reached, i.e. as early as possible.

Default value: `undef`

##### `recovery_target_timeline`

Data type: `Any`

Specifies recovering into a particular timeline.

Default value: `undef`

##### `pause_at_recovery_target`

Data type: `Any`

Specifies whether recovery should pause when the recovery target is reached.

Default value: `undef`

##### `standby_mode`

Data type: `Any`

Specifies whether to start the PostgreSQL server as a standby.

Default value: `undef`

##### `primary_conninfo`

Data type: `Any`

Specifies a connection string to be used for the standby server to connect with the primary.

Default value: `undef`

##### `primary_slot_name`

Data type: `Any`

Optionally specifies an existing replication slot to be used when connecting to the primary via streaming replication to control resource removal on the upstream node.

Default value: `undef`

##### `trigger_file`

Data type: `Any`

Specifies a trigger file whose presence ends recovery in the standby.

Default value: `undef`

##### `recovery_min_apply_delay`

Data type: `Any`

This parameter allows you to delay recovery by a fixed period of time, measured in milliseconds if no unit is specified.

Default value: `undef`

##### `target`

Data type: `Any`

Provides the target for the rule, and is generally an internal only property. Use with caution.

Default value: $postgresql::server::recovery_conf_path

### postgresql::server::role

Define for creating a database role.

#### Parameters

The following parameters are available in the `postgresql::server::role` defined type.

##### `update_password`

Data type: `Any`

If set to true, updates the password on changes. Set this to false to not modify the role's password after creation.

Default value: `true`

##### `password_hash`

Data type: `Any`

Sets the hash to use during password creation.

Default value: `false`

##### `createdb`

Data type: `Any`

Specifies whether to grant the ability to create new databases with this role.

Default value: `false`

##### `createrole`

Data type: `Any`

Specifies whether to grant the ability to create new roles with this role.

Default value: `false`

##### `db`

Data type: `Any`

Database used to connect to.

Default value: $postgresql::server::default_database

##### `port`

Data type: `Any`

Port to use when connecting.

Default value: `undef`

##### `login`

Data type: `Any`

Specifies whether to grant login capability for the new role.

Default value: `true`

##### `inherit`

Data type: `Any`

Specifies whether to grant inherit capability for the new role.

Default value: `true`

##### `superuser`

Data type: `Any`

Specifies whether to grant super user capability for the new role.

Default value: `false`

##### `replication`

Data type: `Any`

Provides provides replication capabilities for this role if set to true.

Default value: `false`

##### `connection_limit`

Data type: `Any`

Specifies how many concurrent connections the role can make. Default value: '-1', meaning no limit.

Default value: '-1'

##### `username`

Data type: `Any`

Defines the username of the role to create.

Default value: $title

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

##### `ensure`

Data type: `Enum['present', 'absent']`

Specify whether to create or drop the role. Specifying 'present' creates the role. Specifying 'absent' drops the role.

Default value: 'present'

##### `psql_user`

Data type: `Any`

Sets the OS user to run psql

Default value: $postgresql::server::user

##### `psql_group`

Data type: `Any`

Sets the OS group to run psql

Default value: $postgresql::server::group

##### `psql_path`

Data type: `Any`

Sets path to psql command

Default value: $postgresql::server::psql_path

##### `module_workdir`

Data type: `Any`

Specifies working directory under which the psql command should be executed. May need to specify if '/tmp' is on volume mounted with noexec option.

Default value: $postgresql::server::module_workdir

### postgresql::server::schema

Create a new schema.

* **Note** The database must exist and the PostgreSQL user should have enough privileges

#### Examples

##### 

```puppet
postgresql::server::schema {'private':
    db => 'template1',
}
```

#### Parameters

The following parameters are available in the `postgresql::server::schema` defined type.

##### `db`

Data type: `Any`

Required. Sets the name of the database in which to create this schema.

Default value: $postgresql::server::default_database

##### `owner`

Data type: `Any`

Sets the default owner of the schema.

Default value: `undef`

##### `schema`

Data type: `Any`

Sets the name of the schema.

Default value: $title

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

### postgresql::server::table_grant

This resource wraps the grant resource to manage table grants specifically.

#### Parameters

The following parameters are available in the `postgresql::server::table_grant` defined type.

##### `privilege`

Data type: `Any`

Specifies comma-separated list of privileges to grant. Valid options: 'ALL', 'SELECT', 'INSERT', 'UPDATE', 'DELETE', 'TRUNCATE', 'REFERENCES', 'TRIGGER'.

##### `table`

Data type: `Any`

Specifies the table to which you are granting access.

##### `db`

Data type: `Any`

Specifies which database the table is in.

##### `role`

Data type: `Any`

Specifies the role or user to whom you are granting access.

##### `ensure`

Data type: `Any`

Specifies whether to grant or revoke the privilege. Default is to grant the privilege.

Default value: `undef`

##### `port`

Data type: `Any`

Port to use when connecting.

Default value: `undef`

##### `psql_db`

Data type: `Any`

Specifies the database to execute the grant against. This should not ordinarily be changed from the default.

Default value: `undef`

##### `psql_user`

Data type: `Any`

Specifies the OS user for running psql.

Default value: `undef`

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: `undef`

##### `onlyif_exists`

Data type: `Any`

Create grant only if it doesn't exist.

Default value: `false`

### postgresql::server::tablespace

This module creates tablespace.

#### Parameters

The following parameters are available in the `postgresql::server::tablespace` defined type.

##### `location`

Data type: `Any`

Specifies the path to locate this tablespace.

##### `manage_location`

Data type: `Any`

Set to false if you have file{ $location: } already defined

Default value: `true`

##### `owner`

Data type: `Any`

Specifies the default owner of the tablespace.

Default value: `undef`

##### `spcname`

Data type: `Any`

Specifies the name of the tablespace.

Default value: $title

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: $postgresql::server::default_connect_settings

### postgresql::validate_db_connection

This validated if the postgres connection can be established
between the node on which this resource is run and a specified postgres
instance (host/port/user/password/database name).

#### Parameters

The following parameters are available in the `postgresql::validate_db_connection` defined type.

##### `database_host`

Data type: `Any`

Database host address

Default value: `undef`

##### `database_name`

Data type: `Any`

Specifies the name of the database you wish to test.

Default value: `undef`

##### `database_password`

Data type: `Any`

Specifies the password to connect with.

Default value: `undef`

##### `database_username`

Data type: `Any`

Specifies the username to connect with.

Default value: `undef`

##### `database_port`

Data type: `Any`

Defines the port to use when connecting.

Default value: `undef`

##### `connect_settings`

Data type: `Any`

Specifies a hash of environment variables used when connecting to a remote server.

Default value: `undef`

##### `run_as`

Data type: `Any`

Specifies the user to run the psql command as.

Default value: `undef`

##### `sleep`

Data type: `Any`

Sets the number of seconds to sleep for before trying again after a failure.

Default value: 2

##### `tries`

Data type: `Any`

Sets the number of attempts after failure before giving up and failing the resource.

Default value: 10

##### `create_db_first`

Data type: `Any`

Creates the database when obtaining a successful connection.

Default value: `true`

## Resource types

### postgresql_conf

This type allows puppet to manage postgresql.conf parameters.

#### Properties

The following properties are available in the `postgresql_conf` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `value`

The value to set for this parameter.

##### `target`

The path to postgresql.conf

#### Parameters

The following parameters are available in the `postgresql_conf` type.

##### `name`

Valid values: %r{^[\w\.]+$}

namevar

The postgresql parameter name to manage.

### postgresql_conn_validator

Verify that a connection can be successfully established between a node
and the PostgreSQL server.  Its primary use is as a precondition to
prevent configuration changes from being applied if the PostgreSQL
server cannot be reached, but it could potentially be used for other
purposes such as monitoring.

#### Properties

The following properties are available in the `postgresql_conn_validator` type.

##### `ensure`

Valid values: present, absent

Ensure connection validation

Default value: present

#### Parameters

The following parameters are available in the `postgresql_conn_validator` type.

##### `name`

namevar

An arbitrary name used as the identity of the resource.

##### `db_name`

The name of the database you are trying to validate a connection with.

##### `db_username`

A user that has access to the target PostgreSQL database.

##### `db_password`

The password required to access the target PostgreSQL database.

##### `host`

The DNS name or IP address of the server where PostgreSQL should be running.

##### `port`

The port that the PostgreSQL server should be listening on.

##### `connect_settings`

Hash of environment variables for connection to a db.

##### `sleep`

The length of sleep time between connection tries.

Default value: 2

##### `tries`

The number of tries to validate the connection to the target PostgreSQL database.

Default value: 10

##### `psql_path`

Path to the psql command.

##### `run_as`

System user that will run the psql command.

##### `command`

Command to run against target database.

Default value: SELECT 1

### postgresql_psql

An arbitrary tag for your own reference; the name of the message.

#### Properties

The following properties are available in the `postgresql_psql` type.

##### `command`

The SQL command to execute via psql.

#### Parameters

The following parameters are available in the `postgresql_psql` type.

##### `name`

namevar

An arbitrary tag for your own reference; the name of the message.

##### `unless`

An optional SQL command to execute prior to the main :command;
this is generally intended to be used for idempotency, to check
for the existence of an object in the database to determine whether
or not the main SQL command needs to be executed at all.'

##### `onlyif`

An optional SQL command to execute prior to the main :command;
this is generally intended to be used for idempotency, to check
for the existence of an object in the database to determine whether
or not the main SQL command needs to be executed at all.

##### `connect_settings`

Connection settings that will be used when connecting to postgres

##### `db`

The name of the database to execute the SQL command against, this overrides any PGDATABASE value in connect_settings

##### `port`

The port of the database server to execute the SQL command against, this overrides any PGPORT value in connect_settings.

##### `search_path`

The schema search path to use when executing the SQL command

##### `psql_path`

The path to psql executable.

Default value: psql

##### `psql_user`

The system user account under which the psql command should be executed.

Default value: postgres

##### `psql_group`

The system user group account under which the psql command should be executed.

Default value: postgres

##### `cwd`

The working directory under which the psql command should be executed.

Default value: /tmp

##### `environment`

Any additional environment variables you want to set for a
SQL command. Multiple environment variables should be
specified as an array.

##### `refreshonly`

Valid values: `true`, `false`

If 'true', then the SQL will only be executed via a notify/subscribe event.

Default value: `false`

### postgresql_replication_slot

This type allows to create and destroy replication slots
to register warm standby replication on a Postgresql
master server.

#### Properties

The following properties are available in the `postgresql_replication_slot` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

#### Parameters

The following parameters are available in the `postgresql_replication_slot` type.

##### `name`

Valid values: %r{^[a-z0-9_]+$}

namevar

The name of the slot to create. Must be a valid replication slot name.

## Functions

### postgresql::default

Type: Puppet Language

This function pull default values from the `params` class  or `globals` class if the value is not present in `params`.

#### Examples

##### 

```puppet
postgresql::default('variable')
```

#### `postgresql::default(String $parameter_name)`

The postgresql::default function.

Returns: `Any`

##### Examples

###### 

```puppet
postgresql::default('variable')
```

##### `parameter_name`

Data type: `String`



### postgresql::postgresql_escape

Type: Ruby 4.x API

This function escapes a string using [Dollar Quoting](https://www.postgresql.org/docs/12/sql-syntax-lexical.html#SQL-SYNTAX-DOLLAR-QUOTING) using a randomly generated tag if required.

#### `postgresql::postgresql_escape(String[1] $input_string)`

The postgresql::postgresql_escape function.

Returns: `String` A `Dollar Quoted` string

##### `input_string`

Data type: `String[1]`

The unescaped string you want to escape using `dollar quoting`

### postgresql::postgresql_password

Type: Ruby 4.x API

This function returns the postgresql password hash from the clear text username / password

#### `postgresql::postgresql_password(Variant[String[1],Integer] $username, Variant[String[1],Integer] $password)`

The postgresql::postgresql_password function.

Returns: `String` The postgresql password hash from the clear text username / password.

##### `username`

Data type: `Variant[String[1],Integer]`

The clear text `username`

##### `password`

Data type: `Variant[String[1],Integer]`

The clear text `password`

### postgresql_escape

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`postgresql::postgresql_escape`](#postgresqlpostgresql_escape) instead.

#### `postgresql_escape(Any *$args)`

The postgresql_escape function.

Returns: `Any`

##### `*args`

Data type: `Any`



### postgresql_password

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`postgresql::postgresql_password`](#postgresqlpostgresql_password) instead.

#### `postgresql_password(Any *$args)`

The postgresql_password function.

Returns: `Any`

##### `*args`

Data type: `Any`



## Tasks

### sql

Allows you to execute arbitary SQL

**Supports noop?** false

#### Parameters

##### `database`

Data type: `Optional[String[1]]`

Database to connect to

##### `host`

Data type: `Optional[String[1]]`

Hostname to connect to

##### `password`

Data type: `Optional[String[1]]`

The password

##### `port`

Data type: `Optional[String[1]]`

The port

##### `sql`

Data type: `String[1]`

The SQL you want to execute

##### `user`

Data type: `Optional[String[1]]`

The user

