# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

_Public Classes_

* [`python`](#python): Installs and manages python, python-dev, python-virtualenv and gunicorn.
* [`python::pip::bootstrap`](#pythonpipbootstrap): allow to bootstrap pip when python is managed from other module

_Private Classes_

* `python::config`: Optionally installs the gunicorn service
* `python::install`: Installs core python packages
* `python::params`: The python Module default configuration settings.

**Defined types**

* [`python::dotfile`](#pythondotfile): Manages any python dotfiles with a simple config hash.
* [`python::gunicorn`](#pythongunicorn): Manages Gunicorn virtual hosts.
* [`python::pip`](#pythonpip): Installs and manages packages from pip.
* [`python::pyvenv`](#pythonpyvenv): Create a Python3 virtualenv using pyvenv.
* [`python::requirements`](#pythonrequirements): Installs and manages Python packages from requirements file.
* [`python::virtualenv`](#pythonvirtualenv): Creates Python virtualenv.

## Classes

### python

Installs and manages python, python-dev, python-virtualenv and gunicorn.

#### Examples

##### install python from system python

```puppet
class { 'python':
  version    => 'system',
  pip        => 'present',
  dev        => 'present',
  virtualenv => 'present',
  gunicorn   => 'present',
}
```

##### install python3 from scl repo

```puppet
class { 'python' :
  ensure      => 'present',
  version     => 'rh-python36-python',
  dev         => 'present',
  virtualenv  => 'present',
}
```

#### Parameters

The following parameters are available in the `python` class.

##### `ensure`

Data type: `Enum['absent', 'present', 'latest']`

Desired installation state for the Python package.

Default value: $python::params::ensure

##### `version`

Data type: `Any`

Python version to install. Beware that valid values for this differ a) by the provider you choose and b) by the osfamily/operatingsystem you are using.
Allowed values:
 - provider == pip: everything pip allows as a version after the 'python=='
 - else: 'system', 'pypy', 3/3.3/...
    - Be aware that 'system' usually means python 2.X.
    - 'pypy' actually lets us use pypy as python.
    - 3/3.3/... means you are going to install the python3/python3.3/...
      package, if available on your osfamily.

Default value: $python::params::version

##### `pip`

Data type: `Enum['absent', 'present', 'latest']`

Desired installation state for the python-pip package.

Default value: $python::params::pip

##### `dev`

Data type: `Enum['absent', 'present', 'latest']`

Desired installation state for the python-dev package.

Default value: $python::params::dev

##### `virtualenv`

Data type: `Enum['absent', 'present', 'latest']`

Desired installation state for the virtualenv package

Default value: $python::params::virtualenv

##### `gunicorn`

Data type: `Enum['absent', 'present', 'latest']`

Desired installation state for Gunicorn.

Default value: $python::params::gunicorn

##### `manage_gunicorn`

Data type: `Boolean`

Allow Installation / Removal of Gunicorn.

Default value: $python::params::manage_gunicorn

##### `provider`

Data type: `Optional[Enum['pip', 'scl', 'rhscl', 'anaconda', '']]`

What provider to use for installation of the packages, except gunicorn and Python itself.

Default value: $python::params::provider

##### `use_epel`

Data type: `Boolean`

to determine if the epel class is used.

Default value: $python::params::use_epel

##### `manage_scl`

Data type: `Boolean`

Whether to manage core SCL packages or not.

Default value: $python::params::manage_scl

##### `umask`

Data type: `Optional[Pattern[/[0-7]{1,4}/]]`

The default umask for invoked exec calls.

Default value: `undef`

##### `manage_python_package`

Data type: `Boolean`



Default value: $python::params::manage_python_package

##### `manage_virtualenv_package`

Data type: `Boolean`



Default value: $python::params::manage_virtualenv_package

##### `manage_pip_package`

Data type: `Boolean`



Default value: $python::params::manage_pip_package

##### `gunicorn_package_name`

Data type: `Any`



Default value: $python::params::gunicorn_package_name

##### `valid_versions`

Data type: `Any`



Default value: $python::params::valid_versions

##### `python_pips`

Data type: `Hash`



Default value: { }

##### `python_virtualenvs`

Data type: `Hash`



Default value: { }

##### `python_pyvenvs`

Data type: `Hash`



Default value: { }

##### `python_requirements`

Data type: `Hash`



Default value: { }

##### `python_dotfiles`

Data type: `Hash`



Default value: { }

##### `rhscl_use_public_repository`

Data type: `Any`



Default value: $python::params::rhscl_use_public_repository

##### `anaconda_installer_url`

Data type: `Stdlib::Httpurl`



Default value: $python::params::anaconda_installer_url

##### `anaconda_install_path`

Data type: `Stdlib::Absolutepath`



Default value: $python::params::anaconda_install_path

### python::pip::bootstrap

allow to bootstrap pip when python is managed from other module

#### Examples

##### 

```puppet
class { 'python::pip::bootstrap':
  version => 'pip',
}
```

#### Parameters

The following parameters are available in the `python::pip::bootstrap` class.

##### `version`

Data type: `Enum['pip', 'pip3']`

should be pip or pip3

Default value: 'pip'

##### `manage_python`

Data type: `Variant[Boolean, String]`

if python module will manage deps

Default value: `false`

##### `http_proxy`

Data type: `Optional[Stdlib::HTTPUrl]`

Proxy server to use for outbound connections.

Default value: `undef`

##### `exec_provider`

Data type: `String[1]`



Default value: 'shell'

## Defined types

### python::dotfile

Manages any python dotfiles with a simple config hash.

#### Examples

##### Create a pip config in /var/lib/jenkins/.pip/

```puppet
python::dotfile { '/var/lib/jenkins/.pip/pip.conf':
  ensure => present,
  owner  => 'jenkins',
  group  => 'jenkins',
  config => {
    'global' => {
      'index-url'       => 'https://mypypi.acme.com/simple/'
      'extra-index-url' => 'https://pypi.risedev.at/simple/'
    }
  }
}
```

#### Parameters

The following parameters are available in the `python::dotfile` defined type.

##### `ensure`

Data type: `Enum['absent', 'present']`



Default value: 'present'

##### `filename`

Data type: `String[1]`

Filename.

Default value: $title

##### `mode`

Data type: `Stdlib::Filemode`

File mode.

Default value: '0644'

##### `owner`

Data type: `String[1]`

user owner of dotfile

Default value: 'root'

##### `group`

Data type: `String[1]`

group owner of dotfile

Default value: 'root'

##### `config`

Data type: `Hash`

Config hash. This will be expanded to an ini-file.

Default value: {}

### python::gunicorn

Manages Gunicorn virtual hosts.

#### Examples

##### run gunicorn on vhost in virtualenv /var/www/project1

```puppet
python::gunicorn { 'vhost':
  ensure      => present,
  virtualenv  => '/var/www/project1',
  mode        => 'wsgi',
  dir         => '/var/www/project1/current',
  bind        => 'unix:/tmp/gunicorn.socket',
  environment => 'prod',
  owner       => 'www-data',
  group       => 'www-data',
  appmodule   => 'app:app',
  osenv       => { 'DBHOST' => 'dbserver.example.com' },
  timeout     => 30,
  template    => 'python/gunicorn.erb',
}
```

#### Parameters

The following parameters are available in the `python::gunicorn` defined type.

##### `ensure`

Data type: `Enum['present', 'absent']`



Default value: present

##### `config_dir`

Data type: `Any`

Configure the gunicorn config directory path.

Default value: '/etc/gunicorn.d'

##### `manage_config_dir`

Data type: `Any`

Set if the gunicorn config directory should be created.

Default value: `false`

##### `virtualenv`

Data type: `Any`

Run in virtualenv, specify directory.

Default value: `false`

##### `mode`

Data type: `Enum['wsgi', 'django']`

Gunicorn mode.

Default value: 'wsgi'

##### `dir`

Data type: `Stdlib::Absolutepath`

Application directory.

##### `bind`

Data type: `Any`

Bind on: 'HOST', 'HOST:PORT', 'unix:PATH'.
Default: system-wide: unix:/tmp/gunicorn-$name.socket
         virtualenv:  unix:${virtualenv}/${name}.socket

Default value: `false`

##### `environment`

Data type: `Any`

Set ENVIRONMENT variable.

Default value: `false`

##### `appmodule`

Data type: `Any`

Set the application module name for gunicorn to load when not using Django.

Default value: 'app:app'

##### `osenv`

Data type: `Any`

Allows setting environment variables for the gunicorn service. Accepts a hash of 'key': 'value' pairs.

Default value: `false`

##### `timeout`

Data type: `Any`

Allows setting the gunicorn idle worker process time before being killed. The unit of time is seconds.

Default value: 30

##### `template`

Data type: `Any`

Which ERB template to use.

Default value: 'python/gunicorn.erb'

##### `args`

Data type: `Any`

Custom arguments to add in gunicorn config file.

Default value: []

##### `owner`

Data type: `Any`



Default value: 'www-data'

##### `group`

Data type: `Any`



Default value: 'www-data'

##### `workers`

Data type: `Any`



Default value: `false`

##### `access_log_format`

Data type: `Any`



Default value: `false`

##### `accesslog`

Data type: `Any`



Default value: `false`

##### `errorlog`

Data type: `Any`



Default value: `false`

##### `log_level`

Data type: `Enum['debug', 'info', 'warning', 'error', 'critical']`



Default value: 'error'

### python::pip

Installs and manages packages from pip.

#### Examples

##### Install Flask to /var/www/project1 using a proxy

```puppet
python::pip { 'flask':
  virtualenv => '/var/www/project1',
  proxy      => 'http://proxy.domain.com:3128',
  index      => 'http://www.example.com/simple/',
}
```

##### Install cx_Oracle with pip

```puppet
python::pip { 'cx_Oracle' :
  pkgname       => 'cx_Oracle',
  ensure        => '5.1.2',
  virtualenv    => '/var/www/project1',
  owner         => 'appuser',
  proxy         => 'http://proxy.domain.com:3128',
  environment   => 'ORACLE_HOME=/usr/lib/oracle/11.2/client64',
  install_args  => '-e',
  timeout       => 1800,
}
```

##### Install Requests with pip3

```puppet
python::pip { 'requests' :
  ensure        => 'present',
  pkgname       => 'requests',
  pip_provider  => 'pip3',
  virtualenv    => '/var/www/project1',
  owner         => 'root',
  timeout       => 1800
}
```

#### Parameters

The following parameters are available in the `python::pip` defined type.

##### `name`

must be unique

##### `pkgname`

Data type: `String`

the name of the package.

Default value: $name

##### `ensure`

Data type: `Variant[Enum[present, absent, latest], String[1]]`

Require pip to be available.

Default value: present

##### `virtualenv`

Data type: `Variant[Enum['system'], Stdlib::Absolutepath]`

virtualenv to run pip in.

Default value: 'system'

##### `pip_provider`

Data type: `String[1]`

version of pip you wish to use.

Default value: 'pip'

##### `url`

Data type: `Variant[Boolean, String]`

URL to install from.

Default value: `false`

##### `owner`

Data type: `String[1]`

The owner of the virtualenv being manipulated.

Default value: 'root'

##### `group`

Data type: `Any`

The group of the virtualenv being manipulated.

Default value: getvar('python::params::group')

##### `index`

Data type: `Any`

Base URL of Python package index.

Default value: `false`

##### `proxy`

Data type: `Optional[Stdlib::HTTPUrl]`

Proxy server to use for outbound connections.

Default value: `undef`

##### `editable`

Data type: `Boolean`

If true the package is installed as an editable resource.

Default value: `false`

##### `environment`

Data type: `Any`

Additional environment variables required to install the packages.

Default value: []

##### `extras`

Data type: `Any`

Extra features provided by the package which should be installed.

Default value: []

##### `timeout`

Data type: `Numeric`

The maximum time in seconds the "pip install" command should take.

Default value: 1800

##### `install_args`

Data type: `String`

Any additional installation arguments that will be supplied when running pip install.

Default value: ''

##### `uninstall_args`

Data type: `String`

Any additional arguments that will be supplied when running pip uninstall.

Default value: ''

##### `log_dir`

Data type: `String[1]`

Log directory

Default value: '/tmp'

##### `egg`

Data type: `Any`

The egg name to use

Default value: `false`

##### `umask`

Data type: `Any`



Default value: `undef`

##### `path`

Data type: `Array[String]`



Default value: ['/usr/local/bin','/usr/bin','/bin', '/usr/sbin']

##### `exec_provider`

Data type: `String[1]`



Default value: 'shell'

### python::pyvenv

Create a Python3 virtualenv using pyvenv.

#### Examples

##### 

```puppet
python::pyvenv { '/var/www/project1' :
  ensure       => present,
  version      => 'system',
  systempkgs   => true,
  venv_dir     => '/home/appuser/virtualenvs',
  owner        => 'appuser',
  group        => 'apps',
}
```

#### Parameters

The following parameters are available in the `python::pyvenv` defined type.

##### `ensure`

Data type: `Any`



Default value: present

##### `version`

Data type: `Any`

Python version to use.

Default value: 'system'

##### `systempkgs`

Data type: `Any`

Copy system site-packages into virtualenv

Default value: `false`

##### `venv_dir`

Data type: `Any`

Directory to install virtualenv to

Default value: $name

##### `owner`

Data type: `Any`

The owner of the virtualenv being manipulated

Default value: 'root'

##### `group`

Data type: `Any`

The group relating to the virtualenv being manipulated

Default value: 'root'

##### `mode`

Data type: `Any`

Optionally specify directory mode

Default value: '0755'

##### `path`

Data type: `Any`

Specifies the PATH variable.

Default value: [ '/bin', '/usr/bin', '/usr/sbin', '/usr/local/bin' ]

##### `environment`

Data type: `Any`

Optionally specify environment variables for pyvenv

Default value: []

### python::requirements

Installs and manages Python packages from requirements file.

#### Examples

##### install pip requirements from /var/www/project1/requirements.txt

```puppet
python::requirements { '/var/www/project1/requirements.txt' :
  virtualenv => '/var/www/project1',
  proxy      => 'http://proxy.domain.com:3128',
  owner      => 'appuser',
  group      => 'apps',
}
```

#### Parameters

The following parameters are available in the `python::requirements` defined type.

##### `requirements`

Data type: `Any`

Path to the requirements file.

Default value: $name

##### `virtualenv`

Data type: `Any`

virtualenv to run pip in.

Default value: 'system'

##### `pip_provider`

Data type: `Enum['pip', 'pip3']`

version of pip you wish to use.

Default value: 'pip'

##### `owner`

Data type: `Any`

The owner of the virtualenv being manipulated.

Default value: 'root'

##### `group`

Data type: `Any`

The group relating to the virtualenv being manipulated.

Default value: 'root'

##### `proxy`

Data type: `Optional[Stdlib::HTTPUrl]`

Proxy server to use for outbound connections.

Default value: `undef`

##### `src`

Data type: `Any`

Pip --src parameter to; if the requirements file contains --editable resources, this parameter specifies where they will be installed. See the pip documentation for more.

Default value: `false`

##### `environment`

Data type: `Any`

Additional environment variables required to install the packages.

Default value: []

##### `forceupdate`

Data type: `Any`

Run a pip install requirements even if we don't receive an event from the requirements file - Useful for when the requirements file is written as part of a resource other than file (E.g vcsrepo)

Default value: `false`

##### `cwd`

Data type: `Any`

The directory from which to run the "pip install" command.

Default value: `undef`

##### `extra_pip_args`

Data type: `Any`

Extra arguments to pass to pip after the requirements file

Default value: ''

##### `manage_requirements`

Data type: `Any`

Create the requirements file if it doesn't exist.

Default value: `true`

##### `fix_requirements_owner`

Data type: `Any`

Change owner and group of requirements file.

Default value: `true`

##### `log_dir`

Data type: `Any`

Log directory.

Default value: '/tmp'

##### `timeout`

Data type: `Any`

The maximum time in seconds the "pip install" command should take.

Default value: 1800

### python::virtualenv

Creates Python virtualenv.

#### Examples

##### install a virtual env at /var/www/project1

```puppet
python::virtualenv { '/var/www/project1':
  ensure       => present,
  version      => 'system',
  requirements => '/var/www/project1/requirements.txt',
  proxy        => 'http://proxy.domain.com:3128',
  systempkgs   => true,
  index        => 'http://www.example.com/simple/',
}
```

#### Parameters

The following parameters are available in the `python::virtualenv` defined type.

##### `ensure`

Data type: `Any`



Default value: 'present'

##### `version`

Data type: `Any`

Python version to use.

Default value: 'system'

##### `requirements`

Data type: `Any`

Path to pip requirements.txt file

Default value: `false`

##### `systempkgs`

Data type: `Any`

Copy system site-packages into virtualenv.

Default value: `false`

##### `venv_dir`

Data type: `Any`

Directory to install virtualenv to

Default value: $name

##### `ensure_venv_dir`

Data type: `Any`

Create $venv_dir

Default value: `true`

##### `distribute`

Data type: `Any`

Include distribute in the virtualenv

Default value: `true`

##### `index`

Data type: `Any`

Base URL of Python package index

Default value: `false`

##### `owner`

Data type: `Any`

The owner of the virtualenv being manipulated

Default value: 'root'

##### `group`

Data type: `Any`

The group relating to the virtualenv being manipulated

Default value: 'root'

##### `mode`

Data type: `Any`

Optionally specify directory mode

Default value: '0755'

##### `proxy`

Data type: `Optional[Stdlib::HTTPUrl]`

Proxy server to use for outbound connections

Default value: `undef`

##### `environment`

Data type: `Any`

Additional environment variables required to install the packages

Default value: []

##### `path`

Data type: `Any`

Specifies the PATH variable

Default value: [ '/bin', '/usr/bin', '/usr/sbin', '/usr/local/bin' ]

##### `cwd`

Data type: `Any`

The directory from which to run the "pip install" command

Default value: `undef`

##### `timeout`

Data type: `Any`

The maximum time in seconds the "pip install" command should take

Default value: 1800

##### `pip_args`

Data type: `Any`

Arguments to pass to pip during initialization

Default value: ''

##### `extra_pip_args`

Data type: `Any`

Extra arguments to pass to pip after requirements file

Default value: ''

##### `virtualenv`

Data type: `Any`



Default value: `undef`

