# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

_Public Classes_

* [`rabbitmq`](#rabbitmq): A module to manage RabbitMQ

_Private Classes_

* `rabbitmq::config`: Sets all the configuration values for RabbitMQ and creates the directories for config and ssl.
* `rabbitmq::install`: Ensures that rabbitmq-server exists
* `rabbitmq::install::rabbitmqadmin`: Install rabbitmq admin
* `rabbitmq::management`: Manage presence / absence of user resource for guest management user.
* `rabbitmq::repo::apt`: requires   puppetlabs-apt   puppetlabs-stdlib
* `rabbitmq::repo::rhel`: Makes sure that the Packagecloud repo is installed
* `rabbitmq::service`: This class manages the rabbitmq server service itself.

**Resource types**

* [`rabbitmq_binding`](#rabbitmq_binding): Native type for managing rabbitmq bindings  rabbitmq_binding { 'binding 1':   ensure           => present,   source           => 'myexchange'
* [`rabbitmq_erlang_cookie`](#rabbitmq_erlang_cookie): Type to manage the rabbitmq erlang cookie securely  This is essentially a private type used by the rabbitmq::config class to manage the erlan
* [`rabbitmq_exchange`](#rabbitmq_exchange): Native type for managing rabbitmq exchanges
* [`rabbitmq_parameter`](#rabbitmq_parameter): Type for managing rabbitmq parameters
* [`rabbitmq_plugin`](#rabbitmq_plugin): manages rabbitmq plugins
* [`rabbitmq_policy`](#rabbitmq_policy): Type for managing rabbitmq policies
* [`rabbitmq_queue`](#rabbitmq_queue): Native type for managing rabbitmq queue
* [`rabbitmq_user`](#rabbitmq_user): Native type for managing rabbitmq users
* [`rabbitmq_user_permissions`](#rabbitmq_user_permissions): Type for managing rabbitmq user permissions
* [`rabbitmq_vhost`](#rabbitmq_vhost): Native type for managing rabbitmq vhosts

## Classes

### rabbitmq

A module to manage RabbitMQ

#### Examples

##### Basic usage

```puppet
include rabbitmq
```

##### rabbitmq class

```puppet
class { 'rabbitmq':
  service_manage    => false,
  port              => '5672',
  delete_guest_user => true,
}
```

##### Offline installation from local mirror:

```puppet
class { 'rabbitmq':
  key_content     => template('openstack/rabbit.pub.key'),
  package_gpg_key => '/tmp/rabbit.pub.key',
}
```

##### Use external package key source for any (apt/rpm) package provider:

```puppet
class { 'rabbitmq':
  package_gpg_key => 'http://www.some_site.some_domain/some_key.pub.key',
}
```

##### To use RabbitMQ Environment Variables, use the parameters `environment_variables` e.g.:

```puppet
class { 'rabbitmq':
  port                  => '5672',
  environment_variables => {
    'NODENAME'    => 'node01',
    'SERVICENAME' => 'RabbitMQ'
  }
}
```

##### Change RabbitMQ Config Variables in rabbitmq.config:

```puppet
class { 'rabbitmq':
  port             => '5672',
  config_variables => {
    'hipe_compile' => true,
    'frame_max'    => 131072,
    'log_levels'   => "[{connection, info}]"
  }
}
```

##### Change Erlang Kernel Config Variables in rabbitmq.config

```puppet
class { 'rabbitmq':
  port                    => '5672',
  config_kernel_variables => {
    'inet_dist_listen_min' => 9100,
    'inet_dist_listen_max' => 9105,
  }
}
```

##### Change Management Plugin Config Variables in rabbitmq.config

```puppet
class { 'rabbitmq':
  config_management_variables => {
    'rates_mode' => 'basic',
  }
}
```

##### Change Additional Config Variables in rabbitmq.config

```puppet
class { 'rabbitmq':
  config_additional_variables => {
    'autocluster' => '[{consul_service, "rabbit"},{cluster_name, "rabbit"}]',
    'foo'         => '[{bar, "baz"}]'
  }
}

This will result in the following config appended to the config file:
{autocluster, [{consul_service, "rabbit"},{cluster_name, "rabbit"}]},
 {foo, [{bar, "baz"}]}
(This is required for the [autocluster plugin](https://github.com/rabbitmq/rabbitmq-autocluster)
```

##### Use RabbitMQ clustering facilities

```puppet
class { 'rabbitmq':
  config_cluster           => true,
  cluster_nodes            => ['rabbit1', 'rabbit2'],
  cluster_node_type        => 'ram',
  erlang_cookie            => 'A_SECRET_COOKIE_STRING',
  wipe_db_on_cookie_change => true,
}
```

#### Parameters

The following parameters are available in the `rabbitmq` class.

##### `admin_enable`

Data type: `Boolean`

If enabled sets up the management interface/plugin for RabbitMQ.
This also install the rabbitmqadmin command line tool.

Default value: `true`

##### `management_enable`

Data type: `Boolean`

If enabled sets up the management interface/plugin for RabbitMQ.
NOTE: This does not install the rabbitmqadmin command line tool.

Default value: `false`

##### `use_config_file_for_plugins`

Data type: `Boolean`

If enabled the /etc/rabbitmq/enabled_plugins config file is created,
replacing the use of the rabbitmqplugins provider to enable plugins.

Default value: `false`

##### `auth_backends`

Data type: `Optional[Array]`

An array specifying authorization/authentication backend to use. Single quotes should be placed around array entries,
ex. `['{foo, baz}', 'baz']` Defaults to [rabbit_auth_backend_internal], and if using LDAP defaults to [rabbit_auth_backend_internal,
rabbit_auth_backend_ldap].

Default value: `undef`

##### `cluster_node_type`

Data type: `Enum['ram', 'disc']`

Choose between disc and ram nodes.

Default value: 'disc'

##### `cluster_nodes`

Data type: `Array`

An array of nodes for clustering.

Default value: []

##### `cluster_partition_handling`

Data type: `String`

Value to set for `cluster_partition_handling` RabbitMQ configuration variable.

Default value: 'ignore'

##### `collect_statistics_interval`

Data type: `Optional[Integer]`

Set the collect_statistics_interval in rabbitmq.config

Default value: `undef`

##### `config`

Data type: `String`

The file to use as the rabbitmq.config template.

Default value: 'rabbitmq/rabbitmq.config.erb'

##### `config_additional_variables`

Data type: `Hash`

Additional config variables in rabbitmq.config

Default value: {}

##### `config_cluster`

Data type: `Boolean`

Enable or disable clustering support.

Default value: `false`

##### `config_kernel_variables`

Data type: `Hash`

Hash of Erlang kernel configuration variables to set (see [Variables Configurable in rabbitmq.config](#variables-configurable-in-rabbitmq.config)).

Default value: {}

##### `config_path`

Data type: `Stdlib::Absolutepath`

The path to write the RabbitMQ configuration file to.

Default value: '/etc/rabbitmq/rabbitmq.config'

##### `config_ranch`

Data type: `Boolean`

When true, suppress config directives needed for older (<3.6) RabbitMQ versions.

Default value: `true`

##### `config_management_variables`

Data type: `Hash`

Hash of configuration variables for the [Management Plugin](https://www.rabbitmq.com/management.html).

Default value: {}

##### `config_stomp`

Data type: `Boolean`

Enable or disable stomp.

Default value: `false`

##### `config_shovel`

Data type: `Boolean`

Enable or disable shovel.

Default value: `false`

##### `config_shovel_statics`

Data type: `Hash`

Hash of static shovel configurations

Default value: {}

##### `config_variables`

Data type: `Hash`

To set config variables in rabbitmq.config

Default value: {}

##### `default_user`

Data type: `String`

Username to set for the `default_user` in rabbitmq.config.

Default value: 'guest'

##### `default_pass`

Data type: `String`

Password to set for the `default_user` in rabbitmq.config.

Default value: 'guest'

##### `delete_guest_user`

Data type: `Boolean`

Controls whether default guest user is deleted.

Default value: `false`

##### `env_config`

Data type: `String`

The template file to use for rabbitmq_env.config.

Default value: 'rabbitmq/rabbitmq-env.conf.erb'

##### `env_config_path`

Data type: `Stdlib::Absolutepath`

The path to write the rabbitmq_env.config file to.

Default value: '/etc/rabbitmq/rabbitmq-env.conf'

##### `environment_variables`

Data type: `Hash`

RabbitMQ Environment Variables in rabbitmq_env.config

Default value: { 'LC_ALL' => 'en_US.UTF-8' }

##### `erlang_cookie`

Data type: `Optional[String]`

The erlang cookie to use for clustering - must be the same between all nodes. This value has no default and must be
set explicitly if using clustering. If you run Pacemaker and you don't want to use RabbitMQ buildin cluster, you can set config_cluster
to 'False' and set 'erlang_cookie'.

Default value: `undef`

##### `file_limit`

Data type: `Variant[Integer[-1],Enum['unlimited'],Pattern[/^(infinity|\d+(:(infinity|\d+))?)$/]]`

Set rabbitmq file ulimit. Defaults to 16384. Only available on systems with `$::osfamily == 'Debian'` or `$::osfamily == 'RedHat'`.

Default value: 16384

##### `heartbeat`

Data type: `Optional[Integer]`

Set the heartbeat timeout interval, default is unset which uses the builtin server defaults of 60 seconds. Setting this

Default value: `undef`

##### `inetrc_config`

Data type: `String`

Template to use for the inetrc config

Default value: 'rabbitmq/inetrc.erb'

##### `inetrc_config_path`

Data type: `Stdlib::Absolutepath`

Path of the file to push the inetrc config to.

Default value: '/etc/rabbitmq/inetrc'

##### `ipv6`

Data type: `Boolean`

Whether to listen on ipv6

Default value: `false`

##### `interface`

Data type: `Optional[String]`

Interface to bind to (sets tcp_listeners parameter). By default, bind to all interfaces
to `0` will disable heartbeats.

Default value: `undef`

##### `key_content`

Data type: `Optional[String]`

Uses content method for Debian OS family. Should be a template for apt::source class. Overrides `package_gpg_key`
behavior, if enabled. Undefined by default.

Default value: `undef`

##### `ldap_auth`

Data type: `Boolean`

Set to true to enable LDAP auth.

Default value: `false`

##### `ldap_server`

Data type: `Variant[String[1],Array[String[1]]]`

LDAP server or servers to use for auth.

Default value: 'ldap'

##### `ldap_user_dn_pattern`

Data type: `Optional[String]`

User DN pattern for LDAP auth.

Default value: `undef`

##### `ldap_other_bind`

Data type: `String`

How to bind to the LDAP server. Defaults to 'anon'.

Default value: 'anon'

##### `ldap_config_variables`

Data type: `Hash`

Hash of other LDAP config variables.

Default value: {}

##### `ldap_use_ssl`

Data type: `Boolean`

Set to true to use SSL for the LDAP server.

Default value: `false`

##### `ldap_port`

Data type: `Integer[1, 65535]`

Numeric port for LDAP server.

Default value: 389

##### `ldap_log`

Data type: `Boolean`

Set to true to log LDAP auth.

Default value: `false`

##### `manage_python`

Data type: `Boolean`

If enabled, on platforms that don't provide a Python 2 package by default, ensure that the python package is
installed (for rabbitmqadmin). This will only apply if `admin_enable` and `service_manage` are set.

Default value: `true`

##### `management_hostname`

Data type: `Optional[String]`

The hostname for the RabbitMQ management interface.

Default value: `undef`

##### `management_port`

Data type: `Integer[1, 65535]`

The port for the RabbitMQ management interface.

Default value: 15672

##### `management_ip_address`

Data type: `Optional[String]`

Allows you to set the IP for management interface to bind to separately. Set to 127.0.0.1 to bind to
localhost only, or 0.0.0.0 to bind to all interfaces.

Default value: `undef`

##### `management_ssl`

Data type: `Boolean`

Enable/Disable SSL for the management port. Has an effect only if ssl => true.

Default value: `true`

##### `node_ip_address`

Data type: `Optional[String]`

Allows you to set the IP for RabbitMQ service to bind to. Set to 127.0.0.1 to bind to localhost only, or 0.0.0.0
to bind to all interfaces.

Default value: `undef`

##### `package_apt_pin`

Data type: `Optional[Variant[Numeric, String]]`

Whether to pin the package to a particular source

Default value: `undef`

##### `package_ensure`

Data type: `String`

Determines the ensure state of the package.  Set to installed by default, but could be changed to latest.

Default value: 'installed'

##### `package_gpg_key`

Data type: `Optional[String]`

RPM package GPG key to import. Uses source method. Should be a URL for Debian/RedHat OS family, or a file name for
RedHat OS family. Set to https://www.rabbitmq.com/rabbitmq-release-signing-key.asc for RedHat OS Family and
https://packagecloud.io/rabbitmq/rabbitmq-server/gpgkey for Debian OS Family by default. Note, that `key_content`, if specified, would
override this parameter for Debian OS family.

Default value: `undef`

##### `package_name`

Data type: `Variant[String, Array]`

Name(s) of the package(s) to install

Default value: 'rabbitmq'

##### `port`

Data type: `Integer`

The RabbitMQ port.

Default value: 5672

##### `python_package`

Data type: `String`

Name of the package required by rabbitmqadmin.

Default value: 'python'

##### `repos_ensure`

Data type: `Boolean`

Ensure that a repo with the official (and newer) RabbitMQ package is configured, along with its signing key.
Defaults to false (use system packages). This does not ensure that soft dependencies (like EPEL on RHEL systems) are present.
It also does not solve the erlang dependency.  See https://www.rabbitmq.com/which-erlang.html for a good breakdown of the
different ways of handling the erlang deps.  See also https://github.com/voxpupuli/puppet-rabbitmq/issues/788

Default value: `false`

##### `service_ensure`

Data type: `Enum['running', 'stopped']`

The state of the service.

Default value: 'running'

##### `service_manage`

Data type: `Boolean`

Determines if the service is managed.

Default value: `true`

##### `service_name`

Data type: `String`

The name of the service to manage.

Default value: 'rabbitmq'

##### `service_restart`

Data type: `Boolean`

Default defined in param.pp. Whether to restart the service on config change.

Default value: `true`

##### `ssl`

Data type: `Boolean`

Configures the service for using SSL.

Default value: `false`

##### `ssl_cacert`

Data type: `Optional[Stdlib::Absolutepath]`

CA cert path to use for SSL.

Default value: `undef`

##### `ssl_cert`

Data type: `Optional[Stdlib::Absolutepath]`

Cert to use for SSL.

Default value: `undef`

##### `ssl_cert_password`

Data type: `Optional[String]`

Password used when generating CSR.

Default value: `undef`

##### `ssl_depth`

Data type: `Optional[Integer]`

SSL verification depth.

Default value: `undef`

##### `ssl_dhfile`

Data type: `Optional[Stdlib::Absolutepath]`

Use this dhparam file [example: generate with `openssl dhparam -out /etc/rabbitmq/ssl/dhparam.pem 2048`

Default value: `undef`

##### `ssl_erl_dist`

Data type: `Boolean`

Whether to use the erlang package's SSL (relies on the ssl_erl_path fact)

Default value: `false`

##### `ssl_honor_cipher_order`

Data type: `Boolean`

Force use of server cipher order

Default value: `true`

##### `ssl_interface`

Data type: `Optional[String]`

Interface for SSL listener to bind to

Default value: `undef`

##### `ssl_key`

Data type: `Optional[Stdlib::Absolutepath]`

Key to use for SSL.

Default value: `undef`

##### `ssl_only`

Data type: `Boolean`

Configures the service to only use SSL. No cleartext TCP listeners will be created. Requires that ssl => true and
port => undef

Default value: `false`

##### `ssl_management_port`

Data type: `Integer[1, 65535]`

SSL management port.

Default value: 15671

##### `ssl_management_cacert`

Data type: `Optional[Stdlib::Absolutepath]`

SSL management cacert. If unset set to ssl_cacert for backwards compatibility.

Default value: $ssl_cacert

##### `ssl_management_cert`

Data type: `Optional[Stdlib::Absolutepath]`

SSL management cert. If unset set to ssl_cert for backwards compatibility.

Default value: $ssl_cert

##### `ssl_management_key`

Data type: `Optional[Stdlib::Absolutepath]`

SSL management key. If unset set to ssl_key for backwards compatibility.

Default value: $ssl_key

##### `ssl_port`

Data type: `Integer[1, 65535]`

SSL port for RabbitMQ

Default value: 5671

##### `ssl_reuse_sessions`

Data type: `Boolean`

Reuse ssl sessions

Default value: `true`

##### `ssl_secure_renegotiate`

Data type: `Boolean`

Use ssl secure renegotiate

Default value: `true`

##### `ssl_stomp_port`

Data type: `Integer[1, 65535]`

SSL stomp port.

Default value: 6164

##### `ssl_verify`

Data type: `Enum['verify_none','verify_peer']`

rabbitmq.config SSL verify setting.

Default value: 'verify_none'

##### `ssl_fail_if_no_peer_cert`

Data type: `Boolean`

rabbitmq.config `fail_if_no_peer_cert` setting.

Default value: `false`

##### `ssl_management_verify`

Data type: `Enum['verify_none','verify_peer']`

rabbitmq.config SSL verify setting for rabbitmq_management.

Default value: 'verify_none'

##### `ssl_versions`

Data type: `Optional[Array]`

Choose which SSL versions to enable. Example: `['tlsv1.2', 'tlsv1.1']` Note
that it is recommended to disable `sslv3 and `tlsv1` to prevent against
POODLE and BEAST attacks. Please see the
[RabbitMQ SSL](https://www.rabbitmq.com/ssl.html) documentation for more information.

Default value: `undef`

##### `ssl_ciphers`

Data type: `Array`

Support only a given list of SSL ciphers, using either the Erlang or OpenSSL styles.
Supported ciphers in your install can be listed with: `rabbitmqctl eval 'ssl:cipher_suites().'`
Functionality can be tested with cipherscan or similar tool: https://github.com/mozilla/cipherscan
* Erlang style: `['ecdhe_rsa,aes_256_cbc,sha', 'dhe_rsa,aes_256_cbc,sha']`
* OpenSSL style: `['ECDHE-RSA-AES256-SHA', 'DHE-RSA-AES256-SHA']`

Default value: []

##### `stomp_port`

Data type: `Integer[1, 65535]`

The port to use for Stomp.

Default value: 6163

##### `stomp_ssl_only`

Data type: `Boolean`

Configures STOMP to only use SSL. No cleartext STOMP TCP listeners will be created. Requires setting ssl_stomp_port also.

Default value: `false`

##### `stomp_ensure`

Data type: `Boolean`

Enable to install the stomp plugin.

Default value: `false`

##### `tcp_backlog`

Data type: `Integer`

The size of the backlog on TCP connections.

Default value: 128

##### `tcp_keepalive`

Data type: `Boolean`

Enable TCP connection keepalive for RabbitMQ service.

Default value: `false`

##### `tcp_recbuf`

Data type: `Optional[Integer]`

Corresponds to recbuf in RabbitMQ `tcp_listen_options`

Default value: `undef`

##### `tcp_sndbuf`

Data type: `Optional[Integer]`

Integer, corresponds to sndbuf in RabbitMQ `tcp_listen_options`

Default value: `undef`

##### `wipe_db_on_cookie_change`

Data type: `Boolean`

Boolean to determine if we should DESTROY AND DELETE the RabbitMQ database.

Default value: `false`

##### `rabbitmq_user`

Data type: `String`

OS dependent The system user the rabbitmq daemon runs as.

Default value: 'rabbitmq'

##### `rabbitmq_group`

Data type: `String`

OS dependent The system group the rabbitmq daemon runs as.

Default value: 'rabbitmq'

##### `rabbitmq_home`

Data type: `Stdlib::Absolutepath`

OS dependent The home directory of the rabbitmq deamon.

Default value: '/var/lib/rabbitmq'

##### `rabbitmqadmin_package`

Data type: `Optional[String]`

OS dependent If undef: install rabbitmqadmin via archive, otherwise via package

Default value: `undef`

##### `archive_options`

Data type: `Array`

Extra options to Archive resource to download rabbitmqadmin file

Default value: []

##### `loopback_users`

Data type: `Array`

This option configures a list of users to allow access via the loopback interfaces

Default value: ['guest']

##### `package_source`

Data type: `Optional[String]`



Default value: `undef`

##### `package_provider`

Data type: `Optional[String]`



Default value: `undef`

##### `ssl_management_fail_if_no_peer_cert`

Data type: `Boolean`



Default value: `false`

## Resource types

### rabbitmq_binding

Native type for managing rabbitmq bindings

rabbitmq_binding { 'binding 1':
  ensure           => present,
  source           => 'myexchange',
  destination      => 'myqueue',
  vhost            => 'myvhost',
  user             => 'dan',
  password         => 'bar',
  destination_type => 'queue',
  routing_key      => 'key1',
  arguments        => {},
}

rabbitmq_binding { 'binding 2':
  ensure           => present,
  source           => 'myexchange',
  destination      => 'myqueue',
  vhost            => 'myvhost',
  user             => 'dan',
  password         => 'bar',
  destination_type => 'queue',
  routing_key      => 'key2',
  arguments        => {},
}

#### Examples

##### Create a rabbitmq_binding

```puppet
rabbitmq_binding { 'myexchange@myqueue@myvhost':
  user             => 'dan',
  password         => 'bar',
  destination_type => 'queue',
  routing_key      => '#',
  arguments        => {},
  ensure           => present,
}
```

##### Create bindings with same source / destination / vhost but different routing key using individual parameters

```puppet

```

#### Properties

The following properties are available in the `rabbitmq_binding` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `source`

Valid values: %r{^\S+$}

namevar

source of binding

##### `destination`

Valid values: %r{^\S+$}

namevar

destination of binding

##### `vhost`

Valid values: %r{^\S+$}

namevar

vhost

Default value: /

##### `routing_key`

Valid values: %r{^\S*$}

namevar

binding routing_key

##### `destination_type`

Valid values: %r{queue|exchange}

binding destination_type

Default value: queue

##### `arguments`

binding arguments

#### Parameters

The following parameters are available in the `rabbitmq_binding` type.

##### `name`

namevar

resource name, either source@destination@vhost or arbitrary name with params

##### `user`

Valid values: %r{^\S+$}

The user to use to connect to rabbitmq

Default value: guest

##### `password`

Valid values: %r{\S+}

The password to use to connect to rabbitmq

Default value: guest

### rabbitmq_erlang_cookie

Type to manage the rabbitmq erlang cookie securely

This is essentially a private type used by the rabbitmq::config class
to manage the erlang cookie. It replaces the rabbitmq_erlang_cookie fact
from earlier versions of this module. It manages the content of the cookie
usually located at "${rabbitmq_home}/.erlang.cookie", which includes
stopping the rabbitmq service and wiping out the database at
"${rabbitmq_home}/mnesia" if the user agrees to it. We don't recommend using
this type directly.

#### Properties

The following properties are available in the `rabbitmq_erlang_cookie` type.

##### `content`

Valid values: %r{^\S+$}

Content of cookie

#### Parameters

The following parameters are available in the `rabbitmq_erlang_cookie` type.

##### `path`



##### `force`

Valid values: `true`, `false`



Default value: `false`

##### `rabbitmq_user`



Default value: rabbitmq

##### `rabbitmq_group`



Default value: rabbitmq

##### `rabbitmq_home`



Default value: /var/lib/rabbitmq

##### `service_name`

Valid values: %r{^\S+$}



### rabbitmq_exchange

Native type for managing rabbitmq exchanges

#### Examples

##### Create a rabbitmq_exchange

```puppet
rabbitmq_exchange { 'myexchange@myvhost':
  user        => 'dan',
  password    => 'bar',
  type        => 'topic',
  ensure      => present,
  internal    => false,
  auto_delete => false,
  durable     => true,
  arguments   => {
    hash-header => 'message-distribution-hash'
  }
}
```

#### Properties

The following properties are available in the `rabbitmq_exchange` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

#### Parameters

The following parameters are available in the `rabbitmq_exchange` type.

##### `name`

Valid values: %r{^\S*@\S+$}

namevar

Name of exchange

##### `type`

Valid values: %r{^\S+$}

Exchange type to be set *on creation*

##### `durable`

Valid values: %r{^\S+$}

Exchange durability to be set *on creation*

Default value: `false`

##### `auto_delete`

Valid values: %r{^\S+$}

Exchange auto delete option to be set *on creation*

Default value: `false`

##### `internal`

Valid values: %r{^\S+$}

Exchange internal option to be set *on creation*

Default value: `false`

##### `arguments`

Exchange arguments example: {"hash-header": "message-distribution-hash"}

##### `user`

Valid values: %r{^\S+$}

The user to use to connect to rabbitmq

Default value: guest

##### `password`

Valid values: %r{\S+}

The password to use to connect to rabbitmq

Default value: guest

### rabbitmq_parameter

Type for managing rabbitmq parameters

#### Examples

##### Create some rabbitmq_parameter resources

```puppet
rabbitmq_parameter { 'documentumShovel@/':
  component_name => '',
  value          => {
      'src-uri'    => 'amqp://',
      'src-queue'  => 'my-queue',
      'dest-uri'   => 'amqp://remote-server',
      'dest-queue' => 'another-queue',
  },
}
rabbitmq_parameter { 'documentumFed@/':
  component_name => 'federation-upstream',
  value          => {
      'uri'     => 'amqp://myserver',
      'expires' => '360000',
  },
}
```

#### Properties

The following properties are available in the `rabbitmq_parameter` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `component_name`

The component_name to use when setting parameter, eg: shovel or federation

##### `value`

A hash of values to use with the component name you are setting

#### Parameters

The following parameters are available in the `rabbitmq_parameter` type.

##### `name`

Valid values: %r{^\S+@\S+$}

namevar

combination of name@vhost to set parameter for

### rabbitmq_plugin

manages rabbitmq plugins

#### Examples

##### query all currently enabled plugins

```puppet
$ puppet resource rabbitmq_plugin
```

##### Ensure a rabbitmq_plugin resource

```puppet
rabbitmq_plugin {'rabbitmq_stomp':
  ensure => present,
}
```

##### Ensure a rabbitmq_plugin offline resource (with RabbitMQ version >=3.4.0)

```puppet
rabbitmq_plugin {'rabbitmq_stomp':
  ensure => present,
  mode   => 'offline',
}
```

#### Properties

The following properties are available in the `rabbitmq_plugin` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

#### Parameters

The following parameters are available in the `rabbitmq_plugin` type.

##### `name`

Valid values: %r{^\S+$}

namevar

The name of the plugin to enable

##### `mode`

Valid values: online, offline, best

Define how the plugin should be enabled regarding node status.

Default value: best

##### `umask`

Sets the octal umask to be used while creating this resource

Default value: 0022

### rabbitmq_policy

Type for managing rabbitmq policies

#### Examples

##### Create a rabbitmq_policy

```puppet
rabbitmq_policy { 'ha-all@myvhost':
  pattern    => '.*',
  priority   => 0,
  applyto    => 'all',
  definition => {
    'ha-mode'      => 'all',
    'ha-sync-mode' => 'automatic',
  },
}
```

#### Properties

The following properties are available in the `rabbitmq_policy` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `pattern`

policy pattern

##### `applyto`

Valid values: all, exchanges, queues

policy apply to

Default value: all

##### `definition`

policy definition

##### `priority`

Valid values: %r{^\d+$}

policy priority

Default value: 0

#### Parameters

The following parameters are available in the `rabbitmq_policy` type.

##### `name`

Valid values: %r{^\S+@\S+$}

namevar

combination of policy@vhost to create policy for

### rabbitmq_queue

Native type for managing rabbitmq queue

#### Examples

##### Create a rabbitmq_queue

```puppet
rabbitmq_queue { 'myqueue@myvhost':
  ensure      => present,
  user        => 'dan',
  password    => 'bar',
  durable     => true,
  auto_delete => false,
  arguments   => {
    x-message-ttl          => 123,
    x-dead-letter-exchange => 'other'
  },
}
```

#### Properties

The following properties are available in the `rabbitmq_queue` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

#### Parameters

The following parameters are available in the `rabbitmq_queue` type.

##### `name`

Valid values: %r{^\S*@\S+$}

namevar

Name of queue

##### `durable`

Valid values: %r{true|false}

Queue is durable

Default value: `true`

##### `auto_delete`

Valid values: %r{true|false}

Queue will be auto deleted

Default value: `false`

##### `arguments`

Queue arguments example: {x-message-ttl => 60, x-expires => 10}

##### `user`

Valid values: %r{^\S+$}

The user to use to connect to rabbitmq

Default value: guest

##### `password`

Valid values: %r{\S+}

The password to use to connect to rabbitmq

Default value: guest

### rabbitmq_user

Native type for managing rabbitmq users

#### Examples

##### query all current users

```puppet
$ puppet resource rabbitmq_user
```

##### Configure a user, dan

```puppet
rabbitmq_user { 'dan':
  admin    => true,
  password => 'bar',
}
```

##### Optional parameter tags will set further rabbitmq tags like monitoring, policymaker, etc.

```puppet
To set the administrator tag use admin-flag.
rabbitmq_user { 'dan':
  admin    => true,
  password => 'bar',
  tags     => ['monitoring', 'tag1'],
}
```

#### Properties

The following properties are available in the `rabbitmq_user` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `password`

User password to be set *on creation* and validated each run

##### `admin`

Valid values: %r{true|false}

whether or not user should be an admin

Default value: false

##### `tags`

additional tags for the user

Default value: []

#### Parameters

The following parameters are available in the `rabbitmq_user` type.

##### `name`

Valid values: %r{^\S+$}

namevar

Name of user

### rabbitmq_user_permissions

Type for managing rabbitmq user permissions

#### Examples

##### Define some rabbitmq_user_permissions

```puppet
rabbitmq_user_permissions { 'dan@myvhost':
  configure_permission => '.*',
  read_permission      => '.*',
  write_permission     => '.*',
}
```

#### Properties

The following properties are available in the `rabbitmq_user_permissions` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `configure_permission`

regexp representing configuration permissions

##### `read_permission`

regexp representing read permissions

##### `write_permission`

regexp representing write permissions

#### Parameters

The following parameters are available in the `rabbitmq_user_permissions` type.

##### `name`

Valid values: %r{^\S+@\S+$}

namevar

combination of user@vhost to grant privileges to

### rabbitmq_vhost

Native type for managing rabbitmq vhosts

#### Examples

##### query all current vhosts

```puppet
$ puppet resource rabbitmq_vhost`
```

##### Create a rabbitmq_vhost

```puppet
rabbitmq_vhost { 'myvhost':
  ensure => present,
}
```

#### Properties

The following properties are available in the `rabbitmq_vhost` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

#### Parameters

The following parameters are available in the `rabbitmq_vhost` type.

##### `name`

Valid values: %r{^\S+$}

namevar

The name of the vhost to add

