# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`monit`](#monit): Main class, includes all other classes.

#### Private Classes

* `monit::config`: This class handles the configuration file.
* `monit::firewall`: This class handles the firewall configuration.
* `monit::install`: This class handles monit packages.
* `monit::params`: This is a container class with default parameters for monit classes.
* `monit::service`: This class handles the monit service.

### Defined types

* [`monit::check`](#monitcheck): Adds a Monit check.

## Classes

### `monit`

Main class, includes all other classes.

#### Examples

##### 

```puppet
class { 'monit': }
```

#### Parameters

The following parameters are available in the `monit` class.

##### `alert_emails`

Data type: `Array[String]`

Specifies one or more email addresses to send global alerts to. Default value: []

Default value: `$monit::params::alert_emails`

##### `check_interval`

Data type: `Integer[0]`

Specifies the interval between two checks of Monit. Default value: 120

Default value: `$monit::params::check_interval`

##### `config_file`

Data type: `String`

Specifies a path to the main config file. Default value: varies with operating system

Default value: `$monit::params::config_file`

##### `config_dir`

Data type: `String`

Specifies a path to the config directory. Default value: varies with operating system

Default value: `$monit::params::config_dir`

##### `config_dir_purge`

Data type: `Variant[Boolean, Enum['true', 'false']]`

Specifies if unmanaged files in the config directory should be purged. Default value: 'false'

Default value: `$monit::params::config_dir_purge`

##### `httpd`

Data type: `Variant[Boolean, Enum['true', 'false']]`

Specifies whether to enable the Monit Dashboard. Default value: 'false'

Default value: `$monit::params::httpd`

##### `httpd_port`

Data type: `Integer[0, 65535]`

Specifies the port of the Monit Dashboard. Default value: 2812

Default value: `$monit::params::httpd_port`

##### `httpd_address`

Data type: `String`

Specifies the IP address of the Monit Dashboard. Default value: 'locahost'

Default value: `$monit::params::httpd_address`

##### `httpd_allow`

Data type: `String`

Specifies the allow option of the Monit Dashboard. Default value: '0.0.0.0/0.0.0.0'

Default value: `$monit::params::httpd_allow`

##### `httpd_user`

Data type: `String`

Specifies the user to access the Monit Dashboard. Default value: 'admin'

Default value: `$monit::params::httpd_user`

##### `httpd_password`

Data type: `String`

Specifies the password to access the Monit Dashboard. Default value: 'monit'

Default value: `$monit::params::httpd_password`

##### `logfile`

Data type: `String`

Specifies the logfile directive value. Default value: '/var/log/monit.log'
It is possible to use syslog instead of direct file logging. (e.g. 'syslog facility log\_daemon')

Default value: `$monit::params::logfile`

##### `mailserver`

Data type: `Optional[String]`

If set to a string, alerts will be sent by email to this mailserver. Default value: undef
For more details, see: https://mmonit.com/monit/documentation/monit.html#Setting-a-mail-server-for-alert-delivery

Default value: `$monit::params::mailserver`

##### `mailformat`

Data type: `Optional[Hash]`

Specifies the alert message format. Default value: undef
For more details, see: https://mmonit.com/monit/documentation/monit.html#Message-format

Default value: `$monit::params::mailformat`

##### `manage_firewall`

Data type: `Variant[Boolean, Enum['true', 'false']]`

If true and if puppetlabs-firewall module is present, Puppet manages firewall to allow HTTP access for Monit Dashboard. Default value: 'false'

Default value: `$monit::params::manage_firewall`

##### `mmonit_address`

Data type: `Optional[String]`

*Requires at least Monit 5.0*<br />
Specifies the remote address of an M/Monit server to be used by Monit agent for report. If set to undef, M/Monit connection is disabled. Default value: undef

Default value: `$monit::params::mmonit_address`

##### `mmonit_https`

Data type: `Variant[Boolean, Enum['true', 'false']]`

*Requires at least Monit 5.0*<br />
Specifies wheither the protocol of the M/Monit server is HTTPs. Default value: 'true'

Default value: `$monit::params::mmonit_https`

##### `mmonit_port`

Data type: `Integer[0, 65535]`

*Requires at least Monit 5.0*<br />
Specifies the remote port of the M/Monit server. Default value: 8443

Default value: `$monit::params::mmonit_port`

##### `mmonit_user`

Data type: `String`

*Requires at least Monit 5.0*<br />
Specifies the user to connect to the remote M/Monit server. Default value: 'monit'
If you set both user and password to an empty string, authentication is disabled.

Default value: `$monit::params::mmonit_user`

##### `mmonit_password`

Data type: `String`

*Requires at least Monit 5.0*<br />
Specifies the password of the account used to connect to the remote M/Monit server. Default value: 'monit'
If you set both user and password to an empty string, authentication is disabled.

Default value: `$monit::params::mmonit_password`

##### `mmonit_without_credential`

Data type: `Variant[Boolean, Enum['true', 'false']]`

*Requires at least Monit 5.0*<br />
By default Monit registers credentials with M/Monit so M/Monit can smoothly communicate back to Monit and you don't have to register Monit credentials manually in M/Monit. It is possible to disable credential registration setting this option to 'true'. Default value: 'false'

Default value: `$monit::params::mmonit_without_credential`

##### `package_ensure`

Data type: `String`

Tells Puppet whether the Monit package should be installed, and what version. Valid options: 'present', 'latest', or a specific version number. Default value: 'present'

Default value: `$monit::params::package_ensure`

##### `package_name`

Data type: `String`

Tells Puppet what Monit package to manage. Default value: 'monit'

Default value: `$monit::params::package_name`

##### `service_ensure`

Data type: `Enum['running', 'stopped']`

Tells Puppet whether the Monit service should be running. Default value: 'running'

Default value: `$monit::params::service_ensure`

##### `service_manage`

Data type: `Variant[Boolean, Enum['true', 'false']]`

Tells Puppet whether to manage the Monit service. Default value: 'true'

Default value: `$monit::params::service_manage`

##### `service_name`

Data type: `String`

Tells Puppet what Monit service to manage. Default value: 'monit'

Default value: `$monit::params::service_name`

##### `start_delay`

Data type: `Integer[0]`

*Requires at least Monit 5.0*
If set, Monit will wait the specified time in seconds before it starts checking services. Default value: 0

Default value: `$monit::params::start_delay`

##### `service_enable`

Data type: `Variant[Boolean, Enum['true', 'false']]`



Default value: `$monit::params::service_enable`

## Defined types

### `monit::check`

Adds a Monit check.

#### Parameters

The following parameters are available in the `monit::check` defined type.

##### `content`

Data type: `Optional[String]`

Specifies the content of the configuration file. The `content` and `source` parameters are exclusive of each other.

Default value: ``undef``

##### `ensure`

Data type: `Enum['present', 'absent']`

Tells Puppet whether the check should exist.

Default value: `present`

##### `source`

Data type: `Optional[String]`

Tells Puppet what is the path of the configuration file. The `content` and `source` parameters are exclusive of each other.

Default value: ``undef``

