# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

* [`stdlib`](#stdlib): This module manages stdlib.
* [`stdlib::stages`](#stdlibstages): This class manages a standard set of run stages for Puppet. It is managed by
the stdlib class, and should not be declared independently.

**Resource types**

* [`anchor`](#anchor): A simple resource type intended to be used as an anchor in a composite class.
* [`file_line`](#file_line): Ensures that a given line is contained within a file.

**Functions**

* [`abs`](#abs): **Deprecated:** Returns the absolute value of a number
* [`any2array`](#any2array): This converts any object to an array containing that object.
* [`any2bool`](#any2bool): Converts 'anything' to a boolean.
* [`assert_private`](#assert_private): Sets the current class or definition as private.
* [`base64`](#base64): Base64 encode or decode a string based on the command and the string submitted
* [`basename`](#basename): Strips directory (and optional suffix) from a filename
* [`bool2num`](#bool2num): Converts a boolean to a number.
* [`bool2str`](#bool2str): Converts a boolean to a string using optionally supplied arguments.
* [`camelcase`](#camelcase): **Deprecated** Converts the case of a string or all strings in an array to camel case.
* [`capitalize`](#capitalize): **Deprecated** Capitalizes the first letter of a string or array of strings.
* [`ceiling`](#ceiling): **Deprecated** Returns the smallest integer greater or equal to the argument.
* [`chomp`](#chomp): **Deprecated** Removes the record separator from the end of a string or an array of strings.
* [`chop`](#chop): **Deprecated** Returns a new string with the last character removed.
* [`clamp`](#clamp): Keeps value within the range [Min, X, Max] by sort based on integer value
(parameter order doesn't matter).
* [`concat`](#concat): Appends the contents of multiple arrays into array 1.
* [`convert_base`](#convert_base): Converts a given integer or base 10 string representing an integer to a
specified base, as a string.
* [`count`](#count): Counts the number of elements in array.
* [`deep_merge`](#deep_merge): Recursively merges two or more hashes together and returns the resulting hash.
* [`defined_with_params`](#defined_with_params): Takes a resource reference and an optional hash of attributes.
* [`delete`](#delete): Deletes all instances of a given element from an array, substring from a
string, or key from a hash.
* [`delete_at`](#delete_at): Deletes a determined indexed value from an array.
* [`delete_regex`](#delete_regex): Deletes all instances of a given element that match a regular expression
from an array or key from a hash.
* [`delete_undef_values`](#delete_undef_values): Returns a copy of input hash or array with all undefs deleted.
* [`delete_values`](#delete_values): Deletes all instances of a given value from a hash.
* [`deprecation`](#deprecation): Function to print deprecation warnings (this is the 3.X version of it).
* [`deprecation`](#deprecation): Function to print deprecation warnings, Logs a warning once for a given key.  The uniqueness key - can appear once. The msg is the message te
* [`difference`](#difference): This function returns the difference between two arrays.
* [`dig`](#dig): **DEPRECATED** Retrieves a value within multiple layers of hashes and arrays via an
array of keys containing a path.
* [`dig44`](#dig44): **DEPRECATED**: Looks up into a complex structure of arrays and hashes and returns a value
or the default value if nothing was found.
* [`dirname`](#dirname): Returns the dirname of a path.
* [`dos2unix`](#dos2unix): Returns the Unix version of the given string.
* [`downcase`](#downcase): **Deprecated:** Converts the case of a string or all strings in an array to lower case.
* [`empty`](#empty): **Deprecated:** Returns true if the variable is empty.
* [`enclose_ipv6`](#enclose_ipv6): Takes an array of ip addresses and encloses the ipv6 addresses with square brackets.
* [`ensure_packages`](#ensure_packages): Takes a list of packages and only installs them if they don't already exist.
* [`ensure_resource`](#ensure_resource): Takes a resource type, title, and a list of attributes that describe a
resource.
* [`ensure_resources`](#ensure_resources): Takes a resource type, title (only hash), and a list of attributes that describe a
resource.
* [`fact`](#fact): Digs into the facts hash using dot-notation
* [`flatten`](#flatten): This function flattens any deeply nested arrays and returns a single flat array
as a result.
* [`floor`](#floor): Returns the largest integer less or equal to the argument.
* [`fqdn_rand_string`](#fqdn_rand_string): Generates a random alphanumeric string. Combining the `$fqdn` fact and an
optional seed for repeatable randomness.
* [`fqdn_rotate`](#fqdn_rotate): Rotates an array or string a random number of times, combining the `$fqdn` fact
and an optional seed for repeatable randomness.
* [`fqdn_uuid`](#fqdn_uuid): Returns a [RFC 4122](https://tools.ietf.org/html/rfc4122) valid version 5 UUID based
on an FQDN string under the DNS namespace
* [`get_module_path`](#get_module_path): Returns the absolute path of the specified module for the current
environment.
* [`getparam`](#getparam): Returns the value of a resource's parameter.
* [`getvar`](#getvar): Lookup a variable in a given namespace.
* [`glob`](#glob): Uses same patterns as Dir#glob.
* [`grep`](#grep): This function searches through an array and returns any elements that match
the provided regular expression.
* [`has_interface_with`](#has_interface_with): Returns boolean based on kind and value.
* [`has_ip_address`](#has_ip_address): Returns true if the client has the requested IP address on some interface.
* [`has_ip_network`](#has_ip_network): Returns true if the client has an IP address within the requested network.
* [`has_key`](#has_key): **Deprecated:** Determine if a hash has a certain key value.
* [`hash`](#hash): **Deprecated:** This function converts an array into a hash.
* [`intersection`](#intersection): This function returns an array of the intersection of two.
* [`is_a`](#is_a): Boolean check to determine whether a variable is of a given data type.
This is equivalent to the `=~` type checks.
* [`is_absolute_path`](#is_absolute_path): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_absolute_path`](#is_absolute_path): **Deprecated:** Returns boolean true if the string represents an absolute path in the filesystem.
* [`is_array`](#is_array): **Deprecated:** Returns true if the variable passed to this function is an array.
* [`is_array`](#is_array): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_bool`](#is_bool): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_bool`](#is_bool): **Deprecated:** Returns true if the variable passed to this function is a boolean.
* [`is_domain_name`](#is_domain_name): **Deprecated:** Returns true if the string passed to this function is
a syntactically correct domain name.
* [`is_email_address`](#is_email_address): **Deprecated:** Returns true if the string passed to this function is a valid email address.
* [`is_float`](#is_float): **Deprecated:** Returns true if the variable passed to this function is a float.
* [`is_float`](#is_float): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_function_available`](#is_function_available): **Deprecated:** Determines whether the Puppet runtime has access to a function by that name.
* [`is_hash`](#is_hash): **Deprecated:** Returns true if the variable passed to this function is a hash.
* [`is_integer`](#is_integer): **Deprecated:** Returns true if the variable passed to this function is an Integer or
a decimal (base 10) integer in String form.
* [`is_ip_address`](#is_ip_address): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_ip_address`](#is_ip_address): **Deprecated:** Returns true if the string passed to this function is a valid IP address.
* [`is_ipv4_address`](#is_ipv4_address): **Deprecated:** Returns true if the string passed to this function is a valid IPv4 address.
* [`is_ipv4_address`](#is_ipv4_address): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_ipv6_address`](#is_ipv6_address): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_ipv6_address`](#is_ipv6_address): **Deprecated:** Returns true if the string passed to this function is a valid IPv6 address.
* [`is_mac_address`](#is_mac_address): **Deprecated:** Returns true if the string passed to this function is a valid mac address.
* [`is_numeric`](#is_numeric): **Deprecated:** Returns true if the given value is numeric.
* [`is_numeric`](#is_numeric): Wrapper that calls the Puppet 3.x function of the same name.
* [`is_string`](#is_string): **Deprecated:** Returns true if the variable passed to this function is a string.
* [`is_string`](#is_string): Wrapper that calls the Puppet 3.x function of the same name.
* [`join`](#join): **Deprecated:** This function joins an array into a string using a separator.
* [`join_keys_to_values`](#join_keys_to_values): This function joins each key of a hash to that key's corresponding value with a
separator.
* [`keys`](#keys): **Deprecated:** Returns the keys of a hash as an array.
* [`length`](#length): **Deprecated:** A function to eventually replace the old size() function for stdlib
* [`load_module_metadata`](#load_module_metadata): This function loads the metadata of a given module.
* [`loadjson`](#loadjson): Load a JSON file containing an array, string, or hash, and return the data
in the corresponding native data type.
* [`loadyaml`](#loadyaml): Load a YAML file containing an array, string, or hash, and return the data
in the corresponding native data type.
* [`lstrip`](#lstrip): **Deprecated:** Strips leading spaces to the left of a string.
* [`max`](#max): **Deprecated:** Returns the highest value of all arguments.
* [`member`](#member): This function determines if a variable is a member of an array.
* [`merge`](#merge): Merges two or more hashes together and returns the resulting hash.
* [`merge`](#merge): Merges two or more hashes together or hashes resulting from iteration, and returns
the resulting hash.
* [`min`](#min): **Deprecated:** Returns the lowest value of all arguments.
* [`num2bool`](#num2bool): This function converts a number or a string representation of a number into a
true boolean.
* [`os_version_gte`](#os_version_gte): Checks if the OS version is at least a certain version.
* [`parsejson`](#parsejson): This function accepts JSON as a string and converts it into the correct
Puppet structure.
* [`parseyaml`](#parseyaml): This function accepts YAML as a string and converts it into the correct
Puppet structure.
* [`pick`](#pick): This function is similar to a coalesce function in SQL in that it will return
the first value in a list of values that is not undefined or an empty string.
* [`pick_default`](#pick_default): This function will return the first value in a list of values that is not undefined or an empty string.
* [`prefix`](#prefix): This function applies a prefix to all elements in an array or a hash.
* [`private`](#private): **Deprecated:** Sets the current class or definition as private.
Calling the class or definition from outside the current module will fail.
* [`pry`](#pry): This function invokes a pry debugging session in the current scope object.
* [`pw_hash`](#pw_hash): Hashes a password using the crypt function. Provides a hash usable
on most POSIX systems.
* [`range`](#range): When given range in the form of (start, stop) it will extrapolate a range as
an array.
* [`regexpescape`](#regexpescape): Regexp escape a string or array of strings.
Requires either a single string or an array as an input.
* [`reject`](#reject): This function searches through an array and rejects all elements that match
the provided regular expression.
* [`reverse`](#reverse): Reverses the order of a string or array.
* [`round`](#round): Rounds a number to the nearest integer
* [`rstrip`](#rstrip): Strips leading spaces to the right of the string.
* [`seeded_rand`](#seeded_rand): Generates a random whole number greater than or equal to 0 and less than MAX, using the value of SEED for repeatable randomness.
* [`seeded_rand_string`](#seeded_rand_string): Generates a consistent random string of specific length based on provided seed.
* [`shell_escape`](#shell_escape): Escapes a string so that it can be safely used in a Bourne shell command line.
* [`shell_join`](#shell_join): Builds a command line string from the given array of strings. Each array item is escaped for Bourne shell. All items are then joined together
* [`shell_split`](#shell_split): Splits a string into an array of tokens in the same way the Bourne shell does.
* [`shuffle`](#shuffle): @summary  Randomizes the order of a string or array elements.
* [`size`](#size): Returns the number of elements in a string, an array or a hash
* [`sort`](#sort): Sorts strings and arrays lexically.
* [`sprintf_hash`](#sprintf_hash): Uses sprintf with named references.
* [`squeeze`](#squeeze): Returns a new string where runs of the same character that occur in this set are replaced by a single character.
* [`stdlib::end_with`](#stdlibend_with): Returns true if str ends with one of the prefixes given. Each of the prefixes should be a String.
* [`stdlib::extname`](#stdlibextname): Returns the Extension (the Portion of Filename in Path starting from the
last Period).
* [`stdlib::ip_in_range`](#stdlibip_in_range): Returns true if the ipaddress is within the given CIDRs
* [`stdlib::start_with`](#stdlibstart_with): Returns true if str starts with one of the prefixes given. Each of the prefixes should be a String.
* [`str2bool`](#str2bool): This converts a string to a boolean.
* [`str2saltedpbkdf2`](#str2saltedpbkdf2): Convert a string into a salted SHA512 PBKDF2 password hash like requred for OS X / macOS 10.8+
* [`str2saltedsha512`](#str2saltedsha512): This converts a string to a salted-SHA512 password hash (which is used for
OS X versions >= 10.7).
* [`strip`](#strip): This function removes leading and trailing whitespace from a string or from
every string inside an array.
* [`suffix`](#suffix): This function applies a suffix to all elements in an array, or to the keys
in a hash.
* [`swapcase`](#swapcase): This function will swap the existing case of a string.
* [`time`](#time): This function will return the current time since epoch as an integer.
* [`to_bytes`](#to_bytes): Converts the argument into bytes, for example 4 kB becomes 4096.
* [`to_json`](#to_json): Convert a data structure and output to JSON
* [`to_json_pretty`](#to_json_pretty): Convert data structure and output to pretty JSON
* [`to_yaml`](#to_yaml): Convert a data structure and output it as YAML
* [`try_get_value`](#try_get_value): **DEPRECATED:** this function is deprecated, please use dig() instead.
* [`type`](#type): **DEPRECATED:** This function will cease to function on Puppet 4;
* [`type3x`](#type3x): **DEPRECATED:** This function will be removed when Puppet 3 support is dropped; please migrate to the new parser's typing system.
* [`type_of`](#type_of): Returns the type of the passed value.
* [`union`](#union): This function returns a union of two or more arrays.
* [`unique`](#unique): This function will remove duplicates from strings and arrays.
* [`unix2dos`](#unix2dos): Returns the DOS version of the given string.
* [`upcase`](#upcase): Converts a string or an array of strings to uppercase.
* [`uriescape`](#uriescape): Urlencodes a string or array of strings.
Requires either a single string or an array as an input.
* [`validate_absolute_path`](#validate_absolute_path): Validate the string represents an absolute path in the filesystem.  This function works
for windows and unix style paths.
* [`validate_absolute_path`](#validate_absolute_path): Validate the string represents an absolute path in the filesystem.
* [`validate_array`](#validate_array): Validate the passed value represents an array.
* [`validate_array`](#validate_array): Validate that all passed values are array data structures. Abort catalog
compilation if any value fails this check.
* [`validate_augeas`](#validate_augeas): Perform validation of a string using an Augeas lens
* [`validate_bool`](#validate_bool): Validate the passed value represents a boolean.
* [`validate_bool`](#validate_bool): Validate that all passed values are either true or false. Abort catalog
compilation if any value fails this check.
* [`validate_cmd`](#validate_cmd): Perform validation of a string with an external command.
* [`validate_domain_name`](#validate_domain_name): Validate that all values passed are syntactically correct domain names.
Fail compilation if any value fails this check.
* [`validate_email_address`](#validate_email_address): Validate that all values passed are valid email addresses.
Fail compilation if any value fails this check.
* [`validate_hash`](#validate_hash): Validate that all passed values are hash data structures. Abort catalog
compilation if any value fails this check.
* [`validate_hash`](#validate_hash): Validate the passed value represents a hash.
* [`validate_integer`](#validate_integer): Validate that the first argument is an integer (or an array of integers). Abort catalog compilation if any of the checks fail.
* [`validate_integer`](#validate_integer): Validate the passed value represents an integer.
* [`validate_ip_address`](#validate_ip_address): Validate that all values passed are valid IP addresses,
regardless they are IPv4 or IPv6
Fail compilation if any value fails this check.
* [`validate_ip_address`](#validate_ip_address): Validate the passed value represents an ip_address.
* [`validate_ipv4_address`](#validate_ipv4_address): Validate the passed value represents an ipv4_address.
* [`validate_ipv4_address`](#validate_ipv4_address): Validate that all values passed are valid IPv4 addresses.
Fail compilation if any value fails this check.
* [`validate_ipv6_address`](#validate_ipv6_address): Validate that all values passed are valid IPv6 addresses.
Fail compilation if any value fails this check.
* [`validate_ipv6_address`](#validate_ipv6_address): Validate the passed value represents an ipv6_address.
* [`validate_legacy`](#validate_legacy): Validate a value against both the target_type (new) and the previous_validation function (old).
* [`validate_numeric`](#validate_numeric): Validate the passed value represents a numeric value.
* [`validate_numeric`](#validate_numeric): Validate that the first argument is a numeric value (or an array of numeric values). Abort catalog compilation if any of the checks fail.
* [`validate_re`](#validate_re): Perform simple validation of a string against one or more regular
expressions.
* [`validate_re`](#validate_re): Perform validation of a string against one or more regular
expressions.
* [`validate_slength`](#validate_slength): Validate that the first argument is a string (or an array of strings), and less/equal to than the length of the second argument.
An optional third parameter can be given the minimum length. It fails if the first argument is not a string or array of strings,
and if arg 2 and arg 3 are not convertable to a number.
* [`validate_slength`](#validate_slength): Validate that a passed string has length less/equal with the passed value
* [`validate_string`](#validate_string): Validate that all passed values are string data structures
* [`validate_string`](#validate_string): Validate that all passed values are string data structures.
* [`validate_x509_rsa_key_pair`](#validate_x509_rsa_key_pair): Validates a PEM-formatted X.509 certificate and RSA private key using
OpenSSL. Verifies that the certficate's signature was created from the
supplied key.
* [`values`](#values): When given a hash this function will return the values of that hash.
* [`values_at`](#values_at): Finds value inside an array based on location.
* [`zip`](#zip): Takes one element from first array and merges corresponding elements from second array.

**Data types**

* [`Stdlib::Absolutepath`](#stdlibabsolutepath): A strict absolutepath type
* [`Stdlib::Base32`](#stdlibbase32): Type to match base32 String
* [`Stdlib::Base64`](#stdlibbase64): Type to match base64 String
* [`Stdlib::Compat::Absolute_path`](#stdlibcompatabsolute_path): Emulate the is_absolute_path and validate_absolute_path functions  The first pattern is originally from is_absolute_path, which had it from 2
* [`Stdlib::Compat::Array`](#stdlibcompatarray): Emulate the is_array and validate_array functions
* [`Stdlib::Compat::Bool`](#stdlibcompatbool): Emulate the is_bool and validate_bool functions
* [`Stdlib::Compat::Float`](#stdlibcompatfloat): Emulate the is_float function The regex is what's currently used in is_float To keep your development moving forward, you can also add a depr
* [`Stdlib::Compat::Hash`](#stdlibcompathash): Emulate the is_hash and validate_hash functions
* [`Stdlib::Compat::Integer`](#stdlibcompatinteger): Emulate the is_integer and validate_integer functions The regex is what's currently used in is_integer validate_numeric also allows range che
* [`Stdlib::Compat::Ip_address`](#stdlibcompatip_address): 
* [`Stdlib::Compat::Ipv4`](#stdlibcompatipv4): Emulate the validate_ipv4_address and is_ipv4_address functions
* [`Stdlib::Compat::Ipv6`](#stdlibcompatipv6): 
* [`Stdlib::Compat::Numeric`](#stdlibcompatnumeric): Emulate the is_numeric and validate_numeric functions The regex is what's currently used in is_numeric validate_numeric also allows range che
* [`Stdlib::Compat::String`](#stdlibcompatstring): Emulate the is_string and validate_string functions
* [`Stdlib::Ensure::Service`](#stdlibensureservice): 
* [`Stdlib::Filemode`](#stdlibfilemode): See `man chmod.1` for the regular expression for symbolic mode
* [`Stdlib::Filesource`](#stdlibfilesource): Validate the source parameter on file types
* [`Stdlib::Fqdn`](#stdlibfqdn): 
* [`Stdlib::HTTPSUrl`](#stdlibhttpsurl): 
* [`Stdlib::HTTPUrl`](#stdlibhttpurl): 
* [`Stdlib::Host`](#stdlibhost): 
* [`Stdlib::IP::Address`](#stdlibipaddress): 
* [`Stdlib::IP::Address::Nosubnet`](#stdlibipaddressnosubnet): 
* [`Stdlib::IP::Address::V4`](#stdlibipaddressv4): 
* [`Stdlib::IP::Address::V4::CIDR`](#stdlibipaddressv4cidr): 
* [`Stdlib::IP::Address::V4::Nosubnet`](#stdlibipaddressv4nosubnet): 
* [`Stdlib::IP::Address::V6`](#stdlibipaddressv6): 
* [`Stdlib::IP::Address::V6::Alternative`](#stdlibipaddressv6alternative): 
* [`Stdlib::IP::Address::V6::CIDR`](#stdlibipaddressv6cidr): 
* [`Stdlib::IP::Address::V6::Compressed`](#stdlibipaddressv6compressed): 
* [`Stdlib::IP::Address::V6::Full`](#stdlibipaddressv6full): 
* [`Stdlib::IP::Address::V6::Nosubnet`](#stdlibipaddressv6nosubnet): 
* [`Stdlib::IP::Address::V6::Nosubnet::Alternative`](#stdlibipaddressv6nosubnetalternative): 
* [`Stdlib::IP::Address::V6::Nosubnet::Compressed`](#stdlibipaddressv6nosubnetcompressed): 
* [`Stdlib::IP::Address::V6::Nosubnet::Full`](#stdlibipaddressv6nosubnetfull): 
* [`Stdlib::MAC`](#stdlibmac): A type for a MAC address
* [`Stdlib::ObjectStore`](#stdlibobjectstore): 
* [`Stdlib::ObjectStore::GSUri`](#stdlibobjectstoregsuri): 
* [`Stdlib::ObjectStore::S3Uri`](#stdlibobjectstores3uri): 
* [`Stdlib::Port`](#stdlibport): 
* [`Stdlib::Port::Privileged`](#stdlibportprivileged): 
* [`Stdlib::Port::Unprivileged`](#stdlibportunprivileged): 
* [`Stdlib::Syslogfacility`](#stdlibsyslogfacility): 
* [`Stdlib::Unixpath`](#stdlibunixpath): this regex rejects any path component that does not start with "/" or is NUL
* [`Stdlib::Windowspath`](#stdlibwindowspath): 
* [`Stdlib::Yes_no`](#stdlibyes_no): 

## Classes

### stdlib

Most of stdlib's features are automatically loaded by Puppet, but this class should be
declared in order to use the standardized run stages.

Declares all other classes in the stdlib module. Currently, this consists
of stdlib::stages.

### stdlib::stages

Declares various run-stages for deploying infrastructure,
language runtimes, and application layers.

The high level stages are (in order):
 * setup
 * main
 * runtime
 * setup_infra
 * deploy_infra
 * setup_app
 * deploy_app
 * deploy

#### Examples

##### 

```puppet
node default {
  include ::stdlib
  class { java: stage => 'runtime' }
}
```

## Resource types

### anchor

In Puppet 2.6, when a class declares another class, the resources in the
interior class are not contained by the exterior class. This interacts badly
with the pattern of composing complex modules from smaller classes, as it
makes it impossible for end users to specify order relationships between the
exterior class and other modules.

The anchor type lets you work around this. By sandwiching any interior
classes between two no-op resources that _are_ contained by the exterior
class, you can ensure that all resources in the module are contained.

```
class ntp {
  # These classes will have the correct order relationship with each
  # other. However, without anchors, they won't have any order
  # relationship to Class['ntp'].
  class { 'ntp::package': }
  -> class { 'ntp::config': }
  -> class { 'ntp::service': }

  # These two resources "anchor" the composed classes within the ntp
  # class.
  anchor { 'ntp::begin': } -> Class['ntp::package']
  Class['ntp::service']    -> anchor { 'ntp::end': }
}
```

This allows the end user of the ntp module to establish require and before
relationships with Class['ntp']:

```
class { 'ntp': } -> class { 'mcollective': }
class { 'mcollective': } -> class { 'ntp': }
```

#### Parameters

The following parameters are available in the `anchor` type.

##### `name`

namevar

The name of the anchor resource.

### file_line

The implementation matches the full line, including whitespace at the
beginning and end.  If the line is not contained in the given file, Puppet
will append the line to the end of the file to ensure the desired state.
Multiple resources may be declared to manage multiple lines in the same file.

* Ensure Example
```
file_line { 'sudo_rule':
  path => '/etc/sudoers',
  line => '%sudo ALL=(ALL) ALL',
}

file_line { 'sudo_rule_nopw':
  path => '/etc/sudoers',
  line => '%sudonopw ALL=(ALL) NOPASSWD: ALL',
}
```
In this example, Puppet will ensure both of the specified lines are
contained in the file /etc/sudoers.

* Match Example

```
file_line { 'bashrc_proxy':
  ensure => present,
  path   => '/etc/bashrc',
  line   => 'export HTTP_PROXY=http://squid.puppetlabs.vm:3128',
  match  => '^export\ HTTP_PROXY\=',
}
```

In this code example match will look for a line beginning with export
followed by HTTP_PROXY and replace it with the value in line.

* Examples With `ensure => absent`:

This type has two behaviors when `ensure => absent` is set.

One possibility is to set `match => ...` and `match_for_absence => true`,
as in the following example:

```
file_line { 'bashrc_proxy':
  ensure            => absent,
  path              => '/etc/bashrc',
  match             => '^export\ HTTP_PROXY\=',
  match_for_absence => true,
}
```

In this code example match will look for a line beginning with export
followed by HTTP_PROXY and delete it.  If multiple lines match, an
error will be raised unless the `multiple => true` parameter is set.

Note that the `line => ...` parameter would be accepted BUT IGNORED in
the above example.

The second way of using `ensure => absent` is to specify a `line => ...`,
and no match:

```
file_line { 'bashrc_proxy':
  ensure => absent,
  path   => '/etc/bashrc',
  line   => 'export HTTP_PROXY=http://squid.puppetlabs.vm:3128',
}
```

> *Note:*
When ensuring lines are absent this way, the default behavior
this time is to always remove all lines matching, and this behavior
can't be disabled.

* Encoding example:

```
file_line { "XScreenSaver":
  ensure   => present,
  path     => '/root/XScreenSaver',
  line     => "*lock: 10:00:00",
  match    => '^*lock:',
  encoding => "iso-8859-1",
}
```

Files with special characters that are not valid UTF-8 will give the
error message "invalid byte sequence in UTF-8".  In this case, determine
the correct file encoding and specify the correct encoding using the
encoding attribute, the value of which needs to be a valid Ruby character
encoding.

**Autorequires:** If Puppet is managing the file that will contain the line
being managed, the file_line resource will autorequire that file.

#### Properties

The following properties are available in the `file_line` type.

##### `ensure`

Valid values: present, absent

Manage the state of this type.

Default value: present

##### `line`

The line to be appended to the file or used to replace matches found by the match attribute.

#### Parameters

The following parameters are available in the `file_line` type.

##### `name`

namevar

An arbitrary name used as the identity of the resource.

##### `match`

An optional ruby regular expression to run against existing lines in the file.
If a match is found, we replace that line rather than adding a new line.
A regex comparison is performed against the line value and if it does not
match an exception will be raised.

##### `match_for_absence`

Valid values: `true`, `false`

An optional value to determine if match should be applied when ensure => absent.
If set to true and match is set, the line that matches match will be deleted.
If set to false (the default), match is ignored when ensure => absent.
When `ensure => present`, match_for_absence is ignored.

Default value: `false`

##### `multiple`

Valid values: `true`, `false`

An optional value to determine if match can change multiple lines.
If set to false, an exception will be raised if more than one line matches

##### `after`

An optional value used to specify the line after which we will add any new lines. (Existing lines are added in place)
This is also takes a regex.

##### `path`

The file Puppet will ensure contains the line specified by the line parameter.

##### `replace`

Valid values: `true`, `false`

If true, replace line that matches. If false, do not write line if a match is found

Default value: `true`

##### `replace_all_matches_not_matching_line`

Valid values: `true`, `false`

Configures the behavior of replacing all lines in a file which match the `match` parameter regular expression, regardless of whether the specified line is already present in the file.

Default value: `false`

##### `encoding`

For files that are not UTF-8 encoded, specify encoding such as iso-8859-1

Default value: UTF-8

##### `append_on_no_match`

Valid values: `true`, `false`

If true, append line if match is not found. If false, do not append line if a match is not found

Default value: `true`

## Functions

### abs

Type: Ruby 3.x API

For example -34.56 becomes 34.56.
Takes a single integer or float value as an argument.

> *Note:*
  **Deprected** from Puppet 6.0.0, the built-in
  ['abs'](https://puppet.com/docs/puppet/6.4/function.html#abs)function will be used instead.

#### `abs()`

For example -34.56 becomes 34.56.
Takes a single integer or float value as an argument.

> *Note:*
  **Deprected** from Puppet 6.0.0, the built-in
  ['abs'](https://puppet.com/docs/puppet/6.4/function.html#abs)function will be used instead.

Returns: `Any` The absolute value of the given number if it was an Integer

### any2array

Type: Ruby 3.x API

Empty argument lists are converted to an empty array. Arrays are left
untouched. Hashes are converted to arrays of alternating keys and values.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Array.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-array-and-tuple)
  function is used to create a new Array..

  ```
  $hsh = {'key' => 42, 'another-key' => 100}
  notice(Array($hsh))
  ```

Would notice `[['key', 42], ['another-key', 100]]`

The Array data type also has a special mode to "create an array if not already an array"

  ```
  notice(Array({'key' => 42, 'another-key' => 100}, true))
  ```

Would notice `[{'key' => 42, 'another-key' => 100}]`, as the `true` flag prevents the hash from being
transformed into an array.

#### `any2array()`

Empty argument lists are converted to an empty array. Arrays are left
untouched. Hashes are converted to arrays of alternating keys and values.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Array.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-array-and-tuple)
  function is used to create a new Array..

  ```
  $hsh = {'key' => 42, 'another-key' => 100}
  notice(Array($hsh))
  ```

Would notice `[['key', 42], ['another-key', 100]]`

The Array data type also has a special mode to "create an array if not already an array"

  ```
  notice(Array({'key' => 42, 'another-key' => 100}, true))
  ```

Would notice `[{'key' => 42, 'another-key' => 100}]`, as the `true` flag prevents the hash from being
transformed into an array.

Returns: `Array` The new array containing the given object

### any2bool

Type: Ruby 3.x API

In practise it does the following:
* Strings such as Y,y,1,T,t,TRUE,yes,'true' will return true
* Strings such as 0,F,f,N,n,FALSE,no,'false' will return false
* Booleans will just return their original value
* Number (or a string representation of a number) > 0 will return true, otherwise false
* undef will return false
* Anything else will return true

Also see the built-in [`Boolean.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-boolean)
function.

#### `any2bool()`

In practise it does the following:
* Strings such as Y,y,1,T,t,TRUE,yes,'true' will return true
* Strings such as 0,F,f,N,n,FALSE,no,'false' will return false
* Booleans will just return their original value
* Number (or a string representation of a number) > 0 will return true, otherwise false
* undef will return false
* Anything else will return true

Also see the built-in [`Boolean.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-boolean)
function.

Returns: `Boolean` The boolean value of the object that was given

### assert_private

Type: Ruby 3.x API

Calling the class or definition from outside the current module will fail.

#### `assert_private()`

Calling the class or definition from outside the current module will fail.

Returns: `Any` set the current class or definition as private.

### base64

Type: Ruby 3.x API

> **Note:*
    Since Puppet 4.8.0, the Binary data type can be used to produce base 64 encoded strings.
    See the `new()` function for the Binary and String types for documentation. Also see `binary_file()`
    function for reading a file with binary (non UTF-8) content.

#### Examples

##### Example usage

```puppet

Encode and decode a string

  $encodestring = base64('encode', 'thestring')
  $decodestring = base64('decode', 'dGhlc3RyaW5n')

Explicitly define encode/decode method: default, strict, urlsafe

  $method = 'default'
  $encodestring = base64('encode', 'thestring', $method)
  $decodestring = base64('decode', 'dGhlc3RyaW5n', $method)

Encode a string as if it was binary

 $encodestring = String(Binary('thestring', '%s'))

Decode a Binary assuming it is an UTF-8 String

 $decodestring = String(Binary("dGhlc3RyaW5n"), "%s")
```

#### `base64()`

> **Note:*
    Since Puppet 4.8.0, the Binary data type can be used to produce base 64 encoded strings.
    See the `new()` function for the Binary and String types for documentation. Also see `binary_file()`
    function for reading a file with binary (non UTF-8) content.

Returns: `String` The encoded/decoded va

##### Examples

###### Example usage

```puppet

Encode and decode a string

  $encodestring = base64('encode', 'thestring')
  $decodestring = base64('decode', 'dGhlc3RyaW5n')

Explicitly define encode/decode method: default, strict, urlsafe

  $method = 'default'
  $encodestring = base64('encode', 'thestring', $method)
  $decodestring = base64('decode', 'dGhlc3RyaW5n', $method)

Encode a string as if it was binary

 $encodestring = String(Binary('thestring', '%s'))

Decode a Binary assuming it is an UTF-8 String

 $decodestring = String(Binary("dGhlc3RyaW5n"), "%s")
```

### basename

Type: Ruby 3.x API

Strips directory (and optional suffix) from a filename

#### `basename()`

The basename function.

Returns: `String` The stripped filename

### bool2num

Type: Ruby 3.x API

Converts the values:
  ```
  false, f, 0, n, and no to 0
  true, t, 1, y, and yes to 1
  ```
Requires a single boolean or string as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Numeric.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-numeric),
  [`Integer.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-integer), and
  [`Float.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-float)
  function are used to convert to numeric values.
  ```
  notice(Integer(false)) # Notices 0
  notice(Float(true))    # Notices 1.0
  ```

#### `bool2num()`

Converts the values:
  ```
  false, f, 0, n, and no to 0
  true, t, 1, y, and yes to 1
  ```
Requires a single boolean or string as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`Numeric.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-numeric),
  [`Integer.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-integer), and
  [`Float.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-float)
  function are used to convert to numeric values.
  ```
  notice(Integer(false)) # Notices 0
  notice(Float(true))    # Notices 1.0
  ```

Returns: `Integer` The converted value as a number

### bool2str

Type: Ruby 3.x API

The optional second and third arguments represent what true and false will be
converted to respectively. If only one argument is given, it will be
converted from a boolean to a string containing 'true' or 'false'.

**Examples of usage**

  ```
    bool2str(true)                    => 'true'
    bool2str(true, 'yes', 'no')       => 'yes'
    bool2str(false, 't', 'f')         => 'f'
  ```

Requires a single boolean as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#boolean-to-string)
  function is used to convert to String with many different format options.

  ```
    notice(String(false))         # Notices 'false'
    notice(String(true))          # Notices 'true'
    notice(String(false, '%y'))   # Notices 'yes'
    notice(String(true, '%y'))    # Notices 'no'
  ```

#### `bool2str()`

The optional second and third arguments represent what true and false will be
converted to respectively. If only one argument is given, it will be
converted from a boolean to a string containing 'true' or 'false'.

**Examples of usage**

  ```
    bool2str(true)                    => 'true'
    bool2str(true, 'yes', 'no')       => 'yes'
    bool2str(false, 't', 'f')         => 'f'
  ```

Requires a single boolean as an input.

> *Note:*
  since Puppet 5.0.0 it is possible to create new data types for almost any
  datatype using the type system and the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#boolean-to-string)
  function is used to convert to String with many different format options.

  ```
    notice(String(false))         # Notices 'false'
    notice(String(true))          # Notices 'true'
    notice(String(false, '%y'))   # Notices 'yes'
    notice(String(true, '%y'))    # Notices 'no'
  ```

Returns: `Any` The converted value to string of the given Boolean

### camelcase

Type: Ruby 3.x API

> *Note:*
  **Deprecated** from Puppet 6.0.0, this function has been replaced with
  a built-in [`camelcase`](https://puppet.com/docs/puppet/latest/function.html#camelcase)
  function.

#### `camelcase()`

> *Note:*
  **Deprecated** from Puppet 6.0.0, this function has been replaced with
  a built-in [`camelcase`](https://puppet.com/docs/puppet/latest/function.html#camelcase)
  function.

Returns: `String` The converted String, if it was a String that was given

### capitalize

Type: Ruby 3.x API

Requires either a single string or an array as an input.

> *Note:*
  **Deprecated** from Puppet 6.0.0, yhis function has been replaced with a
  built-in [`capitalize`](https://puppet.com/docs/puppet/latest/function.html#capitalize)
  function.

#### `capitalize()`

Requires either a single string or an array as an input.

> *Note:*
  **Deprecated** from Puppet 6.0.0, yhis function has been replaced with a
  built-in [`capitalize`](https://puppet.com/docs/puppet/latest/function.html#capitalize)
  function.

Returns: `String` The converted String, if it was a String that was given

### ceiling

Type: Ruby 3.x API

Takes a single numeric value as an argument.

> *Note:*
  **Deprecated** from Puppet 6.0.0, this function has been replaced with a
  built-in [`ceiling`](https://puppet.com/docs/puppet/latest/function.html#ceiling) function.

#### `ceiling()`

Takes a single numeric value as an argument.

> *Note:*
  **Deprecated** from Puppet 6.0.0, this function has been replaced with a
  built-in [`ceiling`](https://puppet.com/docs/puppet/latest/function.html#ceiling) function.

Returns: `Integer` The rounded value

### chomp

Type: Ruby 3.x API

For example `hello\n` becomes `hello`.
Requires a single string or array as an input.

> *Note:*
  **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`chomp`](https://puppet.com/docs/puppet/latest/function.html#chomp) function.

#### `chomp()`

For example `hello\n` becomes `hello`.
Requires a single string or array as an input.

> *Note:*
  **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`chomp`](https://puppet.com/docs/puppet/latest/function.html#chomp) function.

Returns: `String` The converted String, if it was a String that was given

### chop

Type: Ruby 3.x API

If the string ends with `\r\n`, both characters are removed. Applying
chop to an empty string returns an empty string. If you wish to merely
remove record separators then you should use the `chomp` function.
Requires a string or array of strings as input.

> *Note:* **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`chop`](https://puppet.com/docs/puppet/latest/function.html#chop) function.

#### `chop()`

If the string ends with `\r\n`, both characters are removed. Applying
chop to an empty string returns an empty string. If you wish to merely
remove record separators then you should use the `chomp` function.
Requires a string or array of strings as input.

> *Note:* **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`chop`](https://puppet.com/docs/puppet/latest/function.html#chop) function.

Returns: `String` The given String, sans the last character.

### clamp

Type: Ruby 3.x API

Strings are converted and compared numerically. Arrays of values are flattened
into a list for further handling.

> *Note:*
  From Puppet 6.0.0 this can be done with only core Puppet like this:
  `[$minval, $maxval, $value_to_clamp].sort[1]`

#### Examples

##### Example usage

```puppet

clamp('24', [575, 187])` returns 187.
clamp(16, 88, 661)` returns 88.
clamp([4, 3, '99'])` returns 4.
```

#### `clamp()`

Strings are converted and compared numerically. Arrays of values are flattened
into a list for further handling.

> *Note:*
  From Puppet 6.0.0 this can be done with only core Puppet like this:
  `[$minval, $maxval, $value_to_clamp].sort[1]`

Returns: `Array[Integer]` The sorted Array

##### Examples

###### Example usage

```puppet

clamp('24', [575, 187])` returns 187.
clamp(16, 88, 661)` returns 88.
clamp([4, 3, '99'])` returns 4.
```

### concat

Type: Ruby 3.x API

> *Note:*
  Since Puppet 4.0, you can use the `+`` operator for concatenation of arrays and
  merge of hashes, and the `<<`` operator for appending:

`['1','2','3'] + ['4','5','6'] + ['7','8','9']` returns `['1','2','3','4','5','6','7','8','9']`
`[1, 2, 3] << 4` returns `[1, 2, 3, 4]`
`[1, 2, 3] << [4, 5]` returns `[1, 2, 3, [4, 5]]`

#### Examples

##### Example usage

```puppet

concat(['1','2','3'],'4') returns ['1','2','3','4']
concat(['1','2','3'],'4',['5','6','7']) returns ['1','2','3','4','5','6','7']
```

#### `concat()`

> *Note:*
  Since Puppet 4.0, you can use the `+`` operator for concatenation of arrays and
  merge of hashes, and the `<<`` operator for appending:

`['1','2','3'] + ['4','5','6'] + ['7','8','9']` returns `['1','2','3','4','5','6','7','8','9']`
`[1, 2, 3] << 4` returns `[1, 2, 3, 4]`
`[1, 2, 3] << [4, 5]` returns `[1, 2, 3, [4, 5]]`

Returns: `Array` The single concatenated array

##### Examples

###### Example usage

```puppet

concat(['1','2','3'],'4') returns ['1','2','3','4']
concat(['1','2','3'],'4',['5','6','7']) returns ['1','2','3','4','5','6','7']
```

### convert_base

Type: Ruby 3.x API

convert_base(5, 2)` results in: `'101'`
convert_base('254', '16')` results in: `'fe'`

> *Note:*
  Since Puppet 4.5.0 this can be done with the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#integer-to-string)
  function and its many formatting options:

  `$binary_repr = String(5, '%b')` return `"101"`
  `$hex_repr = String(254, "%x")`  return `"fe"`
  `$hex_repr = String(254, "%#x")` return `"0xfe"`

  @return [String] The converted value as a Str

#### Examples

##### Example usage

```puppet

```

#### `convert_base()`

convert_base(5, 2)` results in: `'101'`
convert_base('254', '16')` results in: `'fe'`

> *Note:*
  Since Puppet 4.5.0 this can be done with the built-in
  [`String.new`](https://puppet.com/docs/puppet/latest/function.html#integer-to-string)
  function and its many formatting options:

  `$binary_repr = String(5, '%b')` return `"101"`
  `$hex_repr = String(254, "%x")`  return `"fe"`
  `$hex_repr = String(254, "%#x")` return `"0xfe"`

  @return [String] The converted value as a Str

Returns: `Any` converted value as a string

##### Examples

###### Example usage

```puppet

```

### count

Type: Ruby 3.x API

Takes an array as first argument and an optional second argument. Counts the number of elements in array that is equal to the second argument.
If called with only an array, it counts the number of elements that are not nil/undef/empty-string.

> *Note:*
  equality is tested with a Ruby method and it is therefore subject to what Ruby considers
  to be equal. For strings this means that equality is case sensitive.

In Puppet core, counting can be done in general by using a combination of the core functions
filter() (since Puppet 4.0.0) and length() (since Puppet 5.5.0, before that in stdlib).

Example below shows counting values that are not undef.

  ```notice([42, "hello", undef].filter |$x| { $x =~ NotUndef }.length)```

Would notice the value 2.

#### `count()`

Takes an array as first argument and an optional second argument. Counts the number of elements in array that is equal to the second argument.
If called with only an array, it counts the number of elements that are not nil/undef/empty-string.

> *Note:*
  equality is tested with a Ruby method and it is therefore subject to what Ruby considers
  to be equal. For strings this means that equality is case sensitive.

In Puppet core, counting can be done in general by using a combination of the core functions
filter() (since Puppet 4.0.0) and length() (since Puppet 5.5.0, before that in stdlib).

Example below shows counting values that are not undef.

  ```notice([42, "hello", undef].filter |$x| { $x =~ NotUndef }.length)```

Would notice the value 2.

Returns: `Integer` The amount of elements counted within the array

### deep_merge

Type: Ruby 3.x API

Recursively merges two or more hashes together and returns the resulting hash.

#### Examples

##### Example usage

```puppet

$hash1 = {'one' => 1, 'two' => 2, 'three' => { 'four' => 4 } }
$hash2 = {'two' => 'dos', 'three' => { 'five' => 5 } }
$merged_hash = deep_merge($hash1, $hash2)

The resulting hash is equivalent to:

$merged_hash = { 'one' => 1, 'two' => 'dos', 'three' => { 'four' => 4, 'five' => 5 } }

When there is a duplicate key that is a hash, they are recursively merged.
When there is a duplicate key that is not a hash, the key in the rightmost hash will "win."
```

#### `deep_merge()`

The deep_merge function.

Returns: `Hash` The merged h

##### Examples

###### Example usage

```puppet

$hash1 = {'one' => 1, 'two' => 2, 'three' => { 'four' => 4 } }
$hash2 = {'two' => 'dos', 'three' => { 'five' => 5 } }
$merged_hash = deep_merge($hash1, $hash2)

The resulting hash is equivalent to:

$merged_hash = { 'one' => 1, 'two' => 'dos', 'three' => { 'four' => 4, 'five' => 5 } }

When there is a duplicate key that is a hash, they are recursively merged.
When there is a duplicate key that is not a hash, the key in the rightmost hash will "win."
```

### defined_with_params

Type: Ruby 3.x API

Returns `true` if a resource with the specified attributes has already been added
to the catalog, and `false` otherwise.

  ```
  user { 'dan':
    ensure => present,
  }

  if ! defined_with_params(User[dan], {'ensure' => 'present' }) {
    user { 'dan': ensure => present, }
  }
  ```

#### `defined_with_params()`

Returns `true` if a resource with the specified attributes has already been added
to the catalog, and `false` otherwise.

  ```
  user { 'dan':
    ensure => present,
  }

  if ! defined_with_params(User[dan], {'ensure' => 'present' }) {
    user { 'dan': ensure => present, }
  }
  ```

Returns: `Boolean` returns `true` or `false`

### delete

Type: Ruby 3.x API

> *Note:*
From Puppet 4.0.0 the minus (-) operator deletes values from arrays and keys from a hash
`{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])`
>
A global delete from a string can be performed with the
[`regsubst`](https://puppet.com/docs/puppet/latest/function.html#regsubst) function:
`'abracadabra'.regsubst(/bra/, '', 'G')`

In general, the built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter)
function can filter out entries from arrays and hashes based on keys and/or values.

#### Examples

##### Example usage

```puppet

delete(['a','b','c','b'], 'b')
Would return: ['a','c']

delete({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete({'a'=>1,'b'=>2,'c'=>3}, ['b','c'])
Would return: {'a'=>1}

delete('abracadabra', 'bra')
Would return: 'acada'

['a', 'b', 'c', 'b'] - 'b'
Would return: ['a', 'c']

{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])
Would return: {'a' => '1'}

'abracadabra'.regsubst(/bra/, '', 'G')
Would return: 'acada'
```

#### `delete()`

> *Note:*
From Puppet 4.0.0 the minus (-) operator deletes values from arrays and keys from a hash
`{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])`
>
A global delete from a string can be performed with the
[`regsubst`](https://puppet.com/docs/puppet/latest/function.html#regsubst) function:
`'abracadabra'.regsubst(/bra/, '', 'G')`

In general, the built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter)
function can filter out entries from arrays and hashes based on keys and/or values.

Returns: `String` The filtered String, if one was given.

##### Examples

###### Example usage

```puppet

delete(['a','b','c','b'], 'b')
Would return: ['a','c']

delete({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete({'a'=>1,'b'=>2,'c'=>3}, ['b','c'])
Would return: {'a'=>1}

delete('abracadabra', 'bra')
Would return: 'acada'

['a', 'b', 'c', 'b'] - 'b'
Would return: ['a', 'c']

{'a'=>1,'b'=>2,'c'=>3} - ['b','c'])
Would return: {'a' => '1'}

'abracadabra'.regsubst(/bra/, '', 'G')
Would return: 'acada'
```

### delete_at

Type: Ruby 3.x API

For example
    ```delete_at(['a','b','c'], 1)```

Would return: `['a','c']`

> *Note:*
  Since Puppet 4 this can be done in general with the built-in
  [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:

  ```['a', 'b', 'c'].filter |$pos, $val | { $pos != 1 }```

Or if a delete is wanted from the beginning or end of the array, by using the slice operator [ ]:
  ```
  $array[0, -1] # the same as all the values
  $array[2, -1] # all but the first 2 elements
  $array[0, -3] # all but the last 2 elements
  $array[1, -2] # all but the first and last element
  ```

#### `delete_at()`

For example
    ```delete_at(['a','b','c'], 1)```

Would return: `['a','c']`

> *Note:*
  Since Puppet 4 this can be done in general with the built-in
  [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:

  ```['a', 'b', 'c'].filter |$pos, $val | { $pos != 1 }```

Or if a delete is wanted from the beginning or end of the array, by using the slice operator [ ]:
  ```
  $array[0, -1] # the same as all the values
  $array[2, -1] # all but the first 2 elements
  $array[0, -3] # all but the last 2 elements
  $array[1, -2] # all but the first and last element
  ```

Returns: `Array` The given array, now missing the tar

### delete_regex

Type: Ruby 3.x API

Multiple regular expressions are assumed to be matched as an OR.

> *Note:*
Since Puppet 4 this can be done in general with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
["aaa", "aba", "aca"].filter |$val| { $val !~ /b/ }
Would return: ['aaa', 'aca']

#### Examples

##### Example usage

```puppet

delete_regex(['a','b','c','b'], 'b')
Would return: ['a','c']

delete_regex(['a','b','c','b'], ['b', 'c'])
Would return: ['a']

delete_regex({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete_regex({'a'=>1,'b'=>2,'c'=>3}, '^a$')
Would return: {'b'=>2,'c'=>3}
```

#### `delete_regex()`

Multiple regular expressions are assumed to be matched as an OR.

> *Note:*
Since Puppet 4 this can be done in general with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
["aaa", "aba", "aca"].filter |$val| { $val !~ /b/ }
Would return: ['aaa', 'aca']

Returns: `Array` The given array now missing all targeted values.

##### Examples

###### Example usage

```puppet

delete_regex(['a','b','c','b'], 'b')
Would return: ['a','c']

delete_regex(['a','b','c','b'], ['b', 'c'])
Would return: ['a']

delete_regex({'a'=>1,'b'=>2,'c'=>3}, 'b')
Would return: {'a'=>1,'c'=>3}

delete_regex({'a'=>1,'b'=>2,'c'=>3}, '^a$')
Would return: {'b'=>2,'c'=>3}
```

### delete_undef_values

Type: Ruby 3.x API

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val =~ NotUndef }
$hash.filter |$key, $val| { $val =~ NotUndef }

#### Examples

##### Example usage

```puppet

$hash = delete_undef_values({a=>'A', b=>'', c=>undef, d => false})
Would return: {a => 'A', b => '', d => false}

While:
$array = delete_undef_values(['A','',undef,false])
Would return: ['A','',false]
```

#### `delete_undef_values()`

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val =~ NotUndef }
$hash.filter |$key, $val| { $val =~ NotUndef }

Returns: `Array` The given array now issing of undefined values.

##### Examples

###### Example usage

```puppet

$hash = delete_undef_values({a=>'A', b=>'', c=>undef, d => false})
Would return: {a => 'A', b => '', d => false}

While:
$array = delete_undef_values(['A','',undef,false])
Would return: ['A','',false]
```

### delete_values

Type: Ruby 3.x API

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the
built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val != 'B' }
$hash.filter |$key, $val| { $val != 'B' }

#### Examples

##### Example usage

```puppet

delete_values({'a'=>'A','b'=>'B','c'=>'C','B'=>'D'}, 'B')
Would return: {'a'=>'A','c'=>'C','B'=>'D'}
```

#### `delete_values()`

> *Note:*
Since Puppet 4.0.0 the equivalent can be performed with the
built-in [`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function:
$array.filter |$val| { $val != 'B' }
$hash.filter |$key, $val| { $val != 'B' }

Returns: `Hash` The given hash now missing all instances of the targeted value

##### Examples

###### Example usage

```puppet

delete_values({'a'=>'A','b'=>'B','c'=>'C','B'=>'D'}, 'B')
Would return: {'a'=>'A','c'=>'C','B'=>'D'}
```

### deprecation

Type: Ruby 3.x API

The uniqueness key - can appear once. The msg is the message text including any positional
information that is formatted by the user/caller of the method.).

#### `deprecation()`

The uniqueness key - can appear once. The msg is the message text including any positional
information that is formatted by the user/caller of the method.).

Returns: `String` return deprecation warnings

### deprecation

Type: Ruby 4.x API

Function to print deprecation warnings, Logs a warning once for a given key.

The uniqueness key - can appear once.
The msg is the message text including any positional information that is formatted by the
user/caller of the method.
It is affected by the puppet setting 'strict', which can be set to :error
(outputs as an error message), :off (no message / error is displayed) and :warning
(default, outputs a warning)  *Type*: String, String.

#### `deprecation(String $key, String $message)`

Function to print deprecation warnings, Logs a warning once for a given key.

The uniqueness key - can appear once.
The msg is the message text including any positional information that is formatted by the
user/caller of the method.
It is affected by the puppet setting 'strict', which can be set to :error
(outputs as an error message), :off (no message / error is displayed) and :warning
(default, outputs a warning)  *Type*: String, String.

Returns: `Any` deprecated warnings

##### `key`

Data type: `String`



##### `message`

Data type: `String`



### difference

Type: Ruby 3.x API

The returned array is a copy of the original array, removing any items that
also appear in the second array.

> *Note:*
Since Puppet 4 the minus (-) operator in the Puppet language does the same thing:
['a', 'b', 'c'] - ['b', 'c', 'd']
Would return: `['a']`

#### Examples

##### Example usage

```puppet

difference(["a","b","c"],["b","c","d"])
Would return: `["a"]`
```

#### `difference()`

The returned array is a copy of the original array, removing any items that
also appear in the second array.

> *Note:*
Since Puppet 4 the minus (-) operator in the Puppet language does the same thing:
['a', 'b', 'c'] - ['b', 'c', 'd']
Would return: `['a']`

Returns: `Array` The difference between the two given arrays

##### Examples

###### Example usage

```puppet

difference(["a","b","c"],["b","c","d"])
Would return: `["a"]`
```

### dig

Type: Ruby 3.x API

In addition to the required path argument, the function accepts the default argument.
It is returned if the path is not correct, if no value was found, or if any other error
has occurred.

  ```ruby
  $data = {
    'a' => {
      'b' => [
        'b1',
        'b2',
        'b3',
      ]
    }
  }

  $value = dig($data, ['a', 'b', 2])
  # $value = 'b3'

  # with all possible options
  $value = dig($data, ['a', 'b', 2], 'not_found')
  # $value = 'b3'

  # using the default value
  $value = dig($data, ['a', 'b', 'c', 'd'], 'not_found')
  # $value = 'not_found'
  ```

  1. `$data` The data structure we are working with.
  2. `['a', 'b', 2]` The path array.
  3. `not_found` The default value. It is returned if nothing is found.

> **Note:*
  **Deprecated** This function has been replaced with a built-in
  [`dig`](https://puppet.com/docs/puppet/latest/function.html#dig) function as of
  Puppet 4.5.0. Use [`dig44()`](#dig44) for backwards compatibility or use the new version.

#### `dig()`

In addition to the required path argument, the function accepts the default argument.
It is returned if the path is not correct, if no value was found, or if any other error
has occurred.

  ```ruby
  $data = {
    'a' => {
      'b' => [
        'b1',
        'b2',
        'b3',
      ]
    }
  }

  $value = dig($data, ['a', 'b', 2])
  # $value = 'b3'

  # with all possible options
  $value = dig($data, ['a', 'b', 2], 'not_found')
  # $value = 'b3'

  # using the default value
  $value = dig($data, ['a', 'b', 'c', 'd'], 'not_found')
  # $value = 'not_found'
  ```

  1. `$data` The data structure we are working with.
  2. `['a', 'b', 2]` The path array.
  3. `not_found` The default value. It is returned if nothing is found.

> **Note:*
  **Deprecated** This function has been replaced with a built-in
  [`dig`](https://puppet.com/docs/puppet/latest/function.html#dig) function as of
  Puppet 4.5.0. Use [`dig44()`](#dig44) for backwards compatibility or use the new version.

Returns: `Any` The function goes through the structure by each path component and tries to return
the value at the end of the path.

### dig44

Type: Ruby 3.x API

Key can contain slashes to describe path components. The function will go down
the structure and try to extract the required value.

```
$data = {
  'a' => {
    'b' => [
      'b1',
      'b2',
      'b3',
    ]
  }
}

$value = dig44($data, ['a', 'b', 2])
# $value = 'b3'

# with all possible options
$value = dig44($data, ['a', 'b', 2], 'not_found')
# $value = 'b3'

# using the default value
$value = dig44($data, ['a', 'b', 'c', 'd'], 'not_found')
# $value = 'not_found'
```

> **Note:* **Deprecated** This function has been replaced with a built-in
  [`dig`](https://puppet.com/docs/puppet/latest/function.html#dig) function as of
  Puppet 4.5.0.

#### `dig44()`

Key can contain slashes to describe path components. The function will go down
the structure and try to extract the required value.

```
$data = {
  'a' => {
    'b' => [
      'b1',
      'b2',
      'b3',
    ]
  }
}

$value = dig44($data, ['a', 'b', 2])
# $value = 'b3'

# with all possible options
$value = dig44($data, ['a', 'b', 2], 'not_found')
# $value = 'b3'

# using the default value
$value = dig44($data, ['a', 'b', 'c', 'd'], 'not_found')
# $value = 'not_found'
```

> **Note:* **Deprecated** This function has been replaced with a built-in
  [`dig`](https://puppet.com/docs/puppet/latest/function.html#dig) function as of
  Puppet 4.5.0.

Returns: `String` 'not_found' will be returned if nothing is found

### dirname

Type: Ruby 3.x API

Returns the dirname of a path.

#### `dirname()`

The dirname function.

Returns: `String` the given path's dirname

### dos2unix

Type: Ruby 3.x API

Takes a single string argument.

#### `dos2unix()`

Takes a single string argument.

Returns: `Any` The retrieved version

### downcase

Type: Ruby 3.x API

> *Note:* **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`downcase`](https://puppet.com/docs/puppet/latest/function.html#downcase) function.
>
This function is an implementation of a Ruby class and might not be UTF8 compatible.
To ensure compatibility, use this function with Ruby 2.4.0 or greater.

#### `downcase()`

> *Note:* **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`downcase`](https://puppet.com/docs/puppet/latest/function.html#downcase) function.
>
This function is an implementation of a Ruby class and might not be UTF8 compatible.
To ensure compatibility, use this function with Ruby 2.4.0 or greater.

Returns: `String` The converted String, if it was a String that was given

### empty

Type: Ruby 3.x API

> *Note*: **Deprecated** from Puppet 5.5.0, the built-in
[`empty`](https://puppet.com/docs/puppet/6.4/function.html#empty) function will be used instead.

#### `empty()`

> *Note*: **Deprecated** from Puppet 5.5.0, the built-in
[`empty`](https://puppet.com/docs/puppet/6.4/function.html#empty) function will be used instead.

Returns: `Any` Returns `true` if the argument is an array or hash that contains no elements,
or an empty string. Returns `false` when the argument is a numerical value.

### enclose_ipv6

Type: Ruby 3.x API

Takes an array of ip addresses and encloses the ipv6 addresses with square brackets.

#### `enclose_ipv6()`

The enclose_ipv6 function.

Returns: `Any` encloses the ipv6 addresses with square brackets.

### ensure_packages

Type: Ruby 3.x API

It optionally takes a hash as a second parameter that will be passed as the
third argument to the ensure_resource() function.

#### `ensure_packages()`

It optionally takes a hash as a second parameter that will be passed as the
third argument to the ensure_resource() function.

Returns: `Any` install the passed packages

### ensure_resource

Type: Ruby 3.x API

user { 'dan':
  ensure => present,
}

#### Examples

##### Example usage

```puppet

Creates the resource if it does not already exist:

  ensure_resource('user', 'dan', {'ensure' => 'present' })

If the resource already exists but does not match the specified parameters,
this function will attempt to recreate the resource leading to a duplicate
resource definition error.

An array of resources can also be passed in and each will be created with
the type and parameters specified if it doesn't already exist.

  ensure_resource('user', ['dan','alex'], {'ensure' => 'present'})
```

#### `ensure_resource()`

user { 'dan':
  ensure => present,
}

Returns: `Any` created or recreated the passed resource with the passed type and attributes

##### Examples

###### Example usage

```puppet

Creates the resource if it does not already exist:

  ensure_resource('user', 'dan', {'ensure' => 'present' })

If the resource already exists but does not match the specified parameters,
this function will attempt to recreate the resource leading to a duplicate
resource definition error.

An array of resources can also be passed in and each will be created with
the type and parameters specified if it doesn't already exist.

  ensure_resource('user', ['dan','alex'], {'ensure' => 'present'})
```

### ensure_resources

Type: Ruby 3.x API

An hash of resources should be passed in and each will be created with
  the type and parameters specified if it doesn't already exist.

  ensure_resources('user', {'dan' => { gid => 'mygroup', uid => '600' }, 'alex' => { gid => 'mygroup' }}, {'ensure' => 'present'})

  From Hiera Backend:

  userlist:
    dan:
      gid: 'mygroup'
   uid: '600'
    alex:
   gid: 'mygroup'

  Call:
  ensure_resources('user', hiera_hash('userlist'), {'ensure' => 'present'})

#### Examples

##### Example usage

```puppet

user { 'dan':
  gid => 'mygroup',
  ensure => present,
}
```

#### `ensure_resources()`

An hash of resources should be passed in and each will be created with
  the type and parameters specified if it doesn't already exist.

  ensure_resources('user', {'dan' => { gid => 'mygroup', uid => '600' }, 'alex' => { gid => 'mygroup' }}, {'ensure' => 'present'})

  From Hiera Backend:

  userlist:
    dan:
      gid: 'mygroup'
   uid: '600'
    alex:
   gid: 'mygroup'

  Call:
  ensure_resources('user', hiera_hash('userlist'), {'ensure' => 'present'})

Returns: `Any` created resources with the passed type and attributes

##### Examples

###### Example usage

```puppet

user { 'dan':
  gid => 'mygroup',
  ensure => present,
}
```

### fact

Type: Ruby 4.x API

Supports the use of dot-notation for referring to structured facts. If a fact requested
does not exist, returns Undef.

#### Examples

##### Example usage:

```puppet
fact('osfamily')
fact('os.architecture')
```

##### Array indexing:

```puppet
fact('mountpoints."/dev".options.1')
```

##### Fact containing a "." in the name:

```puppet
fact('vmware."VRA.version"')
```

#### `fact(String $fact_name)`

Supports the use of dot-notation for referring to structured facts. If a fact requested
does not exist, returns Undef.

Returns: `Any` All information retrieved on the given fact_name

##### Examples

###### Example usage:

```puppet
fact('osfamily')
fact('os.architecture')
```

###### Array indexing:

```puppet
fact('mountpoints."/dev".options.1')
```

###### Fact containing a "." in the name:

```puppet
fact('vmware."VRA.version"')
```

##### `fact_name`

Data type: `String`

The name of the fact to check

### flatten

Type: Ruby 3.x API

> **Note:** **Deprecated** from Puppet 5.5.0, this function has been replaced with a
built-in [`flatten`](https://puppet.com/docs/puppet/latest/function.html#flatten) function.

#### Examples

##### Example usage

```puppet

flatten(['a', ['b', ['c']]])` returns: `['a','b','c']
```

#### `flatten()`

> **Note:** **Deprecated** from Puppet 5.5.0, this function has been replaced with a
built-in [`flatten`](https://puppet.com/docs/puppet/latest/function.html#flatten) function.

Returns: `Any` convert nested arrays into a single flat array

##### Examples

###### Example usage

```puppet

flatten(['a', ['b', ['c']]])` returns: `['a','b','c']
```

### floor

Type: Ruby 3.x API

Takes a single numeric value as an argument.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with
a built-in [`floor`](https://puppet.com/docs/puppet/latest/function.html#floor) function.

#### `floor()`

Takes a single numeric value as an argument.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with
a built-in [`floor`](https://puppet.com/docs/puppet/latest/function.html#floor) function.

Returns: `Any` the largest integer less or equal to the argument.

### fqdn_rand_string

Type: Ruby 3.x API

Optionally, you can specify a character set for the function (defaults to alphanumeric).

Arguments
* An integer, specifying the length of the resulting string.
* Optionally, a string specifying the character set.
* Optionally, a string specifying the seed for repeatable randomness.

#### Examples

##### Example Usage:

```puppet
fqdn_rand_string(10)
fqdn_rand_string(10, 'ABCDEF!@$%^')
fqdn_rand_string(10, '', 'custom seed')
```

#### `fqdn_rand_string()`

Optionally, you can specify a character set for the function (defaults to alphanumeric).

Arguments
* An integer, specifying the length of the resulting string.
* Optionally, a string specifying the character set.
* Optionally, a string specifying the seed for repeatable randomness.

Returns: `String`

##### Examples

###### Example Usage:

```puppet
fqdn_rand_string(10)
fqdn_rand_string(10, 'ABCDEF!@$%^')
fqdn_rand_string(10, '', 'custom seed')
```

### fqdn_rotate

Type: Ruby 3.x API

Rotates an array or string a random number of times, combining the `$fqdn` fact
and an optional seed for repeatable randomness.

#### Examples

##### Example Usage:

```puppet
fqdn_rotate(['a', 'b', 'c', 'd'])
fqdn_rotate('abcd')
fqdn_rotate([1, 2, 3], 'custom seed')
```

#### `fqdn_rotate()`

The fqdn_rotate function.

Returns: `Any` rotated array or string

##### Examples

###### Example Usage:

```puppet
fqdn_rotate(['a', 'b', 'c', 'd'])
fqdn_rotate('abcd')
fqdn_rotate([1, 2, 3], 'custom seed')
```

### fqdn_uuid

Type: Ruby 3.x API

Returns a [RFC 4122](https://tools.ietf.org/html/rfc4122) valid version 5 UUID based
on an FQDN string under the DNS namespace

#### Examples

##### Example Usage:

```puppet
fqdn_uuid('puppetlabs.com') # Returns '9c70320f-6815-5fc5-ab0f-debe68bf764c'
fqdn_uuid('google.com') # Returns '64ee70a4-8cc1-5d25-abf2-dea6c79a09
```

#### `fqdn_uuid()`

The fqdn_uuid function.

Returns: `Any` Returns a [RFC 4122](https://tools.ietf.org/html/rfc4122) valid version 5 UUID

##### Examples

###### Example Usage:

```puppet
fqdn_uuid('puppetlabs.com') # Returns '9c70320f-6815-5fc5-ab0f-debe68bf764c'
fqdn_uuid('google.com') # Returns '64ee70a4-8cc1-5d25-abf2-dea6c79a09
```

### get_module_path

Type: Ruby 3.x API

> *Note:*
  that since Puppet 5.4.0 the  built-in
  [`module_directory`](https://puppet.com/docs/puppet/latest/function.html#module_directory)
  function in Puppet does the same thing and will return the path to the first found module
  if given multiple values or an array.

#### Examples

##### Example Usage:

```puppet
$module_path = get_module_path('stdlib')
```

#### `get_module_path()`

> *Note:*
  that since Puppet 5.4.0 the  built-in
  [`module_directory`](https://puppet.com/docs/puppet/latest/function.html#module_directory)
  function in Puppet does the same thing and will return the path to the first found module
  if given multiple values or an array.

Returns: `Any` Returns the absolute path of the specified module for the current
environment.

##### Examples

###### Example Usage:

```puppet
$module_path = get_module_path('stdlib')
```

### getparam

Type: Ruby 3.x API

Takes a resource reference and name of the parameter and
returns value of resource's parameter. Note that user defined
resource types are evaluated lazily.

Would notice: 'the value we are getting in this example'

> **Note** that since Puppet 4.0.0 it is possible to get a parameter value by using its data type
and the [ ] operator. The example below is equivalent to a call to getparam():
  ```Example_resource['example_resource_instance']['param']``

#### Examples

##### Example Usage:

```puppet

# define a resource type with a parameter
define example_resource($param) {
}

# declare an instance of that type
example_resource { "example_resource_instance":
    param => "'the value we are getting in this example''"
}

# Because of order of evaluation, a second definition is needed
# that will be evaluated after the first resource has been declared
#
define example_get_param {
  # This will notice the value of the parameter
  notice(getparam(Example_resource["example_resource_instance"], "param"))
}

# Declare an instance of the second resource type - this will call notice
example_get_param { 'show_notify': }
```

#### `getparam()`

Takes a resource reference and name of the parameter and
returns value of resource's parameter. Note that user defined
resource types are evaluated lazily.

Would notice: 'the value we are getting in this example'

> **Note** that since Puppet 4.0.0 it is possible to get a parameter value by using its data type
and the [ ] operator. The example below is equivalent to a call to getparam():
  ```Example_resource['example_resource_instance']['param']``

Returns: `Any` value of a resource's parameter.

##### Examples

###### Example Usage:

```puppet

# define a resource type with a parameter
define example_resource($param) {
}

# declare an instance of that type
example_resource { "example_resource_instance":
    param => "'the value we are getting in this example''"
}

# Because of order of evaluation, a second definition is needed
# that will be evaluated after the first resource has been declared
#
define example_get_param {
  # This will notice the value of the parameter
  notice(getparam(Example_resource["example_resource_instance"], "param"))
}

# Declare an instance of the second resource type - this will call notice
example_get_param { 'show_notify': }
```

### getvar

Type: Ruby 3.x API

> **Note:** from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function. The new function also has support for
digging into a structured value. See the built-in
[`getvar`](https://puppet.com/docs/puppet/latest/function.html#getvar) funct

#### Examples

##### Example usage

```puppet
$foo = getvar('site::data::foo') # Equivalent to $foo = $site::data::foo
```

##### Where namespace is stored in a string

```puppet
$datalocation = 'site::data'
$bar = getvar("${datalocation}::bar") # Equivalent to $bar = $site::data::bar
```

#### `getvar()`

> **Note:** from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function. The new function also has support for
digging into a structured value. See the built-in
[`getvar`](https://puppet.com/docs/puppet/latest/function.html#getvar) funct

Returns: `Any` undef - if variable does not exist

##### Examples

###### Example usage

```puppet
$foo = getvar('site::data::foo') # Equivalent to $foo = $site::data::foo
```

###### Where namespace is stored in a string

```puppet
$datalocation = 'site::data'
$bar = getvar("${datalocation}::bar") # Equivalent to $bar = $site::data::bar
```

### glob

Type: Ruby 3.x API

Uses same patterns as Dir#glob.

#### Examples

##### Example Usage:

```puppet
$confs = glob(['/etc/**/*.conf', '/opt/**/*.conf'])
```

#### `glob()`

The glob function.

Returns: `Any` Returns an Array of file entries of a directory or an Array of directories.

##### Examples

###### Example Usage:

```puppet
$confs = glob(['/etc/**/*.conf', '/opt/**/*.conf'])
```

### grep

Type: Ruby 3.x API

> **Note:** that since Puppet 4.0.0, the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function does
the "same" - as any logic can be used to filter, as opposed to just regular expressions:
```['aaa', 'bbb', 'ccc', 'aaaddd']. filter |$x| { $x =~ 'aaa' }```

#### Examples

##### Example Usage:

```puppet
grep(['aaa','bbb','ccc','aaaddd'], 'aaa') # Returns ['aaa','aaaddd']
```

#### `grep()`

> **Note:** that since Puppet 4.0.0, the built-in
[`filter`](https://puppet.com/docs/puppet/latest/function.html#filter) function does
the "same" - as any logic can be used to filter, as opposed to just regular expressions:
```['aaa', 'bbb', 'ccc', 'aaaddd']. filter |$x| { $x =~ 'aaa' }```

Returns: `Any` array of elements that match the provided regular expression.

##### Examples

###### Example Usage:

```puppet
grep(['aaa','bbb','ccc','aaaddd'], 'aaa') # Returns ['aaa','aaaddd']
```

### has_interface_with

Type: Ruby 3.x API

Valid kinds are `macaddress`, `netmask`, `ipaddress` and `network`.

#### Examples

##### **Usage**

```puppet
has_interface_with("macaddress", "x:x:x:x:x:x") # Returns `false`
has_interface_with("ipaddress", "127.0.0.1") # Returns `true`
```

##### If no "kind" is given, then the presence of the interface is checked:

```puppet
has_interface_with("lo") # Returns `true`
```

#### `has_interface_with()`

Valid kinds are `macaddress`, `netmask`, `ipaddress` and `network`.

Returns: `Any` boolean values `true` or `false`

##### Examples

###### **Usage**

```puppet
has_interface_with("macaddress", "x:x:x:x:x:x") # Returns `false`
has_interface_with("ipaddress", "127.0.0.1") # Returns `true`
```

###### If no "kind" is given, then the presence of the interface is checked:

```puppet
has_interface_with("lo") # Returns `true`
```

### has_ip_address

Type: Ruby 3.x API

This function iterates through the 'interfaces' fact and checks the
'ipaddress_IFACE' facts, performing a simple string comparison.

#### `has_ip_address()`

This function iterates through the 'interfaces' fact and checks the
'ipaddress_IFACE' facts, performing a simple string comparison.

Returns: `Boolean` `true` or `false`

### has_ip_network

Type: Ruby 3.x API

This function iterates through the 'interfaces' fact and checks the
'network_IFACE' facts, performing a simple string comparision.

#### `has_ip_network()`

This function iterates through the 'interfaces' fact and checks the
'network_IFACE' facts, performing a simple string comparision.

Returns: `Any` Boolean value, `true` if the client has an IP address within the requested network.

### has_key

Type: Ruby 3.x API

> **Note:** **Deprecated** since Puppet 4.0.0, this can now be achieved in the Puppet
language with the following equivalent expression:
$my_hash = {'key_one' => 'value_one'}
if 'key_one' in $my_hash {
  notice('this will be printed')

#### Examples

##### Example Usage:

```puppet

$my_hash = {'key_one' => 'value_one'}
if has_key($my_hash, 'key_two') {
  notice('we will not reach here')
}
if has_key($my_hash, 'key_one') {
  notice('this will be printed')
}
```

#### `has_key()`

> **Note:** **Deprecated** since Puppet 4.0.0, this can now be achieved in the Puppet
language with the following equivalent expression:
$my_hash = {'key_one' => 'value_one'}
if 'key_one' in $my_hash {
  notice('this will be printed')

Returns: `Any` Boolean value

##### Examples

###### Example Usage:

```puppet

$my_hash = {'key_one' => 'value_one'}
if has_key($my_hash, 'key_two') {
  notice('we will not reach here')
}
if has_key($my_hash, 'key_one') {
  notice('this will be printed')
}
```

### hash

Type: Ruby 3.x API

> **Note:** This function has been replaced with the built-in ability to create a new value of almost any
data type - see the built-in [`Hash.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-hash-and-struct) function
in Puppet.
This example shows the equivalent expression in the Puppet language:
  ```
  Hash(['a',1,'b',2,'c',3])
  Hash([['a',1],['b',2],['c',3]])
  ```

#### Examples

##### Example Usage:

```puppet
hash(['a',1,'b',2,'c',3]) # Returns: {'a'=>1,'b'=>2,'c'=>3}
```

#### `hash()`

> **Note:** This function has been replaced with the built-in ability to create a new value of almost any
data type - see the built-in [`Hash.new`](https://puppet.com/docs/puppet/latest/function.html#conversion-to-hash-and-struct) function
in Puppet.
This example shows the equivalent expression in the Puppet language:
  ```
  Hash(['a',1,'b',2,'c',3])
  Hash([['a',1],['b',2],['c',3]])
  ```

Returns: `Any` the converted array as a hash

##### Examples

###### Example Usage:

```puppet
hash(['a',1,'b',2,'c',3]) # Returns: {'a'=>1,'b'=>2,'c'=>3}
```

### intersection

Type: Ruby 3.x API

This function returns an array of the intersection of two.

#### Examples

##### Example Usage:

```puppet
intersection(["a","b","c"],["b","c","d"])  # returns ["b","c"]
intersection(["a","b","c"],[1,2,3,4])      # returns [] (true, when evaluated as a Boolean)
```

#### `intersection()`

The intersection function.

Returns: `Any` an array of the intersection of two.

##### Examples

###### Example Usage:

```puppet
intersection(["a","b","c"],["b","c","d"])  # returns ["b","c"]
intersection(["a","b","c"],[1,2,3,4])      # returns [] (true, when evaluated as a Boolean)
```

### is_a

Type: Ruby 4.x API

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

#### Examples

##### Example Usage:

```puppet
# check a data type
  foo = 3
  $bar = [1,2,3]
  $baz = 'A string!'

  if $foo.is_a(Integer) {
    notify  { 'foo!': }
  }
  if $bar.is_a(Array) {
    notify { 'bar!': }
  }
  if $baz.is_a(String) {
    notify { 'baz!': }
  }
```

#### `is_a(Any $value, Type $type)`

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

Returns: `Boolean` Return's `true` or `false`.

##### Examples

###### Example Usage:

```puppet
# check a data type
  foo = 3
  $bar = [1,2,3]
  $baz = 'A string!'

  if $foo.is_a(Integer) {
    notify  { 'foo!': }
  }
  if $bar.is_a(Array) {
    notify { 'bar!': }
  }
  if $baz.is_a(String) {
    notify { 'baz!': }
  }
```

##### `value`

Data type: `Any`

The value to be checked

##### `type`

Data type: `Type`

The expected type

### is_absolute_path

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_absolute_path(Any $scope, Any *$args)`

The is_absolute_path function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_absolute_path

Type: Ruby 3.x API

This function works for windows and unix style paths.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_leg

#### Examples

##### The following values will return true:

```puppet
$my_path = 'C:/Program Files (x86)/Puppet Labs/Puppet'
is_absolute_path($my_path)
$my_path2 = '/var/lib/puppet'
is_absolute_path($my_path2)
$my_path3 = ['C:/Program Files (x86)/Puppet Labs/Puppet']
is_absolute_path($my_path3)
$my_path4 = ['/var/lib/puppet']
is_absolute_path($my_path4)
```

##### The following values will return false:

```puppet
is_absolute_path(true)
is_absolute_path('../var/lib/puppet')
is_absolute_path('var/lib/puppet')
$undefined = undef
is_absolute_path($undefined)
```

#### `is_absolute_path()`

This function works for windows and unix style paths.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_leg

Returns: `Boolean` Returns `true` or `false`

##### Examples

###### The following values will return true:

```puppet
$my_path = 'C:/Program Files (x86)/Puppet Labs/Puppet'
is_absolute_path($my_path)
$my_path2 = '/var/lib/puppet'
is_absolute_path($my_path2)
$my_path3 = ['C:/Program Files (x86)/Puppet Labs/Puppet']
is_absolute_path($my_path3)
$my_path4 = ['/var/lib/puppet']
is_absolute_path($my_path4)
```

###### The following values will return false:

```puppet
is_absolute_path(true)
is_absolute_path('../var/lib/puppet')
is_absolute_path('var/lib/puppet')
$undefined = undef
is_absolute_path($undefined)
```

### is_array

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_array()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_array

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_array(Any $scope, Any *$args)`

The is_array function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_bool

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_bool(Any $scope, Any *$args)`

The is_bool function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_bool

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_bool()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_domain_name

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_domain_name()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_email_address

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_email_address()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_float

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_float()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_float

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_float(Any $scope, Any *$args)`

The is_float function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_function_available

Type: Ruby 3.x API

This function accepts a string as an argument.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_function_available()`

This function accepts a string as an argument.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_hash

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_hash()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_integer

Type: Ruby 3.x API

The string may start with a '-' (minus). A value of '0' is allowed, but a leading '0'
digit may not be followed by other digits as this indicates that the value is octal (base 8).

If given any other argument `false` is returned.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_integer()`

The string may start with a '-' (minus). A value of '0' is allowed, but a leading '0'
digit may not be followed by other digits as this indicates that the value is octal (base 8).

If given any other argument `false` is returned.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_ip_address

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_ip_address(Any $scope, Any *$args)`

The is_ip_address function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_ip_address

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_ip_address()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_ipv4_address

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_ipv4_address()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_ipv4_address

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_ipv4_address(Any $scope, Any *$args)`

The is_ipv4_address function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_ipv6_address

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_ipv6_address(Any $scope, Any *$args)`

The is_ipv6_address function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_ipv6_address

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_ipv6_address()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_mac_address

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_mac_address()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_numeric

Type: Ruby 3.x API

Returns true if the given argument is a Numeric (Integer or Float),
or a String containing either a valid integer in decimal base 10 form, or
a valid floating point string representation.

The function recognizes only decimal (base 10) integers and float but not
integers in hex (base 16) or octal (base 8) form.

The string representation may start with a '-' (minus). If a decimal '.' is used,
it must be followed by at least one digit.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_numeric()`

Returns true if the given argument is a Numeric (Integer or Float),
or a String containing either a valid integer in decimal base 10 form, or
a valid floating point string representation.

The function recognizes only decimal (base 10) integers and float but not
integers in hex (base 16) or octal (base 8) form.

The string representation may start with a '-' (minus). If a decimal '.' is used,
it must be followed by at least one digit.

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_numeric

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_numeric(Any $scope, Any *$args)`

The is_numeric function.

Returns: `Boolea` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### is_string

Type: Ruby 3.x API

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

#### `is_string()`

> **Note:* **Deprecated** Will be removed in a future version of stdlib. See
[`validate_legacy`](#validate_legacy).

Returns: `Boolean` Returns `true` or `false`

### is_string

Type: Ruby 4.x API

Wrapper that calls the Puppet 3.x function of the same name.

#### `is_string(Any $scope, Any *$args)`

The is_string function.

Returns: `Boolean` A boolean value returned from the called 3.x function.

##### `scope`

Data type: `Any`

The main value that will be passed to the wrapped method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the wrapped method

### join

Type: Ruby 3.x API

> **Note:** **Deprecated** from Puppet 5.4.0 this function has been replaced
with a built-in [`join`](https://puppet.com/docs/puppet/latest/function.html#join) function.

#### Examples

##### Example Usage:

```puppet
join(['a','b','c'], ",") # Results in: "a,b,c"
```

#### `join()`

> **Note:** **Deprecated** from Puppet 5.4.0 this function has been replaced
with a built-in [`join`](https://puppet.com/docs/puppet/latest/function.html#join) function.

Returns: `String` The String containing each of the array values

##### Examples

###### Example Usage:

```puppet
join(['a','b','c'], ",") # Results in: "a,b,c"
```

### join_keys_to_values

Type: Ruby 3.x API

Keys are cast to strings. If values are arrays, multiple keys
are added for each element. The return value is an array in
which each element is one joined key/value pair.

> **Note:** Since Puppet 5.0.0 - for more detailed control over the formatting (including indentations and
line breaks, delimiters around arrays and hash entries, between key/values in hash entries, and individual
formatting of values in the array) - see the `new` function for `String` and its formatting
options for `Array` and `Hash`.

#### Examples

##### Example Usage:

```puppet
join_keys_to_values({'a'=>1,'b'=>2}, " is ") # Results in: ["a is 1","b is 2"]
join_keys_to_values({'a'=>1,'b'=>[2,3]}, " is ") # Results in: ["a is 1","b is 2","b is 3"]
```

#### `join_keys_to_values()`

Keys are cast to strings. If values are arrays, multiple keys
are added for each element. The return value is an array in
which each element is one joined key/value pair.

> **Note:** Since Puppet 5.0.0 - for more detailed control over the formatting (including indentations and
line breaks, delimiters around arrays and hash entries, between key/values in hash entries, and individual
formatting of values in the array) - see the `new` function for `String` and its formatting
options for `Array` and `Hash`.

Returns: `Hash` The joined hash

##### Examples

###### Example Usage:

```puppet
join_keys_to_values({'a'=>1,'b'=>2}, " is ") # Results in: ["a is 1","b is 2"]
join_keys_to_values({'a'=>1,'b'=>[2,3]}, " is ") # Results in: ["a is 1","b is 2","b is 3"]
```

### keys

Type: Ruby 3.x API

> **Note:** **Deprecated** from Puppet 5.5.0, the built-in [`keys`](https://puppet.com/docs/puppet/latest/function.html#keys)
function will be used instead of this function.

#### `keys()`

> **Note:** **Deprecated** from Puppet 5.5.0, the built-in [`keys`](https://puppet.com/docs/puppet/latest/function.html#keys)
function will be used instead of this function.

Returns: `Array` An array containing each of the hashes key values.

### length

Type: Ruby 4.x API

The original size() function did not handle Puppets new type capabilities, so this function
is a Puppet 4 compatible solution.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`length`](https://puppet.com/docs/puppet/latest/function.html#length) function.

#### `length(Variant[String,Array,Hash] $value)`

The original size() function did not handle Puppets new type capabilities, so this function
is a Puppet 4 compatible solution.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`length`](https://puppet.com/docs/puppet/latest/function.html#length) function.

Returns: `Integer` The length of the given object

##### `value`

Data type: `Variant[String,Array,Hash]`

The value whose length is to be found

### load_module_metadata

Type: Ruby 3.x API

This function loads the metadata of a given module.

#### Examples

##### Example USage:

```puppet
$metadata = load_module_metadata('archive')
notify { $metadata['author']: }
```

#### `load_module_metadata()`

The load_module_metadata function.

Returns: `Any` The modules metadata

##### Examples

###### Example USage:

```puppet
$metadata = load_module_metadata('archive')
notify { $metadata['author']: }
```

### loadjson

Type: Ruby 3.x API

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

#### Examples

##### Example Usage:

```puppet
$myhash = loadjson('/etc/puppet/data/myhash.json')
$myhash = loadjson('https://example.local/my_hash.json')
$myhash = loadjson('https://username:password@example.local/my_hash.json')
$myhash = loadjson('no-file.json', {'default' => 'val
```

#### `loadjson()`

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

Returns: `Array|String|Hash` The data stored in the JSON file, the type depending on the type of data that was stored.

##### Examples

###### Example Usage:

```puppet
$myhash = loadjson('/etc/puppet/data/myhash.json')
$myhash = loadjson('https://example.local/my_hash.json')
$myhash = loadjson('https://username:password@example.local/my_hash.json')
$myhash = loadjson('no-file.json', {'default' => 'val
```

### loadyaml

Type: Ruby 3.x API

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

#### Examples

##### Example Usage:

```puppet
$myhash = loadyaml('/etc/puppet/data/myhash.yaml')
$myhash = loadyaml('https://example.local/my_hash.yaml')
$myhash = loadyaml('https://username:password@example.local/my_hash.yaml')
$myhash = loadyaml('no-file.yaml', {'default' => 'val
```

#### `loadyaml()`

The first parameter can be a file path or a URL.
The second parameter is the default value. It will be returned if the file
was not found or could not be parsed.

Returns: `Array|String|Hash` The data stored in the YAML file, the type depending on the type of data that was stored.

##### Examples

###### Example Usage:

```puppet
$myhash = loadyaml('/etc/puppet/data/myhash.yaml')
$myhash = loadyaml('https://example.local/my_hash.yaml')
$myhash = loadyaml('https://username:password@example.local/my_hash.yaml')
$myhash = loadyaml('no-file.yaml', {'default' => 'val
```

### lstrip

Type: Ruby 3.x API

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`max`](https://puppet.com/docs/puppet/latest/function.html#max) function.

#### `lstrip()`

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`max`](https://puppet.com/docs/puppet/latest/function.html#max) function.

Returns: `String` The stripped string

### max

Type: Ruby 3.x API

Requires at least one argument.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`lstrip`](https://puppet.com/docs/puppet/latest/function.html#lstrip) function.

#### `max()`

Requires at least one argument.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`lstrip`](https://puppet.com/docs/puppet/latest/function.html#lstrip) function.

Returns: `Any` The highest value among those passed in

### member

Type: Ruby 3.x API

The variable can be a string, fixnum, or array.

> **Note**: This function does not support nested arrays. If the first argument contains
nested arrays, it will not recurse through them.

> *Note:*
Since Puppet 4.0.0 the same can be performed in the Puppet language.
For single values the operator `in` can be used:
`'a' in ['a', 'b']  # true`
For arrays by using operator `-` to compute a diff:
`['d', 'b'] - ['a', 'b', 'c'] == []  # false because 'd' is not subtracted`
`['a', 'b'] - ['a', 'b', 'c'] == []  # true because both 'a' and 'b' are subtracted`

> **Note** that since Puppet 5.2.0, the general form to test the content of an array or
hash is to use the built-in [`any`](https://puppet.com/docs/puppet/latest/function.html#any)
and [`all`](https://puppet.com/docs/puppet/latest/function.html#all) functions.

#### Examples

##### **Usage**

```puppet
member(['a','b'], 'b') # Returns: true
member(['a', 'b', 'c'], ['a', 'b']) # Returns: true
member(['a','b'], 'c') # Returns: false
member(['a', 'b', 'c'], ['d', 'b']) # Returns: false
```

#### `member()`

The variable can be a string, fixnum, or array.

> **Note**: This function does not support nested arrays. If the first argument contains
nested arrays, it will not recurse through them.

> *Note:*
Since Puppet 4.0.0 the same can be performed in the Puppet language.
For single values the operator `in` can be used:
`'a' in ['a', 'b']  # true`
For arrays by using operator `-` to compute a diff:
`['d', 'b'] - ['a', 'b', 'c'] == []  # false because 'd' is not subtracted`
`['a', 'b'] - ['a', 'b', 'c'] == []  # true because both 'a' and 'b' are subtracted`

> **Note** that since Puppet 5.2.0, the general form to test the content of an array or
hash is to use the built-in [`any`](https://puppet.com/docs/puppet/latest/function.html#any)
and [`all`](https://puppet.com/docs/puppet/latest/function.html#all) functions.

Returns: `Any` Returns whether the given value was a member of the array

##### Examples

###### **Usage**

```puppet
member(['a','b'], 'b') # Returns: true
member(['a', 'b', 'c'], ['a', 'b']) # Returns: true
member(['a','b'], 'c') # Returns: false
member(['a', 'b', 'c'], ['d', 'b']) # Returns: false
```

### merge

Type: Ruby 3.x API

When there is a duplicate key, the key in the rightmost hash will "win."

Note that since Puppet 4.0.0 the same merge can be achieved with the + operator.
  `$merged_hash = $hash1 + $has

#### Examples

##### **Usage**

```puppet
$hash1 = {'one' => 1, 'two', => 2}
$hash2 = {'two' => 'dos', 'three', => 'tres'}
$merged_hash = merge($hash1, $hash2) # $merged_hash =  {'one' => 1, 'two' => 'dos', 'three' => 'tres'}
```

#### `merge()`

When there is a duplicate key, the key in the rightmost hash will "win."

Note that since Puppet 4.0.0 the same merge can be achieved with the + operator.
  `$merged_hash = $hash1 + $has

Returns: `Hash` The merged hash

##### Examples

###### **Usage**

```puppet
$hash1 = {'one' => 1, 'two', => 2}
$hash2 = {'two' => 'dos', 'three', => 'tres'}
$merged_hash = merge($hash1, $hash2) # $merged_hash =  {'one' => 1, 'two' => 'dos', 'three' => 'tres'}
```

### merge

Type: Ruby 4.x API

When there is a duplicate key, the key in the rightmost hash will "win."

Note that since Puppet 4.0.0 the same merge can be achieved with the + operator.
 `$merged_hash = $hash1 + $hash2`

If merge is given a single Iterable (Array, Hash, etc.) it will call a given block with
up to three parameters, and merge each resulting Hash into the accumulated result. All other types
of values returned from the block (typically undef) are skipped (not merged).

The codeblock can take 2 or three parameters:
* with two, it gets the current hash (as built to this point), and each value (for hash the value is a [key, value] tuple)
* with three, it gets the current hash (as built to this point), the key/index of each value, and then the value

If the iterable is empty, or no hash was returned from the given block, an empty hash is returned. In the given block, a call to `next()`
will skip that entry, and a call to `break()` will end the iteration.

The iterative `merge()` has an advantage over doing the same with a general `reduce()` in that the constructed hash
does not have to be copied in each iteration and thus will perform much better with large inputs.

#### Examples

##### Using merge()

```puppet
$hash1 = {'one' => 1, 'two', => 2}
$hash2 = {'two' => 'dos', 'three', => 'tres'}
$merged_hash = merge($hash1, $hash2) # $merged_hash =  {'one' => 1, 'two' => 'dos', 'three' => 'tres'}
```

##### counting occurrences of strings in an array

```puppet
['a', 'b', 'c', 'c', 'd', 'b'].merge | $hsh, $v | { { $v => $hsh[$v].lest || { 0 } + 1 } } # results in { a => 1, b => 2, c => 2, d => 1 }
```

##### skipping values for entries that are longer than 1 char

```puppet
['a', 'b', 'c', 'c', 'd', 'b', 'blah', 'blah'].merge | $hsh, $v | { if $v =~ String[1,1] { { $v => $hsh[$v].lest || { 0 } + 1 } } } # results in { a => 1, b => 2, c => 2, d => 1 }
```

#### `merge(Variant[Hash, Undef, String[0,0]] *$args)`

The merge function.

Returns: `Hash` The merged hash

##### `*args`

Data type: `Variant[Hash, Undef, String[0,0]]`

Repeated Param - The hashes that are to be merged

#### `merge(Iterable *$args, Callable[3,3] &$block)`

The merge function.

Returns: `Hash` The merged hash

##### `*args`

Data type: `Iterable`

Repeated Param - The hashes that are to be merged

##### `&block`

Data type: `Callable[3,3]`

A block placed on the repeatable param `args`

#### `merge(Iterable *$args, Callable[2,2] &$block)`

The merge function.

Returns: `Hash` The merged hash

##### `*args`

Data type: `Iterable`

Repeated Param - The hashes that are to be merged

##### `&block`

Data type: `Callable[2,2]`

A block placed on the repeatable param `args`

### min

Type: Ruby 3.x API

Requires at least one argument.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`min`](https://puppet.com/docs/puppet/latest/function.html#min) function.

#### `min()`

Requires at least one argument.

> **Note:** **Deprecated** from Puppet 6.0.0, this function has been replaced with a
built-in [`min`](https://puppet.com/docs/puppet/latest/function.html#min) function.

Returns: `Any` The lowest value among the given arguments

### num2bool

Type: Ruby 3.x API

> *Note:* that since Puppet 5.0.0 the same can be achieved with the Puppet Type System.
See the new() function in Puppet for the many available type conversions.

#### `num2bool()`

> *Note:* that since Puppet 5.0.0 the same can be achieved with the Puppet Type System.
See the new() function in Puppet for the many available type conversions.

Returns: `Boolean` Boolean(0) # false for any zero or negative number
Boolean(1) # true for any positive number

### os_version_gte

Type: Ruby 4.x API

> *Note:*
Only the major version is taken into account.

#### Examples

##### Example usage:#

```puppet
if os_version_gte('Debian', '9') { }
if os_version_gte('Ubuntu', '18.04') { }
```

#### `os_version_gte(String[1] $os, String[1] $version)`

> *Note:*
Only the major version is taken into account.

Returns: `Boolean` `true` or `false

##### Examples

###### Example usage:#

```puppet
if os_version_gte('Debian', '9') { }
if os_version_gte('Ubuntu', '18.04') { }
```

##### `os`

Data type: `String[1]`

operating system

##### `version`

Data type: `String[1]`



### parsejson

Type: Ruby 3.x API

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of YAML string have failed.

#### `parsejson()`

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of YAML string have failed.

Returns: `Any` convert JSON into Puppet structure

### parseyaml

Type: Ruby 3.x API

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of YAML string have failed.

#### `parseyaml()`

> *Note:*
  The optional second argument can be used to pass a default value that will
  be returned if the parsing of YAML string have failed.

Returns: `Any` converted YAML into Puppet structure

### pick

Type: Ruby 3.x API

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the following:

```$real_jenkins_version = pick($::jenkins_version, '1.449')```

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

#### `pick()`

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the following:

```$real_jenkins_version = pick($::jenkins_version, '1.449')```

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

Returns: `Any` the first value in a list of values that is not undefined or an empty string.

### pick_default

Type: Ruby 3.x API

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the
following:

  $real_jenkins_version = pick_default($::jenkins_version, '1.449')

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

  Contrary to the pick() function, the pick_default does not fail if
  all arguments are empty. This allows pick_default to use an empty value as
  default.

#### `pick_default()`

Typically, this function is used to check for a value in the Puppet
Dashboard/Enterprise Console, and failover to a default value like the
following:

  $real_jenkins_version = pick_default($::jenkins_version, '1.449')

> *Note:*
  The value of $real_jenkins_version will first look for a top-scope variable
  called 'jenkins_version' (note that parameters set in the Puppet Dashboard/
  Enterprise Console are brought into Puppet as top-scope variables), and,
  failing that, will use a default value of 1.449.

  Contrary to the pick() function, the pick_default does not fail if
  all arguments are empty. This allows pick_default to use an empty value as
  default.

Returns: `Any` This function is similar to a coalesce function in SQL in that it will return
the first value in a list of values that is not undefined or an empty string
If no value is found, it will return the last argument.

### prefix

Type: Ruby 3.x API

> *Note:* since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:
['a', 'b', 'c'].map |$x| { "p${x}" }

#### Examples

##### **Usage**

```puppet

prefix(['a','b','c'], 'p')
Will return: ['pa','pb','pc']
```

#### `prefix()`

> *Note:* since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:
['a', 'b', 'c'].map |$x| { "p${x}" }

Returns: `Hash` or [Array] The passed values now contains the passed prefix

##### Examples

###### **Usage**

```puppet

prefix(['a','b','c'], 'p')
Will return: ['pa','pb','pc']
```

### private

Type: Ruby 3.x API

**Deprecated:** Sets the current class or definition as private.
Calling the class or definition from outside the current module will fail.

#### `private()`

The private function.

Returns: `Any` Sets the current class or definition as private

### pry

Type: Ruby 3.x API

This is useful for debugging manifest code at specific points during a compilation.

#### Examples

##### **Usage**

```puppet

`pry()`
```

#### `pry()`

This is useful for debugging manifest code at specific points during a compilation.

Returns: `Any` debugging information

##### Examples

###### **Usage**

```puppet

`pry()`
```

### pw_hash

Type: Ruby 3.x API

The first argument to this function is the password to hash. If it is
undef or an empty string, this function returns undef.

The second argument to this function is which type of hash to use. It
will be converted into the appropriate crypt(3) hash specifier. Valid
hash types are:

|Hash type            |Specifier|
|---------------------|---------|
|MD5                  |1        |
|SHA-256              |5        |
|SHA-512 (recommended)|6        |

The third argument to this function is the salt to use.

> *Note:*: this uses the Puppet Master's implementation of crypt(3). If your
  environment contains several different operating systems, ensure that they
  are compatible before using this function.

#### `pw_hash()`

The first argument to this function is the password to hash. If it is
undef or an empty string, this function returns undef.

The second argument to this function is which type of hash to use. It
will be converted into the appropriate crypt(3) hash specifier. Valid
hash types are:

|Hash type            |Specifier|
|---------------------|---------|
|MD5                  |1        |
|SHA-256              |5        |
|SHA-512 (recommended)|6        |

The third argument to this function is the salt to use.

> *Note:*: this uses the Puppet Master's implementation of crypt(3). If your
  environment contains several different operating systems, ensure that they
  are compatible before using this function.

Returns: `Hash` Provides a hash usable on most POSIX systems.

### range

Type: Ruby 3.x API

NB Be explicit in including trailing zeros. Otherwise the underlying ruby function will fail.

> *Note:*
  Passing a third argument will cause the generated range to step by that
  interval, e.g.

The Puppet Language support Integer and Float ranges by using the type system. Those are suitable for
iterating a given number of times.

 Integer[0, 9].each |$x| { notice($x) } # notices 0, 1, 2, ... 9

#### Examples

##### **Usage**

```puppet
range("0", "9")
Will return: [0,1,2,3,4,5,6,7,8,9]

range("00", "09")
Will return: [0,1,2,3,4,5,6,7,8,9]
(Zero padded strings are converted to integers automatically)

range("a", "c")
Will return: ["a","b","c"]

range("host01", "host10")
Will return: ["host01", "host02", ..., "host09", "host10"]

range("0", "9", "2")
Will return: [0,2,4,6,8]
```

#### `range()`

NB Be explicit in including trailing zeros. Otherwise the underlying ruby function will fail.

> *Note:*
  Passing a third argument will cause the generated range to step by that
  interval, e.g.

The Puppet Language support Integer and Float ranges by using the type system. Those are suitable for
iterating a given number of times.

 Integer[0, 9].each |$x| { notice($x) } # notices 0, 1, 2, ... 9

Returns: `Any` the range is extrapolated as an array

##### Examples

###### **Usage**

```puppet
range("0", "9")
Will return: [0,1,2,3,4,5,6,7,8,9]

range("00", "09")
Will return: [0,1,2,3,4,5,6,7,8,9]
(Zero padded strings are converted to integers automatically)

range("a", "c")
Will return: ["a","b","c"]

range("host01", "host10")
Will return: ["host01", "host02", ..., "host09", "host10"]

range("0", "9", "2")
Will return: [0,2,4,6,8]
```

### regexpescape

Type: Ruby 3.x API

Regexp escape a string or array of strings.
Requires either a single string or an array as an input.

#### `regexpescape()`

The regexpescape function.

Returns: `String` A string of characters with metacharacters converted to their escaped form.

### reject

Type: Ruby 3.x API

> *Note:*
Since Puppet 4.0.0 the same is in general done with the filter function. Here is the equivalence of the reject() function:
['aaa','bbb','ccc','aaaddd'].filter |$x| { $x !~

#### Examples

##### **Usage**

```puppet

reject(['aaa','bbb','ccc','aaaddd'], 'aaa')

Would return: ['bbb','ccc']
```

#### `reject()`

> *Note:*
Since Puppet 4.0.0 the same is in general done with the filter function. Here is the equivalence of the reject() function:
['aaa','bbb','ccc','aaaddd'].filter |$x| { $x !~

Returns: `Any` an array containing all the elements which doesn'' match the provided regular expression

##### Examples

###### **Usage**

```puppet

reject(['aaa','bbb','ccc','aaaddd'], 'aaa')

Would return: ['bbb','ccc']
```

### reverse

Type: Ruby 3.x API

> *Note:* that the same can be done with the reverse_each() function in Puppet.

#### `reverse()`

> *Note:* that the same can be done with the reverse_each() function in Puppet.

Returns: `Any` reversed string or array

### round

Type: Ruby 3.x API

```round(2.9)``` returns ```3```

```round(2.4)``` returns ```2```

> *Note:* from Puppet 6.0.0, the compatible function with the same name in Puppet core
  will be used instead of this function.

#### `round()`

```round(2.9)``` returns ```3```

```round(2.4)``` returns ```2```

> *Note:* from Puppet 6.0.0, the compatible function with the same name in Puppet core
  will be used instead of this function.

Returns: `Any` the rounded value as integer

### rstrip

Type: Ruby 3.x API

> *Note:* from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function.

#### `rstrip()`

> *Note:* from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function.

Returns: `Any` the string with leading spaces removed

### seeded_rand

Type: Ruby 3.x API

Generates a random whole number greater than or equal to 0 and less
than MAX, using the value of SEED for repeatable randomness.  If SEED
starts with "$fqdn:", this is behaves the same as `fqdn_rand`.

#### Examples

##### **Usage:**

```puppet
seeded_rand(MAX, SEED).
MAX must be a positive integer; SEED is any string.
```

#### `seeded_rand()`

Generates a random whole number greater than or equal to 0 and less
than MAX, using the value of SEED for repeatable randomness.  If SEED
starts with "$fqdn:", this is behaves the same as `fqdn_rand`.

Returns: `Any` random number greater than or equal to 0 and less than MAX

##### Examples

###### **Usage:**

```puppet
seeded_rand(MAX, SEED).
MAX must be a positive integer; SEED is any string.
```

### seeded_rand_string

Type: Ruby 4.x API

Generates a consistent random string of specific length based on provided seed.

#### Examples

##### Generate a consistently random string of length 8 with a seed:

```puppet
seeded_rand_string(8, "${module_name}::redis_password")
```

##### Generate a random string from a specific set of characters:

```puppet
seeded_rand_string(5, '', 'abcdef')
```

#### `seeded_rand_string(Integer[1] $length, String $seed, Optional[String[2]] $charset)`

The seeded_rand_string function.

Returns: `String` Random string.

##### Examples

###### Generate a consistently random string of length 8 with a seed:

```puppet
seeded_rand_string(8, "${module_name}::redis_password")
```

###### Generate a random string from a specific set of characters:

```puppet
seeded_rand_string(5, '', 'abcdef')
```

##### `length`

Data type: `Integer[1]`

Length of string to be generated.

##### `seed`

Data type: `String`

Seed string.

##### `charset`

Data type: `Optional[String[2]]`

String that contains characters to use for the random string.

### shell_escape

Type: Ruby 3.x API

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

This function behaves the same as ruby's Shellwords.shellescape() function.

#### `shell_escape()`

>* Note:* that the resulting string should be used unquoted and is not intended for use in double quotes nor in single
quotes.

This function behaves the same as ruby's Shellwords.shellescape() function.

Returns: `Any` A string of characters with metacharacters converted to their escaped form.

### shell_join

Type: Ruby 3.x API

Builds a command line string from the given array of strings.
Each array item is escaped for Bourne shell. All items are then joined together, with a single space in between.
This function behaves the same as ruby's Shellwords.shelljoin() function

#### `shell_join()`

Builds a command line string from the given array of strings.
Each array item is escaped for Bourne shell. All items are then joined together, with a single space in between.
This function behaves the same as ruby's Shellwords.shelljoin() function

Returns: `Any` a command line string

### shell_split

Type: Ruby 3.x API

This function behaves the same as ruby's Shellwords.shellsplit() function

#### `shell_split()`

This function behaves the same as ruby's Shellwords.shellsplit() function

Returns: `Any` array of tokens

### shuffle

Type: Ruby 3.x API

@summary
 Randomizes the order of a string or array elements.

#### `shuffle()`

@summary
 Randomizes the order of a string or array elements.

Returns: `Any` randomized string or array

### size

Type: Ruby 3.x API

> *Note:* that since Puppet 5.4.0, the length() function in Puppet is preferred over this. For versions
of Puppet < 5.4.0 use the stdlib length() function.

#### `size()`

> *Note:* that since Puppet 5.4.0, the length() function in Puppet is preferred over this. For versions
of Puppet < 5.4.0 use the stdlib length() function.

Returns: `Any` the number of elements in a string, an array or a hash

### sort

Type: Ruby 3.x API

Note that from Puppet 6.0.0 the same function in Puppet will be used instead of this.

#### `sort()`

Note that from Puppet 6.0.0 the same function in Puppet will be used instead of this.

Returns: `Any` sorted string or array

### sprintf_hash

Type: Ruby 4.x API

The first parameter is format string describing how the rest of the parameters in the hash
should be formatted. See the documentation for the `Kernel::sprintf` function in Ruby for
all the details.

In the given argument hash with parameters, all keys are converted to symbols so they work
with the `sprintf` function.

Note that since Puppet 4.10.10, and 5.3.4 this functionality is supported by the
`sprintf` function in puppet core.

#### Examples

##### Format a string and number

```puppet
$output = sprintf_hash('String: %<foo>s / number converted to binary: %<number>b',
                       { 'foo' => 'a string', 'number' => 5 })
# $output = 'String: a string / number converted to binary: 101'
```

#### `sprintf_hash(String $format, Hash $arguments)`

The first parameter is format string describing how the rest of the parameters in the hash
should be formatted. See the documentation for the `Kernel::sprintf` function in Ruby for
all the details.

In the given argument hash with parameters, all keys are converted to symbols so they work
with the `sprintf` function.

Note that since Puppet 4.10.10, and 5.3.4 this functionality is supported by the
`sprintf` function in puppet core.

Returns: `Any` The formatted string.

##### Examples

###### Format a string and number

```puppet
$output = sprintf_hash('String: %<foo>s / number converted to binary: %<number>b',
                       { 'foo' => 'a string', 'number' => 5 })
# $output = 'String: a string / number converted to binary: 101'
```

##### `format`

Data type: `String`

The format to use.

##### `arguments`

Data type: `Hash`

Hash with parameters.

### squeeze

Type: Ruby 3.x API

Returns a new string where runs of the same character that occur in this set are replaced by a single character.

#### `squeeze()`

The squeeze function.

Returns: `Any` a new string where runs of the same character that occur in this set are replaced by a single character.

### stdlib::end_with

Type: Ruby 4.x API

@example
   'foobar'.stdlib::end_with('bar') => true
   'foobar'.stdlib::end_with('foo') => false
   'foobar'.stdlib::end_with(['foo', 'baz']) => false

#### `stdlib::end_with(String[1] $test_string, Variant[String[1],Array[String[1], 1]] $suffixes)`

@example
   'foobar'.stdlib::end_with('bar') => true
   'foobar'.stdlib::end_with('foo') => false
   'foobar'.stdlib::end_with(['foo', 'baz']) => false

Returns: `Boolean` True or False

##### `test_string`

Data type: `String[1]`

The string to check

##### `suffixes`

Data type: `Variant[String[1],Array[String[1], 1]]`

The suffixes to check

### stdlib::extname

Type: Ruby 4.x API

If Path is a Dotfile, or starts with a Period, then the starting Dot is not
dealt with the Start of the Extension.

An empty String will also be returned, when the Period is the last Character
in Path.

#### Examples

##### Determining the Extension of a Filename

```puppet
stdlib::extname('test.rb')       => '.rb'
stdlib::extname('a/b/d/test.rb') => '.rb'
stdlib::extname('test')          => ''
stdlib::extname('.profile')      => ''
```

#### `stdlib::extname(String $filename)`

If Path is a Dotfile, or starts with a Period, then the starting Dot is not
dealt with the Start of the Extension.

An empty String will also be returned, when the Period is the last Character
in Path.

Returns: `String` The Extension starting from the last Period

##### Examples

###### Determining the Extension of a Filename

```puppet
stdlib::extname('test.rb')       => '.rb'
stdlib::extname('a/b/d/test.rb') => '.rb'
stdlib::extname('test')          => ''
stdlib::extname('.profile')      => ''
```

##### `filename`

Data type: `String`

The Filename

### stdlib::ip_in_range

Type: Ruby 4.x API

Returns true if the ipaddress is within the given CIDRs

#### Examples

##### ip_in_range(<IPv4 Address>, <IPv4 CIDR>)

```puppet
stdlib::ip_in_range('10.10.10.53', '10.10.10.0/24') => true
```

#### `stdlib::ip_in_range(String $ipaddress, Variant[String, Array] $range)`

The stdlib::ip_in_range function.

Returns: `Boolean` True or False

##### Examples

###### ip_in_range(<IPv4 Address>, <IPv4 CIDR>)

```puppet
stdlib::ip_in_range('10.10.10.53', '10.10.10.0/24') => true
```

##### `ipaddress`

Data type: `String`

The IP address to check

##### `range`

Data type: `Variant[String, Array]`

One CIDR or an array of CIDRs
defining the range(s) to check against

### stdlib::start_with

Type: Ruby 4.x API

Returns true if str starts with one of the prefixes given. Each of the prefixes should be a String.

#### Examples

##### 

```puppet
'foobar'.stdlib::start_with('foo') => true
'foobar'.stdlib::start_with('bar') => false
'foObar'.stdlib::start_with(['bar', 'baz']) => false
```

#### `stdlib::start_with(String[1] $test_string, Variant[String[1],Array[String[1], 1]] $prefixes)`

The stdlib::start_with function.

Returns: `Boolean` True or False

##### Examples

###### 

```puppet
'foobar'.stdlib::start_with('foo') => true
'foobar'.stdlib::start_with('bar') => false
'foObar'.stdlib::start_with(['bar', 'baz']) => false
```

##### `test_string`

Data type: `String[1]`

The string to check

##### `prefixes`

Data type: `Variant[String[1],Array[String[1], 1]]`

The prefixes to check.

### str2bool

Type: Ruby 3.x API

> *Note:* that since Puppet 5.0.0 the Boolean data type can convert strings to a Boolean value.
See the function new() in Puppet for details what the Boolean data type supports.

#### `str2bool()`

> *Note:* that since Puppet 5.0.0 the Boolean data type can convert strings to a Boolean value.
See the function new() in Puppet for details what the Boolean data type supports.

Returns: `Any` This attempt to convert to boolean strings that contain things like: Y,y, 1, T,t, TRUE,true to 'true' and strings that contain things
like: 0, F,f, N,n, false, FALSE, no to 'false'.

### str2saltedpbkdf2

Type: Ruby 3.x API

Convert a string into a salted SHA512 PBKDF2 password hash like requred for OS X / macOS 10.8+.
Note, however, that Apple changes what's required periodically and this may not work for the latest
version of macOS. If that is the case you should get a helpful error message when Puppet tries to set
the pasword using the parameters you provide to the user resource.

#### Examples

##### Plain text password and salt

```puppet
$pw_info = str2saltedpbkdf2('Pa55w0rd', 'Using s0m3 s@lt', 50000)
user { 'jdoe':
  ensure     => present,
  iterations => $pw_info['interations'],
  password   => $pw_info['password_hex'],
  salt       => $pw_info['salt_hex'],
}
```

##### Sensitive password and salt

```puppet
$pw = Sensitive.new('Pa55w0rd')
$salt = Sensitive.new('Using s0m3 s@lt')
$pw_info = Sensitive.new(str2saltedpbkdf2($pw, $salt, 50000))
user { 'jdoe':
  ensure     => present,
  iterations => unwrap($pw_info)['interations'],
  password   => unwrap($pw_info)['password_hex'],
  salt       => unwrap($pw_info)['salt_hex'],
}
```

#### `str2saltedpbkdf2()`

Convert a string into a salted SHA512 PBKDF2 password hash like requred for OS X / macOS 10.8+.
Note, however, that Apple changes what's required periodically and this may not work for the latest
version of macOS. If that is the case you should get a helpful error message when Puppet tries to set
the pasword using the parameters you provide to the user resource.

Returns: `Hash` Provides a hash containing the hex version of the password, the hex version of the salt, and iterations.

##### Examples

###### Plain text password and salt

```puppet
$pw_info = str2saltedpbkdf2('Pa55w0rd', 'Using s0m3 s@lt', 50000)
user { 'jdoe':
  ensure     => present,
  iterations => $pw_info['interations'],
  password   => $pw_info['password_hex'],
  salt       => $pw_info['salt_hex'],
}
```

###### Sensitive password and salt

```puppet
$pw = Sensitive.new('Pa55w0rd')
$salt = Sensitive.new('Using s0m3 s@lt')
$pw_info = Sensitive.new(str2saltedpbkdf2($pw, $salt, 50000))
user { 'jdoe':
  ensure     => present,
  iterations => unwrap($pw_info)['interations'],
  password   => unwrap($pw_info)['password_hex'],
  salt       => unwrap($pw_info)['salt_hex'],
}
```

### str2saltedsha512

Type: Ruby 3.x API

Given any simple string, you will get a hex version
of a salted-SHA512 password hash that can be inserted into your Puppet
manifests as a valid password attribute.

#### `str2saltedsha512()`

Given any simple string, you will get a hex version
of a salted-SHA512 password hash that can be inserted into your Puppet
manifests as a valid password attribute.

Returns: `Any` converted string as a hex version of a salted-SHA512 password hash

### strip

Type: Ruby 3.x API

> *Note:*: from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function.

#### Examples

##### **Usage**

```puppet

strip("    aaa   ")
Would result in: "aaa"
```

#### `strip()`

> *Note:*: from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function.

Returns: `Any` String or Array converted

##### Examples

###### **Usage**

```puppet

strip("    aaa   ")
Would result in: "aaa"
```

### suffix

Type: Ruby 3.x API

> *Note:* that since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:

```['a', 'b', 'c'].map |$x| { "${x}p" }```

#### Examples

##### **Usage**

```puppet

suffix(['a','b','c'], 'p')
Will return: ['ap','bp','cp']
```

#### `suffix()`

> *Note:* that since Puppet 4.0.0 the general way to modify values is in array is by using the map
function in Puppet. This example does the same as the example above:

```['a', 'b', 'c'].map |$x| { "${x}p" }```

Returns: `Any` Array or Hash with updated elements containing the passed suffix

##### Examples

###### **Usage**

```puppet

suffix(['a','b','c'], 'p')
Will return: ['ap','bp','cp']
```

### swapcase

Type: Ruby 3.x API

This function will swap the existing case of a string.

#### Examples

##### **Usage**

```puppet

swapcase("aBcD")
Would result in: "AbCd"
```

#### `swapcase()`

The swapcase function.

Returns: `Any` string with uppercase alphabetic characters converted to lowercase and lowercase characters converted to uppercase

##### Examples

###### **Usage**

```puppet

swapcase("aBcD")
Would result in: "AbCd"
```

### time

Type: Ruby 3.x API

> *Note:* that since Puppet 4.8.0 the Puppet language has the data types Timestamp (a point in time) and
Timespan (a duration). The following example is equivalent to calling time() without
any arguments:

```Timestamp()```

#### Examples

##### **Usage**

```puppet

time()
Will return something like: 1311972653
```

#### `time()`

> *Note:* that since Puppet 4.8.0 the Puppet language has the data types Timestamp (a point in time) and
Timespan (a duration). The following example is equivalent to calling time() without
any arguments:

```Timestamp()```

Returns: `Any` the current time since epoch as an integer.

##### Examples

###### **Usage**

```puppet

time()
Will return something like: 1311972653
```

### to_bytes

Type: Ruby 3.x API

Takes a single string value as an argument.
These conversions reflect a layperson's understanding of
1 MB = 1024 KB, when in fact 1 MB = 1000 KB, and 1 MiB = 1024 KiB.

#### `to_bytes()`

Takes a single string value as an argument.
These conversions reflect a layperson's understanding of
1 MB = 1024 KB, when in fact 1 MB = 1000 KB, and 1 MiB = 1024 KiB.

Returns: `Any` converted value into bytes

### to_json

Type: Ruby 4.x API

Convert a data structure and output to JSON

#### Examples

##### how to output JSON

```puppet
# output json to a file
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json($myhash),
  }
```

#### `to_json(Any $data)`

The to_json function.

Returns: `Any` converted data to json

##### Examples

###### how to output JSON

```puppet
# output json to a file
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json($myhash),
  }
```

##### `data`

Data type: `Any`

data structure which needs to be converted into JSON

### to_json_pretty

Type: Ruby 4.x API

Convert data structure and output to pretty JSON

#### Examples

##### **Usage**

```puppet
* how to output pretty JSON to file
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json_pretty($myhash),
  }

* how to output pretty JSON skipping over keys with undef values
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json_pretty({
      param_one => 'value',
      param_two => undef,
    }, true),
  }

* how to output pretty JSON using tabs for indentation
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json_pretty({
      param_one => 'value',
      param_two => {
        param_more => 42,
      },
    }, nil, {indent => '    '}),
  }
```

#### `to_json_pretty(Variant[Hash, Array] $data, Optional[Optional[Boolean]] $skip_undef, Optional[Struct[{
indent       => Optional[String],
space        => Optional[String],
space_before => Optional[String],
object_nl    => Optional[String],
array_nl     => Optional[String],
allow_nan    => Optional[Boolean],
max_nesting  => Optional[Integer[-1,default]],
}]] $opts)`

The to_json_pretty function.

Returns: `Any` converted data to pretty json

##### Examples

###### **Usage**

```puppet
* how to output pretty JSON to file
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json_pretty($myhash),
  }

* how to output pretty JSON skipping over keys with undef values
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json_pretty({
      param_one => 'value',
      param_two => undef,
    }, true),
  }

* how to output pretty JSON using tabs for indentation
  file { '/tmp/my.json':
    ensure  => file,
    content => to_json_pretty({
      param_one => 'value',
      param_two => {
        param_more => 42,
      },
    }, nil, {indent => '    '}),
  }
```

##### `data`

Data type: `Variant[Hash, Array]`

data structure which needs to be converted to pretty json

##### `skip_undef`

Data type: `Optional[Optional[Boolean]]`

value `true` or `false`

##### `opts`

Data type: `Optional[Struct[{
indent       => Optional[String],
space        => Optional[String],
space_before => Optional[String],
object_nl    => Optional[String],
array_nl     => Optional[String],
allow_nan    => Optional[Boolean],
max_nesting  => Optional[Integer[-1,default]],
}]]`

hash-map of settings passed to JSON.pretty_generate, see
https://ruby-doc.org/stdlib-2.0.0/libdoc/json/rdoc/JSON.html#method-i-generate.
Note that `max_nesting` doesn't take the value `false`; use `-1` instead.

### to_yaml

Type: Ruby 4.x API

Convert a data structure and output it as YAML

#### Examples

##### how to output YAML

```puppet
# output yaml to a file
  file { '/tmp/my.yaml':
    ensure  => file,
    content => to_yaml($myhash),
  }
```

#### `to_yaml(Any $data)`

The to_yaml function.

Returns: `String`

##### Examples

###### how to output YAML

```puppet
# output yaml to a file
  file { '/tmp/my.yaml':
    ensure  => file,
    content => to_yaml($myhash),
  }
```

##### `data`

Data type: `Any`



### try_get_value

Type: Ruby 3.x API

Key can contain slashes to describe path components. The function will go down
the structure and try to extract the required value.
``
$data = {
  'a' => {
    'b' => [
      'b1',
      'b2',
      'b3',
    ]
  }
}

$value = try_get_value($data, 'a/b/2', 'not_found', '/')
=> $value = 'b3'
```
```
a -> first hash key
b -> second hash key
2 -> array index starting with 0

not_found -> (optional) will be returned if there is no value or the path did not match. Defaults to nil.
/ -> (optional) path delimiter. Defaults to '/'.
```

In addition to the required "key" argument, "try_get_value" accepts default
argument. It will be returned if no value was found or a path component is
missing. And the fourth argument can set a variable path separator.

#### `try_get_value()`

Key can contain slashes to describe path components. The function will go down
the structure and try to extract the required value.
``
$data = {
  'a' => {
    'b' => [
      'b1',
      'b2',
      'b3',
    ]
  }
}

$value = try_get_value($data, 'a/b/2', 'not_found', '/')
=> $value = 'b3'
```
```
a -> first hash key
b -> second hash key
2 -> array index starting with 0

not_found -> (optional) will be returned if there is no value or the path did not match. Defaults to nil.
/ -> (optional) path delimiter. Defaults to '/'.
```

In addition to the required "key" argument, "try_get_value" accepts default
argument. It will be returned if no value was found or a path component is
missing. And the fourth argument can set a variable path separator.

Returns: `Any` Looks up into a complex structure of arrays and hashes and returns a value
or the default value if nothing was found.

### type

Type: Ruby 3.x API

please use type3x() before upgrading to Puppet 4 for backwards-compatibility, or migrate to the new parser's typing system.

* string
* array
* hash
* float
* integer
* boolean

#### `type()`

please use type3x() before upgrading to Puppet 4 for backwards-compatibility, or migrate to the new parser's typing system.

* string
* array
* hash
* float
* integer
* boolean

Returns: `Any` the type when passed a value. Type can be one of:

### type3x

Type: Ruby 3.x API

* string
* array
* hash
* float
* integer
* boolean

#### `type3x()`

* string
* array
* hash
* float
* integer
* boolean

Returns: `Any` the type when passed a value. Type can be one of:

### type_of

Type: Ruby 4.x API

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

The built-in type() function in puppet is generally preferred over this function
this function is provided for backwards compatibility.

#### Examples

##### how to compare values' types

```puppet
# compare the types of two values
if type_of($first_value) != type_of($second_value) { fail("first_value and second_value are different types") }
```

##### how to compare against an abstract type

```puppet
unless type_of($first_value) <= Numeric { fail("first_value must be Numeric") }
unless type_of{$first_value) <= Collection[1] { fail("first_value must be an Array or Hash, and contain at least one element") }
```

#### `type_of(Any $value)`

See the documentation for "The Puppet Type System" for more information about types.
See the `assert_type()` function for flexible ways to assert the type of a value.

The built-in type() function in puppet is generally preferred over this function
this function is provided for backwards compatibility.

Returns: `String` the type of the passed value

##### Examples

###### how to compare values' types

```puppet
# compare the types of two values
if type_of($first_value) != type_of($second_value) { fail("first_value and second_value are different types") }
```

###### how to compare against an abstract type

```puppet
unless type_of($first_value) <= Numeric { fail("first_value must be Numeric") }
unless type_of{$first_value) <= Collection[1] { fail("first_value must be an Array or Hash, and contain at least one element") }
```

##### `value`

Data type: `Any`



### union

Type: Ruby 3.x API

This function returns a union of two or more arrays.

#### Examples

##### **Usage**

```puppet

union(["a","b","c"],["b","c","d"])
Would return: ["a","b","c","d"]
```

#### `union()`

The union function.

Returns: `Any` a unionized array of two or more arrays

##### Examples

###### **Usage**

```puppet

union(["a","b","c"],["b","c","d"])
Would return: ["a","b","c","d"]
```

### unique

Type: Ruby 3.x API

This function will remove duplicates from strings and arrays.

#### Examples

##### **Usage**

```puppet

unique("aabbcc")
Will return: abc

You can also use this with arrays:

unique(["a","a","b","b","c","c"])
This returns: ["a","b","c"]
```

#### `unique()`

The unique function.

Returns: `Any` String or array with duplicates removed

##### Examples

###### **Usage**

```puppet

unique("aabbcc")
Will return: abc

You can also use this with arrays:

unique(["a","a","b","b","c","c"])
This returns: ["a","b","c"]
```

### unix2dos

Type: Ruby 3.x API

Takes a single string argument.

#### `unix2dos()`

Takes a single string argument.

Returns: `Any` the DOS version of the given string.

### upcase

Type: Ruby 3.x API

> *Note:* from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function.

#### Examples

##### **Usage**

```puppet

upcase("abcd")
Will return ABCD
```

#### `upcase()`

> *Note:* from Puppet 6.0.0, the compatible function with the same name in Puppet core
will be used instead of this function.

Returns: `Any` converted string ot array of strings to uppercase

##### Examples

###### **Usage**

```puppet

upcase("abcd")
Will return ABCD
```

### uriescape

Type: Ruby 3.x API

Urlencodes a string or array of strings.
Requires either a single string or an array as an input.

#### `uriescape()`

The uriescape function.

Returns: `String` a string that contains the converted value

### validate_absolute_path

Type: Ruby 3.x API

Validate the string represents an absolute path in the filesystem.  This function works
for windows and unix style paths.

#### Examples

##### **Usage**

```puppet

The following values will pass:

    $my_path = 'C:/Program Files (x86)/Puppet Labs/Puppet'
    validate_absolute_path($my_path)
    $my_path2 = '/var/lib/puppet'
    validate_absolute_path($my_path2)
    $my_path3 = ['C:/Program Files (x86)/Puppet Labs/Puppet','C:/Program Files/Puppet Labs/Puppet']
    validate_absolute_path($my_path3)
    $my_path4 = ['/var/lib/puppet','/usr/share/puppet']
    validate_absolute_path($my_path4)

The following values will fail, causing compilation to abort:

    validate_absolute_path(true)
    validate_absolute_path('../var/lib/puppet')
    validate_absolute_path('var/lib/puppet')
    validate_absolute_path([ 'var/lib/puppet', '/var/foo' ])
    validate_absolute_path([ '/var/lib/puppet', 'var/foo' ])
    $undefined = undef
    validate_absolute_path($undefin
```

#### `validate_absolute_path()`

The validate_absolute_path function.

Returns: `Any` passes when the string is an absolute path or raise an error when it is not and fails compilation

##### Examples

###### **Usage**

```puppet

The following values will pass:

    $my_path = 'C:/Program Files (x86)/Puppet Labs/Puppet'
    validate_absolute_path($my_path)
    $my_path2 = '/var/lib/puppet'
    validate_absolute_path($my_path2)
    $my_path3 = ['C:/Program Files (x86)/Puppet Labs/Puppet','C:/Program Files/Puppet Labs/Puppet']
    validate_absolute_path($my_path3)
    $my_path4 = ['/var/lib/puppet','/usr/share/puppet']
    validate_absolute_path($my_path4)

The following values will fail, causing compilation to abort:

    validate_absolute_path(true)
    validate_absolute_path('../var/lib/puppet')
    validate_absolute_path('var/lib/puppet')
    validate_absolute_path([ 'var/lib/puppet', '/var/foo' ])
    validate_absolute_path([ '/var/lib/puppet', 'var/foo' ])
    $undefined = undef
    validate_absolute_path($undefin
```

### validate_absolute_path

Type: Ruby 4.x API

Validate the string represents an absolute path in the filesystem.

#### `validate_absolute_path(Any $scope, Any *$args)`

The validate_absolute_path function.

Returns: `Boolean` A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_array

Type: Ruby 4.x API

Validate the passed value represents an array.

#### `validate_array(Any $scope, Any *$args)`

The validate_array function.

Returns: `Any` A boolean value (`true` or `false`) returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_array

Type: Ruby 3.x API

Validate that all passed values are array data structures. Abort catalog
compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet
The following values will pass:

    $my_array = [ 'one', 'two' ]
    validate_array($my_array)

The following values will fail, causing compilation to abort:

    validate_array(true)
    validate_array('some_string')
    $undefined = undef
    validate_array($undefined
```

#### `validate_array()`

The validate_array function.

Returns: `Any` validate array

##### Examples

###### **Usage**

```puppet
The following values will pass:

    $my_array = [ 'one', 'two' ]
    validate_array($my_array)

The following values will fail, causing compilation to abort:

    validate_array(true)
    validate_array('some_string')
    $undefined = undef
    validate_array($undefined
```

### validate_augeas

Type: Ruby 3.x API

The first argument of this function should be a string to
test, and the second argument should be the name of the Augeas lens to use.
If Augeas fails to parse the string with the lens, the compilation will
abort with a parse error.

A third argument can be specified, listing paths which should
not be found in the file. The `$file` variable points to the location
of the temporary file being tested in the Augeas tree.

#### Examples

##### **Usage**

```puppet

If you want to make sure your passwd content never contains
a user `foo`, you could write:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/foo'])

If you wanted to ensure that no users used the '/bin/barsh' shell,
you could use:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/*[shell="/bin/barsh"]']

If a fourth argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

  validate_augeas($sudoerscontent, 'Sudoers.lns', [], 'Failed to validate sudoers content with Augeas')
```

#### `validate_augeas()`

The first argument of this function should be a string to
test, and the second argument should be the name of the Augeas lens to use.
If Augeas fails to parse the string with the lens, the compilation will
abort with a parse error.

A third argument can be specified, listing paths which should
not be found in the file. The `$file` variable points to the location
of the temporary file being tested in the Augeas tree.

Returns: `Any` validate string using an Augeas lens

##### Examples

###### **Usage**

```puppet

If you want to make sure your passwd content never contains
a user `foo`, you could write:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/foo'])

If you wanted to ensure that no users used the '/bin/barsh' shell,
you could use:

  validate_augeas($passwdcontent, 'Passwd.lns', ['$file/*[shell="/bin/barsh"]']

If a fourth argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

  validate_augeas($sudoerscontent, 'Sudoers.lns', [], 'Failed to validate sudoers content with Augeas')
```

### validate_bool

Type: Ruby 4.x API

Validate the passed value represents a boolean.

#### `validate_bool(Any $scope, Any *$args)`

The validate_bool function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_bool

Type: Ruby 3.x API

Validate that all passed values are either true or false. Abort catalog
compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet

The following values will pass:

    $iamtrue = true
    validate_bool(true)
    validate_bool(true, true, false, $iamtrue)

The following values will fail, causing compilation to abort:

    $some_array = [ true ]
    validate_bool("false")
    validate_bool("true")
    validate_bool($some_array)
```

#### `validate_bool()`

The validate_bool function.

Returns: `Any` validate boolean

##### Examples

###### **Usage**

```puppet

The following values will pass:

    $iamtrue = true
    validate_bool(true)
    validate_bool(true, true, false, $iamtrue)

The following values will fail, causing compilation to abort:

    $some_array = [ true ]
    validate_bool("false")
    validate_bool("true")
    validate_bool($some_array)
```

### validate_cmd

Type: Ruby 3.x API

The first argument of this function should be a string to
test, and the second argument should be a path to a test command
taking a % as a placeholder for the file path (will default to the end).
If the command, launched against a tempfile containing the passed string,
returns a non-null value, compilation will abort with a parse error.
If a third argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

#### Examples

##### **Usage**

```puppet

Defaults to end of path
  validate_cmd($sudoerscontent, '/usr/sbin/visudo -c -f', 'Visudo failed to validate sudoers content')

% as file location
  validate_cmd($haproxycontent, '/usr/sbin/haproxy -f % -c', 'Haproxy failed to validate config content')
```

#### `validate_cmd()`

The first argument of this function should be a string to
test, and the second argument should be a path to a test command
taking a % as a placeholder for the file path (will default to the end).
If the command, launched against a tempfile containing the passed string,
returns a non-null value, compilation will abort with a parse error.
If a third argument is specified, this will be the error message raised and
seen by the user.

A helpful error message can be returned like this:

Returns: `Any` validate of a string with an external command

##### Examples

###### **Usage**

```puppet

Defaults to end of path
  validate_cmd($sudoerscontent, '/usr/sbin/visudo -c -f', 'Visudo failed to validate sudoers content')

% as file location
  validate_cmd($haproxycontent, '/usr/sbin/haproxy -f % -c', 'Haproxy failed to validate config content')
```

### validate_domain_name

Type: Ruby 3.x API

Validate that all values passed are syntactically correct domain names.
Fail compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet

The following values will pass:

    $my_domain_name = 'server.domain.tld'
    validate_domain_name($my_domain_name)
    validate_domain_name('domain.tld', 'puppet.com', $my_domain_name)

The following values will fail, causing compilation to abort:

    validate_domain_name(1)
    validate_domain_name(true)
    validate_domain_name('invalid domain')
    validate_domain_name('-foo.example.com')
    validate_domain_name('www.example.2com')
```

#### `validate_domain_name()`

The validate_domain_name function.

Returns: `Any` passes when the given values are syntactically correct domain names or raise an error when they are not and fails compilation

##### Examples

###### **Usage**

```puppet

The following values will pass:

    $my_domain_name = 'server.domain.tld'
    validate_domain_name($my_domain_name)
    validate_domain_name('domain.tld', 'puppet.com', $my_domain_name)

The following values will fail, causing compilation to abort:

    validate_domain_name(1)
    validate_domain_name(true)
    validate_domain_name('invalid domain')
    validate_domain_name('-foo.example.com')
    validate_domain_name('www.example.2com')
```

### validate_email_address

Type: Ruby 3.x API

Validate that all values passed are valid email addresses.
Fail compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet

The following values will pass:

  $my_email = "waldo@gmail.com"
  validate_email_address($my_email)
  validate_email_address("bob@gmail.com", "alice@gmail.com", $my_email)

The following values will fail, causing compilation to abort:

  $some_array = [ 'bad_email@/d/efdf.com' ]
  validate_email_address($some_array)
```

#### `validate_email_address()`

The validate_email_address function.

Returns: `Any` Fail compilation if any value fails this check.

##### Examples

###### **Usage**

```puppet

The following values will pass:

  $my_email = "waldo@gmail.com"
  validate_email_address($my_email)
  validate_email_address("bob@gmail.com", "alice@gmail.com", $my_email)

The following values will fail, causing compilation to abort:

  $some_array = [ 'bad_email@/d/efdf.com' ]
  validate_email_address($some_array)
```

### validate_hash

Type: Ruby 3.x API

Validate that all passed values are hash data structures. Abort catalog
compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet

The following values will pass:

    $my_hash = { 'one' => 'two' }
    validate_hash($my_hash)

The following values will fail, causing compilation to abort:

    validate_hash(true)
    validate_hash('some_string')
    $undefined = undef
    validate_hash($undefined)
```

#### `validate_hash()`

The validate_hash function.

Returns: `Any` validate hash

##### Examples

###### **Usage**

```puppet

The following values will pass:

    $my_hash = { 'one' => 'two' }
    validate_hash($my_hash)

The following values will fail, causing compilation to abort:

    validate_hash(true)
    validate_hash('some_string')
    $undefined = undef
    validate_hash($undefined)
```

### validate_hash

Type: Ruby 4.x API

Validate the passed value represents a hash.

#### `validate_hash(Any $scope, Any *$args)`

The validate_hash function.

Returns: `Any` A boolean value (`true` or `false`) returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_integer

Type: Ruby 3.x API

The second argument is optional and passes a maximum. (All elements of) the first argument has to be less or equal to this max.
The third argument is optional and passes a minimum.  (All elements of) the first argument has to be greater or equal to this min.
If, and only if, a minimum is given, the second argument may be an empty string or undef, which will be handled to just check
if (all elements of) the first argument are greater or equal to the given minimum.
It will fail if the first argument is not an integer or array of integers, and if arg 2 and arg 3 are not convertable to an integer.

#### Examples

##### **Usage**

```puppet

The following values will pass:

  validate_integer(1)
  validate_integer(1, 2)
  validate_integer(1, 1)
  validate_integer(1, 2, 0)
  validate_integer(2, 2, 2)
  validate_integer(2, '', 0)
  validate_integer(2, undef, 0)
  $foo = undef
  validate_integer(2, $foo, 0)
  validate_integer([1,2,3,4,5], 6)
  validate_integer([1,2,3,4,5], 6, 0)

Plus all of the above, but any combination of values passed as strings ('1' or "1").
Plus all of the above, but with (correct) combinations of negative integer values.

The following values will not:

  validate_integer(true)
  validate_integer(false)
  validate_integer(7.0)
  validate_integer({ 1 => 2 })
  $foo = undef
  validate_integer($foo)
  validate_integer($foobaridontexist)

  validate_integer(1, 0)
  validate_integer(1, true)
  validate_integer(1, '')
  validate_integer(1, undef)
  validate_integer(1, , 0)
  validate_integer(1, 2, 3)
  validate_integer(1, 3, 2)
  validate_integer(1, 3, true)

Plus all of the above, but any combination of values passed as strings ('false' or "false").
Plus all of the above, but with incorrect combinations of negative integer values.
Plus all of the above, but with non-integer items in arrays or maximum / minimum argument.
```

#### `validate_integer()`

The second argument is optional and passes a maximum. (All elements of) the first argument has to be less or equal to this max.
The third argument is optional and passes a minimum.  (All elements of) the first argument has to be greater or equal to this min.
If, and only if, a minimum is given, the second argument may be an empty string or undef, which will be handled to just check
if (all elements of) the first argument are greater or equal to the given minimum.
It will fail if the first argument is not an integer or array of integers, and if arg 2 and arg 3 are not convertable to an integer.

Returns: `Any` Validate that the first argument is an integer (or an array of integers). Fail compilation if any of the checks fail.

##### Examples

###### **Usage**

```puppet

The following values will pass:

  validate_integer(1)
  validate_integer(1, 2)
  validate_integer(1, 1)
  validate_integer(1, 2, 0)
  validate_integer(2, 2, 2)
  validate_integer(2, '', 0)
  validate_integer(2, undef, 0)
  $foo = undef
  validate_integer(2, $foo, 0)
  validate_integer([1,2,3,4,5], 6)
  validate_integer([1,2,3,4,5], 6, 0)

Plus all of the above, but any combination of values passed as strings ('1' or "1").
Plus all of the above, but with (correct) combinations of negative integer values.

The following values will not:

  validate_integer(true)
  validate_integer(false)
  validate_integer(7.0)
  validate_integer({ 1 => 2 })
  $foo = undef
  validate_integer($foo)
  validate_integer($foobaridontexist)

  validate_integer(1, 0)
  validate_integer(1, true)
  validate_integer(1, '')
  validate_integer(1, undef)
  validate_integer(1, , 0)
  validate_integer(1, 2, 3)
  validate_integer(1, 3, 2)
  validate_integer(1, 3, true)

Plus all of the above, but any combination of values passed as strings ('false' or "false").
Plus all of the above, but with incorrect combinations of negative integer values.
Plus all of the above, but with non-integer items in arrays or maximum / minimum argument.
```

### validate_integer

Type: Ruby 4.x API

Validate the passed value represents an integer.

#### `validate_integer(Any $scope, Any *$args)`

The validate_integer function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_ip_address

Type: Ruby 3.x API

Validate that all values passed are valid IP addresses,
regardless they are IPv4 or IPv6
Fail compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet
The following values will pass:

  $my_ip = "1.2.3.4"
  validate_ip_address($my_ip)
  validate_ip_address("8.8.8.8", "172.16.0.1", $my_ip)

  $my_ip = "3ffe:505:2"
  validate_ip_address(1)
  validate_ip_address($my_ip)
  validate_ip_address("fe80::baf6:b1ff:fe19:7507", $my_ip)

The following values will fail, causing compilation to abort:

  $some_array = [ 1, true, false, "garbage string", "3ffe:505:2" ]
  validate_ip_address($some_array)
```

#### `validate_ip_address()`

The validate_ip_address function.

Returns: `Any` passes when the given values are valid IP addresses or raise an error when they are not and fails compilation

##### Examples

###### **Usage**

```puppet
The following values will pass:

  $my_ip = "1.2.3.4"
  validate_ip_address($my_ip)
  validate_ip_address("8.8.8.8", "172.16.0.1", $my_ip)

  $my_ip = "3ffe:505:2"
  validate_ip_address(1)
  validate_ip_address($my_ip)
  validate_ip_address("fe80::baf6:b1ff:fe19:7507", $my_ip)

The following values will fail, causing compilation to abort:

  $some_array = [ 1, true, false, "garbage string", "3ffe:505:2" ]
  validate_ip_address($some_array)
```

### validate_ip_address

Type: Ruby 4.x API

Validate the passed value represents an ip_address.

#### `validate_ip_address(Any $scope, Any *$args)`

The validate_ip_address function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_ipv4_address

Type: Ruby 4.x API

Validate the passed value represents an ipv4_address.

#### `validate_ipv4_address(Any $scope, Any *$args)`

The validate_ipv4_address function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_ipv4_address

Type: Ruby 3.x API

Validate that all values passed are valid IPv4 addresses.
Fail compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet
The following values will pass:

  $my_ip = "1.2.3.4"
  validate_ipv4_address($my_ip)
  validate_ipv4_address("8.8.8.8", "172.16.0.1", $my_ip)

The following values will fail, causing compilation to abort:

  $some_array = [ 1, true, false, "garbage string", "3ffe:505:2" ]
  validate_ipv4_address($some_array)
```

#### `validate_ipv4_address()`

The validate_ipv4_address function.

Returns: `Any` passes when the given values are valid IPv4 addresses or raise an error when they are not and fails compilation

##### Examples

###### **Usage**

```puppet
The following values will pass:

  $my_ip = "1.2.3.4"
  validate_ipv4_address($my_ip)
  validate_ipv4_address("8.8.8.8", "172.16.0.1", $my_ip)

The following values will fail, causing compilation to abort:

  $some_array = [ 1, true, false, "garbage string", "3ffe:505:2" ]
  validate_ipv4_address($some_array)
```

### validate_ipv6_address

Type: Ruby 3.x API

Validate that all values passed are valid IPv6 addresses.
Fail compilation if any value fails this check.

#### Examples

##### **Usage**

```puppet
The following values will pass:

  $my_ip = "3ffe:505:2"
  validate_ipv6_address(1)
  validate_ipv6_address($my_ip)
  validate_bool("fe80::baf6:b1ff:fe19:7507", $my_ip)

The following values will fail, causing compilation to abort:

  $some_array = [ true, false, "garbage string", "1.2.3.4" ]
  validate_ipv6_address($some_array)
```

#### `validate_ipv6_address()`

The validate_ipv6_address function.

Returns: `Any` passes when the given values are valid IPv6 addresses or raise an error when they are not and fails compilation

##### Examples

###### **Usage**

```puppet
The following values will pass:

  $my_ip = "3ffe:505:2"
  validate_ipv6_address(1)
  validate_ipv6_address($my_ip)
  validate_bool("fe80::baf6:b1ff:fe19:7507", $my_ip)

The following values will fail, causing compilation to abort:

  $some_array = [ true, false, "garbage string", "1.2.3.4" ]
  validate_ipv6_address($some_array)
```

### validate_ipv6_address

Type: Ruby 4.x API

Validate the passed value represents an ipv6_address.

#### `validate_ipv6_address(Any $scope, Any *$args)`

The validate_ipv6_address function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_legacy

Type: Ruby 4.x API

Validate a value against both the target_type (new) and the previous_validation function (old).

#### `validate_legacy(Any $scope, Type $target_type, String $function_name, Any $value, Any *$args)`

The function checks a value against both the target_type (new) and the previous_validation function (old).

Returns: `Any` A boolean value (`true` or `false`) returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `target_type`

Data type: `Type`



##### `function_name`

Data type: `String`



##### `value`

Data type: `Any`



##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

#### `validate_legacy(Any $scope, String $type_string, String $function_name, Any $value, Any *$args)`

The validate_legacy function.

Returns: `Any` Legacy validation method

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `type_string`

Data type: `String`



##### `function_name`

Data type: `String`



##### `value`

Data type: `Any`



##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_numeric

Type: Ruby 4.x API

Validate the passed value represents a numeric value.

#### `validate_numeric(Any $scope, Any *$args)`

The validate_numeric function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_numeric

Type: Ruby 3.x API

The second argument is optional and passes a maximum. (All elements of) the first argument has to be less or equal to this max.
The third argument is optional and passes a minimum.  (All elements of) the first argument has to be greater or equal to this min.
If, and only if, a minimum is given, the second argument may be an empty string or undef, which will be handled to just check
if (all elements of) the first argument are greater or equal to the given minimum.
It will fail if the first argument is not a numeric (Integer or Float) or array of numerics, and if arg 2 and arg 3 are not convertable to a numeric.

For passing and failing usage, see `validate_integer()`. It is all the same for validate_numeric, yet now floating point values are allowed, too.

#### `validate_numeric()`

The second argument is optional and passes a maximum. (All elements of) the first argument has to be less or equal to this max.
The third argument is optional and passes a minimum.  (All elements of) the first argument has to be greater or equal to this min.
If, and only if, a minimum is given, the second argument may be an empty string or undef, which will be handled to just check
if (all elements of) the first argument are greater or equal to the given minimum.
It will fail if the first argument is not a numeric (Integer or Float) or array of numerics, and if arg 2 and arg 3 are not convertable to a numeric.

For passing and failing usage, see `validate_integer()`. It is all the same for validate_numeric, yet now floating point values are allowed, too.

Returns: `Any` Validate that the first argument is a numeric value (or an array of numeric values). Fail compilation if any of the checks fail.

### validate_re

Type: Ruby 3.x API

The first argument of this function should be a string to
test, and the second argument should be a stringified regular expression
(without the // delimiters) or an array of regular expressions.  If none
of the regular expressions match the string passed in, compilation will
abort with a parse error.
If a third argument is specified, this will be the error message raised and
seen by the user.

> *Note:*
Compilation will also abort, if the first argument is not a String. Always use
quotes to force stringification:
validate_re("${::operatingsystemmajrelease}", '^[57]$')

#### Examples

##### **Usage**

```puppet
The following strings will validate against the regular expressions:

    validate_re('one', '^one$')
    validate_re('one', [ '^one', '^two' ])

The following strings will fail to validate, causing compilation to abort:

    validate_re('one', [ '^two', '^three' ])

A helpful error message can be returned like this:

    validate_re($::puppetversion, '^2.7', 'The $puppetversion fact value does not match 2.7')
```

#### `validate_re()`

The first argument of this function should be a string to
test, and the second argument should be a stringified regular expression
(without the // delimiters) or an array of regular expressions.  If none
of the regular expressions match the string passed in, compilation will
abort with a parse error.
If a third argument is specified, this will be the error message raised and
seen by the user.

> *Note:*
Compilation will also abort, if the first argument is not a String. Always use
quotes to force stringification:
validate_re("${::operatingsystemmajrelease}", '^[57]$')

Returns: `Any` validation of a string against one or more regular expressions.

##### Examples

###### **Usage**

```puppet
The following strings will validate against the regular expressions:

    validate_re('one', '^one$')
    validate_re('one', [ '^one', '^two' ])

The following strings will fail to validate, causing compilation to abort:

    validate_re('one', [ '^two', '^three' ])

A helpful error message can be returned like this:

    validate_re($::puppetversion, '^2.7', 'The $puppetversion fact value does not match 2.7')
```

### validate_re

Type: Ruby 4.x API

Perform validation of a string against one or more regular
expressions.

#### `validate_re(Any $scope, Any *$args)`

The validate_re function.

Returns: `Boolean` `true` or `false` returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method
The first argument of this function should be a string to
test, and the second argument should be a stringified regular expression
(without the // delimiters) or an array of regular expressions

### validate_slength

Type: Ruby 3.x API

Validate that the first argument is a string (or an array of strings), and less/equal to than the length of the second argument.
An optional third parameter can be given the minimum length. It fails if the first argument is not a string or array of strings,
and if arg 2 and arg 3 are not convertable to a number.

#### Examples

##### **Usage**

```puppet
The following values will pass:

  validate_slength("discombobulate",17)
  validate_slength(["discombobulate","moo"],17)
  validate_slength(["discombobulate","moo"],17,3)

The following valueis will not:

  validate_slength("discombobulate",1)
  validate_slength(["discombobulate","thermometer"],5)
  validate_slength(["discombobulate","moo"],17,10)
```

#### `validate_slength()`

The validate_slength function.

Returns: `Any` validate that the first argument is a string (or an array of strings), and less/equal to than the length of the second argument. Fail compilation if any of the checks fail.

##### Examples

###### **Usage**

```puppet
The following values will pass:

  validate_slength("discombobulate",17)
  validate_slength(["discombobulate","moo"],17)
  validate_slength(["discombobulate","moo"],17,3)

The following valueis will not:

  validate_slength("discombobulate",1)
  validate_slength(["discombobulate","thermometer"],5)
  validate_slength(["discombobulate","moo"],17,10)
```

### validate_slength

Type: Ruby 4.x API

Validate that a passed string has length less/equal with the passed value

#### `validate_slength(Any $scope, Any *$args)`

Validate that a passed string has length less/equal with the passed value

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_string

Type: Ruby 3.x API

> *Note:*
Validate_string(undef) will not fail in this version of the
functions API (incl. current and future parser). Instead, use:
```
  if $var == undef {
     fail('...')
    }
```

#### Examples

##### **Usage**

```puppet
The following values will pass:

    $my_string = "one two"
    validate_string($my_string, 'three')

The following values will fail, causing compilation to abort:

    validate_string(true)
    validate_string([ 'some', 'array' ])
```

#### `validate_string()`

> *Note:*
Validate_string(undef) will not fail in this version of the
functions API (incl. current and future parser). Instead, use:
```
  if $var == undef {
     fail('...')
    }
```

Returns: `Any` Validate that all passed values are string data structures. Failed
compilation if any value fails this check.

##### Examples

###### **Usage**

```puppet
The following values will pass:

    $my_string = "one two"
    validate_string($my_string, 'three')

The following values will fail, causing compilation to abort:

    validate_string(true)
    validate_string([ 'some', 'array' ])
```

### validate_string

Type: Ruby 4.x API

Validate that all passed values are string data structures.

#### `validate_string(Any $scope, Any *$args)`

The validate_string function.

Returns: `Boolean` `true` or `false`
A boolean value returned from the called function.

##### `scope`

Data type: `Any`

The main value that will be passed to the method

##### `*args`

Data type: `Any`

Any additional values that are to be passed to the method

### validate_x509_rsa_key_pair

Type: Ruby 3.x API

```validate_x509_rsa_key_pair($cert, $key)```

#### `validate_x509_rsa_key_pair()`

```validate_x509_rsa_key_pair($cert, $key)```

Returns: `Any` Fail compilation if any value fails this check.

### values

Type: Ruby 3.x API

> *Note:*
From Puppet 5.5.0, the compatible function with the same name in Puppet core
will be used instead of this function.

#### Examples

##### **Usage**

```puppet
$hash = {
  'a' => 1,
  'b' => 2,
  'c' => 3,
}
values($hash)

This example would return: ```[1,2,3]```
```

#### `values()`

> *Note:*
From Puppet 5.5.0, the compatible function with the same name in Puppet core
will be used instead of this function.

Returns: `Any` array of values

##### Examples

###### **Usage**

```puppet
$hash = {
  'a' => 1,
  'b' => 2,
  'c' => 3,
}
values($hash)

This example would return: ```[1,2,3]```
```

### values_at

Type: Ruby 3.x API

The first argument is the array you want to analyze, and the second element can
be a combination of:

* A single numeric index
* A range in the form of 'start-stop' (eg. 4-9)
* An array combining the above

> *Note:*
Since Puppet 4.0.0 it is possible to slice an array with index and count directly in the language.
A negative value is taken to be "from the end" of the array:

`['a', 'b', 'c', 'd'][1, 2]`   results in `['b', 'c']`
`['a', 'b', 'c', 'd'][2, -1]`  results in `['c', 'd']`
`['a', 'b', 'c', 'd'][1, -2]`  results in `['b', 'c']`

#### Examples

##### **Usage**

```puppet

values_at(['a','b','c'], 2)
Would return ['c']

values_at(['a','b','c'], ["0-1"])
Would return ['a','b']

values_at(['a','b','c','d','e'], [0, "2-3"])
Would return ['a','c','d']
```

#### `values_at()`

The first argument is the array you want to analyze, and the second element can
be a combination of:

* A single numeric index
* A range in the form of 'start-stop' (eg. 4-9)
* An array combining the above

> *Note:*
Since Puppet 4.0.0 it is possible to slice an array with index and count directly in the language.
A negative value is taken to be "from the end" of the array:

`['a', 'b', 'c', 'd'][1, 2]`   results in `['b', 'c']`
`['a', 'b', 'c', 'd'][2, -1]`  results in `['c', 'd']`
`['a', 'b', 'c', 'd'][1, -2]`  results in `['b', 'c']`

Returns: `Any` an array of values identified by location

##### Examples

###### **Usage**

```puppet

values_at(['a','b','c'], 2)
Would return ['c']

values_at(['a','b','c'], ["0-1"])
Would return ['a','b']

values_at(['a','b','c','d','e'], [0, "2-3"])
Would return ['a','c','d']
```

### zip

Type: Ruby 3.x API

Takes one element from first array and merges corresponding elements from second array.

#### Examples

##### 

```puppet
zip(['1','2','3'],['4','5','6'])
Would result in: ["1", "4"], ["2", "5"], ["3", "6"]
```

#### `zip()`

The zip function.

Returns: `Any` This generates a sequence of n-element arrays, where n is one more than the count of arguments.

##### Examples

###### 

```puppet
zip(['1','2','3'],['4','5','6'])
Would result in: ["1", "4"], ["2", "5"], ["3", "6"]
```

## Data types

### Stdlib::Absolutepath

A strict absolutepath type

Alias of `Variant[Stdlib::Windowspath, Stdlib::Unixpath]`

### Stdlib::Base32

Type to match base32 String

Alias of `Pattern[/\A[a-z2-7]+={,6}\z/, /\A[A-Z2-7]+={,6}\z/]`

### Stdlib::Base64

Type to match base64 String

Alias of `Pattern[/\A[a-zA-Z0-9\/\+]+={,2}\z/]`

### Stdlib::Compat::Absolute_path

Emulate the is_absolute_path and validate_absolute_path functions

The first pattern is originally from is_absolute_path, which had it from 2.7.x's lib/puppet/util.rb Puppet::Util.absolute_path?
slash = '[\\\\/]'
name = '[^\\\\/]+'
%r!^(([A-Z]:#{slash})|(#{slash}#{slash}#{name}#{slash}#{name})|(#{slash}#{slash}\?#{slash}#{name}))!i,

Alias of `Variant[Pattern[/^(([a-zA-Z]:[\\\/])|([\\\/][\\\/][^\\\/]+[\\\/][^\\\/]+)|([\\\/][\\\/]\?[\\\/][^\\\/]+))/], Pattern[/^\//]]`

### Stdlib::Compat::Array

Emulate the is_array and validate_array functions

Alias of `Array[Any]`

### Stdlib::Compat::Bool

Emulate the is_bool and validate_bool functions

Alias of `Boolean`

### Stdlib::Compat::Float

Emulate the is_float function
The regex is what's currently used in is_float
To keep your development moving forward, you can also add a deprecation warning using the Integer type:

```class example($value) { validate_float($value,) }```

would turn into

```
class example(Stdlib::Compat::Float $value) {
  validate_float($value, 10, 0)
  assert_type(Integer[0, 10], $value) |$expected, $actual| {
    warning("The 'value' parameter for the 'ntp' class has type ${actual}, but should be ${expected}.")
  }
}
```

This allows you to find all places where a consumers of your code call it with unexpected values.

Alias of `Variant[Float, Pattern[/^-?(?:(?:[1-9]\d*)|0)(?:\.\d+)(?:[eE]-?\d+)?$/]]`

### Stdlib::Compat::Hash

Emulate the is_hash and validate_hash functions

Alias of `Hash[Any, Any]`

### Stdlib::Compat::Integer

Emulate the is_integer and validate_integer functions
The regex is what's currently used in is_integer
validate_numeric also allows range checking, which cannot be mapped to the string parsing inside the function.
For full backwards compatibility, you will need to keep the validate_numeric call around to catch everything.
To keep your development moving forward, you can also add a deprecation warning using the Integer type:

```class example($value) { validate_integer($value, 10, 0) }```

would turn into

```
class example(Stdlib::Compat::Integer $value) {
  validate_numeric($value, 10, 0)
  assert_type(Integer[0, 10], $value) |$expected, $actual| {
    warning("The 'value' parameter for the 'ntp' class has type ${actual}, but should be ${expected}.")
  }
}
```

> Note that you need to use Variant[Integer[0, 10], Float[0, 10]] if you want to match both integers and floating point numbers.

This allows you to find all places where a consumers of your code call it with unexpected values.

Alias of `Variant[Integer, Pattern[/^-?(?:(?:[1-9]\d*)|0)$/], Array[Variant[Integer, Pattern[/^-?(?:(?:[1-9]\d*)|0)$/]]]]`

### Stdlib::Compat::Ip_address

The Stdlib::Compat::Ip_address data type.

Alias of `Variant[Stdlib::Compat::Ipv4, Stdlib::Compat::Ipv6]`

### Stdlib::Compat::Ipv4

Emulate the validate_ipv4_address and is_ipv4_address functions

Alias of `Pattern[/^((([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))[.]){3}([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d)))(\/((([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))[.]){3}([0-9](?!\d)|[1-9][0-9](?!\d)|1[0-9]{2}(?!\d)|2[0-4][0-9](?!\d)|25[0-5](?!\d))|[0-9]+))?$/]`

### Stdlib::Compat::Ipv6

The Stdlib::Compat::Ipv6 data type.

Alias of `Pattern[/\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/]`

### Stdlib::Compat::Numeric

Emulate the is_numeric and validate_numeric functions
The regex is what's currently used in is_numeric
validate_numeric also allows range checking, which cannot be mapped to the string parsing inside the function.
For full backwards compatibility, you will need to keep the validate_numeric call around to catch everything.
To keep your development moving forward, you can also add a deprecation warning using the Integer type:

```class example($value) { validate_numeric($value, 10, 0) }```

would turn into

```
class example(Stdlib::Compat::Numeric $value) {
  validate_numeric($value, 10, 0)
  assert_type(Integer[0, 10], $value) |$expected, $actual| {
    warning("The 'value' parameter for the 'ntp' class has type ${actual}, but should be ${expected}.")
  }
}
```

> Note that you need to use Variant[Integer[0, 10], Float[0, 10]] if you want to match both integers and floating point numbers.

This allows you to find all places where a consumers of your code call it with unexpected values.

Alias of `Variant[Numeric, Pattern[/^-?(?:(?:[1-9]\d*)|0)(?:\.\d+)?(?:[eE]-?\d+)?$/], Array[Variant[Numeric, Pattern[/^-?(?:(?:[1-9]\d*)|0)(?:\.\d+)?(?:[eE]-?\d+)?$/]]]]`

### Stdlib::Compat::String

Emulate the is_string and validate_string functions

Alias of `Optional[String]`

### Stdlib::Ensure::Service

The Stdlib::Ensure::Service data type.

Alias of `Enum['stopped', 'running']`

### Stdlib::Filemode

See `man chmod.1` for the regular expression for symbolic mode

Alias of `Pattern[/\A(([0-7]{1,4})|(([ugoa]*([-+=]([rwxXst]*|[ugo]))+|[-+=][0-7]+)(,([ugoa]*([-+=]([rwxXst]*|[ugo]))+|[-+=][0-7]+))*))\z/]`

### Stdlib::Filesource

Validate the source parameter on file types

Alias of `Variant[Stdlib::Absolutepath, Stdlib::HTTPUrl, Pattern[
    /\Afile:\/\/\/([^\n\/\0]+(\/)?)+\z/,
    /\Apuppet:\/\/(([\w-]+\.?)+)?\/([^\n\/\0]+(\/)?)+\z/,
  ]]`

### Stdlib::Fqdn

The Stdlib::Fqdn data type.

Alias of `Pattern[/\A(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])\z/]`

### Stdlib::HTTPSUrl

The Stdlib::HTTPSUrl data type.

Alias of `Pattern[/(?i:\Ahttps:\/\/.*\z)/]`

### Stdlib::HTTPUrl

The Stdlib::HTTPUrl data type.

Alias of `Pattern[/(?i:\Ahttps?:\/\/.*\z)/]`

### Stdlib::Host

The Stdlib::Host data type.

Alias of `Variant[Stdlib::Fqdn, Stdlib::Compat::Ip_address]`

### Stdlib::IP::Address

The Stdlib::IP::Address data type.

Alias of `Variant[Stdlib::IP::Address::V4, Stdlib::IP::Address::V6]`

### Stdlib::IP::Address::Nosubnet

The Stdlib::IP::Address::Nosubnet data type.

Alias of `Variant[Stdlib::IP::Address::V4::Nosubnet, Stdlib::IP::Address::V6::Nosubnet]`

### Stdlib::IP::Address::V4

The Stdlib::IP::Address::V4 data type.

Alias of `Variant[Stdlib::IP::Address::V4::CIDR, Stdlib::IP::Address::V4::Nosubnet]`

### Stdlib::IP::Address::V4::CIDR

The Stdlib::IP::Address::V4::CIDR data type.

Alias of `Pattern[/\A([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\/([0-9]|[12][0-9]|3[0-2])\z/]`

### Stdlib::IP::Address::V4::Nosubnet

The Stdlib::IP::Address::V4::Nosubnet data type.

Alias of `Pattern[/\A([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/]`

### Stdlib::IP::Address::V6

The Stdlib::IP::Address::V6 data type.

Alias of `Variant[Stdlib::IP::Address::V6::Full, Stdlib::IP::Address::V6::Compressed, Stdlib::IP::Address::V6::Alternative, Stdlib::IP::Address::V6::Nosubnet]`

### Stdlib::IP::Address::V6::Alternative

The Stdlib::IP::Address::V6::Alternative data type.

Alias of `Pattern[/\A([[:xdigit:]]{1,4}:){6}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){4}(:[[:xdigit:]]{1,4}){0,1}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){3}(:[[:xdigit:]]{1,4}){0,2}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){2}(:[[:xdigit:]]{1,4}){0,3}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){1}(:[[:xdigit:]]{1,4}){0,4}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A:(:[[:xdigit:]]{1,4}){0,5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/]`

### Stdlib::IP::Address::V6::CIDR

The Stdlib::IP::Address::V6::CIDR data type.

Alias of `Pattern[/\A((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]d|1dd|[1-9]?d)(.(25[0-5]|2[0-4]d|1dd|[1-9]?d)){3}))|:)))(%.+)?s*\/([0-9]|[1-9][0-9]|1[0-1][0-9]|12[0-8])?\z/]`

### Stdlib::IP::Address::V6::Compressed

The Stdlib::IP::Address::V6::Compressed data type.

Alias of `Pattern[/\A:(:|(:[[:xdigit:]]{1,4}){1,7})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){1}(:|(:[[:xdigit:]]{1,4}){1,6})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){2}(:|(:[[:xdigit:]]{1,4}){1,5})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){3}(:|(:[[:xdigit:]]{1,4}){1,4})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){4}(:|(:[[:xdigit:]]{1,4}){1,3})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){5}(:|(:[[:xdigit:]]{1,4}){1,2})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){6}(:|(:[[:xdigit:]]{1,4}){1,1})(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/, /\A([[:xdigit:]]{1,4}:){7}:(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/]`

### Stdlib::IP::Address::V6::Full

The Stdlib::IP::Address::V6::Full data type.

Alias of `Pattern[/\A[[:xdigit:]]{1,4}(:[[:xdigit:]]{1,4}){7}(\/(1([01][0-9]|2[0-8])|[1-9][0-9]|[0-9]))?\z/]`

### Stdlib::IP::Address::V6::Nosubnet

The Stdlib::IP::Address::V6::Nosubnet data type.

Alias of `Variant[Stdlib::IP::Address::V6::Nosubnet::Full, Stdlib::IP::Address::V6::Nosubnet::Compressed, Stdlib::IP::Address::V6::Nosubnet::Alternative]`

### Stdlib::IP::Address::V6::Nosubnet::Alternative

The Stdlib::IP::Address::V6::Nosubnet::Alternative data type.

Alias of `Pattern[/\A([[:xdigit:]]{1,4}:){6}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){4}(:[[:xdigit:]]{1,4}){0,1}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){3}(:[[:xdigit:]]{1,4}){0,2}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){2}(:[[:xdigit:]]{1,4}){0,3}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A([[:xdigit:]]{1,4}:){1}(:[[:xdigit:]]{1,4}){0,4}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/, /\A:(:[[:xdigit:]]{1,4}){0,5}:([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}\z/]`

### Stdlib::IP::Address::V6::Nosubnet::Compressed

The Stdlib::IP::Address::V6::Nosubnet::Compressed data type.

Alias of `Pattern[/\A:(:|(:[[:xdigit:]]{1,4}){1,7})\z/, /\A([[:xdigit:]]{1,4}:){1}(:|(:[[:xdigit:]]{1,4}){1,6})\z/, /\A([[:xdigit:]]{1,4}:){2}(:|(:[[:xdigit:]]{1,4}){1,5})\z/, /\A([[:xdigit:]]{1,4}:){3}(:|(:[[:xdigit:]]{1,4}){1,4})\z/, /\A([[:xdigit:]]{1,4}:){4}(:|(:[[:xdigit:]]{1,4}){1,3})\z/, /\A([[:xdigit:]]{1,4}:){5}(:|(:[[:xdigit:]]{1,4}){1,2})\z/, /\A([[:xdigit:]]{1,4}:){6}(:|(:[[:xdigit:]]{1,4}){1,1})\z/, /\A([[:xdigit:]]{1,4}:){7}:\z/]`

### Stdlib::IP::Address::V6::Nosubnet::Full

The Stdlib::IP::Address::V6::Nosubnet::Full data type.

Alias of `Pattern[/\A[[:xdigit:]]{1,4}(:[[:xdigit:]]{1,4}){7}\z/]`

### Stdlib::MAC

A type for a MAC address

Alias of `Pattern[/\A([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})\z/, /\A([0-9A-Fa-f]{2}[:-]){19}([0-9A-Fa-f]{2})\z/]`

### Stdlib::ObjectStore

The Stdlib::ObjectStore data type.

Alias of `Variant[Stdlib::ObjectStore::GSUri, Stdlib::ObjectStore::S3Uri]`

### Stdlib::ObjectStore::GSUri

The Stdlib::ObjectStore::GSUri data type.

Alias of `Pattern[/\Ags:\/\/.*\z/]`

### Stdlib::ObjectStore::S3Uri

The Stdlib::ObjectStore::S3Uri data type.

Alias of `Pattern[/\As3:\/\/.*\z/]`

### Stdlib::Port

The Stdlib::Port data type.

Alias of `Integer[0, 65535]`

### Stdlib::Port::Privileged

The Stdlib::Port::Privileged data type.

Alias of `Integer[1, 1023]`

### Stdlib::Port::Unprivileged

The Stdlib::Port::Unprivileged data type.

Alias of `Integer[1024, 65535]`

### Stdlib::Syslogfacility

The Stdlib::Syslogfacility data type.

Alias of `Enum['kern', 'user', 'mail', 'daemon', 'auth', 'syslog', 'lpr', 'news', 'uucp', 'cron', 'authpriv', 'ftp', 'ntp', 'security', 'console', 'solaris-cron', 'local0', 'local1', 'local2', 'local3', 'local4', 'local5', 'local6', 'local7']`

### Stdlib::Unixpath

this regex rejects any path component that does not start with "/" or is NUL

Alias of `Pattern[/\A\/([^\n\/\0]+\/*)*\z/]`

### Stdlib::Windowspath

The Stdlib::Windowspath data type.

Alias of `Pattern[/\A(([a-zA-Z]:[\\\/])|([\\\/][\\\/][^\\\/]+[\\\/][^\\\/]+)|([\\\/][\\\/]\?[\\\/][^\\\/]+)).*\z/]`

### Stdlib::Yes_no

The Stdlib::Yes_no data type.

Alias of `Pattern[/\A(?i:(yes|no))\z/]`

