class systemd::system(
                        $ensure                           = 'present',
                        $cpu_affinity                     = undef,
                        $capability_bounding_set          = undef,
                        $crash_change_vt                  = undef,
                        $crash_reboot                     = undef,
                        $crash_shell                      = undef,
                        $ctrl_alt_del_burst_action        = undef,
                        $default_block_io_accounting      = undef,
                        $default_cpu_accounting           = undef,
                        $default_environment              = undef,
                        $default_limit_as                 = undef,
                        $default_limit_core               = undef,
                        $default_limit_cpu                = undef,
                        $default_limit_data               = undef,
                        $default_limit_fsize              = undef,
                        $default_limit_locks              = undef,
                        $default_limit_memlock            = undef,
                        $default_limit_msgqueue           = undef,
                        $default_limit_nice               = undef,
                        $default_limit_nofile             = undef,
                        $default_limit_nproc              = undef,
                        $default_limit_rss                = undef,
                        $default_limit_rtprio             = undef,
                        $default_limit_rttime             = undef,
                        $default_limit_sigpending         = undef,
                        $default_limit_stack              = undef,
                        $default_memory_accounting        = undef,
                        $default_restart_sec              = undef,
                        $default_standard_error           = undef,
                        $default_standard_output          = undef,
                        $default_start_limit_burst        = undef,
                        $default_start_limit_interval_sec = undef,
                        $default_tasks_accounting         = undef,
                        $default_tasks_max                = undef,
                        $default_timeout_start_sec        = undef,
                        $default_timeout_stop_sec         = undef,
                        $default_timer_accuracy_sec       = undef,
                        $dump_core                        = undef,
                        $hibernate_mode                   = undef,
                        $hibernate_state                  = undef,
                        $hybrid_sleep_mode                = undef,
                        $hybrid_sleep_state               = undef,
                        $join_controllers                 = undef,
                        $log_color                        = undef,
                        $log_level                        = undef,
                        $log_location                     = undef,
                        $log_target                       = undef,
                        $runtime_watchdog_sec             = undef,
                        $show_status                      = undef,
                        $shutdown_watchdog_sec            = undef,
                        $suspend_mode                     = undef,
                        $suspend_state                    = undef,
                        $system_call_architectures        = undef,
                        $timer_slack_nsec                 = undef
                      ) {
  file { '/etc/systemd/system.conf':
    ensure  => $ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/system.conf.erb"),
    notify  => Exec['systemctl daemon-reload'],
  }
}
