# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Resource types**

* [`vcsrepo`](#vcsrepo): A local version control repository

## Resource types

### vcsrepo

A local version control repository

#### Properties

The following properties are available in the `vcsrepo` type.

##### `ensure`

Valid values: present, bare, mirror, absent, latest

Ensure the version control repository.

##### `source`

The source URI for the repository

##### `revision`

Valid values: %r{^\S+$}

The revision of the repository

##### `includes`

Paths to be included from the repository

##### `module`

The repository module to manage

#### Parameters

The following parameters are available in the `vcsrepo` type.

##### `path`

namevar

Absolute path to repository

##### `fstype`

Filesystem type

##### `owner`

The user/uid that owns the repository files

##### `group`

The group/gid that owns the repository files

##### `user`

The user to run for repository operations

##### `excludes`

Local paths which shouldn't be tracked by the repository

##### `force`

Valid values: `true`, `false`, yes, no

Force repository creation, destroying any files on the path in the process.

Default value: `false`

##### `compression`

Compression level

##### `basic_auth_username`

HTTP Basic Auth username

##### `basic_auth_password`

HTTP Basic Auth password

##### `identity`

SSH identity file

##### `remote`

The remote repository to track

Default value: origin

##### `configuration`

The configuration directory to use

##### `cvs_rsh`

The value to be used for the CVS_RSH environment variable.

##### `depth`

The value to be used to do a shallow clone.

##### `branch`

The name of the branch to clone.

##### `p4config`

The Perforce P4CONFIG environment.

##### `submodules`

Valid values: `true`, `false`

Initialize and update each submodule in the repository.

Default value: `true`

##### `conflict`

The action to take if conflicts exist between repository and working copy

##### `trust_server_cert`

Valid values: `true`, `false`

Trust server certificate

Default value: `false`

##### `keep_local_changes`

Valid values: `true`, `false`

Keep local changes on files tracked by the repository when changing revision

Default value: `false`

