class akamai_stats (
  $ensure      = present,
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary      = false,
  $svcname     = 'akamai_stats',
  $user        = 'nobody',
  $nop         = false,
  $concurrency = 0
) {

  file { "/opt/twitch/${svcname}/etc/${svcname}.conf.json":
    ensure  => $ensure,
    content => template('akamai_stats/akamai_stats.conf.json')
  }

  if $nop {
    $noop_flag = '--noop'
  }

  $daemon = "${lsbdistcodename}/run --config_file=/opt/twitch/${svcname}/etc/${svcname}.conf.json"

  twitch::service { 'akamai_stats':
    ensure         => $ensure,
    env            => $env,
    canary         => $canary,
    manage_service => true,
    daemon_cmd     => "${daemon} ${noop_flag}",
    predaemon      => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo   => 'video/akamai_stats',
    user           => $user,
    concurrency    => $concurrency
  }
}
