# installs video-mapping's almanac service
class almanac::install inherits almanac {
  file { '/var/run/almanac':
    ensure => 'directory',
    owner  => 'nobody',
    group  => 'nogroup',
    mode   => '0755',
  }

  # define our own rsyslog config to strip leading space without affecting the global conf
  # the number is to ensure the file is processed before the global 41-jtv-local3-logs.conf
  # XXX - you could switch to 'local5' and remove all this stuff - mghali
  ::rsyslog::snippet { '40-almanac-local3-logs':
    content => file("${module_name}/almanac-local3-logs.conf")
  }

  twitch_svclogs::logfile { 'almanac_app_logs':
    filename        => 'almanac*.log',
    log_group_name  => "/twitch/video/almanac/${::almanac_env}",
    log_stream_name => $::hostname,
    account         => 'instance-role',
    use_milliner    => false,
    region          => $::pop,
  }
}
