# == Class: asset_transcoder
#
# asset_transcoder is runs the
# code.justin.tv/video/asset-transcoder/cmd/asset-transcoder binary.

class asset_transcoder (
  $environment = $asset_transcoder::params::asset_transcoder_environment,
) inherits asset_transcoder::params {

  require courier

  consul::service { 'asset-transcoder':
    consul_tags => [$environment],
  }

  courier::install { 'asset-transcoder':
    env     => $environment,
    repo    => 'video/asset-transcoder',
    basedir => '/opt/twitch',
    require => Consul::Service['asset-transcoder'],
  }

  daemontools::supervise { 'asset-transcoder':
    down    => false,
    user    => 'nobody',
    syslog  => local3,
    daemon  => '/opt/twitch/asset-transcoder/current/asset-transcoder',
    options => join(
      [
        '-aws-region', 'us-west-2',
        '-environment', $environment,
        '-transcoder', '/opt/twitch/asset-transcoder/current/TwitchTranscoder',
        '2>&1',
      ], ' '),
    require => Courier::Install['asset-transcoder'],
    wd      => '/opt/twitch/asset-transcoder/current',
  }

  ::filebeat::prospector { 'asset-transcoder':
    paths      => [
      '/var/log/jtv/asset-transcoder.log',
    ],
    doc_type   => 'asset-transcoder',
    fields     => {
      'output' => 'syslog_elasticsearch',
    },
    require    => [
      Daemontools::Supervise['asset-transcoder'],
    ]
  }

}
