# Takes the $services hash (one key at a time) from the bird::services class and turns it into:
# - an interface -> lo:$name
# - a bird (BGP) network routing config entry.
# - a health enforcer service: anycast_health_forcer
# - that's it, but this is where you expand on each "service" if you need more logic.
#   something like passing in special health enforcer parameters should happen here.
#
define bird::service (
  $ipaddress,
  $ensure       = 'present',
  $auto         = true,
  $community    = undef,
  $consul_tags  = undef,
  $service_port = undef,
) {
  include bird::services

  if !$::disable_anycast {
    concat::fragment { "bird-config-${name}":
      target  => 'bird-config',
      order   => '50',
      content => template('bird/bird-announce.erb'),
    }

    bird::loopback { "lo:${name}":
      ensure    => $ensure,
      ipaddress => $ipaddress,
      auto      => $auto,
    }

    # lint:ignore:only_variable_string
    # $service_port is only used to pass metadata to consul::service, there's a
    # chance that it may be undef
    $_service_port = $service_port ? {
      undef   => undef,
      default => "${service_port}",
    }

    consul::service { "anycast-${title}":
      service_name => 'anycast',
      consul_tags  => $consul_tags,
      meta         => delete_undef_values({
        'service_name' => $name,
        'service_port' => $_service_port,
        'anycast_ip'   => $ipaddress,
        'community'    => "${community}",
      }),
    }
    # lint:endignore
  }
}
