define bird_watcher::instance () {
  $options = {
    # Options that vary between instances.
    "config" => "current/config/cmd/${name}.json"
  }
  $all_options = prefix(delete_undef_values($options), '-')

  ::daemontools::supervise { $name:
    daemon         => './current/bird-watcher',
    daemon_dir     => '/var/lib/service',
    options        => shell_join(join_keys_to_values($all_options, '=')),
    user           => "${bird_watcher::user}",
    wd             => "${bird_watcher::basedir}/${name}",
    syslog         => 'local3',
    manage_service => true,
    predaemon      => [
      # Duplicate this here because Puppet is not always run as frequently as it should be.  This should be entirely
      # unnecesary if we also have a corresponding 'file' resource below.
      "mkdir -p /var/run/bird_watcher && chown -R ${bird_watcher::user}: /var/run/bird_watcher",
      "exec 2>&1",
      "test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh"
    ],
  }

  ::consul::service { $name:
    service_name => 'bird_watcher',
    consul_tags  => [$name],
    require      => Daemontools::Supervise[$name],
  }
}
