class birdbot::bird {
  package{ 'bird':
    ensure => present,
  }

  service{ 'bird':
    ensure => running,
    enable => true,
  }

  service{ 'bird6':
    ensure => stopped,
    enable => false,
  }

  file{ '/etc/default/bird':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/birdbot/default-bird',
    notify  => Service['bird'],
    require => Package['bird'],
  }

  file{ '/etc/default/bird6':
    ensure  => present,
    owner   => root,
    group   => root,
    mode    => '0644',
    source  => 'puppet:///modules/birdbot/default-bird6',
    notify  => Service['bird6'],
    require => Package['bird'],
  }
}
