class birdbot (
  $listen_port = $birdbot::params::listen_port
) inherits birdbot::params {
  include birdbot::bird
  include twitch::killstrays
  include twitch::packages

  realize(Package['socat'])

  # Assuming this was separated from the class formerly known as software::bird
  # Because the video cluster did not want this?  -MB
  file { '/etc/bird.conf':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0444',
    content => template('birdbot/birdbot.conf.erb'),
    notify  => [Service['bird'],Service['bird6'],],
  }

  daemontools::supervise{ 'birdbot_proxy':
    syslog    => 'local2',
    predaemon => [],
    daemon    => "/usr/local/bin/killstrays.py socat TCP-LISTEN:${listen_port},reuseaddr,fork UNIX-CLIENT:/var/run/bird.ctl",
    wd        => '/var/run',
    require   => [File['/etc/bird.conf'],Package['socat'],]
  }
}
