class birdcage (
  $birdcage_env              = $birdcage::params::env,
  $listen_host               = $birdcage::params::listen_host,
  $listen_port               = $birdcage::params::listen_port,
  $envoy_host                = $birdcage::params::envoy_host,
  $envoy_port                = $birdcage::params::envoy_port,
  $statsd_addr               = $birdcage::params::statsd_addr,
  $netrr_na_list             = $birdcage::params::netrr_na_list,
  $netrr_eu_list             = $birdcage::params::netrr_eu_list,
  $undergoing_find_migration = $birdcage::params::undergoing_find_migration,
  $nagios_server_name        = $birdcage::params::nagios_server_name,
) inherits birdcage::params {
  validate_array($netrr_na_list)
  validate_array($netrr_eu_list)

  # Need a running babybird
  include bird

  include twitch_nsca::nsca_client

  validate_string($nagios_server_name)

  $rotated_na_list = fqdn_rotate($netrr_na_list)
  if count($rotated_na_list) >= 1 {
    $netrr_list_1 = concat([], $rotated_na_list[0])
  } else {
    $netrr_list_1 = []
  }

  $rotated_eu_list = fqdn_rotate($netrr_eu_list)
  if count($rotated_eu_list) >= 1 {
    $netrr_list_2 = concat($netrr_list_1, $rotated_eu_list[0])
  } else {
    $netrr_list_2 = $netrr_list_1
  }

  # Alias for future use
  $netrr_list = $netrr_list_2

  notify { "Selected birdfeeders: $netrr_list": }

  ## TODO: FIX, THIS MAY BE BROKE BECAUSE VARIABLE SCOPES INSIDE TEMPLATE
  # solution is not to add custom code to bird, perhaps add more abstraction
  bird::daemon { 'babybird':
    template => "${module_name}/bird_babybird.conf.erb",
  }

  courier::install{ 'birdcage':
    env      => $birdcage_env,
    repo     => 'video/birdcage',
    basedir  => '/home/jtv',
  }

  # consul-template polls for this service on the netrr machines themselves,
  # ensuring they are always configured so that we can connect to them. This
  # only works with the babybirds in the sfo01, sjc01, us-west2, and us-east-1 consul
  # pops!
  # if we are undergoing the find localpref migration then we want to
  # advertise use-find-migration in consul.
  if $undergoing_find_migration {
    $netrr_downstream_tags = ['babybird', 'use-find-migration']
  } else {
    $netrr_downstream_tags = ['babybird', 'no-use-find-migration']
  }

  consul::service { 'bird_netrr_downstream_consul':
    service_name => 'bird-netrr-downstream',
    consul_tags  =>  $netrr_downstream_tags
  }

  $birdcage_cmd = join([
     "env GOMAXPROCS=2",
     "./birdcage",
     "-controlPath /var/run/bird_babybird.ctl",
     "-http ${listen_host}:${listen_port}",
     "-envoy ${envoy_host}:${envoy_port}",
     "-nagios $nagios_server_name",
     "-statsd ${statsd_addr}",
     "2>&1"
  ], ' ')


  daemontools::supervise { "birdcage":
    daemon  => $birdcage_cmd,
    syslog  => local3,
    wd      => "/home/jtv/birdcage/current",
    require => [
      Bird::Daemon['babybird'],
      Class['twitch_nsca::nsca_client'],
    ]
  }

  consul::service { "birdcage":
    service_name => "birdcage",
    consul_tags  => $birdcage_env,
    port         => $listen_port,
  }

  envoy::service { "birdcage":
    port         => $envoy_port,
  }
}
