# to instantiate brood on baremetal hosts
class brood (
  $env          = $brood::params::env,
  $canary       = $brood::params::canary,
  $http_port    = $brood::params::http_port,
  $consul_addr  = $brood::params::consul_addr,
  $ensure       = $brood::params::ensure,
) inherits brood::params {
  if $canary {
    $consul_tags = ['canary', 'nodesAPI-bastion']
  } else {
    $consul_tags = 'nodesAPI-bastion'
  }

  twitch::service { 'brood':
    env                   => $env,
    canary                => $consul_tags,
    daemon_cmd            => "./brood-server --port ${http_port} --consul-addr ${consul_addr} --role bastion --env ${env}",
    predaemon             => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh', 'source /etc/milliner-client-env.sh'],
    user                  => 'nobody',
    service_repo          => 'video/brood',
    consul_advertise_port => $http_port,
    manage_service        => true,
    codedeploy_compat     => true,
  }
}
