# cdnstatter is a platform that collects utilization data from 3P CDNS
# and updates hosesAPI with those values.
class cdnstatter (
  $user                      = 'nobody',
  $svcname                   = 'cdnstatter',
  $env                       = pick($::twitch_environment, $twitch_environment, 'production'),
  $systemd_start_timeout_sec = '60',
  $concurrency               = 0,
  $aws_creds_file            = '/opt/twitch/cdnstatter/awsCreds',
  $aws_creds_profile         = 'twitch-video-aws',
  $cdnstatter_awscreds_keyid = 'video/cdnstatter/production/awscreds_keyid',
  $cdnstatter_awscreds_key   = 'video/cdnstatter/production/awscreds_key',
) {

  file { "/opt/twitch/${svcname}/etc/${svcname}.conf.json":
    content => template('cdnstatter/cdnstatter.conf.json')
  }

  if $env == 'staging' {
    $hosesapi='http://hosesapi-v2.staging.internal.justin.tv'
  } else {
    $hosesapi='http://hosesapi-v2.internal.justin.tv'
  }

  twitch_sandstorm_agent::template { 'cdnstatter_aws_creds':
    destination => $aws_creds_file,
    contents    => template("${module_name}/cdnstatter_awsCreds.erb"),
  }

  twitch::service { 'cdnstatter':
    env                => $env,
    daemon_cmd         => "./cdnstatter --config=/opt/twitch/${svcname}/etc/${svcname}.conf.json --hosesapi=${hosesapi} --awsCredsFile=${aws_creds_file} -awsCredsProfile ${aws_creds_profile}",
    predaemon          => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo       => 'video/cdnstatter',
    user               => $user,
    daemontools_ensure => 'absent',
    concurrency        => $concurrency,
  }

  $systemd_exec_cmd = "/opt/twitch/cdnstatter/current/cdnstatter --config=/opt/twitch/${svcname}/etc/${svcname}.conf.json --hosesapi=${hosesapi} --awsCredsFile=${aws_creds_file} --awsCredsProfile ${aws_creds_profile}"

  twitch_systemd::unit_file {'video-cdnstatter.service':
    ensure  => 'present',
    content => template('cdnstatter/cdnstatter.service.erb'),
  }

  service { ['video-cdnstatter']:
    ensure    => 'running',
    enable    => true,
    subscribe => Twitch_systemd::Unit_file['video-cdnstatter.service'],
  }
}
