# == Definition: cgroups::namespace
#
# Helper definition to create namespace directories without dupe resource
#
# == Parameters
#
# [*paths*]
#  Array of paths to attempt to create.  Default: []
#
define cgroups::namespace (
  $paths = [],
) {
  validate_array($paths)

  if ($::lsbmajdistrelease >= '12') {
    ensure_resource('file', $paths, {
      'ensure' => 'directory',
      'owner'  => 'root',
      'group'  => 'root',
      'mode'   => '0755',
      })
  }
}
