require 'spec_helper'

describe 'cgroups', :type => :class do
  let(:facts) do {
    :osfamily => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress => '127.0.0.1',
  }
  end

  describe 'verify module lucid or older' do
    let(:params) do {
      :basedir   => '/tmp',
      :namespace => 'flippy',
      :package   => 'cgroup-heavy',
      :service   => 'cgroup-heavy',
    }
    end
    let(:facts) do {
      :lsbmajdistrelease => '11',
      :lsbdistcodename => 'lucid'
    }
    end

    it "should contain only 1 resource" do
      should have_resource_count(1)
    end

    it "does contain notify Unsupported" do
      should contain_notify("Unsupported: cgroups not supported on lucid").with({
      })
    end
  end

  context 'verify module precise or newer' do
    let(:params) do {
      :basedir   => '/tmp',
      :namespace => 'flippy',
      :package   => 'cgroup-heavy',
      :service   => 'cgroup-heavy',
    }
    end
    let(:facts) do {
      :lsbmajdistrelease => '12',
    }
    end

    it "does contain cgroups_namespace DEFAULT: flippy" do
      should contain_cgroups__namespace("DEFAULT: flippy")
    end

    it 'does contain package cgroup-heavy' do
      should contain_package('cgroup-heavy')
    end

    it 'does contain service cgroup-heavy' do
      should contain_service('cgroup-heavy')
    end
  end
end
