require 'spec_helper'


describe 'cgroups::service', :type => :define do
  let(:title) { 'myservice' }
  let(:params) do {
    :rules => { 'memory' => { 'memory.swappiness' => '0' } },
    :namespace => 'service'
  }
  end

  describe 'running on lucid' do
    let(:facts) do {
      :lsbdistcodename => 'lucid',
      :lsbmajdistrelease => 11,
    }
    end

    it 'notify with loglevel => info' do
      should contain_notify('myservice No cgroups for you...').with({
        :loglevel => :info })
    end
  end

  describe 'running on precise' do
    let(:facts) do {
      :lsbdistcodename => 'precise',
      :lsbmajdistrelease => 12,
      :available_cgroups => 'memory,cpuacct,blkio',
    }
    end

    it 'should contain class cgroups' do
      should contain_class('cgroups')
    end

    it 'should create rules file /usr/local/bin/cgroups_rules_myservice.sh' do
      should contain_file('/usr/local/bin/cgroups_rules_myservice.sh')
    end

    it 'does create a namespace' do
      should contain_cgroups__namespace('myservice service')
    end
  end
end
