class cloudfront_stats (
  $env         = pick($::twitch_environment, $twitch_environment, 'production'),
  $canary      = false,
  $svcname     = 'cloudfront_stats',
  $user        = 'nobody',
  $nop         = false,
  $concurrency = 0
) {

  file { "/opt/twitch/${svcname}/etc/${svcname}.conf.json":
    content => template('cloudfront_stats/cloudfront_stats.conf.json')
  }

  if $nop {
    $noop_flag = '--noop'
  }

  $daemon = "./run --config_file=/opt/twitch/${svcname}/etc/${svcname}.conf.json"

  twitch::service { 'cloudfront_stats':
    env            => $env,
    canary         => $canary,
    manage_service => true,
    daemon_cmd     => "${daemon} ${noop_flag}",
    predaemon      => ['test -f /etc/profile.d/proxy.sh && source /etc/profile.d/proxy.sh'],
    service_repo   => 'video/cloudfront_stats',
    user           => $user,
    concurrency    => $concurrency
  }
}
