#!/bin/bash

# This script acts as an additional guardrail to prevent machines without a configured interface
# from falling into consul's default behavior in absense of go-sockaddr detecting an upped interface
# which selects localhost as its advertise address.
MAX_WAIT_SECONDS=600
SLEEP_SECONDS=10

for ((i = 0; i < MAX_WAIT_SECONDS / SLEEP_SECONDS; i++)) {
    # ensure an active, non-loopback, non-localhost interface is configured.
    # ip -o addr e.g.
    # 1: lo    inet 127.0.0.1/8 scope host lo\       valid_lft forever preferred_lft forever
    # 1: lo    inet 23.160.0.0/32 brd 23.160.0.0 scope global lo:entrypop_gbl\       valid_lft forever preferred_lft forever
    # 6: team0    inet 10.18.99.36/22 brd 10.18.99.255 scope global team0\       valid_lft forever preferred_lft forever
    [ -n "$(ip -o addr|grep -Pv "^\d+:\s+(lo|docker\d+|.*127.0.0.1|.*::1)"|grep -oP "\s+inet\s+\K[.\d]+")" ] && exit 0
    sleep $SLEEP_SECONDS
}
echo "Error: no ip address was assigned after waiting for $MAX_WAIT_SECONDS seconds"
exit 124
