#!/bin/bash
set -u -e -o pipefail

service="${1?Service argument must be specified}"

if [[ $(cat - | jq --raw-output type) == object ]]; then
  consul maint -disable -service "$service"
else
  consul maint -enable -service "$service" -reason "Local watch detected no enabled-key as of $(date) (consul index $CONSUL_INDEX)."
fi
