#
# consul_kv_lookup.rb
#

$LOAD_PATH.unshift File.dirname(__FILE__)

require 'libconsul'

module Puppet::Parser::Functions
  newfunction(:consul_kv_lookup, :type => :rvalue, :doc => <<-EOS
Lookup a key from consul

*Examples:*

    consul_kv_lookup("key", {"dc" => "lhr03"})

All optional arguments must be passed in as an hash.

Optional Arguments:

    consul_api_endpoint: Api server and port to query.
    dc: Datacenter to lookup key in. By default "wanmaster".

Global Settings:

    consul_api_endpoint: Api server and port to query. The optional argument has higher priority.
                         Defaults to 'localhost:8500'.
    EOS
  ) do |args|
    raise(Puppet::ParseError, "consul_kv_lookup(): Wrong number of arguments " +
          "given (#{args.size} for 1)") if args.size < 1

    key = args[0]
    opt = {"dc" => "wanmaster"}.merge(args[1] || {})

    # Optional argument has highest priority, than the global value, than the default
    consul_server = opt["consul_api_endpoint"] || lookupvar("consul_api_endpoint") || "consul.internal.justin.tv"

    # Configure query args:
    query = ["raw", "dc=#{opt["dc"]}"]

    # Configure the URL
    url = URI::join("http://#{consul_server}/v1/kv/", key)
    url.query = query.join("&")

    return consul_api_call(url)
  end
end
