# Anycast configuration for consul module
class consul::anycast {
  include consul
  if $::consul::anycast_ip != undef {
    include bird::monitoring
    include twitch_anycast_health_enforcer::monitoring
    validate_integer($consul::bgp_community)
    twitch_anycast_health_enforcer::service { 'consul_ui':
      interval   => '2s',
      window     => 4,
      threshold  => 2,
      healthy    => 'all',
      addresses  => [$consul::anycast_ip],
      community  => $consul::bgp_community,
      flap_limit => -1,
      checks     => {
        "/usr/lib/nagios/plugins/check_tcp -H 127.0.0.1 -p 80" => {
          type    => 'cmd',
          timeout => '4s',
        },
      },
    }
  }
}
