define consul::check (
  $check_name     = $name,
  $check_script   = undef,
  $check_interval = undef,
  $check_notes    = undef,
  $check_service  = undef,
) {
  include ::consul

  if $check_script != undef {
    $args = shell_split($check_script)
  }

  $config = delete_undef_values({
    'check' => delete_undef_values({
      'args'       => $args,
      'id'         => $name,
      'name'       => $check_name,
      'interval'   => $check_interval,
      'notes'      => $check_notes,
      'service_id' => $check_service,
    })
  })

  file { "${consul::config_dir}/check_${name}.json":
    ensure  => 'present',
    mode    => '0644',
    owner   => 'root',
    group   => 'root',
    content => pretty_json($config),
    notify  => Class['::consul::reload_service'],
  }
}
