class consul::checks inherits consul {
    consul::check{ 'node-enabled':
        check_script   => '/usr/local/bin/consul-status',
        check_interval => '15s',
        require        => File['/usr/local/bin/consul-status']
    }

    consul::service{ 'deploy':
        check_script   => '/usr/local/bin/deploy-status',
        check_interval => '15s',
        require        => File['/usr/local/bin/deploy-status']
    }

    file { $scripts_data_dir:
        ensure => directory,
        owner  => 'root',
        group  => 'root',
        mode   => '0755',
    }

    file { '/usr/local/bin/consul-checks-base':
        ensure  => file,
        owner   => 'root',
        group   => 'root',
        mode    => '0755',
        # uses: $scripts_data_dir
        content => template('consul/consul-checks.erb'),
    }

    $script_suffixes = {'enable' => {}, 'disable' => {}, 'status' => {}}
    $script_names = merge(prefix($script_suffixes, 'consul-'), prefix($script_suffixes, 'deploy-'))

    create_resources(file, prefix($script_names, '/usr/local/bin/'), {
        ensure => link,
        owner  => 'root',
        group  => 'root',
        mode   => '0755',
        target => '/usr/local/bin/consul-checks-base',
    })
}
