class consul::daemon inherits consul {

  if $::consul::enable {
    $ensure = 'running'
    $enable = true
  } else {
    $ensure = 'stopped'
    $enable = false
  }

  service { 'consul':
    ensure     => $ensure,
    enable     => $enable,
    hasrestart => true,
    hasstatus  => true,
    require    => Class['::systemd'],
  }

}
