# Installs/configures consul
class consul (
  $systemd_restart       = $consul::params::systemd_restart,
  $bind                  = $consul::params::bind,
  $interface             = $consul::params::interface,
  $bootstrap             = undef,
  $cluster_size          = undef,
  $config_dir            = $consul::params::config_dir,
  $scripts_data_dir      = $consul::params::scripts_data_dir,
  $data_dir              = $consul::params::data_dir,
  $datacenter            = $consul::params::datacenter,
  $disable_remote_exec   = $consul::params::disable_remote_exec,
  $disable_update_check  = $consul::params::disable_update_check,
  $dns_name              = $consul::params::dns_name,
  $enable                = $consul::params::enable,
  $group                 = $consul::params::group,
  $join                  = $consul::params::join,
  $join_wan              = $consul::params::join_wan,
  $join_wan_ignore       = $consul::params::join_wan_ignore,
  $deb_version           = $consul::params::deb_version,
  $log_level             = $consul::params::log_level,
  $node_name             = $consul::params::node_name,
  $serf_lan              = undef,
  $server                = undef,
  $statsd_addr           = $consul::params::statsd_addr,
  $server_metrics_prefix = $consul::params::server_metrics_prefix,
  $client_metrics_prefix = $consul::params::client_metrics_prefix,
  $syslog                = $consul::params::syslog,
  $syslog_facility       = $consul::params::syslog_facility,
  $ui_enabled            = $consul::params::ui_enabled,
  $user                  = $consul::params::user,
  $version               = $consul::params::version,
  $leave_on_exit         = $consul::params::leave_on_exit,
  $hourly_logrotate      = $consul::params::hourly_logrotate,
  $anycast_ip            = $consul::params::anycast_ip,
  $bgp_community         = $consul::params::bgp_community,
  $use_ssl               = $consul::params::use_ssl,
) inherits consul::params {
  include twitch::packages
  validate_bool($enable, $syslog, $ui_enabled)

  # In version >= 1, we can pass a go-sockaddr to $advertise, avoiding the
  # issue where hosts get a new dhcp ip, and are broken until a puppet run.
  $advertise = "{{  GetInterfaceIP \"${interface}\" }}"

  if empty($join) {
    fail('Must define a \$join list for consul')
  }

  validate_array($join, $join_wan, $join_wan_ignore)
  validate_absolute_path($data_dir, $config_dir)
  # Allow manually overriding if a node is a server. If it is undeclared
  # then we will decide based upon if the server is in the join list.
  if $server != undef {
    validate_bool($server)
    $is_server = $server
  } else {
    $is_server = (member($join, $::fqdn) or member($join, $bind))
  }

  anchor{ 'consul::begin': }
  -> class{ '::consul::logrotate': }
  -> class{ '::consul::setup': }
  -> class{ '::consul::config': }
  -> class{ '::consul::checks': }
  -> class{ '::consul::nginx': }
  -> class{ '::consul::daemon': }
  -> class{ '::consul::reload_service': }
  -> anchor{ 'consul::end': }

  include consul::nodeinfo
  include consul::alerts
  include consul::anycast
  if $is_server {
    include consul::monitoring
  }

  $maintmode_kv_watch_basename = 'consul-kv-watch-handler_svc-maintmode'
  $maintmode_kv_watch_handler = "/usr/local/bin/${maintmode_kv_watch_basename}"

  file { $maintmode_kv_watch_handler:
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => "puppet:///modules/consul/${maintmode_kv_watch_basename}.sh",
    require => Package['jq'],
  }

  # maintmode_kv_watch uses nonstandard utility to examine json
  realize(Package['jq'])

}
